/*
 * Decompiled with CFR 0.152.
 */
package com.huike.nova.sdk.utils;

import com.huike.nova.sdk.ext.StringExtKt;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u0004J\u0010\u0010\t\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u0004J\u0016\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\u0004J\u0016\u0010\n\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/huike/nova/sdk/utils/RegexUtil;", "", "()V", "inputPhoneNumberRegex", "", "phoneNumberRegex", "isInputPhoneNumber", "", "input", "isPhoneNumber", "match", "pattern", "Ljava/util/regex/Pattern;", "regex", "nova-sdk_debug"})
public final class RegexUtil {
    @NotNull
    public static final RegexUtil INSTANCE = new RegexUtil();
    @NotNull
    private static final String phoneNumberRegex = "^1[0-9]{10}$";
    @NotNull
    private static final String inputPhoneNumberRegex = "^1[0-9]{0,10}$";

    private RegexUtil() {
    }

    public final boolean match(@NotNull Pattern pattern, @NotNull String input) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        return pattern.matcher(input).matches();
    }

    public final boolean match(@NotNull String regex, @NotNull String input) {
        Intrinsics.checkNotNullParameter((Object)regex, (String)"regex");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Pattern pattern = Pattern.compile(regex);
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(regex)");
        return this.match(pattern, input);
    }

    public final boolean isPhoneNumber(@Nullable String input) {
        return this.match(phoneNumberRegex, StringExtKt.nullToEmpty(input));
    }

    public final boolean isInputPhoneNumber(@Nullable String input) {
        return this.match(inputPhoneNumberRegex, StringExtKt.nullToEmpty(input));
    }
}

