/*
 * Decompiled with CFR 0.152.
 */
package com.huike.nova.sdk.utils;

import android.app.Activity;
import android.content.Context;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.util.DisplayMetrics;
import android.util.Size;
import android.view.WindowManager;
import com.fshows.android.stark.utils.FsLogUtil;
import com.huike.nova.sdk.NovaSdkInitializer;
import com.huike.nova.sdk.ext.ContextExtKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/huike/nova/sdk/utils/CameraUtil;", "", "()V", "LogTag", "", "getBestCameraSize", "Landroid/util/Size;", "context", "Landroid/content/Context;", "getScreenSize", "Landroid/util/DisplayMetrics;", "windowManager", "Landroid/view/WindowManager;", "nova-sdk_debug"})
public final class CameraUtil {
    @NotNull
    public static final CameraUtil INSTANCE = new CameraUtil();
    @NotNull
    private static final String LogTag = "NovaSdk-CameraUtil";

    private CameraUtil() {
    }

    private final DisplayMetrics getScreenSize(WindowManager windowManager) {
        DisplayMetrics displayMetrics = new DisplayMetrics();
        windowManager.getDefaultDisplay().getRealMetrics(displayMetrics);
        return displayMetrics;
    }

    @NotNull
    public final Size getBestCameraSize(@NotNull Context context) {
        Size size;
        Object object;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Size size2 = null;
        size2 = new Size(NovaSdkInitializer.INSTANCE.getScreenWidth(), NovaSdkInitializer.INSTANCE.getScreenHeight());
        if (context instanceof Activity) {
            WindowManager windowManager = ((Activity)context).getWindowManager();
            Intrinsics.checkNotNullExpressionValue((Object)windowManager, (String)"context.windowManager");
            DisplayMetrics displayMetrics = this.getScreenSize(windowManager);
            size2 = new Size(displayMetrics.widthPixels, displayMetrics.heightPixels);
        }
        Object object2 = this;
        try {
            CameraUtil $this$getBestCameraSize_u24lambda_u242 = object2;
            boolean bl = false;
            int deviceWidth = size2.getWidth();
            int deviceHeight = size2.getHeight();
            long screenPixels = (long)deviceWidth * (long)deviceHeight;
            Object object3 = context.getSystemService("camera");
            Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type android.hardware.camera2.CameraManager");
            CameraManager cameraManager = (CameraManager)object3;
            Size bestSize = null;
            String[] stringArray = cameraManager.getCameraIdList();
            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"cameraManager.cameraIdList");
            Object[] $this$forEach$iv = stringArray;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CameraCharacteristics cameraCharacteristics;
                StreamConfigurationMap streamConfigurationMap;
                String cid = (String)element$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNullExpressionValue((Object)cameraManager.getCameraCharacteristics(cid), (String)"cameraManager.getCameraCharacteristics(cid)");
                StreamConfigurationMap streamConfigurationMap2 = streamConfigurationMap = (StreamConfigurationMap)cameraCharacteristics.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
                Intrinsics.checkNotNull((Object)streamConfigurationMap2);
                Size[] sizes = streamConfigurationMap2.getOutputSizes(256);
                Intrinsics.checkNotNullExpressionValue((Object)sizes, (String)"sizes");
                for (Size sz : sizes) {
                    long lastPixelDiff;
                    if (bestSize == null) {
                        bestSize = sz;
                        continue;
                    }
                    if (ContextExtKt.isDebuggable()) {
                        FsLogUtil.error((String)LogTag, (String)("DETECTED CAMERA SIZE: " + sz.getHeight() + 'x' + sz.getWidth()), (Object[])new Object[0]);
                    }
                    Size it = bestSize;
                    boolean bl3 = false;
                    long currentPixelsDiff = Math.abs((long)sz.getWidth() * (long)sz.getHeight() - screenPixels);
                    if (currentPixelsDiff >= (lastPixelDiff = Math.abs((long)it.getWidth() * (long)it.getHeight() - screenPixels))) continue;
                    bestSize = sz;
                }
            }
            object = Result.constructor-impl(bestSize);
        }
        catch (Throwable bl) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object2 = object;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable != null) {
            Object it = object = throwable;
            boolean bl = false;
            FsLogUtil.error((String)LogTag, (String)("CameraUtil.getBestCameraSize>> " + it), (Object[])new Object[0]);
        }
        if ((size = (Size)(Result.isFailure-impl((Object)object2) ? null : object2)) == null) {
            size = size2;
        }
        return size;
    }
}

