/*
 * Decompiled with CFR 0.152.
 */
package com.huike.nova.sdk.ui.douyin;

import android.net.Uri;
import com.huike.nova.sdk.constants.enums.OrderChannelType;
import com.huike.nova.sdk.ui.douyin.TicketCodeHelper;
import com.huike.nova.sdk.utils.RegexUtil;
import java.util.regex.Pattern;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0004J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0004J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0013\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0006\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000e\u00a8\u0006\u0016"}, d2={"Lcom/huike/nova/sdk/ui/douyin/TicketCodeHelper;", "", "()V", "AmapPrefix", "", "DouyinClosedLoopEncryptedDataKey", "DouyinClosedLoopPattern", "Ljava/util/regex/Pattern;", "getDouyinClosedLoopPattern", "()Ljava/util/regex/Pattern;", "DouyinClosedLoopPattern$delegate", "Lkotlin/Lazy;", "DouyinOpenLoopElements", "", "[Ljava/lang/String;", "getDouyinClosedLoopEncryptData", "ticketRedirectUrl", "getOrderChannelTypeByTicketCode", "Lcom/huike/nova/sdk/constants/enums/OrderChannelType;", "ticketCode", "isDouyinOpenLoopTicket", "", "nova-sdk_debug"})
public final class TicketCodeHelper {
    @NotNull
    public static final TicketCodeHelper INSTANCE = new TicketCodeHelper();
    @NotNull
    private static final String AmapPrefix = "GD";
    @NotNull
    private static final String[] DouyinOpenLoopElements;
    @NotNull
    private static final String DouyinClosedLoopEncryptedDataKey = "object_id";
    @NotNull
    private static final Lazy DouyinClosedLoopPattern$delegate;

    private TicketCodeHelper() {
    }

    private final Pattern getDouyinClosedLoopPattern() {
        Lazy lazy = DouyinClosedLoopPattern$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-DouyinClosedLoopPattern>(...)");
        return (Pattern)object;
    }

    @NotNull
    public final OrderChannelType getOrderChannelTypeByTicketCode(@NotNull String ticketCode) {
        Intrinsics.checkNotNullParameter((Object)ticketCode, (String)"ticketCode");
        return StringsKt.startsWith$default((String)ticketCode, (String)AmapPrefix, (boolean)false, (int)2, null) ? OrderChannelType.Amap : (this.isDouyinOpenLoopTicket(ticketCode) ? OrderChannelType.DouyinOpenLoop : (RegexUtil.INSTANCE.match(this.getDouyinClosedLoopPattern(), ticketCode) ? OrderChannelType.DouyinClosedLoop : OrderChannelType.UnKnown));
    }

    @NotNull
    public final String getDouyinClosedLoopEncryptData(@NotNull String ticketRedirectUrl) {
        Intrinsics.checkNotNullParameter((Object)ticketRedirectUrl, (String)"ticketRedirectUrl");
        String $this$toUri$iv = ticketRedirectUrl;
        boolean $i$f$toUri = false;
        Uri uri = Uri.parse((String)$this$toUri$iv);
        Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"parse(this)");
        Uri uri2 = uri;
        String string2 = uri2.getQueryParameter(DouyinClosedLoopEncryptedDataKey);
        if (string2 == null) {
            string2 = "";
        }
        return string2;
    }

    private final boolean isDouyinOpenLoopTicket(String ticketCode) {
        String[] $this$forEach$iv = DouyinOpenLoopElements;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int j = 0; j < n; ++j) {
            String element$iv;
            String it = element$iv = $this$forEach$iv[j];
            boolean bl = false;
            if (StringsKt.contains$default((CharSequence)ticketCode, (CharSequence)it, (boolean)false, (int)2, null)) continue;
            return false;
        }
        return true;
    }

    static {
        String[] stringArray = new String[]{"app_id=", "encrypted_data=", "out_order_no="};
        DouyinOpenLoopElements = stringArray;
        DouyinClosedLoopPattern$delegate = LazyKt.lazy((Function0)DouyinClosedLoopPattern.2.INSTANCE);
    }
}

