/*
 * Decompiled with CFR 0.152.
 */
package com.huike.nova.sdk.model.domain;

import androidx.annotation.Keep;
import com.fshows.android.foundation.gears.FsKeychains;
import com.fshows.android.stark.extensions.HashingExt;
import com.huike.nova.sdk.ext.JsonExtKt;
import com.huike.nova.sdk.utils.RandomStringUtil;
import java.util.Map;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010%\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B#\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0001\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006J\u000b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0004H\u00c6\u0003J)\u0010\u0013\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00012\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0004H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0018J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u0004H\u00d6\u0001R\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0001X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\r\u00a8\u0006\u001c"}, d2={"Lcom/huike/nova/sdk/model/domain/NovaSigner;", "", "content", "nonce", "", "timestamp", "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/String;)V", "getContent", "()Ljava/lang/Object;", "setContent", "(Ljava/lang/Object;)V", "contentString", "getNonce", "()Ljava/lang/String;", "signature", "getTimestamp", "component1", "component2", "component3", "copy", "equals", "", "other", "getHeaderMap", "", "hashCode", "", "toString", "nova-sdk_debug"})
@Keep
public final class NovaSigner {
    @Nullable
    private Object content;
    @NotNull
    private final String nonce;
    @NotNull
    private final String timestamp;
    @NotNull
    private final String signature;
    @NotNull
    private final String contentString;

    public NovaSigner(@Nullable Object content, @NotNull String nonce, @NotNull String timestamp) {
        Intrinsics.checkNotNullParameter((Object)nonce, (String)"nonce");
        Intrinsics.checkNotNullParameter((Object)timestamp, (String)"timestamp");
        this.content = content;
        this.nonce = nonce;
        this.timestamp = timestamp;
        TreeMap json = new TreeMap();
        this.contentString = JsonExtKt.toJsonString(this.content instanceof Unit ? new Object() : this.content);
        ((Map)json).put("content", this.contentString);
        ((Map)json).put("nonce", this.nonce);
        Map map = json;
        String string = "salt";
        String string2 = FsKeychains.getKeychainItemValue((String)"nova-sdk.salt");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getKeychainItemValue(\"nova-sdk.salt\")");
        String string3 = string2;
        map.put(string, string3);
        ((Map)json).put("timestamp", this.timestamp);
        this.signature = HashingExt.md5((String)JsonExtKt.toJsonString(json));
    }

    public /* synthetic */ NovaSigner(Object object, String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = RandomStringUtil.randomString$default(RandomStringUtil.INSTANCE, 32, null, 2, null);
        }
        if ((n & 4) != 0) {
            string2 = String.valueOf(System.currentTimeMillis() / (long)1000);
        }
        this(object, string, string2);
    }

    @Nullable
    public final Object getContent() {
        return this.content;
    }

    public final void setContent(@Nullable Object object) {
        this.content = object;
    }

    @NotNull
    public final String getNonce() {
        return this.nonce;
    }

    @NotNull
    public final String getTimestamp() {
        return this.timestamp;
    }

    @NotNull
    public final Map<String, String> getHeaderMap() {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"nonce", (Object)this.nonce), TuplesKt.to((Object)"timestamp", (Object)this.timestamp), TuplesKt.to((Object)"sign", (Object)this.signature)};
        return MapsKt.mutableMapOf((Pair[])pairArray);
    }

    @Nullable
    public final Object component1() {
        return this.content;
    }

    @NotNull
    public final String component2() {
        return this.nonce;
    }

    @NotNull
    public final String component3() {
        return this.timestamp;
    }

    @NotNull
    public final NovaSigner copy(@Nullable Object content, @NotNull String nonce, @NotNull String timestamp) {
        Intrinsics.checkNotNullParameter((Object)nonce, (String)"nonce");
        Intrinsics.checkNotNullParameter((Object)timestamp, (String)"timestamp");
        return new NovaSigner(content, nonce, timestamp);
    }

    public static /* synthetic */ NovaSigner copy$default(NovaSigner novaSigner, Object object, String string, String string2, int n, Object object2) {
        if ((n & 1) != 0) {
            object = novaSigner.content;
        }
        if ((n & 2) != 0) {
            string = novaSigner.nonce;
        }
        if ((n & 4) != 0) {
            string2 = novaSigner.timestamp;
        }
        return novaSigner.copy(object, string, string2);
    }

    @NotNull
    public String toString() {
        return "NovaSigner(content=" + this.content + ", nonce=" + this.nonce + ", timestamp=" + this.timestamp + ')';
    }

    public int hashCode() {
        int result = this.content == null ? 0 : this.content.hashCode();
        result = result * 31 + this.nonce.hashCode();
        result = result * 31 + this.timestamp.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof NovaSigner)) {
            return false;
        }
        NovaSigner novaSigner = (NovaSigner)other;
        if (!Intrinsics.areEqual((Object)this.content, (Object)novaSigner.content)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.nonce, (Object)novaSigner.nonce)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.timestamp, (Object)novaSigner.timestamp);
    }
}

