/*
 * Decompiled with CFR 0.152.
 */
package sun.jdbc.rowset;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.AbstractList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.sql.RowSet;
import javax.sql.RowSetMetaData;
import org.xml.sax.AttributeList;
import org.xml.sax.HandlerBase;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import sun.jdbc.rowset.Row;
import sun.jdbc.rowset.RowSetMetaDataImpl;
import sun.jdbc.rowset.WebRowSet;

public class XmlReaderDocHandler
extends HandlerBase {
    private HashMap propMap;
    private HashMap colDefMap;
    private HashMap dataMap;
    private Vector updates;
    private Vector keyCols;
    private String columnValue;
    private String propertyValue;
    private String metaDataValue;
    private int tag;
    private int state;
    private WebRowSet rs;
    private boolean nullVal;
    private RowSetMetaData md;
    private int idx;
    private String[] properties = new String[]{"command", "concurrency", "datasource", "escape-processing", "fetch-direction", "fetch-size", "isolation-level", "key-columns", "map", "max-field-size", "max-rows", "query-timeout", "read-only", "rowset-type", "show-deleted", "table-name", "url", "null", "column", "type", "class"};
    private static final int CommandTag = 0;
    private static final int ConcurrencyTag = 1;
    private static final int DatasourceTag = 2;
    private static final int EscapeProcessingTag = 3;
    private static final int FetchDirectionTag = 4;
    private static final int FetchSizeTag = 5;
    private static final int IsolationLevelTag = 6;
    private static final int KeycolsTag = 7;
    private static final int MapTag = 8;
    private static final int MaxFieldSizeTag = 9;
    private static final int MaxRowsTag = 10;
    private static final int QueryTimeoutTag = 11;
    private static final int ReadOnlyTag = 12;
    private static final int RowsetTypeTag = 13;
    private static final int ShowDeletedTag = 14;
    private static final int TableNameTag = 15;
    private static final int UrlTag = 16;
    private static final int PropNullTag = 17;
    private static final int PropColumnTag = 18;
    private static final int PropTypeTag = 19;
    private static final int PropClassTag = 20;
    private String[] colDef = new String[]{"column-count", "column-definition", "column-index", "auto-increment", "case-sensitive", "currency", "nullable", "signed", "searchable", "column-display-size", "column-label", "column-name", "schema-name", "column-precision", "column-scale", "table-name", "catalog-name", "column-type", "column-type-name", "null"};
    private static final int ColumnCountTag = 0;
    private static final int ColumnDefinitionTag = 1;
    private static final int ColumnIndexTag = 2;
    private static final int AutoIncrementTag = 3;
    private static final int CaseSensitiveTag = 4;
    private static final int CurrencyTag = 5;
    private static final int NullableTag = 6;
    private static final int SignedTag = 7;
    private static final int SearchableTag = 8;
    private static final int ColumnDisplaySizeTag = 9;
    private static final int ColumnLabelTag = 10;
    private static final int ColumnNameTag = 11;
    private static final int SchemaNameTag = 12;
    private static final int ColumnPrecisionTag = 13;
    private static final int ColumnScaleTag = 14;
    private static final int MetaTableNameTag = 15;
    private static final int CatalogNameTag = 16;
    private static final int ColumnTypeTag = 17;
    private static final int ColumnTypeNameTag = 18;
    private static final int MetaNullTag = 19;
    private String[] data = new String[]{"row", "col", "ins", "del", "insdel", "upd", "null"};
    private static final int RowTag = 0;
    private static final int ColTag = 1;
    private static final int InsTag = 2;
    private static final int DelTag = 3;
    private static final int InsDelTag = 4;
    private static final int UpdTag = 5;
    private static final int NullTag = 6;
    private static final int INITIAL = 0;
    private static final int PROPERTIES = 1;
    private static final int METADATA = 2;
    private static final int DATA = 3;

    XmlReaderDocHandler(RowSet rowSet) {
        this.rs = (WebRowSet)rowSet;
        this.initMaps();
        this.updates = new Vector();
        this.columnValue = new String("");
        this.propertyValue = new String("");
        this.metaDataValue = new String("");
        this.nullVal = false;
        this.idx = 0;
    }

    private void applyUpdates() throws SAXException {
        if (this.updates.size() > 0) {
            try {
                Iterator iterator = ((AbstractList)this.updates).iterator();
                while (iterator.hasNext()) {
                    Object[] objectArray = (Object[])iterator.next();
                    this.idx = (Integer)objectArray[0];
                    this.insertValue((String)objectArray[1]);
                }
                this.rs.updateRow();
            }
            catch (SQLException sQLException) {
                throw new SAXException("Error updating row: " + sQLException.getMessage());
            }
            this.updates.removeAllElements();
        }
    }

    public void characters(char[] cArray, int n2, int n3) throws SAXException {
        try {
            switch (this.getState()) {
                case 1: {
                    this.propertyValue = new String(cArray, n2, n3);
                    break;
                }
                case 2: {
                    this.metaDataValue = new String(cArray, n2, n3);
                    break;
                }
                case 3: {
                    this.setDataValue(cArray, n2, n3);
                    break;
                }
                default: {
                    return;
                }
            }
        }
        catch (SQLException sQLException) {
            throw new SAXException("characters: " + sQLException.getMessage());
        }
    }

    public void endElement(String string) throws SAXException {
        block8 : switch (this.getState()) {
            case 1: {
                if (string.equals("properties")) {
                    this.state = 0;
                    break;
                }
                try {
                    int n2 = (Integer)this.propMap.get(string);
                    switch (n2) {
                        case 7: {
                            if (this.keyCols == null) break;
                            int[] nArray = new int[this.keyCols.size()];
                            int n3 = 0;
                            while (n3 < nArray.length) {
                                nArray[n3] = Integer.parseInt((String)this.keyCols.elementAt(n3));
                                ++n3;
                            }
                            this.rs.setKeyColumns(nArray);
                            break;
                        }
                    }
                    if (this.getNullValue()) {
                        this.setPropertyValue(null);
                        this.setNullValue(false);
                    } else {
                        this.setPropertyValue(this.propertyValue);
                    }
                }
                catch (SQLException sQLException) {
                    throw new SAXException(sQLException.getMessage());
                }
                this.propertyValue = new String("");
                this.setTag(-1);
                break;
            }
            case 2: {
                if (string.equals("metadata")) {
                    try {
                        this.rs.setMetaData(this.md);
                        this.state = 0;
                    }
                    catch (SQLException sQLException) {
                        throw new SAXException("Error setting Metadata: " + sQLException.getMessage());
                    }
                }
                try {
                    if (this.getNullValue()) {
                        this.setMetaDataValue(null);
                        this.setNullValue(false);
                    } else {
                        this.setMetaDataValue(this.metaDataValue);
                    }
                }
                catch (SQLException sQLException) {
                    throw new SAXException("Error setting Metadata: " + sQLException.getMessage());
                }
                this.metaDataValue = new String("");
                this.setTag(-1);
                break;
            }
            case 3: {
                if (string.equals("data")) {
                    this.state = 0;
                    return;
                }
                int n4 = (Integer)this.dataMap.get(string);
                switch (n4) {
                    case 1: {
                        try {
                            ++this.idx;
                            if (this.getNullValue()) {
                                this.insertValue(null);
                                this.setNullValue(false);
                            } else {
                                this.insertValue(this.columnValue);
                            }
                            this.columnValue = new String("");
                            break block8;
                        }
                        catch (SQLException sQLException) {
                            throw new SAXException("Error inserting values: " + sQLException.getMessage());
                        }
                    }
                    case 0: {
                        try {
                            this.rs.insertRow();
                            this.rs.moveToCurrentRow();
                            this.rs.next();
                            Row row = (Row)this.rs.getCurrentRow();
                            row.clearInserted();
                            this.applyUpdates();
                            break block8;
                        }
                        catch (SQLException sQLException) {
                            throw new SAXException("Error constructing row: " + sQLException.getMessage());
                        }
                    }
                    case 3: {
                        try {
                            this.rs.insertRow();
                            this.rs.moveToCurrentRow();
                            this.rs.next();
                            Row row = (Row)this.rs.getCurrentRow();
                            row.clearInserted();
                            row.setDeleted();
                            this.applyUpdates();
                            break block8;
                        }
                        catch (SQLException sQLException) {
                            throw new SAXException("Error constructing deleted row: " + sQLException.getMessage());
                        }
                    }
                    case 2: {
                        try {
                            this.rs.insertRow();
                            this.rs.moveToCurrentRow();
                            this.rs.next();
                            this.applyUpdates();
                            break block8;
                        }
                        catch (SQLException sQLException) {
                            throw new SAXException("Error constructing inserted row: " + sQLException.getMessage());
                        }
                    }
                    case 4: {
                        try {
                            this.rs.insertRow();
                            this.rs.moveToCurrentRow();
                            this.rs.next();
                            Row row = (Row)this.rs.getCurrentRow();
                            row.setDeleted();
                            this.applyUpdates();
                            break block8;
                        }
                        catch (SQLException sQLException) {
                            throw new SAXException("Error constructing insdel row: " + sQLException.getMessage());
                        }
                    }
                }
            }
        }
    }

    public void error(SAXParseException sAXParseException) throws SAXParseException {
        throw sAXParseException;
    }

    private BigDecimal getBigDecimalValue(String string) {
        return new BigDecimal(string);
    }

    private byte[] getBinaryValue(String string) {
        return string.getBytes();
    }

    private boolean getBooleanValue(String string) {
        return new Boolean(string);
    }

    private byte getByteValue(String string) {
        return Byte.parseByte(string);
    }

    private Date getDateValue(String string) {
        return new Date(this.getLongValue(string));
    }

    private double getDoubleValue(String string) {
        return Double.parseDouble(string);
    }

    private float getFloatValue(String string) {
        return Float.parseFloat(string);
    }

    private int getIntegerValue(String string) {
        return Integer.parseInt(string);
    }

    private long getLongValue(String string) {
        return Long.parseLong(string);
    }

    private boolean getNullValue() {
        return this.nullVal;
    }

    private short getShortValue(String string) {
        return Short.parseShort(string);
    }

    private int getState() {
        return this.state;
    }

    private String getStringValue(String string) {
        return string;
    }

    private int getTag() {
        return this.tag;
    }

    private Time getTimeValue(String string) {
        return new Time(this.getLongValue(string));
    }

    private Timestamp getTimestampValue(String string) {
        return new Timestamp(this.getLongValue(string));
    }

    private void initMaps() {
        this.propMap = new HashMap();
        int n2 = this.properties.length;
        int n3 = 0;
        while (n3 < n2) {
            this.propMap.put(this.properties[n3], new Integer(n3));
            ++n3;
        }
        this.colDefMap = new HashMap();
        n2 = this.colDef.length;
        n3 = 0;
        while (n3 < n2) {
            this.colDefMap.put(this.colDef[n3], new Integer(n3));
            ++n3;
        }
        this.dataMap = new HashMap();
        n2 = this.data.length;
        n3 = 0;
        while (n3 < n2) {
            this.dataMap.put(this.data[n3], new Integer(n3));
            ++n3;
        }
    }

    private void insertValue(String string) throws SQLException {
        if (this.getNullValue()) {
            this.rs.updateNull(this.idx);
            return;
        }
        int n2 = this.rs.getMetaData().getColumnType(this.idx);
        switch (n2) {
            case -7: {
                this.rs.updateByte(this.idx, this.getByteValue(string));
                break;
            }
            case 5: {
                this.rs.updateShort(this.idx, this.getShortValue(string));
                break;
            }
            case 4: {
                this.rs.updateInt(this.idx, this.getIntegerValue(string));
                break;
            }
            case -5: {
                this.rs.updateLong(this.idx, this.getLongValue(string));
                break;
            }
            case 6: 
            case 7: {
                this.rs.updateFloat(this.idx, this.getFloatValue(string));
                break;
            }
            case 8: {
                this.rs.updateDouble(this.idx, this.getDoubleValue(string));
                break;
            }
            case 2: 
            case 3: {
                this.rs.updateObject(this.idx, (Object)this.getBigDecimalValue(string));
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                this.rs.updateBytes(this.idx, this.getBinaryValue(string));
                break;
            }
            case 91: {
                this.rs.updateDate(this.idx, this.getDateValue(string));
                break;
            }
            case 92: {
                this.rs.updateTime(this.idx, this.getTimeValue(string));
                break;
            }
            case 93: {
                this.rs.updateTimestamp(this.idx, this.getTimestampValue(string));
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                this.rs.updateString(this.idx, this.getStringValue(string));
                break;
            }
            default: {
                System.out.println("Why here? Why now?");
            }
        }
    }

    private void setDataValue(char[] cArray, int n2, int n3) throws SQLException {
        switch (this.getTag()) {
            case 1: {
                this.columnValue = new String(cArray, n2, n3);
                break;
            }
            case 5: {
                Object[] objectArray = new Object[2];
                objectArray[1] = new String(cArray, n2, n3);
                objectArray[0] = new Integer(this.idx);
                this.updates.add(objectArray);
                break;
            }
        }
    }

    private void setMetaDataValue(String string) throws SQLException {
        boolean bl = this.getNullValue();
        switch (this.getTag()) {
            case 0: {
                this.md = new RowSetMetaDataImpl();
                this.idx = 0;
                if (bl) {
                    throw new SQLException("Bad value; non-nullable metadata");
                }
                this.md.setColumnCount(this.getIntegerValue(string));
                break;
            }
            case 2: {
                ++this.idx;
                break;
            }
            case 3: {
                if (bl) {
                    throw new SQLException("Bad value; non-nullable metadata");
                }
                this.md.setAutoIncrement(this.idx, this.getBooleanValue(string));
                break;
            }
            case 4: {
                if (bl) {
                    throw new SQLException("Bad value; non-nullable metadata");
                }
                this.md.setCaseSensitive(this.idx, this.getBooleanValue(string));
                break;
            }
            case 5: {
                if (bl) {
                    throw new SQLException("Bad value; non-nullable metadata");
                }
                this.md.setCurrency(this.idx, this.getBooleanValue(string));
                break;
            }
            case 6: {
                if (bl) {
                    throw new SQLException("Bad value; non-nullable metadata");
                }
                this.md.setNullable(this.idx, this.getIntegerValue(string));
                break;
            }
            case 7: {
                if (bl) {
                    throw new SQLException("Bad value; non-nullable metadata");
                }
                this.md.setSigned(this.idx, this.getBooleanValue(string));
                break;
            }
            case 8: {
                if (bl) {
                    throw new SQLException("Bad value; non-nullable metadata");
                }
                this.md.setSearchable(this.idx, this.getBooleanValue(string));
                break;
            }
            case 9: {
                if (bl) {
                    throw new SQLException("Bad value; non-nullable metadata");
                }
                this.md.setColumnDisplaySize(this.idx, this.getIntegerValue(string));
                break;
            }
            case 10: {
                if (bl) {
                    this.md.setColumnLabel(this.idx, null);
                    break;
                }
                this.md.setColumnLabel(this.idx, string);
                break;
            }
            case 11: {
                if (bl) {
                    this.md.setColumnName(this.idx, null);
                    break;
                }
                this.md.setColumnName(this.idx, string);
                break;
            }
            case 12: {
                if (bl) {
                    this.md.setSchemaName(this.idx, null);
                    break;
                }
                this.md.setSchemaName(this.idx, string);
                break;
            }
            case 13: {
                if (bl) {
                    throw new SQLException("Bad value; non-nullable metadata");
                }
                this.md.setPrecision(this.idx, this.getIntegerValue(string));
                break;
            }
            case 14: {
                if (bl) {
                    throw new SQLException("Bad value; non-nullable metadata");
                }
                this.md.setScale(this.idx, this.getIntegerValue(string));
                break;
            }
            case 15: {
                if (bl) {
                    this.md.setTableName(this.idx, null);
                    break;
                }
                this.md.setTableName(this.idx, string);
                break;
            }
            case 16: {
                if (bl) {
                    this.md.setCatalogName(this.idx, null);
                    break;
                }
                this.md.setCatalogName(this.idx, string);
                break;
            }
            case 17: {
                if (bl) {
                    throw new SQLException("Bad value; non-nullable metadata");
                }
                this.md.setColumnType(this.idx, this.getIntegerValue(string));
                break;
            }
            case 18: {
                if (bl) {
                    this.md.setColumnTypeName(this.idx, null);
                    break;
                }
                this.md.setColumnTypeName(this.idx, string);
                break;
            }
        }
    }

    private void setNullValue(boolean bl) {
        this.nullVal = bl;
    }

    private void setPropertyValue(String string) throws SQLException {
        boolean bl = this.getNullValue();
        switch (this.getTag()) {
            case 0: {
                if (bl) {
                    this.rs.setCommand(null);
                    break;
                }
                this.rs.setCommand(string);
                break;
            }
            case 1: {
                if (bl) {
                    throw new SQLException("Bad value; non-nullable property");
                }
                this.rs.setConcurrency(this.getIntegerValue(string));
                break;
            }
            case 2: {
                if (bl) {
                    this.rs.setDataSourceName(null);
                    break;
                }
                this.rs.setDataSourceName(string);
                break;
            }
            case 3: {
                if (bl) {
                    throw new SQLException("Bad value; non-nullable property");
                }
                this.rs.setEscapeProcessing(this.getBooleanValue(string));
                break;
            }
            case 4: {
                if (bl) {
                    throw new SQLException("Bad value; non-nullable property");
                }
                this.rs.setFetchDirection(this.getIntegerValue(string));
                break;
            }
            case 5: {
                if (bl) {
                    throw new SQLException("Bad value; non-nullable property");
                }
                this.rs.setFetchSize(this.getIntegerValue(string));
                break;
            }
            case 6: {
                if (bl) {
                    throw new SQLException("Bad value; non-nullable property");
                }
                this.rs.setTransactionIsolation(this.getIntegerValue(string));
                break;
            }
            case 18: {
                if (this.keyCols == null) {
                    this.keyCols = new Vector();
                }
                this.keyCols.add(string);
                break;
            }
            case 9: {
                if (bl) {
                    throw new SQLException("Bad value; non-nullable property");
                }
                this.rs.setMaxFieldSize(this.getIntegerValue(string));
                break;
            }
            case 10: {
                if (bl) {
                    throw new SQLException("Bad value; non-nullable property");
                }
                this.rs.setMaxRows(this.getIntegerValue(string));
                break;
            }
            case 11: {
                if (bl) {
                    throw new SQLException("Bad value; non-nullable property");
                }
                this.rs.setQueryTimeout(this.getIntegerValue(string));
                break;
            }
            case 12: {
                if (bl) {
                    throw new SQLException("Bad value; non-nullable property");
                }
                this.rs.setReadOnly(this.getBooleanValue(string));
                break;
            }
            case 13: {
                if (bl) {
                    throw new SQLException("Bad value; non-nullable property");
                }
                this.rs.setType(this.getIntegerValue(string));
                break;
            }
            case 14: {
                if (bl) {
                    throw new SQLException("Bad value; non-nullable property");
                }
                this.rs.setShowDeleted(this.getBooleanValue(string));
                break;
            }
            case 15: {
                if (bl) {
                    this.rs.setTableName(null);
                    break;
                }
                this.rs.setTableName(string);
                break;
            }
            case 16: {
                if (bl) {
                    this.rs.setUrl(null);
                    break;
                }
                this.rs.setUrl(string);
                break;
            }
        }
    }

    private void setState(String string) throws SAXException {
        if (string.equals("RowSet")) {
            this.state = 0;
        } else if (string.equals("properties")) {
            this.state = this.state != 1 ? 1 : 0;
        } else if (string.equals("metadata")) {
            this.state = this.state != 2 ? 2 : 0;
        } else if (string.equals("data")) {
            this.state = this.state != 3 ? 3 : 0;
        }
    }

    private void setTag(int n2) {
        this.tag = n2;
    }

    public void startElement(String string, AttributeList attributeList) throws SAXException {
        switch (this.getState()) {
            case 1: {
                int n2 = (Integer)this.propMap.get(string);
                if (n2 == 17) {
                    this.setNullValue(true);
                    break;
                }
                this.setTag(n2);
                break;
            }
            case 2: {
                int n3 = (Integer)this.colDefMap.get(string);
                if (n3 == 19) {
                    this.setNullValue(true);
                    break;
                }
                this.setTag(n3);
                break;
            }
            case 3: {
                int n4 = (Integer)this.dataMap.get(string);
                if (n4 == 6) {
                    this.setNullValue(true);
                    break;
                }
                this.setTag(n4);
                if (n4 != 0 && n4 != 3 && n4 != 2) break;
                this.idx = 0;
                try {
                    this.rs.moveToInsertRow();
                }
                catch (SQLException sQLException) {}
                break;
            }
            default: {
                this.setState(string);
            }
        }
    }

    public void warning(SAXParseException sAXParseException) throws SAXParseException {
        System.out.println("** Warning, line " + sAXParseException.getLineNumber() + ", uri " + sAXParseException.getSystemId());
        System.out.println("   " + sAXParseException.getMessage());
    }
}

