/*
 * Decompiled with CFR 0.152.
 */
package sun.jdbc.rowset;

import java.io.Serializable;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Struct;
import java.util.Map;
import sun.jdbc.rowset.SerialBlob;
import sun.jdbc.rowset.SerialClob;
import sun.jdbc.rowset.SerialStruct;

class SerialArray
implements Array,
Serializable,
Cloneable {
    private Object[] elements;
    private int baseType;
    private String baseTypeName;
    private int len;

    SerialArray(Array array, Map map) throws SQLException {
        this.elements = (Object[])array.getArray(map);
        this.baseType = this.getBaseType();
        this.baseTypeName = this.getBaseTypeName();
        this.len = this.elements.length;
        switch (this.baseType) {
            case 2002: {
                int n2 = 0;
                while (n2 < this.len) {
                    this.elements[n2] = new SerialStruct((Struct)this.elements[n2], map);
                    ++n2;
                }
                break;
            }
            case 2003: {
                int n3 = 0;
                while (n3 < this.len) {
                    this.elements[n3] = new SerialArray((Array)this.elements[n3], map);
                    ++n3;
                }
                break;
            }
            case 2004: {
                int n4 = 0;
                while (n4 < this.len) {
                    this.elements[n4] = new SerialBlob((Blob)this.elements[n4]);
                    ++n4;
                }
                break;
            }
            case 2005: {
                int n5 = 0;
                while (n5 < this.len) {
                    this.elements[n5] = new SerialClob((Clob)this.elements[n5]);
                    ++n5;
                }
                break;
            }
        }
    }

    public Object getArray() throws SQLException {
        Object[] objectArray = new Object[this.len];
        System.arraycopy(this.elements, 0, objectArray, 0, this.len);
        return objectArray;
    }

    public Object getArray(long l2, int n2) throws SQLException {
        Object[] objectArray = new Object[n2];
        System.arraycopy(this.elements, (int)l2, objectArray, 0, n2);
        return objectArray;
    }

    public Object getArray(long l2, int n2, Map map) throws SQLException {
        Object[] objectArray = new Object[n2];
        System.arraycopy(this.elements, (int)l2, objectArray, 0, n2);
        return objectArray;
    }

    public Object getArray(Map map) throws SQLException {
        Object[] objectArray = new Object[this.len];
        System.arraycopy(this.elements, 0, objectArray, 0, this.len);
        return objectArray;
    }

    public int getBaseType() throws SQLException {
        return this.baseType;
    }

    public String getBaseTypeName() throws SQLException {
        return this.baseTypeName;
    }

    public ResultSet getResultSet() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public ResultSet getResultSet(long l2, int n2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public ResultSet getResultSet(long l2, int n2, Map map) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public ResultSet getResultSet(Map map) throws SQLException {
        throw new UnsupportedOperationException();
    }
}

