/*
 * Decompiled with CFR 0.152.
 */
package sun.jdbc.rowset;

import java.io.Serializable;
import java.sql.SQLException;
import javax.sql.RowSetMetaData;
import sun.jdbc.rowset.ColInfo;

public class RowSetMetaDataImpl
implements RowSetMetaData,
Serializable {
    private int colCount;
    private ColInfo[] colInfo;

    private void checkColRange(int n2) throws SQLException {
        if (n2 <= 0 || n2 > this.colCount) {
            throw new SQLException("Invalid column index");
        }
    }

    public String getCatalogName(int n2) throws SQLException {
        this.checkColRange(n2);
        return this.colInfo[n2].catName;
    }

    public String getColumnClassName(int n2) throws SQLException {
        return null;
    }

    public int getColumnCount() throws SQLException {
        return this.colCount;
    }

    public int getColumnDisplaySize(int n2) throws SQLException {
        this.checkColRange(n2);
        return this.colInfo[n2].columnDisplaySize;
    }

    public String getColumnLabel(int n2) throws SQLException {
        this.checkColRange(n2);
        return this.colInfo[n2].columnLabel;
    }

    public String getColumnName(int n2) throws SQLException {
        this.checkColRange(n2);
        return this.colInfo[n2].columnName;
    }

    public int getColumnType(int n2) throws SQLException {
        this.checkColRange(n2);
        return this.colInfo[n2].colType;
    }

    public String getColumnTypeName(int n2) throws SQLException {
        this.checkColRange(n2);
        return this.colInfo[n2].colTypeName;
    }

    public int getPrecision(int n2) throws SQLException {
        this.checkColRange(n2);
        return this.colInfo[n2].colPrecision;
    }

    public int getScale(int n2) throws SQLException {
        this.checkColRange(n2);
        return this.colInfo[n2].colScale;
    }

    public String getSchemaName(int n2) throws SQLException {
        this.checkColRange(n2);
        return this.colInfo[n2].schemaName;
    }

    public String getTableName(int n2) throws SQLException {
        this.checkColRange(n2);
        return this.colInfo[n2].tableName;
    }

    public boolean isAutoIncrement(int n2) throws SQLException {
        this.checkColRange(n2);
        return this.colInfo[n2].autoIncrement;
    }

    public boolean isCaseSensitive(int n2) throws SQLException {
        this.checkColRange(n2);
        return this.colInfo[n2].caseSensitive;
    }

    public boolean isCurrency(int n2) throws SQLException {
        this.checkColRange(n2);
        return this.colInfo[n2].currency;
    }

    public boolean isDefinitelyWritable(int n2) throws SQLException {
        return true;
    }

    public int isNullable(int n2) throws SQLException {
        this.checkColRange(n2);
        return this.colInfo[n2].nullable;
    }

    public boolean isReadOnly(int n2) throws SQLException {
        this.checkColRange(n2);
        return true;
    }

    public boolean isSearchable(int n2) throws SQLException {
        this.checkColRange(n2);
        return this.colInfo[n2].searchable;
    }

    public boolean isSigned(int n2) throws SQLException {
        this.checkColRange(n2);
        return this.colInfo[n2].signed;
    }

    public boolean isWritable(int n2) throws SQLException {
        this.checkColRange(n2);
        return false;
    }

    public void setAutoIncrement(int n2, boolean bl) throws SQLException {
        this.checkColRange(n2);
        this.colInfo[n2].autoIncrement = bl;
    }

    public void setCaseSensitive(int n2, boolean bl) throws SQLException {
        this.checkColRange(n2);
        this.colInfo[n2].caseSensitive = bl;
    }

    public void setCatalogName(int n2, String string) throws SQLException {
        this.checkColRange(n2);
        this.colInfo[n2].catName = new String(string);
    }

    public void setColumnCount(int n2) throws SQLException {
        if (n2 <= 0) {
            throw new SQLException("Invalid column count");
        }
        this.colCount = n2;
        this.colInfo = new ColInfo[this.colCount + 1];
        int n3 = 1;
        while (n3 <= this.colCount) {
            this.colInfo[n3] = new ColInfo();
            ++n3;
        }
    }

    public void setColumnDisplaySize(int n2, int n3) throws SQLException {
        this.checkColRange(n2);
        this.colInfo[n2].columnDisplaySize = n3;
    }

    public void setColumnLabel(int n2, String string) throws SQLException {
        this.checkColRange(n2);
        this.colInfo[n2].columnLabel = new String(string);
    }

    public void setColumnName(int n2, String string) throws SQLException {
        this.checkColRange(n2);
        this.colInfo[n2].columnName = new String(string);
    }

    public void setColumnType(int n2, int n3) throws SQLException {
        this.checkColRange(n2);
        this.colInfo[n2].colType = n3;
    }

    public void setColumnTypeName(int n2, String string) throws SQLException {
        this.checkColRange(n2);
        this.colInfo[n2].colTypeName = new String(string);
    }

    public void setCurrency(int n2, boolean bl) throws SQLException {
        this.checkColRange(n2);
        this.colInfo[n2].currency = bl;
    }

    public void setNullable(int n2, int n3) throws SQLException {
        this.checkColRange(n2);
        this.colInfo[n2].nullable = n3;
    }

    public void setPrecision(int n2, int n3) throws SQLException {
        this.checkColRange(n2);
        this.colInfo[n2].colPrecision = n3;
    }

    public void setScale(int n2, int n3) throws SQLException {
        this.checkColRange(n2);
        this.colInfo[n2].colScale = n3;
    }

    public void setSchemaName(int n2, String string) throws SQLException {
        this.checkColRange(n2);
        this.colInfo[n2].schemaName = new String(string);
    }

    public void setSearchable(int n2, boolean bl) throws SQLException {
        this.checkColRange(n2);
        this.colInfo[n2].searchable = bl;
    }

    public void setSigned(int n2, boolean bl) throws SQLException {
        this.checkColRange(n2);
        this.colInfo[n2].signed = bl;
    }

    public void setTableName(int n2, String string) throws SQLException {
        this.checkColRange(n2);
        this.colInfo[n2].tableName = string != null ? new String(string) : new String("");
    }
}

