/*
 * Decompiled with CFR 0.152.
 */
package sun.jdbc.rowset;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.BitSet;
import sun.jdbc.rowset.BaseRow;

class Row
extends BaseRow
implements Serializable,
Cloneable {
    private Object[] currentVals;
    private BitSet colsChanged;
    private boolean deleted;
    private boolean updated;
    private boolean inserted;
    private int numCols;

    Row(int n2) {
        this.origVals = new Object[n2];
        this.currentVals = new Object[n2];
        this.colsChanged = new BitSet(n2);
        this.numCols = n2;
    }

    Row(int n2, Object[] objectArray) {
        this.origVals = new Object[n2];
        int n3 = 0;
        while (n3 < n2) {
            this.origVals[n3] = objectArray[n3];
            ++n3;
        }
        this.currentVals = new Object[n2];
        this.colsChanged = new BitSet(n2);
        this.numCols = n2;
    }

    protected void clearDeleted() {
        this.deleted = false;
    }

    protected void clearInserted() {
        this.inserted = false;
    }

    protected void clearUpdated() {
        this.updated = false;
        int n2 = 0;
        while (n2 < this.numCols) {
            this.currentVals[n2] = null;
            this.colsChanged.clear(n2);
            ++n2;
        }
    }

    protected boolean getColUpdated(int n2) {
        return this.colsChanged.get(n2);
    }

    protected Object getColumnObject(int n2) throws SQLException {
        if (this.getColUpdated(n2 - 1)) {
            return this.currentVals[n2 - 1];
        }
        return this.origVals[n2 - 1];
    }

    protected boolean getDeleted() {
        return this.deleted;
    }

    protected boolean getInserted() {
        return this.inserted;
    }

    protected boolean getUpdated() {
        return this.updated;
    }

    protected void initColumnObject(int n2, Object object) {
        this.origVals[n2 - 1] = object;
    }

    protected void moveCurrentToOrig() {
        int n2 = 0;
        while (n2 < this.numCols) {
            if (this.getColUpdated(n2)) {
                this.origVals[n2] = this.currentVals[n2];
                this.currentVals[n2] = null;
                this.colsChanged.clear(n2);
            }
            ++n2;
        }
        this.updated = false;
    }

    private void setColUpdated(int n2) {
        this.colsChanged.set(n2);
    }

    protected void setColumnObject(int n2, Object object) {
        this.currentVals[n2 - 1] = object;
        this.setColUpdated(n2 - 1);
    }

    protected void setDeleted() {
        this.deleted = true;
    }

    protected void setInserted() {
        this.inserted = true;
    }

    protected void setUpdated() {
        int n2 = 0;
        while (n2 < this.numCols) {
            if (this.getColUpdated(n2)) {
                this.updated = true;
                return;
            }
            ++n2;
        }
    }
}

