/*
 * Decompiled with CFR 0.152.
 */
package sun.jdbc.rowset;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.sql.RowSet;
import sun.jdbc.rowset.BaseRowSet;

public class JdbcRowSet
extends BaseRowSet
implements RowSet {
    private Connection conn = null;
    private PreparedStatement ps = null;
    private ResultSet rs = null;

    public JdbcRowSet() throws SQLException {
        this.initParams();
        this.setShowDeleted(false);
        this.setQueryTimeout(0);
        this.setMaxRows(0);
        this.setMaxFieldSize(0);
        this.setType(1004);
        this.setConcurrency(1007);
        this.setReadOnly(true);
        this.setTransactionIsolation(2);
        this.setEscapeProcessing(true);
        this.setTypeMap(null);
    }

    public boolean absolute(int n2) throws SQLException {
        this.checkState();
        boolean bl = this.rs.absolute(n2);
        this.notifyCursorMoved();
        return bl;
    }

    public void afterLast() throws SQLException {
        this.checkState();
        this.rs.afterLast();
        this.notifyCursorMoved();
    }

    public void beforeFirst() throws SQLException {
        this.checkState();
        this.rs.beforeFirst();
        this.notifyCursorMoved();
    }

    public void cancelRowUpdates() throws SQLException {
        this.checkState();
        this.rs.cancelRowUpdates();
        this.notifyRowChanged();
    }

    void checkState() throws SQLException {
        if (this.conn == null || this.ps == null || this.rs == null) {
            throw new SQLException("Invalid State");
        }
    }

    public void clearWarnings() throws SQLException {
        this.checkState();
        this.rs.clearWarnings();
    }

    public void close() throws SQLException {
        if (this.rs != null) {
            this.rs.close();
        }
        if (this.ps != null) {
            this.ps.close();
        }
        if (this.conn != null) {
            this.conn.close();
        }
    }

    private Connection connect() throws SQLException {
        if (this.getDataSourceName() != null) {
            try {
                InitialContext initialContext = new InitialContext();
                DataSource dataSource = (DataSource)initialContext.lookup(this.getDataSourceName());
                return dataSource.getConnection(this.getUsername(), this.getPassword());
            }
            catch (NamingException namingException) {
                throw new SQLException("(JNDI) Unable to connect");
            }
        }
        if (this.getUrl() != null) {
            return DriverManager.getConnection(this.getUrl(), this.getUsername(), this.getPassword());
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void decodeParams(Object[] objectArray, PreparedStatement preparedStatement) throws SQLException {
        Object[] objectArray2 = null;
        int n2 = 0;
        while (n2 < objectArray.length) {
            if (objectArray2[n2] instanceof Object[]) {
                objectArray2 = (Object[])objectArray[n2];
                if (objectArray2.length == 2) {
                    if (objectArray2[0] == null) {
                        preparedStatement.setNull(n2 + 1, (Integer)objectArray2[1]);
                    } else if (objectArray2[0] instanceof Date || objectArray2[0] instanceof Time || objectArray2[0] instanceof Timestamp) {
                        System.err.println("Detected a Date");
                        if (!(objectArray2[1] instanceof Calendar)) throw new SQLException("Unable to deduce param type");
                        System.err.println("Detected a Calendar");
                        preparedStatement.setDate(n2 + 1, (Date)objectArray2[0], (Calendar)objectArray2[1]);
                    } else if (objectArray2[0] instanceof Reader) {
                        preparedStatement.setCharacterStream(n2 + 1, (Reader)objectArray2[0], (Integer)objectArray2[1]);
                    } else if (objectArray2[1] instanceof Integer) {
                        preparedStatement.setObject(n2 + 1, objectArray2[0], (Integer)objectArray2[1]);
                    }
                } else if (objectArray2.length == 3) {
                    if (objectArray2[0] == null) {
                        preparedStatement.setNull(n2 + 1, (Integer)objectArray2[1], (String)objectArray2[2]);
                    } else {
                        if (objectArray2[0] instanceof InputStream) {
                            switch ((Integer)objectArray2[2]) {
                                case 0: {
                                    preparedStatement.setUnicodeStream(n2 + 1, (InputStream)objectArray2[0], (Integer)objectArray2[1]);
                                }
                                case 1: {
                                    preparedStatement.setBinaryStream(n2 + 1, (InputStream)objectArray2[0], (Integer)objectArray2[1]);
                                }
                                case 2: {
                                    preparedStatement.setAsciiStream(n2 + 1, (InputStream)objectArray2[0], (Integer)objectArray2[1]);
                                }
                            }
                            throw new SQLException("Unable to deduce parameter type");
                        }
                        if (!(objectArray2[1] instanceof Integer) || !(objectArray2[2] instanceof Integer)) throw new SQLException("Unable to deduce param type");
                        preparedStatement.setObject(n2 + 1, objectArray2[0], (Integer)objectArray2[1], (int)((Integer)objectArray2[2]));
                    }
                } else {
                    preparedStatement.setObject(n2 + 1, objectArray[n2]);
                }
            }
            ++n2;
        }
    }

    public void deleteRow() throws SQLException {
        this.checkState();
        this.rs.deleteRow();
        this.notifyRowChanged();
    }

    public void execute() throws SQLException {
        this.conn = this.connect();
        try {
            this.conn.setTransactionIsolation(this.getTransactionIsolation());
        }
        catch (SQLException sQLException) {
            System.err.println("JdbcRowSet (setTransactionIsolation): " + sQLException.getMessage());
        }
        try {
            this.conn.setTypeMap(this.getTypeMap());
        }
        catch (Throwable throwable) {
            System.err.println("JdbcRowSet (setTypeMap): " + throwable.getMessage());
        }
        try {
            this.ps = this.conn.prepareStatement(this.getCommand());
        }
        catch (SQLException sQLException) {
            System.err.println("JdbcRowSet (execute): " + sQLException.getMessage());
            if (this.ps != null) {
                this.ps.close();
            }
            if (this.conn != null) {
                this.conn.close();
            }
            throw new SQLException(sQLException.getMessage());
        }
        this.setProperties(this.ps);
        this.decodeParams(this.getParams(), this.ps);
        this.rs = this.ps.executeQuery();
        this.notifyRowSetChanged();
    }

    public int findColumn(String string) throws SQLException {
        this.checkState();
        return this.rs.findColumn(string);
    }

    public boolean first() throws SQLException {
        this.checkState();
        boolean bl = this.rs.first();
        this.notifyCursorMoved();
        return bl;
    }

    public Array getArray(int n2) throws SQLException {
        this.checkState();
        return this.rs.getArray(n2);
    }

    public Array getArray(String string) throws SQLException {
        return this.getArray(this.findColumn(string));
    }

    public InputStream getAsciiStream(int n2) throws SQLException {
        this.checkState();
        return this.rs.getAsciiStream(n2);
    }

    public InputStream getAsciiStream(String string) throws SQLException {
        return this.getAsciiStream(this.findColumn(string));
    }

    public BigDecimal getBigDecimal(int n2) throws SQLException {
        this.checkState();
        return this.rs.getBigDecimal(n2);
    }

    public BigDecimal getBigDecimal(int n2, int n3) throws SQLException {
        this.checkState();
        return this.rs.getBigDecimal(n2, n3);
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        return this.getBigDecimal(this.findColumn(string));
    }

    public BigDecimal getBigDecimal(String string, int n2) throws SQLException {
        return this.getBigDecimal(this.findColumn(string), n2);
    }

    public InputStream getBinaryStream(int n2) throws SQLException {
        this.checkState();
        return this.rs.getBinaryStream(n2);
    }

    public InputStream getBinaryStream(String string) throws SQLException {
        return this.getBinaryStream(this.findColumn(string));
    }

    public Blob getBlob(int n2) throws SQLException {
        this.checkState();
        return this.rs.getBlob(n2);
    }

    public Blob getBlob(String string) throws SQLException {
        return this.getBlob(this.findColumn(string));
    }

    public boolean getBoolean(int n2) throws SQLException {
        this.checkState();
        return this.rs.getBoolean(n2);
    }

    public boolean getBoolean(String string) throws SQLException {
        return this.getBoolean(this.findColumn(string));
    }

    public byte getByte(int n2) throws SQLException {
        this.checkState();
        return this.rs.getByte(n2);
    }

    public byte getByte(String string) throws SQLException {
        return this.getByte(this.findColumn(string));
    }

    public byte[] getBytes(int n2) throws SQLException {
        this.checkState();
        return this.rs.getBytes(n2);
    }

    public byte[] getBytes(String string) throws SQLException {
        return this.getBytes(this.findColumn(string));
    }

    public Reader getCharacterStream(int n2) throws SQLException {
        this.checkState();
        return this.rs.getCharacterStream(n2);
    }

    public Reader getCharacterStream(String string) throws SQLException {
        return this.getCharacterStream(this.findColumn(string));
    }

    public Clob getClob(int n2) throws SQLException {
        this.checkState();
        return this.rs.getClob(n2);
    }

    public Clob getClob(String string) throws SQLException {
        return this.getClob(this.findColumn(string));
    }

    public int getConcurrency() throws SQLException {
        this.checkState();
        return this.rs.getConcurrency();
    }

    public String getCursorName() throws SQLException {
        this.checkState();
        return this.rs.getCursorName();
    }

    public Date getDate(int n2) throws SQLException {
        this.checkState();
        return this.rs.getDate(n2);
    }

    public Date getDate(int n2, Calendar calendar) throws SQLException {
        this.checkState();
        return this.rs.getDate(n2, calendar);
    }

    public Date getDate(String string) throws SQLException {
        return this.getDate(this.findColumn(string));
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        return this.getDate(this.findColumn(string), calendar);
    }

    public double getDouble(int n2) throws SQLException {
        this.checkState();
        return this.rs.getDouble(n2);
    }

    public double getDouble(String string) throws SQLException {
        return this.getDouble(this.findColumn(string));
    }

    public int getFetchDirection() throws SQLException {
        this.checkState();
        return this.rs.getFetchDirection();
    }

    public float getFloat(int n2) throws SQLException {
        this.checkState();
        return this.rs.getFloat(n2);
    }

    public float getFloat(String string) throws SQLException {
        return this.getFloat(this.findColumn(string));
    }

    public int getInt(int n2) throws SQLException {
        this.checkState();
        return this.rs.getInt(n2);
    }

    public int getInt(String string) throws SQLException {
        return this.getInt(this.findColumn(string));
    }

    public long getLong(int n2) throws SQLException {
        this.checkState();
        return this.rs.getLong(n2);
    }

    public long getLong(String string) throws SQLException {
        return this.getLong(this.findColumn(string));
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkState();
        return this.rs.getMetaData();
    }

    public Object getObject(int n2) throws SQLException {
        this.checkState();
        return this.rs.getObject(n2);
    }

    public Object getObject(int n2, Map map) throws SQLException {
        this.checkState();
        return this.rs.getObject(n2, map);
    }

    public Object getObject(String string) throws SQLException {
        return this.getObject(this.findColumn(string));
    }

    public Object getObject(String string, Map map) throws SQLException {
        return this.getObject(this.findColumn(string), map);
    }

    public Ref getRef(int n2) throws SQLException {
        this.checkState();
        return this.rs.getRef(n2);
    }

    public Ref getRef(String string) throws SQLException {
        return this.getRef(this.findColumn(string));
    }

    public int getRow() throws SQLException {
        this.checkState();
        return this.rs.getRow();
    }

    public short getShort(int n2) throws SQLException {
        this.checkState();
        return this.rs.getShort(n2);
    }

    public short getShort(String string) throws SQLException {
        return this.getShort(this.findColumn(string));
    }

    public Statement getStatement() throws SQLException {
        throw new SQLException("Unsupported Operation");
    }

    public String getString(int n2) throws SQLException {
        this.checkState();
        return this.rs.getString(n2);
    }

    public String getString(String string) throws SQLException {
        return this.getString(this.findColumn(string));
    }

    public Time getTime(int n2) throws SQLException {
        this.checkState();
        return this.rs.getTime(n2);
    }

    public Time getTime(int n2, Calendar calendar) throws SQLException {
        this.checkState();
        return this.rs.getTime(n2, calendar);
    }

    public Time getTime(String string) throws SQLException {
        return this.getTime(this.findColumn(string));
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        return this.getTime(this.findColumn(string), calendar);
    }

    public Timestamp getTimestamp(int n2) throws SQLException {
        this.checkState();
        return this.rs.getTimestamp(n2);
    }

    public Timestamp getTimestamp(int n2, Calendar calendar) throws SQLException {
        this.checkState();
        return this.rs.getTimestamp(n2, calendar);
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        return this.getTimestamp(this.findColumn(string));
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return this.getTimestamp(this.findColumn(string), calendar);
    }

    public int getType() throws SQLException {
        this.checkState();
        return this.rs.getType();
    }

    public InputStream getUnicodeStream(int n2) throws SQLException {
        this.checkState();
        return this.rs.getUnicodeStream(n2);
    }

    public InputStream getUnicodeStream(String string) throws SQLException {
        return this.getUnicodeStream(this.findColumn(string));
    }

    public SQLWarning getWarnings() throws SQLException {
        this.checkState();
        return this.rs.getWarnings();
    }

    public void insertRow() throws SQLException {
        this.checkState();
        this.rs.insertRow();
        this.notifyRowChanged();
    }

    public boolean isAfterLast() throws SQLException {
        this.checkState();
        return this.rs.isAfterLast();
    }

    public boolean isBeforeFirst() throws SQLException {
        this.checkState();
        return this.rs.isBeforeFirst();
    }

    public boolean isFirst() throws SQLException {
        this.checkState();
        return this.rs.isFirst();
    }

    public boolean isLast() throws SQLException {
        this.checkState();
        return this.rs.isLast();
    }

    public boolean last() throws SQLException {
        this.checkState();
        boolean bl = this.rs.last();
        this.notifyCursorMoved();
        return bl;
    }

    public void moveToCurrentRow() throws SQLException {
        this.checkState();
        this.rs.moveToCurrentRow();
    }

    public void moveToInsertRow() throws SQLException {
        this.checkState();
        this.rs.moveToInsertRow();
    }

    public boolean next() throws SQLException {
        this.checkState();
        boolean bl = this.rs.next();
        this.notifyCursorMoved();
        return bl;
    }

    public boolean previous() throws SQLException {
        this.checkState();
        boolean bl = this.rs.previous();
        this.notifyCursorMoved();
        return bl;
    }

    public void refreshRow() throws SQLException {
        this.checkState();
        this.rs.refreshRow();
    }

    public boolean relative(int n2) throws SQLException {
        this.checkState();
        boolean bl = this.rs.relative(n2);
        this.notifyCursorMoved();
        return bl;
    }

    public boolean rowDeleted() throws SQLException {
        this.checkState();
        return this.rs.rowDeleted();
    }

    public boolean rowInserted() throws SQLException {
        this.checkState();
        return this.rs.rowInserted();
    }

    public boolean rowUpdated() throws SQLException {
        this.checkState();
        return this.rs.rowUpdated();
    }

    public void setFetchDirection(int n2) throws SQLException {
        this.checkState();
        this.rs.setFetchDirection(n2);
    }

    public void setFetchSize(int n2) throws SQLException {
        this.checkState();
        this.rs.setFetchSize(n2);
    }

    private void setProperties(PreparedStatement preparedStatement) throws SQLException {
        try {
            preparedStatement.setEscapeProcessing(this.getEscapeProcessing());
        }
        catch (SQLException sQLException) {
            System.err.println("JdbcRowSet (setEscapeProcessing): " + sQLException.getMessage());
        }
        try {
            preparedStatement.setMaxFieldSize(this.getMaxFieldSize());
        }
        catch (SQLException sQLException) {
            System.err.println("JdbcRowSet (setMaxFieldSize): " + sQLException.getMessage());
        }
        try {
            preparedStatement.setMaxRows(this.getMaxRows());
        }
        catch (SQLException sQLException) {
            System.err.println("JdbcRowSet (setMaxRows): " + sQLException.getMessage());
        }
        try {
            preparedStatement.setQueryTimeout(this.getQueryTimeout());
        }
        catch (SQLException sQLException) {
            System.err.println("JdbcRowSet (setQueryTimeout): " + sQLException.getMessage());
        }
    }

    public void updateAsciiStream(int n2, InputStream inputStream, int n3) throws SQLException {
        this.checkState();
        this.rs.updateAsciiStream(n2, inputStream, n3);
    }

    public void updateAsciiStream(String string, InputStream inputStream, int n2) throws SQLException {
        this.updateAsciiStream(this.findColumn(string), inputStream, n2);
    }

    public void updateBigDecimal(int n2, BigDecimal bigDecimal) throws SQLException {
        this.checkState();
        this.rs.updateBigDecimal(n2, bigDecimal);
    }

    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.updateBigDecimal(this.findColumn(string), bigDecimal);
    }

    public void updateBinaryStream(int n2, InputStream inputStream, int n3) throws SQLException {
        this.checkState();
        this.rs.updateBinaryStream(n2, inputStream, n3);
    }

    public void updateBinaryStream(String string, InputStream inputStream, int n2) throws SQLException {
        this.updateBinaryStream(this.findColumn(string), inputStream, n2);
    }

    public void updateBoolean(int n2, boolean bl) throws SQLException {
        this.checkState();
        this.rs.updateBoolean(n2, bl);
    }

    public void updateBoolean(String string, boolean bl) throws SQLException {
        this.updateBoolean(this.findColumn(string), bl);
    }

    public void updateByte(int n2, byte by) throws SQLException {
        this.checkState();
        this.rs.updateByte(n2, by);
    }

    public void updateByte(String string, byte by) throws SQLException {
        this.updateByte(this.findColumn(string), by);
    }

    public void updateBytes(int n2, byte[] byArray) throws SQLException {
        this.checkState();
        this.rs.updateBytes(n2, byArray);
    }

    public void updateBytes(String string, byte[] byArray) throws SQLException {
        this.updateBytes(this.findColumn(string), byArray);
    }

    public void updateCharacterStream(int n2, Reader reader, int n3) throws SQLException {
        this.checkState();
        this.rs.updateCharacterStream(n2, reader, n3);
    }

    public void updateCharacterStream(String string, Reader reader, int n2) throws SQLException {
        this.updateCharacterStream(this.findColumn(string), reader, n2);
    }

    public void updateDate(int n2, Date date) throws SQLException {
        this.checkState();
        this.rs.updateDate(n2, date);
    }

    public void updateDate(String string, Date date) throws SQLException {
        this.updateDate(this.findColumn(string), date);
    }

    public void updateDouble(int n2, double d2) throws SQLException {
        this.checkState();
        this.rs.updateDouble(n2, d2);
    }

    public void updateDouble(String string, double d2) throws SQLException {
        this.updateDouble(this.findColumn(string), d2);
    }

    public void updateFloat(int n2, float f2) throws SQLException {
        this.checkState();
        this.rs.updateFloat(n2, f2);
    }

    public void updateFloat(String string, float f2) throws SQLException {
        this.updateFloat(this.findColumn(string), f2);
    }

    public void updateInt(int n2, int n3) throws SQLException {
        this.checkState();
        this.rs.updateInt(n2, n3);
    }

    public void updateInt(String string, int n2) throws SQLException {
        this.updateInt(this.findColumn(string), n2);
    }

    public void updateLong(int n2, long l2) throws SQLException {
        this.checkState();
        this.rs.updateLong(n2, l2);
    }

    public void updateLong(String string, long l2) throws SQLException {
        this.updateLong(this.findColumn(string), l2);
    }

    public void updateNull(int n2) throws SQLException {
        this.checkState();
        this.rs.updateNull(n2);
    }

    public void updateNull(String string) throws SQLException {
        this.updateNull(this.findColumn(string));
    }

    public void updateObject(int n2, Object object) throws SQLException {
        this.checkState();
        this.rs.updateObject(n2, object);
    }

    public void updateObject(int n2, Object object, int n3) throws SQLException {
        this.checkState();
        this.rs.updateObject(n2, object, n3);
    }

    public void updateObject(String string, Object object) throws SQLException {
        this.updateObject(this.findColumn(string), object);
    }

    public void updateObject(String string, Object object, int n2) throws SQLException {
        this.updateObject(this.findColumn(string), object, n2);
    }

    public void updateRow() throws SQLException {
        this.checkState();
        this.rs.updateRow();
        this.notifyRowChanged();
    }

    public void updateShort(int n2, short s2) throws SQLException {
        this.checkState();
        this.rs.updateShort(n2, s2);
    }

    public void updateShort(String string, short s2) throws SQLException {
        this.updateShort(this.findColumn(string), s2);
    }

    public void updateString(int n2, String string) throws SQLException {
        this.checkState();
        this.rs.updateString(n2, string);
    }

    public void updateString(String string, String string2) throws SQLException {
        this.updateString(this.findColumn(string), string2);
    }

    public void updateTime(int n2, Time time) throws SQLException {
        this.checkState();
        this.rs.updateTime(n2, time);
    }

    public void updateTime(String string, Time time) throws SQLException {
        this.updateTime(this.findColumn(string), time);
    }

    public void updateTimestamp(int n2, Timestamp timestamp) throws SQLException {
        this.checkState();
        this.rs.updateTimestamp(n2, timestamp);
    }

    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.updateTimestamp(this.findColumn(string), timestamp);
    }

    public boolean wasNull() throws SQLException {
        this.checkState();
        return this.rs.wasNull();
    }
}

