/*
 * Decompiled with CFR 0.152.
 */
package sun.jdbc.rowset;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.BitSet;
import javax.sql.RowSetMetaData;
import sun.jdbc.rowset.BaseRow;

class InsertRow
extends BaseRow
implements Serializable,
Cloneable {
    private BitSet colsInserted;
    private int cols;

    InsertRow(int n2) {
        this.origVals = new Object[n2];
        this.colsInserted = new BitSet(n2);
        this.cols = n2;
    }

    protected Object getColumnObject(int n2) throws SQLException {
        if (!this.colsInserted.get(n2 - 1)) {
            throw new SQLException("No value has been inserted");
        }
        return this.origVals[n2 - 1];
    }

    protected void initInsertRow() {
        int n2 = 0;
        while (n2 < this.cols) {
            this.colsInserted.clear(n2);
            ++n2;
        }
    }

    protected boolean isCompleteRow(RowSetMetaData rowSetMetaData) throws SQLException {
        int n2 = 0;
        while (n2 < this.cols) {
            if (!this.colsInserted.get(n2) && rowSetMetaData.isNullable(n2 + 1) == 0) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    protected void markColInserted(int n2) {
        this.colsInserted.set(n2);
    }

    protected void setColumnObject(int n2, Object object) {
        this.origVals[n2 - 1] = object;
        this.markColInserted(n2 - 1);
    }
}

