/*
 * Decompiled with CFR 0.152.
 */
package sun.jdbc.rowset;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.io.StringBufferInputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.AbstractList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import javax.sql.RowSet;
import javax.sql.RowSetInternal;
import javax.sql.RowSetMetaData;
import javax.sql.RowSetReader;
import javax.sql.RowSetWriter;
import sun.jdbc.rowset.BaseRow;
import sun.jdbc.rowset.BaseRowSet;
import sun.jdbc.rowset.InsertRow;
import sun.jdbc.rowset.Row;
import sun.jdbc.rowset.RowSetMetaDataImpl;
import sun.jdbc.rowset.RowSetReaderImpl;
import sun.jdbc.rowset.RowSetWriterImpl;
import sun.jdbc.rowset.SQLInputImpl;
import sun.jdbc.rowset.SerialArray;
import sun.jdbc.rowset.SerialBlob;
import sun.jdbc.rowset.SerialClob;
import sun.jdbc.rowset.SerialStruct;

public class CachedRowSet
extends BaseRowSet
implements RowSet,
RowSetInternal,
Serializable,
Cloneable {
    private RowSetReader rowSetReader;
    private RowSetWriter rowSetWriter;
    private transient Connection conn;
    private transient ResultSetMetaData RSMD;
    private RowSetMetaData RowSetMD;
    private int[] keyCols;
    private String tableName;
    private Vector cachedRows;
    private int cursorPos;
    private int absolutePos;
    private int numDeleted;
    private int numRows;
    private InsertRow insertRow;
    private boolean onInsertRow;
    private int currentRow;
    private boolean lastValueNull;

    public CachedRowSet() throws SQLException {
        this.setReader(new RowSetReaderImpl());
        this.setWriter(new RowSetWriterImpl());
        this.initParams();
        this.initContainer();
        this.initProperties();
        this.onInsertRow = false;
        this.insertRow = null;
    }

    public boolean absolute(int n2) throws SQLException {
        if (n2 == 0 || this.getType() == 1003) {
            throw new SQLException("absolute: Invalid cursor operation.");
        }
        if (n2 > 0) {
            if (n2 > this.numRows) {
                this.afterLast();
            } else if (this.absolutePos <= 0) {
                this.internalFirst();
            }
        } else if (this.cursorPos + n2 < 0) {
            this.beforeFirst();
        } else if (this.absolutePos >= 0) {
            this.internalLast();
        }
        while (this.absolutePos != n2) {
            if (this.absolutePos >= n2 ? !this.internalPrevious() : !this.internalNext()) break;
        }
        this.notifyCursorMoved();
        return !this.isAfterLast() && !this.isBeforeFirst();
    }

    public void acceptChanges() throws SQLException {
        if (this.onInsertRow) {
            throw new SQLException("Invalid operation while on insert row");
        }
        RowSetWriter rowSetWriter = this.getWriter();
        int n2 = this.cursorPos;
        boolean bl = true;
        if (rowSetWriter != null) {
            n2 = this.cursorPos;
            bl = rowSetWriter.writeData(this);
            this.cursorPos = n2;
        }
        if (!bl) {
            throw new SQLException("acceptChanges Failed");
        }
        this.setOriginal();
    }

    public void acceptChanges(Connection connection) throws SQLException {
        this.setConnection(connection);
        this.acceptChanges();
    }

    public void afterLast() throws SQLException {
        if (this.numRows > 0) {
            this.cursorPos = this.numRows + 1;
            this.absolutePos = 0;
            this.notifyCursorMoved();
        }
    }

    public void beforeFirst() throws SQLException {
        if (this.getType() == 1003) {
            throw new SQLException("beforeFirst: Invalid cursor operation.");
        }
        this.cursorPos = 0;
        this.absolutePos = 0;
        this.notifyCursorMoved();
    }

    public void cancelRowDelete() throws SQLException {
        if (!this.getShowDeleted()) {
            return;
        }
        this.checkCursor();
        if (this.onInsertRow) {
            throw new SQLException("Invalid cursor position.");
        }
        Row row = (Row)this.getCurrentRow();
        if (row.getDeleted()) {
            row.clearDeleted();
            --this.numDeleted;
            this.notifyRowChanged();
        }
    }

    public void cancelRowInsert() throws SQLException {
        this.checkCursor();
        if (this.onInsertRow) {
            throw new SQLException("Invalid cursor position.");
        }
        Row row = (Row)this.getCurrentRow();
        if (row.getInserted()) {
            this.cachedRows.remove(this.cursorPos);
            --this.numRows;
        } else {
            throw new SQLException("Illegal operation on non-inserted row");
        }
        this.notifyRowChanged();
    }

    public void cancelRowUpdates() throws SQLException {
        this.checkCursor();
        if (this.onInsertRow) {
            throw new SQLException("Invalid cursor position.");
        }
        Row row = (Row)this.getCurrentRow();
        if (row.getUpdated()) {
            row.clearUpdated();
            this.notifyRowChanged();
        }
    }

    private void checkCursor() throws SQLException {
        if (this.isAfterLast() || this.isBeforeFirst()) {
            throw new SQLException("Invalid cursor position");
        }
    }

    private void checkIndex(int n2) throws SQLException {
        if (n2 < 1 || n2 > this.RowSetMD.getColumnCount()) {
            throw new SQLException("Invalid column index");
        }
    }

    public void clearWarnings() {
        throw new UnsupportedOperationException();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public void close() throws SQLException {
        this.release();
    }

    public boolean columnUpdated(int n2) throws SQLException {
        this.checkCursor();
        if (this.onInsertRow) {
            throw new SQLException("Operation invalid on insert row");
        }
        return ((Row)this.getCurrentRow()).getColUpdated(n2 - 1);
    }

    private Object convertNumeric(Object object, int n2, int n3) throws SQLException {
        if (n2 == n3) {
            return object;
        }
        if (!this.isNumeric(n3) && !this.isString(n3)) {
            throw new SQLException("1.Datatype Mismatch: " + n3);
        }
        try {
            switch (n3) {
                case -7: {
                    Integer n4 = new Integer(object.toString().trim());
                    return n4.equals(new Integer(0)) ? new Boolean(false) : new Boolean(true);
                }
                case -6: {
                    return new Byte(object.toString().trim());
                }
                case 5: {
                    return new Short(object.toString().trim());
                }
                case 4: {
                    return new Integer(object.toString().trim());
                }
                case -5: {
                    return new Long(object.toString().trim());
                }
                case 2: 
                case 3: {
                    return new BigDecimal(object.toString().trim());
                }
                case 6: 
                case 7: {
                    return new Float(object.toString().trim());
                }
                case 8: {
                    return new Double(object.toString().trim());
                }
                case -1: 
                case 1: 
                case 12: {
                    return new String(object.toString());
                }
            }
            throw new SQLException("2.Data Type Mismatch: " + n3);
        }
        catch (NumberFormatException numberFormatException) {
            throw new SQLException("3.Data Type Mismatch: " + n3);
        }
    }

    private Object convertTemporal(Object object, int n2, int n3) throws SQLException {
        if (n2 == n3) {
            return object;
        }
        if (this.isNumeric(n3) || !this.isString(n3) && !this.isTemporal(n3)) {
            throw new SQLException("Datatype Mismatch");
        }
        try {
            switch (n3) {
                case 91: {
                    if (n2 == 93) {
                        return new Date(((java.util.Date)((Timestamp)object)).getTime());
                    }
                    throw new SQLException("Data Type Mismatch");
                }
                case 93: {
                    if (n2 == 92) {
                        return new Timestamp(((Time)object).getTime());
                    }
                    return new Timestamp(((Date)object).getTime());
                }
                case 92: {
                    if (n2 == 93) {
                        return new Time(((java.util.Date)((Timestamp)object)).getTime());
                    }
                    throw new SQLException("Data Type Mismatch");
                }
                case -1: 
                case 1: 
                case 12: {
                    return new String(object.toString());
                }
            }
            throw new SQLException("Data Type Mismatch");
        }
        catch (NumberFormatException numberFormatException) {
            throw new SQLException("Data Type Mismatch");
        }
    }

    public RowSet createCopy() throws SQLException {
        ObjectInputStream objectInputStream;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(this);
        }
        catch (IOException iOException) {
            throw new SQLException("Clone failed: " + iOException.getMessage());
        }
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            objectInputStream = new ObjectInputStream(byteArrayInputStream);
        }
        catch (StreamCorruptedException streamCorruptedException) {
            throw new SQLException("Clone failed: " + streamCorruptedException.getMessage());
        }
        catch (IOException iOException) {
            throw new SQLException("Clone failed: " + iOException.getMessage());
        }
        try {
            return (RowSet)objectInputStream.readObject();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new SQLException("Clone failed: " + classNotFoundException.getMessage());
        }
        catch (OptionalDataException optionalDataException) {
            throw new SQLException("Clone failed: " + optionalDataException.getMessage());
        }
        catch (IOException iOException) {
            throw new SQLException("Clone failed; " + iOException.getMessage());
        }
    }

    public RowSet createShared() throws SQLException {
        RowSet rowSet;
        try {
            rowSet = (RowSet)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new SQLException(cloneNotSupportedException.getMessage());
        }
        return rowSet;
    }

    public void deleteRow() throws SQLException {
        this.checkCursor();
        ((Row)this.getCurrentRow()).setDeleted();
        ++this.numDeleted;
        this.notifyRowChanged();
    }

    public void execute() throws SQLException {
        this.execute(null);
    }

    public void execute(Connection connection) throws SQLException {
        this.setConnection(connection);
        this.getReader().readData(this);
    }

    public int findColumn(String string) throws SQLException {
        return this.getColIdxByName(string);
    }

    public boolean first() throws SQLException {
        if (this.getType() == 1003) {
            throw new SQLException("First: Invalid cursor operation.");
        }
        boolean bl = this.internalFirst();
        this.notifyCursorMoved();
        return bl;
    }

    public Array getArray(int n2) throws SQLException {
        this.checkIndex(n2);
        this.checkCursor();
        if (this.RowSetMD.getColumnType(n2) != 2003) {
            throw new SQLException("Datatype Mismatch");
        }
        this.setLastValueNull(false);
        Array array = (Array)this.getCurrentRow().getColumnObject(n2);
        if (array == null) {
            this.setLastValueNull(true);
            return null;
        }
        return array;
    }

    public Array getArray(String string) throws SQLException {
        return this.getArray(this.getColIdxByName(string));
    }

    public InputStream getAsciiStream(int n2) throws SQLException {
        this.asciiStream = null;
        this.checkIndex(n2);
        this.checkCursor();
        Object object = this.getCurrentRow().getColumnObject(n2);
        if (object == null) {
            this.lastValueNull = true;
            return null;
        }
        try {
            if (!this.isString(this.RowSetMD.getColumnType(n2))) {
                throw new SQLException("Data type mismatch");
            }
            this.asciiStream = new ByteArrayInputStream(((String)object).getBytes("ASCII"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SQLException(unsupportedEncodingException.getMessage());
        }
        return this.asciiStream;
    }

    public InputStream getAsciiStream(String string) throws SQLException {
        return this.getAsciiStream(this.getColIdxByName(string));
    }

    public BigDecimal getBigDecimal(int n2) throws SQLException {
        this.checkIndex(n2);
        this.checkCursor();
        this.setLastValueNull(false);
        Object object = this.getCurrentRow().getColumnObject(n2);
        if (object == null) {
            this.setLastValueNull(true);
            return null;
        }
        try {
            return new BigDecimal(object.toString().trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw new SQLException("getDouble Failed on value (" + object.toString().trim() + ") in column " + n2);
        }
    }

    public BigDecimal getBigDecimal(int n2, int n3) throws SQLException {
        return this.getBigDecimal(n2).setScale(n3);
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        return this.getBigDecimal(this.getColIdxByName(string));
    }

    public BigDecimal getBigDecimal(String string, int n2) throws SQLException {
        return this.getBigDecimal(this.getColIdxByName(string), n2);
    }

    public InputStream getBinaryStream(int n2) throws SQLException {
        this.binaryStream = null;
        this.checkIndex(n2);
        this.checkCursor();
        if (!this.isBinary(this.RowSetMD.getColumnType(n2))) {
            throw new SQLException("Data Type Mismatch");
        }
        Object object = this.getCurrentRow().getColumnObject(n2);
        if (object == null) {
            this.lastValueNull = true;
            return null;
        }
        this.binaryStream = new ByteArrayInputStream((byte[])object);
        return this.binaryStream;
    }

    public InputStream getBinaryStream(String string) throws SQLException {
        return this.getBinaryStream(this.getColIdxByName(string));
    }

    public Blob getBlob(int n2) throws SQLException {
        this.checkIndex(n2);
        this.checkCursor();
        if (this.RowSetMD.getColumnType(n2) != 2004) {
            throw new SQLException("Datatype Mismatch");
        }
        this.setLastValueNull(false);
        Blob blob = (Blob)this.getCurrentRow().getColumnObject(n2);
        if (blob == null) {
            this.setLastValueNull(true);
            return null;
        }
        return blob;
    }

    public Blob getBlob(String string) throws SQLException {
        return this.getBlob(this.getColIdxByName(string));
    }

    public boolean getBoolean(int n2) throws SQLException {
        this.checkIndex(n2);
        this.checkCursor();
        this.setLastValueNull(false);
        Object object = this.getCurrentRow().getColumnObject(n2);
        if (object == null) {
            this.setLastValueNull(true);
            return false;
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        try {
            Double d2 = new Double(object.toString());
            return d2.compareTo(new Double(0.0)) != 0;
        }
        catch (NumberFormatException numberFormatException) {
            throw new SQLException("getBoolen Failed on value (" + object.toString().trim() + ") in column " + n2);
        }
    }

    public boolean getBoolean(String string) throws SQLException {
        return this.getBoolean(this.getColIdxByName(string));
    }

    public byte getByte(int n2) throws SQLException {
        this.checkIndex(n2);
        this.checkCursor();
        this.setLastValueNull(false);
        Object object = this.getCurrentRow().getColumnObject(n2);
        if (object == null) {
            this.setLastValueNull(true);
            return 0;
        }
        try {
            return new Byte(object.toString());
        }
        catch (NumberFormatException numberFormatException) {
            throw new SQLException("getByte Failed on value (" + object.toString() + ") in column " + n2);
        }
    }

    public byte getByte(String string) throws SQLException {
        return this.getByte(this.getColIdxByName(string));
    }

    public byte[] getBytes(int n2) throws SQLException {
        this.checkIndex(n2);
        this.checkCursor();
        if (!this.isBinary(this.RowSetMD.getColumnType(n2))) {
            throw new SQLException("Data Type Mismatch");
        }
        return (byte[])this.getCurrentRow().getColumnObject(n2);
    }

    public byte[] getBytes(String string) throws SQLException {
        return this.getBytes(this.getColIdxByName(string));
    }

    public Reader getCharacterStream(int n2) throws SQLException {
        this.checkIndex(n2);
        this.checkCursor();
        if (this.isBinary(this.RowSetMD.getColumnType(n2))) {
            Object object = this.getCurrentRow().getColumnObject(n2);
            if (object == null) {
                this.lastValueNull = true;
                return null;
            }
            this.charStream = new InputStreamReader(new ByteArrayInputStream((byte[])object));
        } else if (this.isString(this.RowSetMD.getColumnType(n2))) {
            Object object = this.getCurrentRow().getColumnObject(n2);
            if (object == null) {
                this.lastValueNull = true;
                return null;
            }
            this.charStream = new StringReader(object.toString());
        } else {
            throw new SQLException("Datatye mismatch");
        }
        return this.charStream;
    }

    public Reader getCharacterStream(String string) throws SQLException {
        return this.getCharacterStream(this.getColIdxByName(string));
    }

    public Clob getClob(int n2) throws SQLException {
        this.checkIndex(n2);
        this.checkCursor();
        if (this.RowSetMD.getColumnType(n2) != 2005) {
            throw new SQLException("Datatype Mismatch");
        }
        this.setLastValueNull(false);
        Clob clob = (Clob)this.getCurrentRow().getColumnObject(n2);
        if (clob == null) {
            this.setLastValueNull(true);
            return null;
        }
        return clob;
    }

    public Clob getClob(String string) throws SQLException {
        return this.getClob(this.getColIdxByName(string));
    }

    private int getColIdxByName(String string) throws SQLException {
        int n2 = this.RowSetMD.getColumnCount();
        int n3 = 1;
        while (n3 <= n2) {
            String string2 = this.RowSetMD.getColumnName(n3);
            if (string2 != null && string.equalsIgnoreCase(string2)) {
                return n3;
            }
            ++n3;
        }
        throw new SQLException("Invalid column name");
    }

    public Connection getConnection() throws SQLException {
        return this.conn;
    }

    protected BaseRow getCurrentRow() {
        if (this.onInsertRow) {
            return this.insertRow;
        }
        return (Row)this.cachedRows.get(this.cursorPos - 1);
    }

    public String getCursorName() throws SQLException {
        throw new SQLException("Positioned updates not supported");
    }

    public Date getDate(int n2) throws SQLException {
        this.checkIndex(n2);
        this.checkCursor();
        this.setLastValueNull(false);
        Object object = this.getCurrentRow().getColumnObject(n2);
        if (object == null) {
            this.setLastValueNull(true);
            return null;
        }
        switch (this.RowSetMD.getColumnType(n2)) {
            case 91: {
                return (Date)object;
            }
            case 93: {
                long l2 = ((java.util.Date)((Timestamp)object)).getTime();
                return new Date(l2);
            }
            case -1: 
            case 1: 
            case 12: {
                try {
                    DateFormat dateFormat = DateFormat.getDateInstance();
                    return (Date)dateFormat.parse(object.toString());
                }
                catch (ParseException parseException) {
                    throw new SQLException("getDate Failed on value (" + object.toString().trim() + ") in column " + n2);
                }
            }
        }
        throw new SQLException("getDate Failed on value (" + object.toString().trim() + ") in column " + n2 + "no conversion available");
    }

    public Date getDate(int n2, Calendar calendar) throws SQLException {
        this.checkIndex(n2);
        this.checkCursor();
        this.setLastValueNull(false);
        Object object = this.getCurrentRow().getColumnObject(n2);
        if (object == null) {
            this.setLastValueNull(true);
            return null;
        }
        object = this.convertTemporal(object, this.RowSetMD.getColumnType(n2), 91);
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime((java.util.Date)object);
        calendar.set(1, calendar2.get(1));
        calendar.set(2, calendar2.get(2));
        calendar.set(5, calendar2.get(5));
        return new Date(calendar.getTime().getTime());
    }

    public Date getDate(String string) throws SQLException {
        return this.getDate(this.getColIdxByName(string));
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        return this.getDate(this.getColIdxByName(string), calendar);
    }

    public double getDouble(int n2) throws SQLException {
        this.checkIndex(n2);
        this.checkCursor();
        this.setLastValueNull(false);
        Object object = this.getCurrentRow().getColumnObject(n2);
        if (object == null) {
            this.setLastValueNull(true);
            return 0.0;
        }
        try {
            return new Double(object.toString().trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw new SQLException("getDouble Failed on value (" + object.toString().trim() + ") in column " + n2);
        }
    }

    public double getDouble(String string) throws SQLException {
        return this.getDouble(this.getColIdxByName(string));
    }

    public float getFloat(int n2) throws SQLException {
        this.checkIndex(n2);
        this.checkCursor();
        this.setLastValueNull(false);
        Object object = this.getCurrentRow().getColumnObject(n2);
        if (object == null) {
            this.setLastValueNull(true);
            return 0.0f;
        }
        try {
            return new Float(object.toString()).floatValue();
        }
        catch (NumberFormatException numberFormatException) {
            throw new SQLException("getfloat Failed on value (" + object.toString().trim() + ") in column " + n2);
        }
    }

    public float getFloat(String string) throws SQLException {
        return this.getFloat(this.getColIdxByName(string));
    }

    public int getInt(int n2) throws SQLException {
        this.checkIndex(n2);
        this.checkCursor();
        this.setLastValueNull(false);
        Object object = this.getCurrentRow().getColumnObject(n2);
        if (object == null) {
            this.setLastValueNull(true);
            return 0;
        }
        try {
            return new Integer(object.toString().trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw new SQLException("getInt Failed on value (" + object.toString() + ") in column " + n2);
        }
    }

    public int getInt(String string) throws SQLException {
        return this.getInt(this.getColIdxByName(string));
    }

    public int[] getKeyColumns() throws SQLException {
        return this.keyCols;
    }

    public long getLong(int n2) throws SQLException {
        this.checkIndex(n2);
        this.checkCursor();
        this.setLastValueNull(false);
        Object object = this.getCurrentRow().getColumnObject(n2);
        if (object == null) {
            this.setLastValueNull(true);
            return 0L;
        }
        try {
            return new Long(object.toString().trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw new SQLException("getLong Failed on value (" + object.toString().trim() + ") in column " + n2);
        }
    }

    public long getLong(String string) throws SQLException {
        return this.getLong(this.getColIdxByName(string));
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return this.RowSetMD;
    }

    public Object getObject(int n2) throws SQLException {
        this.checkIndex(n2);
        this.checkCursor();
        this.setLastValueNull(false);
        Object object = this.getCurrentRow().getColumnObject(n2);
        if (object == null) {
            this.setLastValueNull(true);
            return null;
        }
        if (object instanceof Struct) {
            Struct struct = (Struct)object;
            Map map = this.getTypeMap();
            Class clazz = (Class)map.get(struct.getSQLTypeName());
            if (clazz != null) {
                SQLData sQLData = null;
                try {
                    sQLData = (SQLData)clazz.newInstance();
                }
                catch (InstantiationException instantiationException) {
                    throw new SQLException("Unable to instantiate: " + instantiationException.getMessage());
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new SQLException("Unable to instantiate: " + illegalAccessException.getMessage());
                }
                Object[] objectArray = struct.getAttributes(map);
                SQLInputImpl sQLInputImpl = new SQLInputImpl(objectArray, map);
                sQLData.readSQL(sQLInputImpl, struct.getSQLTypeName());
                return sQLData;
            }
        }
        return object;
    }

    public Object getObject(int n2, Map map) throws SQLException {
        Struct struct;
        Class clazz;
        this.checkIndex(n2);
        this.checkCursor();
        this.setLastValueNull(false);
        Object object = this.getCurrentRow().getColumnObject(n2);
        if (object == null) {
            this.setLastValueNull(true);
            return null;
        }
        if (object instanceof Struct && (clazz = (Class)map.get((struct = (Struct)object).getSQLTypeName())) != null) {
            SQLData sQLData = null;
            try {
                sQLData = (SQLData)clazz.newInstance();
            }
            catch (InstantiationException instantiationException) {
                throw new SQLException("Unable to instantiate: " + instantiationException.getMessage());
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new SQLException("Unable to instantiate: " + illegalAccessException.getMessage());
            }
            Object[] objectArray = struct.getAttributes(map);
            SQLInputImpl sQLInputImpl = new SQLInputImpl(objectArray, map);
            sQLData.readSQL(sQLInputImpl, struct.getSQLTypeName());
            return sQLData;
        }
        return object;
    }

    public Object getObject(String string) throws SQLException {
        return this.getObject(this.getColIdxByName(string));
    }

    public Object getObject(String string, Map map) throws SQLException {
        return this.getObject(this.getColIdxByName(string), map);
    }

    public ResultSet getOriginal() throws SQLException {
        CachedRowSet cachedRowSet = new CachedRowSet();
        cachedRowSet.RowSetMD = this.RowSetMD;
        cachedRowSet.numRows = this.numRows;
        cachedRowSet.cursorPos = 0;
        cachedRowSet.setReader(null);
        cachedRowSet.setWriter(null);
        int n2 = this.RowSetMD.getColumnCount();
        Iterator iterator = ((AbstractList)this.cachedRows).iterator();
        while (iterator.hasNext()) {
            Row row = new Row(n2, ((Row)iterator.next()).getOrigRow());
            cachedRowSet.cachedRows.add(row);
        }
        return cachedRowSet;
    }

    public ResultSet getOriginalRow() throws SQLException {
        CachedRowSet cachedRowSet = new CachedRowSet();
        cachedRowSet.RowSetMD = this.RowSetMD;
        cachedRowSet.numRows = 1;
        cachedRowSet.cursorPos = 0;
        cachedRowSet.setReader(null);
        cachedRowSet.setWriter(null);
        Row row = new Row(this.RowSetMD.getColumnCount(), this.getCurrentRow().getOrigRow());
        cachedRowSet.cachedRows.add(row);
        return cachedRowSet;
    }

    public RowSetReader getReader() throws SQLException {
        return this.rowSetReader;
    }

    public Ref getRef(int n2) throws SQLException {
        this.checkIndex(n2);
        this.checkCursor();
        if (this.RowSetMD.getColumnType(n2) != 2006) {
            throw new SQLException("Datatype Mismatch");
        }
        this.setLastValueNull(false);
        Ref ref = (Ref)this.getCurrentRow().getColumnObject(n2);
        if (ref == null) {
            this.setLastValueNull(true);
            return null;
        }
        return ref;
    }

    public Ref getRef(String string) throws SQLException {
        return this.getRef(this.getColIdxByName(string));
    }

    public int getRow() throws SQLException {
        if (this.numRows > 0 && this.cursorPos > 0 && this.cursorPos < this.numRows + 1 && !this.getShowDeleted() && !this.rowDeleted()) {
            return this.absolutePos;
        }
        return 0;
    }

    public short getShort(int n2) throws SQLException {
        this.checkIndex(n2);
        this.checkCursor();
        this.setLastValueNull(false);
        Object object = this.getCurrentRow().getColumnObject(n2);
        if (object == null) {
            this.setLastValueNull(true);
            return 0;
        }
        try {
            return new Short(object.toString().trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw new SQLException("getShort Failed on value (" + object.toString() + ") in column " + n2);
        }
    }

    public short getShort(String string) throws SQLException {
        return this.getShort(this.getColIdxByName(string));
    }

    public Statement getStatement() throws SQLException {
        return null;
    }

    public String getString(int n2) throws SQLException {
        this.checkIndex(n2);
        this.checkCursor();
        this.setLastValueNull(false);
        Object object = this.getCurrentRow().getColumnObject(n2);
        if (object == null) {
            this.setLastValueNull(true);
            return null;
        }
        return object.toString();
    }

    public String getString(String string) throws SQLException {
        return this.getString(this.getColIdxByName(string));
    }

    public String getTableName() throws SQLException {
        return this.tableName;
    }

    public Time getTime(int n2) throws SQLException {
        this.checkIndex(n2);
        this.checkCursor();
        this.setLastValueNull(false);
        Object object = this.getCurrentRow().getColumnObject(n2);
        if (object == null) {
            this.setLastValueNull(true);
            return null;
        }
        switch (this.RowSetMD.getColumnType(n2)) {
            case 92: {
                return (Time)object;
            }
            case 93: {
                long l2 = ((java.util.Date)((Timestamp)object)).getTime();
                return new Time(l2);
            }
            case -1: 
            case 1: 
            case 12: {
                try {
                    DateFormat dateFormat = DateFormat.getTimeInstance();
                    return (Time)dateFormat.parse(object.toString());
                }
                catch (ParseException parseException) {
                    throw new SQLException("getTime Failed on value (" + object.toString().trim() + ") in column " + n2);
                }
            }
        }
        throw new SQLException("getTime Failed on value (" + object.toString().trim() + ") in column " + n2 + "no conversion available");
    }

    public Time getTime(int n2, Calendar calendar) throws SQLException {
        this.checkIndex(n2);
        this.checkCursor();
        this.setLastValueNull(false);
        Object object = this.getCurrentRow().getColumnObject(n2);
        if (object == null) {
            this.setLastValueNull(true);
            return null;
        }
        object = this.convertTemporal(object, this.RowSetMD.getColumnType(n2), 92);
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime((java.util.Date)object);
        calendar.set(11, calendar2.get(11));
        calendar.set(12, calendar2.get(12));
        calendar.set(13, calendar2.get(13));
        return new Time(calendar.getTime().getTime());
    }

    public Time getTime(String string) throws SQLException {
        return this.getTime(this.getColIdxByName(string));
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        return this.getTime(this.getColIdxByName(string), calendar);
    }

    public Timestamp getTimestamp(int n2) throws SQLException {
        this.checkIndex(n2);
        this.checkCursor();
        this.setLastValueNull(false);
        Object object = this.getCurrentRow().getColumnObject(n2);
        if (object == null) {
            this.setLastValueNull(true);
            return null;
        }
        switch (this.RowSetMD.getColumnType(n2)) {
            case 93: {
                return (Timestamp)object;
            }
            case 92: {
                long l2 = ((Time)object).getTime();
                return new Timestamp(l2);
            }
            case 91: {
                long l3 = ((Date)object).getTime();
                return new Timestamp(l3);
            }
            case -1: 
            case 1: 
            case 12: {
                try {
                    DateFormat dateFormat = DateFormat.getTimeInstance();
                    return (Timestamp)dateFormat.parse(object.toString());
                }
                catch (ParseException parseException) {
                    throw new SQLException("getTime Failed on value (" + object.toString().trim() + ") in column " + n2);
                }
            }
        }
        throw new SQLException("getTime Failed on value (" + object.toString().trim() + ") in column " + n2 + "no conversion available");
    }

    public Timestamp getTimestamp(int n2, Calendar calendar) throws SQLException {
        this.checkIndex(n2);
        this.checkCursor();
        this.setLastValueNull(false);
        Object object = this.getCurrentRow().getColumnObject(n2);
        if (object == null) {
            this.setLastValueNull(true);
            return null;
        }
        object = this.convertTemporal(object, this.RowSetMD.getColumnType(n2), 93);
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime((java.util.Date)object);
        calendar.set(1, calendar2.get(1));
        calendar.set(2, calendar2.get(2));
        calendar.set(5, calendar2.get(5));
        calendar.set(11, calendar2.get(11));
        calendar.set(12, calendar2.get(12));
        calendar.set(13, calendar2.get(13));
        return new Timestamp(calendar.getTime().getTime());
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        return this.getTimestamp(this.getColIdxByName(string));
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return this.getTimestamp(this.getColIdxByName(string), calendar);
    }

    public InputStream getUnicodeStream(int n2) throws SQLException {
        this.unicodeStream = null;
        this.checkIndex(n2);
        this.checkCursor();
        if (!this.isBinary(this.RowSetMD.getColumnType(n2)) && !this.isString(this.RowSetMD.getColumnType(n2))) {
            throw new SQLException("Data Type Mismatch");
        }
        Object object = this.getCurrentRow().getColumnObject(n2);
        if (object == null) {
            this.lastValueNull = true;
            return null;
        }
        this.unicodeStream = new StringBufferInputStream(object.toString());
        return this.unicodeStream;
    }

    public InputStream getUnicodeStream(String string) throws SQLException {
        return this.getUnicodeStream(this.getColIdxByName(string));
    }

    public SQLWarning getWarnings() {
        throw new UnsupportedOperationException();
    }

    public RowSetWriter getWriter() throws SQLException {
        return this.rowSetWriter;
    }

    private void initContainer() {
        this.cachedRows = new Vector(100);
        this.cursorPos = 0;
        this.absolutePos = 0;
        this.numRows = 0;
        this.numDeleted = 0;
    }

    private void initMetaData(RowSetMetaData rowSetMetaData, ResultSetMetaData resultSetMetaData) throws SQLException {
        int n2 = resultSetMetaData.getColumnCount();
        rowSetMetaData.setColumnCount(n2);
        int n3 = 1;
        while (n3 <= n2) {
            rowSetMetaData.setAutoIncrement(n3, resultSetMetaData.isAutoIncrement(n3));
            rowSetMetaData.setCaseSensitive(n3, resultSetMetaData.isCaseSensitive(n3));
            rowSetMetaData.setCurrency(n3, resultSetMetaData.isCurrency(n3));
            rowSetMetaData.setNullable(n3, resultSetMetaData.isNullable(n3));
            rowSetMetaData.setSigned(n3, resultSetMetaData.isSigned(n3));
            rowSetMetaData.setSearchable(n3, resultSetMetaData.isSearchable(n3));
            rowSetMetaData.setColumnDisplaySize(n3, resultSetMetaData.getColumnDisplaySize(n3));
            rowSetMetaData.setColumnLabel(n3, resultSetMetaData.getColumnLabel(n3));
            rowSetMetaData.setColumnName(n3, resultSetMetaData.getColumnName(n3));
            rowSetMetaData.setSchemaName(n3, resultSetMetaData.getSchemaName(n3));
            rowSetMetaData.setPrecision(n3, resultSetMetaData.getPrecision(n3));
            rowSetMetaData.setScale(n3, resultSetMetaData.getScale(n3));
            rowSetMetaData.setTableName(n3, resultSetMetaData.getTableName(n3));
            rowSetMetaData.setCatalogName(n3, resultSetMetaData.getCatalogName(n3));
            rowSetMetaData.setColumnType(n3, resultSetMetaData.getColumnType(n3));
            rowSetMetaData.setColumnTypeName(n3, resultSetMetaData.getColumnTypeName(n3));
            ++n3;
        }
    }

    private void initProperties() throws SQLException {
        this.setShowDeleted(false);
        this.setQueryTimeout(0);
        this.setMaxRows(0);
        this.setMaxFieldSize(0);
        this.setType(1004);
        this.setConcurrency(1007);
        this.setReadOnly(true);
        this.setTransactionIsolation(2);
        this.setEscapeProcessing(true);
        this.setTypeMap(null);
    }

    public void insertRow() throws SQLException {
        if (!this.onInsertRow || !this.insertRow.isCompleteRow(this.RowSetMD)) {
            throw new SQLException("Failed to insert Row");
        }
        Row row = new Row(this.RowSetMD.getColumnCount(), this.insertRow.getOrigRow());
        row.setInserted();
        int n2 = this.currentRow >= this.numRows || this.currentRow < 0 ? this.numRows : this.currentRow;
        this.cachedRows.add(n2, row);
        ++this.numRows;
        this.notifyRowChanged();
    }

    protected boolean internalFirst() throws SQLException {
        boolean bl = false;
        if (this.numRows > 0) {
            this.cursorPos = 1;
            bl = !this.getShowDeleted() && this.rowDeleted() ? this.internalNext() : true;
        }
        this.absolutePos = bl ? 1 : 0;
        return bl;
    }

    protected boolean internalLast() throws SQLException {
        boolean bl = false;
        if (this.numRows > 0) {
            this.cursorPos = this.numRows;
            bl = !this.getShowDeleted() && this.rowDeleted() ? this.internalPrevious() : true;
        }
        this.absolutePos = bl ? this.numRows - this.numDeleted : 0;
        return bl;
    }

    protected boolean internalNext() throws SQLException {
        boolean bl = false;
        do {
            if (this.cursorPos < this.numRows) {
                ++this.cursorPos;
                bl = true;
                continue;
            }
            if (this.cursorPos != this.numRows) continue;
            ++this.cursorPos;
            bl = false;
            break;
        } while (!this.getShowDeleted() && this.rowDeleted());
        this.absolutePos = bl ? ++this.absolutePos : 0;
        return bl;
    }

    protected boolean internalPrevious() throws SQLException {
        boolean bl = false;
        do {
            if (this.cursorPos > 1) {
                --this.cursorPos;
                bl = true;
                continue;
            }
            if (this.cursorPos != 1) continue;
            --this.cursorPos;
            bl = false;
            break;
        } while (!this.getShowDeleted() && this.rowDeleted());
        this.absolutePos = bl ? --this.absolutePos : 0;
        return bl;
    }

    public boolean isAfterLast() throws SQLException {
        return this.cursorPos == this.numRows + 1 && this.numRows > 0;
    }

    public boolean isBeforeFirst() throws SQLException {
        return this.cursorPos == 0 && this.numRows > 0;
    }

    private boolean isBinary(int n2) {
        switch (n2) {
            case -4: 
            case -3: 
            case -2: {
                return true;
            }
        }
        return false;
    }

    public boolean isFirst() throws SQLException {
        int n2 = this.cursorPos;
        int n3 = this.absolutePos;
        this.internalFirst();
        if (this.cursorPos == n2) {
            return true;
        }
        this.cursorPos = n2;
        this.absolutePos = n3;
        return false;
    }

    public boolean isLast() throws SQLException {
        int n2 = this.cursorPos;
        int n3 = this.absolutePos;
        boolean bl = this.getShowDeleted();
        this.setShowDeleted(true);
        this.internalLast();
        if (this.cursorPos == n2) {
            this.setShowDeleted(bl);
            return true;
        }
        this.setShowDeleted(bl);
        this.cursorPos = n2;
        this.absolutePos = n3;
        return false;
    }

    private boolean isNumeric(int n2) {
        switch (n2) {
            case -7: 
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    private boolean isString(int n2) {
        switch (n2) {
            case -1: 
            case 1: 
            case 12: {
                return true;
            }
        }
        return false;
    }

    private boolean isTemporal(int n2) {
        switch (n2) {
            case 91: 
            case 92: 
            case 93: {
                return true;
            }
        }
        return false;
    }

    public boolean last() throws SQLException {
        if (this.getType() == 1003) {
            throw new SQLException("last: TYPE_FORWARD_ONLY");
        }
        boolean bl = this.internalLast();
        this.notifyCursorMoved();
        return bl;
    }

    private void makeRowOriginal(Row row) {
        if (row.getInserted()) {
            row.clearInserted();
        }
        if (row.getUpdated()) {
            row.moveCurrentToOrig();
        }
    }

    public void moveToCurrentRow() throws SQLException {
        if (!this.onInsertRow) {
            return;
        }
        this.cursorPos = this.currentRow;
        this.onInsertRow = false;
    }

    public void moveToInsertRow() throws SQLException {
        int n2;
        if (this.getType() == 1003) {
            throw new SQLException("last: TYPE_FORWARD_ONLY");
        }
        if (this.insertRow == null && (n2 = this.RowSetMD.getColumnCount()) > 0) {
            this.insertRow = new InsertRow(n2);
        }
        this.onInsertRow = true;
        this.currentRow = this.cursorPos;
        this.cursorPos = -1;
        this.insertRow.initInsertRow();
    }

    public boolean next() throws SQLException {
        if (this.cursorPos < 0 || this.cursorPos >= this.numRows + 1) {
            throw new SQLException("Invalid Cursor position");
        }
        boolean bl = this.internalNext();
        this.notifyCursorMoved();
        return bl;
    }

    public void populate(ResultSet resultSet) throws SQLException {
        Map map = this.getTypeMap();
        this.RSMD = resultSet.getMetaData();
        int n2 = this.RSMD.getColumnCount();
        int n3 = 0;
        while (resultSet.next()) {
            Row row = new Row(n2);
            int n4 = 1;
            while (n4 <= n2) {
                Object object = map == null ? resultSet.getObject(n4) : resultSet.getObject(n4, map);
                if (object instanceof Struct) {
                    object = new SerialStruct((Struct)object, map);
                } else if (object instanceof SQLData) {
                    object = new SerialStruct((SQLData)object, map);
                } else if (object instanceof Blob) {
                    object = new SerialBlob((Blob)object);
                } else if (object instanceof Clob) {
                    object = new SerialClob((Clob)object);
                } else if (object instanceof Array) {
                    object = new SerialArray((Array)object, map);
                }
                row.initColumnObject(n4, object);
                ++n4;
            }
            this.cachedRows.add(row);
            ++n3;
        }
        this.numRows = n3;
        this.RowSetMD = new RowSetMetaDataImpl();
        this.initMetaData(this.RowSetMD, this.RSMD);
        this.RSMD = null;
        this.notifyRowSetChanged();
    }

    public boolean previous() throws SQLException {
        if (this.getType() == 1003) {
            throw new SQLException("last: TYPE_FORWARD_ONLY");
        }
        if (this.cursorPos < 0 || this.cursorPos > this.numRows + 1) {
            throw new SQLException("Invalid Cursor position");
        }
        boolean bl = this.internalPrevious();
        this.notifyCursorMoved();
        return bl;
    }

    public void refreshRow() throws SQLException {
        this.checkCursor();
        if (this.onInsertRow) {
            throw new SQLException("Invalid cursor position.");
        }
        Row row = (Row)this.getCurrentRow();
        row.clearUpdated();
    }

    public boolean relative(int n2) throws SQLException {
        if (this.numRows == 0 || this.isBeforeFirst() || this.isAfterLast() || this.getType() == 1003) {
            throw new SQLException("relative: Invalid cursor operation");
        }
        if (n2 == 0) {
            return true;
        }
        if (n2 > 0) {
            if (this.cursorPos + n2 > this.numRows) {
                this.afterLast();
            } else {
                int n3 = 0;
                while (n3 < n2) {
                    if (this.internalNext()) {
                        ++n3;
                        continue;
                    }
                    break;
                }
            }
        } else if (this.cursorPos + n2 < 0) {
            this.beforeFirst();
        } else {
            int n4 = n2;
            while (n4 > 0) {
                if (this.internalPrevious()) {
                    --n4;
                    continue;
                }
                break;
            }
        }
        this.notifyCursorMoved();
        return !this.isAfterLast() && !this.isBeforeFirst();
    }

    public void release() throws SQLException {
        this.initContainer();
        this.notifyRowSetChanged();
    }

    protected void removeCurrentRow() {
        this.cachedRows.remove(this.cursorPos - 1);
        --this.numRows;
    }

    public void restoreOriginal() throws SQLException {
        Iterator iterator = ((AbstractList)this.cachedRows).iterator();
        while (iterator.hasNext()) {
            Row row = (Row)iterator.next();
            if (row.getInserted()) {
                iterator.remove();
                --this.numRows;
                continue;
            }
            if (row.getDeleted()) {
                row.clearDeleted();
            }
            if (!row.getUpdated()) continue;
            row.clearUpdated();
        }
        this.cursorPos = 0;
        this.notifyRowSetChanged();
    }

    public boolean rowDeleted() throws SQLException {
        if (this.isAfterLast() || this.isBeforeFirst() || this.onInsertRow) {
            throw new SQLException("Invalid cursor position");
        }
        return ((Row)this.getCurrentRow()).getDeleted();
    }

    public boolean rowInserted() throws SQLException {
        this.checkCursor();
        if (this.onInsertRow) {
            throw new SQLException("Operation invalid on insert row");
        }
        return ((Row)this.getCurrentRow()).getInserted();
    }

    public boolean rowUpdated() throws SQLException {
        this.checkCursor();
        if (this.onInsertRow) {
            throw new SQLException("Operation invalid on insert row");
        }
        return ((Row)this.getCurrentRow()).getUpdated();
    }

    public void setCommand(String string) throws SQLException {
        super.setCommand(string);
    }

    private void setConnection(Connection connection) {
        this.conn = connection;
    }

    public void setKeyColumns(int[] nArray) throws SQLException {
        int n2 = 0;
        if (this.RowSetMD != null && nArray.length > (n2 = this.RowSetMD.getColumnCount())) {
            throw new SQLException("Invalid key columns");
        }
        this.keyCols = new int[nArray.length];
        int n3 = 0;
        while (n3 < nArray.length) {
            if (this.RowSetMD != null && (nArray[n3] <= 0 || nArray[n3] > n2)) {
                throw new SQLException("Invalid column index: " + nArray[n3]);
            }
            this.keyCols[n3] = nArray[n3];
            ++n3;
        }
    }

    private void setLastValueNull(boolean bl) {
        this.lastValueNull = bl;
    }

    public void setMetaData(RowSetMetaData rowSetMetaData) throws SQLException {
        this.RowSetMD = rowSetMetaData;
    }

    public void setOriginal() throws SQLException {
        Iterator iterator = ((AbstractList)this.cachedRows).iterator();
        while (iterator.hasNext()) {
            Row row = (Row)iterator.next();
            this.makeRowOriginal(row);
            if (!row.getDeleted()) continue;
            iterator.remove();
            --this.numRows;
        }
        this.numDeleted = 0;
        this.notifyRowSetChanged();
    }

    public void setOriginalRow() throws SQLException {
        if (this.onInsertRow) {
            throw new SQLException("Invalid operation on Insert Row");
        }
        Row row = (Row)this.getCurrentRow();
        this.makeRowOriginal(row);
        if (row.getDeleted()) {
            this.removeCurrentRow();
            --this.numRows;
        }
    }

    public void setReader(RowSetReader rowSetReader) throws SQLException {
        this.rowSetReader = rowSetReader;
    }

    public void setTableName(String string) throws SQLException {
        this.tableName = string == null ? null : new String(string);
    }

    public void setWriter(RowSetWriter rowSetWriter) throws SQLException {
        this.rowSetWriter = rowSetWriter;
    }

    public int size() {
        return this.numRows;
    }

    public Collection toCollection() throws SQLException {
        int n2 = 0;
        int n3 = this.RowSetMD.getColumnCount();
        TreeMap treeMap = new TreeMap();
        Iterator iterator = ((AbstractList)this.cachedRows).iterator();
        while (iterator.hasNext()) {
            Vector<Object> vector = new Vector<Object>(n3);
            Row row = (Row)iterator.next();
            int n4 = 1;
            while (n4 <= n3) {
                vector.add(row.getColumnObject(n4));
                ++n4;
            }
            treeMap.put(new Integer(n2), vector);
            ++n2;
        }
        return (Collection)((Object)treeMap);
    }

    public Collection toCollection(int n2) throws SQLException {
        Vector<Object> vector = new Vector<Object>(this.numRows);
        Iterator iterator = ((AbstractList)this.cachedRows).iterator();
        while (iterator.hasNext()) {
            Row row = (Row)iterator.next();
            vector.add(row.getColumnObject(n2));
        }
        return vector;
    }

    public void updateAsciiStream(int n2, InputStream inputStream, int n3) {
        throw new UnsupportedOperationException();
    }

    public void updateAsciiStream(String string, InputStream inputStream, int n2) {
        throw new UnsupportedOperationException();
    }

    public void updateBigDecimal(int n2, BigDecimal bigDecimal) throws SQLException {
        this.checkIndex(n2);
        this.checkCursor();
        Object object = this.convertNumeric(bigDecimal, 2, this.RowSetMD.getColumnType(n2));
        this.getCurrentRow().setColumnObject(n2, object);
    }

    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.updateBigDecimal(this.getColIdxByName(string), bigDecimal);
    }

    public void updateBinaryStream(int n2, InputStream inputStream, int n3) throws SQLException {
        this.checkIndex(n2);
        this.checkCursor();
        if (!this.isBinary(this.RowSetMD.getColumnType(n2))) {
            throw new SQLException("Data Type Mismatch");
        }
        byte[] byArray = new byte[n3];
        try {
            int n4 = 0;
            while ((n4 += inputStream.read(byArray, n4, n3 - n4)) != -1) {
            }
        }
        catch (IOException iOException) {
            throw new SQLException("read failed for binaryStream");
        }
        this.getCurrentRow().setColumnObject(n2, byArray);
    }

    public void updateBinaryStream(String string, InputStream inputStream, int n2) throws SQLException {
        this.updateBinaryStream(this.getColIdxByName(string), inputStream, n2);
    }

    public void updateBoolean(int n2, boolean bl) throws SQLException {
        this.checkIndex(n2);
        this.checkCursor();
        Object object = this.convertNumeric(new Boolean(bl), -7, this.RowSetMD.getColumnType(n2));
        this.getCurrentRow().setColumnObject(n2, object);
    }

    public void updateBoolean(String string, boolean bl) throws SQLException {
        this.updateBoolean(this.getColIdxByName(string), bl);
    }

    public void updateByte(int n2, byte by) throws SQLException {
        this.checkIndex(n2);
        this.checkCursor();
        Object object = this.convertNumeric(new Byte(by), -6, this.RowSetMD.getColumnType(n2));
        this.getCurrentRow().setColumnObject(n2, object);
    }

    public void updateByte(String string, byte by) throws SQLException {
        this.updateByte(this.getColIdxByName(string), by);
    }

    public void updateBytes(int n2, byte[] byArray) throws SQLException {
        this.checkIndex(n2);
        this.checkCursor();
        if (!this.isBinary(this.RowSetMD.getColumnType(n2))) {
            throw new SQLException("Data Type Mismatch");
        }
        this.getCurrentRow().setColumnObject(n2, byArray);
    }

    public void updateBytes(String string, byte[] byArray) throws SQLException {
        this.updateBytes(this.getColIdxByName(string), byArray);
    }

    public void updateCharacterStream(int n2, Reader reader, int n3) throws SQLException {
        this.checkIndex(n2);
        this.checkCursor();
        if (!this.isString(this.RowSetMD.getColumnType(n2)) && !this.isBinary(this.RowSetMD.getColumnType(n2))) {
            throw new SQLException("Data Type Mismatch");
        }
        char[] cArray = new char[n3];
        try {
            int n4 = 0;
            while ((n4 += reader.read(cArray, n4, n3 - n4)) != -1) {
            }
        }
        catch (IOException iOException) {
            throw new SQLException("read failed for binaryStream");
        }
        String string = new String(cArray);
        this.getCurrentRow().setColumnObject(n2, string);
    }

    public void updateCharacterStream(String string, Reader reader, int n2) throws SQLException {
        this.updateCharacterStream(this.getColIdxByName(string), reader, n2);
    }

    public void updateDate(int n2, Date date) throws SQLException {
        this.checkIndex(n2);
        this.checkCursor();
        Object object = this.convertTemporal(date, 91, this.RowSetMD.getColumnType(n2));
        this.getCurrentRow().setColumnObject(n2, object);
    }

    public void updateDate(String string, Date date) throws SQLException {
        this.updateDate(this.getColIdxByName(string), date);
    }

    public void updateDouble(int n2, double d2) throws SQLException {
        this.checkIndex(n2);
        this.checkCursor();
        Object object = this.convertNumeric(new Double(d2), 8, this.RowSetMD.getColumnType(n2));
        this.getCurrentRow().setColumnObject(n2, object);
    }

    public void updateDouble(String string, double d2) throws SQLException {
        this.updateDouble(this.getColIdxByName(string), d2);
    }

    public void updateFloat(int n2, float f2) throws SQLException {
        this.checkIndex(n2);
        this.checkCursor();
        Object object = this.convertNumeric(new Float(f2), 7, this.RowSetMD.getColumnType(n2));
        this.getCurrentRow().setColumnObject(n2, object);
    }

    public void updateFloat(String string, float f2) throws SQLException {
        this.updateFloat(this.getColIdxByName(string), f2);
    }

    public void updateInt(int n2, int n3) throws SQLException {
        this.checkIndex(n2);
        this.checkCursor();
        Object object = this.convertNumeric(new Integer(n3), 4, this.RowSetMD.getColumnType(n2));
        this.getCurrentRow().setColumnObject(n2, object);
    }

    public void updateInt(String string, int n2) throws SQLException {
        this.updateInt(this.getColIdxByName(string), n2);
    }

    public void updateLong(int n2, long l2) throws SQLException {
        this.checkIndex(n2);
        this.checkCursor();
        Object object = this.convertNumeric(new Long(l2), -5, this.RowSetMD.getColumnType(n2));
        this.getCurrentRow().setColumnObject(n2, object);
    }

    public void updateLong(String string, long l2) throws SQLException {
        this.updateLong(this.getColIdxByName(string), l2);
    }

    public void updateNull(int n2) throws SQLException {
        this.checkIndex(n2);
        this.checkCursor();
        BaseRow baseRow = this.getCurrentRow();
        baseRow.setColumnObject(n2, null);
    }

    public void updateNull(String string) throws SQLException {
        this.updateNull(this.getColIdxByName(string));
    }

    public void updateObject(int n2, Object object) throws SQLException {
        this.checkIndex(n2);
        this.checkCursor();
        this.getCurrentRow().setColumnObject(n2, object);
    }

    public void updateObject(int n2, Object object, int n3) throws SQLException {
        this.checkIndex(n2);
        this.checkCursor();
        int n4 = this.RowSetMD.getColumnType(n2);
        if (n4 == 3 || n4 == 2) {
            ((BigDecimal)object).setScale(n3);
        }
        this.getCurrentRow().setColumnObject(n2, object);
    }

    public void updateObject(String string, Object object) throws SQLException {
        this.updateObject(this.getColIdxByName(string), object);
    }

    public void updateObject(String string, Object object, int n2) throws SQLException {
        this.updateObject(this.getColIdxByName(string), object, n2);
    }

    public void updateRow() throws SQLException {
        if (this.onInsertRow) {
            throw new SQLException("updateRow called while on insert row");
        }
        ((Row)this.getCurrentRow()).setUpdated();
        this.notifyRowChanged();
    }

    public void updateShort(int n2, short s2) throws SQLException {
        this.checkIndex(n2);
        this.checkCursor();
        Object object = this.convertNumeric(new Short(s2), 5, this.RowSetMD.getColumnType(n2));
        this.getCurrentRow().setColumnObject(n2, object);
    }

    public void updateShort(String string, short s2) throws SQLException {
        this.updateShort(this.getColIdxByName(string), s2);
    }

    public void updateString(int n2, String string) throws SQLException {
        this.checkIndex(n2);
        this.checkCursor();
        this.getCurrentRow().setColumnObject(n2, string);
    }

    public void updateString(String string, String string2) throws SQLException {
        this.updateString(this.getColIdxByName(string), string2);
    }

    public void updateTime(int n2, Time time) throws SQLException {
        this.checkIndex(n2);
        this.checkCursor();
        Object object = this.convertTemporal(time, 92, this.RowSetMD.getColumnType(n2));
        this.getCurrentRow().setColumnObject(n2, object);
    }

    public void updateTime(String string, Time time) throws SQLException {
        this.updateTime(this.getColIdxByName(string), time);
    }

    public void updateTimestamp(int n2, Timestamp timestamp) throws SQLException {
        this.checkIndex(n2);
        this.checkCursor();
        Object object = this.convertTemporal(timestamp, 93, this.RowSetMD.getColumnType(n2));
        this.getCurrentRow().setColumnObject(n2, object);
    }

    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.updateTimestamp(this.getColIdxByName(string), timestamp);
    }

    public boolean wasNull() throws SQLException {
        return this.lastValueNull;
    }
}

