/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.dom;

import java.util.StringTokenizer;
import java.util.Vector;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.DOMImplementationSource;

public class DOMImplementationRegistry {
    public static String PROPERTY = "org.w3c.dom.DOMImplementationSourceList";
    private static Vector sources = new Vector();
    private static boolean initialized = false;

    private static void initialize() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        initialized = true;
        String p2 = System.getProperty(PROPERTY);
        if (p2 == null) {
            return;
        }
        StringTokenizer st = new StringTokenizer(p2);
        while (st.hasMoreTokens()) {
            Object source = Class.forName(st.nextToken()).newInstance();
            sources.addElement(source);
        }
    }

    public static DOMImplementation getDOMImplementation(String features) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (!initialized) {
            DOMImplementationRegistry.initialize();
        }
        int len = sources.size();
        int i2 = 0;
        while (i2 < len) {
            DOMImplementationSource source = (DOMImplementationSource)sources.elementAt(i2);
            DOMImplementation impl = source.getDOMImplementation(features);
            if (impl != null) {
                return impl;
            }
            ++i2;
        }
        return null;
    }

    public static void addSource(DOMImplementationSource s2) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (!initialized) {
            DOMImplementationRegistry.initialize();
        }
        sources.addElement(s2);
        StringBuffer b2 = new StringBuffer(System.getProperty(PROPERTY));
        b2.append(" " + s2.getClass().getName());
        System.setProperty(PROPERTY, b2.toString());
    }
}

