/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql.converter;

import java.sql.SQLException;
import oracle.sql.converter.CharacterConverterLC;

public class CharacterConverterLCFixed
extends CharacterConverterLC {
    static final int ORACHARBYTECNT = 4;
    public int m_4ByteOraCharReplacement = 0;

    public CharacterConverterLCFixed() {
        this.m_groupId = 3;
    }

    int toOracleCharacter(char c2) throws SQLException {
        int n2 = c2 >> this.m_oraL1KeyShift & this.m_oraL1KeyMask;
        int n3 = c2 & this.m_oraL2KeyMask;
        int n4 = this.m_oraCharLevel1[n2] + n3;
        int n5 = this.m_oraCharLevel2[n4];
        int n6 = this.m_oraLcIndex[n4 / 2] >> n4 % 2 * 4 & 0xF;
        char c3 = this.m_ucsCharLeadingCode[n6][0];
        if (c3 != '\u0000') {
            n5 |= c3 << 16;
        }
        if (n5 == 65535) {
            throw new SQLException("Cannot map Unicode to Oracle character.");
        }
        return n5;
    }

    int toOracleCharacterWithReplacement(char c2) {
        int n2 = c2 >> this.m_oraL1KeyShift & this.m_oraL1KeyMask;
        int n3 = c2 & this.m_oraL2KeyMask;
        int n4 = this.m_oraCharLevel1[n2] + n3;
        int n5 = this.m_oraCharLevel2[n4];
        int n6 = this.m_oraLcIndex[n4 / 2] >> n4 % 2 * 4 & 0xF;
        char c3 = this.m_ucsCharLeadingCode[n6][0];
        if (c3 != '\u0000') {
            n5 |= c3 << 16;
        }
        if (n5 == 65535) {
            return this.m_4ByteOraCharReplacement;
        }
        return n5;
    }

    public String toUnicodeString(byte[] byArray, int n2, int n3) throws SQLException {
        char[] cArray = new char[n3];
        int n4 = 0;
        if (n3 >= 4) {
            int n5 = byArray[n2] << 8 & 0xFF00 | byArray[n2 + 1] & 0xFF;
            int n6 = 0;
            while (n6 < this.m_ucsCharLeadingCode.length) {
                if (n5 == this.m_ucsCharLeadingCode[n6][0]) {
                    int n7 = byArray[n2 + 2] << 8 & 0xFF00 | byArray[n2 + 3] & 0xFF;
                    char c2 = this.m_ucsCharLeadingCode[n6][1];
                    int n8 = (n7 >> this.m_ucsL1KeyShift & this.m_ucsL1KeyMask) + c2;
                    int n9 = n7 & this.m_ucsL2KeyMask;
                    char c3 = this.m_ucsCharLevel2[this.m_ucsCharLevel1[n8] + n9];
                    if (c3 == this.m_ucsCharReplacement) {
                        throw new SQLException("Cannot map Oracle character to Unicode.");
                    }
                    cArray[n4++] = c3;
                    n3 -= 4;
                    n2 += 4;
                    break;
                }
                ++n6;
            }
            throw new SQLException("Cannot map Oracle character to Unicode.");
        }
        if (n3 != 0) {
            throw new SQLException("Cannot map Oracle character to Unicode.");
        }
        return new String(cArray, 0, n4);
    }

    public String toUnicodeStringWithReplacement(byte[] byArray, int n2, int n3) {
        char[] cArray = new char[n3];
        int n4 = 0;
        while (n3 >= 4) {
            int n5 = byArray[n2] << 8 & 0xFF00 | byArray[n2 + 1] & 0xFF;
            char c2 = this.m_ucsCharReplacement;
            int n6 = 0;
            while (n6 < this.m_ucsCharLeadingCode.length) {
                if (n5 == this.m_ucsCharLeadingCode[n6][0]) {
                    char c3 = this.m_ucsCharLeadingCode[n6][1];
                    int n7 = byArray[n2 + 2] << 8 & 0xFF00 | byArray[n2 + 3] & 0xFF;
                    int n8 = (n7 >> this.m_ucsL1KeyShift & this.m_ucsL1KeyMask) + c3;
                    int n9 = n7 & this.m_ucsL2KeyMask;
                    c2 = this.m_ucsCharLevel2[this.m_ucsCharLevel1[n8] + n9];
                    break;
                }
                ++n6;
            }
            cArray[n4++] = c2;
            n3 -= 4;
            n2 += 4;
        }
        return new String(cArray, 0, n4);
    }
}

