/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql.converter;

import java.sql.SQLException;
import java.util.Vector;
import oracle.sql.converter.CharacterConverter;

public abstract class CharacterConverterLC
extends CharacterConverter {
    static final int MAX_7BIT = 127;
    static final int ORACHARMASK = 255;
    static final int UCSCHARWIDTH = 16;
    static final int ORACHARWIDTH = 16;
    static final int ORACHARWITHLCWIDTH = 32;
    static final int BYTEWIDTH = 8;
    static final int HIBYTEMASK = 65280;
    static final int LOWBYTEMASK = 255;
    static final int LOW16BITMASK = 65535;
    static final int BELOW_CJK = 12287;
    static final int INVALID_ORA_CHAR = 65535;
    static final int LEADINGCODEWIDTH = 16;
    static final int LEADINGCODESHIFT = 16;
    static final int LEADINGCODEMASK = 65535;
    static final int LCINDEXWIDTH = 4;
    static final int LCINDEXMASK = 15;
    static final int LCINDEXFACTOR = 2;
    static final int MAXBYTEPERCHAR = 4;
    public int m_ucsL1KeyWidth = 0;
    public int m_oraL1KeyWidth = 0;
    public char[][] m_ucsCharLeadingCode = null;
    public char[] m_ucsCharLevel1 = null;
    public char[] m_ucsCharLevel2 = null;
    public char m_ucsCharReplacement = '\u0000';
    public char m_1ByteOraCharReplacement = '\u0000';
    public char m_2ByteOraCharReplacement = '\u0000';
    public int m_ucsL1KeyShift = 0;
    int m_ucsL1KeyMask = 0;
    int m_ucsL2KeyMask = 0;
    public int m_oraL1KeyShift = 0;
    int m_oraL1KeyMask = 0;
    int m_oraL2KeyMask = 0;
    public char[] m_oraCharLevel1 = null;
    public char[] m_oraCharLevel2 = null;
    public byte[] m_oraLcIndex = null;
    public int[][] extraUnicodeToOracleMapping = null;

    CharacterConverterLC() {
        this.m_groupId = 8;
    }

    public void buildUnicodeToOracleMapping() {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        this.m_ucsL1KeyShift = 16 - this.m_ucsL1KeyWidth;
        this.m_ucsL1KeyMask = (1 << this.m_ucsL1KeyWidth) - 1;
        this.m_ucsL2KeyMask = (1 << this.m_ucsL1KeyShift) - 1;
        int n8 = this.m_oraL1KeyWidth;
        int n9 = 16 - n8;
        int n10 = (1 << n8) - 1;
        int n11 = (1 << n9) - 1;
        this.m_oraL1KeyShift = n9;
        this.m_oraL1KeyMask = n10;
        this.m_oraL2KeyMask = n11;
        int n12 = 1 << n8;
        char[] cArray = new char[n12];
        char[][] cArray2 = new char[n12][2];
        int n13 = 0;
        while (n13 < n12) {
            cArray[n13] = '\u0000';
            cArray2[n13][0] = (char)n11;
            cArray2[n13][1] = '\u0000';
            ++n13;
        }
        int n14 = 65536;
        char c2 = this.m_ucsCharReplacement;
        int n15 = 0;
        while (n15 < this.m_ucsCharLeadingCode.length) {
            n7 = this.m_ucsCharLeadingCode[n15][0];
            n13 = 0;
            while (n13 < n14) {
                n6 = this.toUnicodeWithReplacement(n13 | n7 << 16);
                if (n6 != c2) {
                    n5 = n6 >> n9 & n10;
                    cArray[n5] = '\u0001';
                    n4 = n6 & n11;
                    if (n4 < cArray2[n5][0]) {
                        cArray2[n5][0] = (char)n4;
                    }
                    if (n4 > cArray2[n5][1]) {
                        cArray2[n5][1] = (char)n4;
                    }
                }
                ++n13;
            }
            ++n15;
        }
        if (this.extraUnicodeToOracleMapping != null) {
            n14 = this.extraUnicodeToOracleMapping.length;
            n13 = 0;
            while (n13 < n14) {
                n6 = this.extraUnicodeToOracleMapping[n13][0];
                n5 = n6 >> n9 & n10;
                cArray[n5] = '\u0001';
                n4 = n6 & n11;
                if (n4 < cArray2[n5][0]) {
                    cArray2[n5][0] = (char)n4;
                }
                if (n4 > cArray2[n5][1]) {
                    cArray2[n5][1] = (char)n4;
                }
                ++n13;
            }
        }
        int n16 = n3 = n11 + 1;
        int n17 = 0;
        n13 = 0;
        while (n13 < n12) {
            if (cArray[n13] != '\u0000') {
                int n18 = cArray2[n13][0];
                cArray[n13] = (char)(n16 - (n17 < n18 ? n17 : n18));
                n16 = cArray[n13] + n3;
                n17 = n3 - cArray2[n13][1] - 1;
            }
            ++n13;
        }
        char[] cArray3 = new char[n16];
        byte[] byArray = new byte[(n16 + 1) / 2];
        n13 = 0;
        while (n13 < n16) {
            cArray3[n13] = 65535;
            if (n13 % 2 == 0) {
                byArray[n13 / 2] = 0;
            }
            ++n13;
        }
        n14 = 65536;
        n15 = 0;
        while (n15 < this.m_ucsCharLeadingCode.length) {
            n7 = this.m_ucsCharLeadingCode[n15][0];
            n13 = 0;
            while (n13 < n14) {
                n6 = this.toUnicodeWithReplacement(n7 << 16 | n13);
                if (n6 != c2) {
                    n5 = n6 >> n9 & n10;
                    n4 = n6 & n11;
                    n2 = cArray[n5] + n4;
                    if (cArray3[n2] == '\uffff') {
                        cArray3[n2] = (char)n13;
                    }
                    int n19 = n2 / 2;
                    byArray[n19] = (byte)(byArray[n19] | n15 << n2 % 2 * 4);
                }
                ++n13;
            }
            ++n15;
        }
        if (this.extraUnicodeToOracleMapping != null) {
            n14 = this.extraUnicodeToOracleMapping.length;
            n13 = 0;
            while (n13 < n14) {
                n6 = this.extraUnicodeToOracleMapping[n13][0];
                n5 = n6 >> n9 & n10;
                n4 = n6 & n11;
                n2 = cArray[n5] + n4;
                if (cArray3[n2] == '\uffff') {
                    cArray3[n2] = (char)this.extraUnicodeToOracleMapping[n13][1];
                }
                n7 = this.extraUnicodeToOracleMapping[n13][1] >> 16 & 0xFFFF;
                n15 = 0;
                while (n15 < this.m_ucsCharLeadingCode.length) {
                    if (n7 == this.m_ucsCharLeadingCode[n15][0]) {
                        int n20 = n2 / 2;
                        byArray[n20] = (byte)(byArray[n20] | n15 << n2 % 2 * 4);
                        break;
                    }
                    ++n15;
                }
                ++n13;
            }
        }
        this.m_oraCharLevel1 = cArray;
        this.m_oraCharLevel2 = cArray3;
        this.m_oraLcIndex = byArray;
    }

    public void extractCodepoints(Vector vector) {
        int n2 = 0;
        while (n2 < this.m_ucsCharLeadingCode.length) {
            char c2 = this.m_ucsCharLeadingCode[n2][0];
            int n3 = c2 << 16;
            int n4 = n3 + 65535;
            int n5 = n3;
            while (n5 <= n4) {
                try {
                    int[] nArray = new int[]{n5, this.toUnicode(n5)};
                    vector.addElement(nArray);
                }
                catch (SQLException sQLException) {}
                ++n5;
            }
            ++n2;
        }
    }

    public void extractExtraMappings(Vector vector) {
        if (this.extraUnicodeToOracleMapping == null) {
            return;
        }
        int n2 = 0;
        while (n2 < this.extraUnicodeToOracleMapping.length) {
            vector.addElement(this.extraUnicodeToOracleMapping[n2]);
            ++n2;
        }
    }

    public char[] getLeadingCodes() {
        char[] cArray = new char[this.m_ucsCharLeadingCode.length];
        int n2 = 0;
        while (n2 < cArray.length) {
            cArray[n2] = this.m_ucsCharLeadingCode[n2][0];
            ++n2;
        }
        return cArray;
    }

    public char getOraChar1ByteRep() {
        return this.m_1ByteOraCharReplacement;
    }

    public char getOraChar2ByteRep() {
        return this.m_2ByteOraCharReplacement;
    }

    public char getUCS2CharRep() {
        return this.m_ucsCharReplacement;
    }

    public boolean hasExtraMappings() {
        return this.extraUnicodeToOracleMapping != null;
    }

    int toOracleCharacter(char c2) throws SQLException {
        int n2 = c2 >> this.m_oraL1KeyShift & this.m_oraL1KeyMask;
        int n3 = c2 & this.m_oraL2KeyMask;
        int n4 = this.m_oraCharLevel1[n2] + n3;
        int n5 = this.m_oraCharLevel2[n4];
        int n6 = this.m_oraLcIndex[n4 / 2] >> n4 % 2 * 4 & 0xF;
        char c3 = this.m_ucsCharLeadingCode[n6][0];
        if (c3 != '\u0000') {
            n5 |= c3 << 16;
        }
        if (n5 == 65535) {
            throw new SQLException("Cannot map Unicode to Oracle character.");
        }
        return n5;
    }

    int toOracleCharacterWithReplacement(char c2) {
        int n2 = c2 >> this.m_oraL1KeyShift & this.m_oraL1KeyMask;
        int n3 = c2 & this.m_oraL2KeyMask;
        int n4 = this.m_oraCharLevel1[n2] + n3;
        int n5 = this.m_oraCharLevel2[n4];
        int n6 = this.m_oraLcIndex[n4 / 2] >> n4 % 2 * 4 & 0xF;
        char c3 = this.m_ucsCharLeadingCode[n6][0];
        if (c3 != '\u0000') {
            n5 |= c3 << 16;
        }
        if (n5 == 65535) {
            if (c2 > '\u2fff') {
                return this.m_2ByteOraCharReplacement;
            }
            return this.m_1ByteOraCharReplacement;
        }
        return n5;
    }

    public byte[] toOracleString(String string) throws SQLException {
        int n2 = string.length();
        if (n2 == 0) {
            return new byte[0];
        }
        char[] cArray = new char[n2];
        string.getChars(0, n2, cArray, 0);
        int n3 = n2 * 4;
        byte[] byArray = new byte[n3];
        int n4 = 0;
        int n5 = 0;
        while (n5 < n2) {
            int n6;
            int n7 = this.toOracleCharacter(cArray[n5]);
            int n8 = n7 >> 16 & 0xFFFF;
            if (n8 != 0) {
                n6 = n8 & 0xFF00;
                if (n6 != 0) {
                    byArray[n4++] = (byte)(n6 >> 8);
                }
                byArray[n4++] = (byte)n8;
                byArray[n4++] = (byte)(n7 >> 8);
            } else {
                n6 = n7 & 0xFF00;
                if (n6 != 0) {
                    byArray[n4++] = (byte)(n6 >> 8);
                }
            }
            byArray[n4++] = (byte)n7;
            ++n5;
        }
        if (n4 < n3) {
            byte[] byArray2 = new byte[n4];
            System.arraycopy(byArray, 0, byArray2, 0, n4);
            return byArray2;
        }
        return byArray;
    }

    public byte[] toOracleStringWithReplacement(String string) {
        int n2 = string.length();
        if (n2 == 0) {
            return new byte[0];
        }
        char[] cArray = new char[n2];
        string.getChars(0, n2, cArray, 0);
        int n3 = n2 * 4;
        byte[] byArray = new byte[n3];
        int n4 = 0;
        int n5 = 0;
        while (n5 < n2) {
            int n6;
            int n7 = this.toOracleCharacterWithReplacement(cArray[n5]);
            int n8 = n7 >> 16 & 0xFFFF;
            if (n8 != 0) {
                n6 = n8 & 0xFF00;
                if (n6 != 0) {
                    byArray[n4++] = (byte)(n6 >> 8);
                }
                byArray[n4++] = (byte)n8;
                byArray[n4++] = (byte)(n7 >> 8);
            } else {
                n6 = n7 & 0xFF00;
                if (n6 != 0) {
                    byArray[n4++] = (byte)(n6 >> 8);
                }
            }
            byArray[n4++] = (byte)n7;
            ++n5;
        }
        if (n4 < n3) {
            byte[] byArray2 = new byte[n4];
            System.arraycopy(byArray, 0, byArray2, 0, n4);
            return byArray2;
        }
        return byArray;
    }

    char toUnicode(int n2) throws SQLException {
        int n3 = 0;
        int n4 = n2 >> 16 & 0xFFFF;
        int n5 = 0;
        while (n5 < this.m_ucsCharLeadingCode.length) {
            if (n4 == this.m_ucsCharLeadingCode[n5][0]) {
                n3 = this.m_ucsCharLeadingCode[n5][1];
                break;
            }
            ++n5;
        }
        if (n5 == this.m_ucsCharLeadingCode.length) {
            throw new SQLException("Cannot map Oracle character to Unicode.");
        }
        int n6 = (n2 >> this.m_ucsL1KeyShift & this.m_ucsL1KeyMask) + n3;
        int n7 = n2 & this.m_ucsL2KeyMask;
        char c2 = this.m_ucsCharLevel2[this.m_ucsCharLevel1[n6] + n7];
        if (c2 == this.m_ucsCharReplacement) {
            throw new SQLException("Cannot map Oracle character to Unicode.");
        }
        return c2;
    }

    char toUnicodeWithReplacement(int n2) {
        int n3 = 0;
        int n4 = n2 >> 16 & 0xFFFF;
        int n5 = 0;
        while (n5 < this.m_ucsCharLeadingCode.length) {
            if (n4 == this.m_ucsCharLeadingCode[n5][0]) {
                n3 = this.m_ucsCharLeadingCode[n5][1];
                break;
            }
            ++n5;
        }
        if (n5 == this.m_ucsCharLeadingCode.length) {
            return this.m_ucsCharReplacement;
        }
        int n6 = (n2 >> this.m_ucsL1KeyShift & this.m_ucsL1KeyMask) + n3;
        int n7 = n2 & this.m_ucsL2KeyMask;
        return this.m_ucsCharLevel2[this.m_ucsCharLevel1[n6] + n7];
    }
}

