/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql.converter;

import java.sql.SQLException;
import java.util.Vector;
import oracle.sql.converter.CharacterConverter;

public class CharacterConverter1Byte
extends CharacterConverter {
    static final int ORACHARMASK = 255;
    static final int UCSCHARWIDTH = 16;
    public int m_l1KeyWidth = 0;
    public int m_l1KeyShift = 0;
    int m_l1KeyMask = 0;
    int m_l2KeyMask = 0;
    public char m_ucsReplacement = '\u0000';
    public char[] m_ucsChar = null;
    public char[] m_oraCharLevel1 = null;
    public byte[] m_oraCharLevel2 = null;
    public byte m_oraCharReplacement = 0;
    public char[][] extraUnicodeToOracleMapping = null;

    public CharacterConverter1Byte() {
        this.m_groupId = 0;
    }

    public void buildUnicodeToOracleMapping() {
        int n2;
        int n3;
        int n4;
        int n5;
        char c2;
        int n6 = this.m_l1KeyWidth;
        int n7 = 16 - n6;
        int n8 = (1 << n6) - 1;
        int n9 = (1 << n7) - 1;
        this.m_l1KeyShift = n7;
        this.m_l1KeyMask = n8;
        this.m_l2KeyMask = n9;
        int n10 = 1 << n6;
        char[] cArray = new char[n10];
        char[][] cArray2 = new char[n10][2];
        int n11 = 0;
        while (n11 < n10) {
            cArray[n11] = '\u0000';
            cArray2[n11][0] = (char)n9;
            cArray2[n11][1] = '\u0000';
            ++n11;
        }
        int n12 = this.m_ucsChar.length;
        char c3 = this.m_ucsReplacement;
        n11 = 0;
        while (n11 < n12) {
            c2 = this.m_ucsChar[n11];
            if (c2 != c3) {
                n5 = c2 >> n7 & n8;
                cArray[n5] = '\u0001';
                n4 = c2 & n9;
                if (n4 < cArray2[n5][0]) {
                    cArray2[n5][0] = (char)n4;
                }
                if (n4 > cArray2[n5][1]) {
                    cArray2[n5][1] = (char)n4;
                }
            }
            ++n11;
        }
        if (this.extraUnicodeToOracleMapping != null) {
            n12 = this.extraUnicodeToOracleMapping.length;
            n11 = 0;
            while (n11 < n12) {
                c2 = this.extraUnicodeToOracleMapping[n11][0];
                n5 = c2 >> n7 & n8;
                cArray[n5] = '\u0001';
                n4 = c2 & n9;
                if (n4 < cArray2[n5][0]) {
                    cArray2[n5][0] = (char)n4;
                }
                if (n4 > cArray2[n5][1]) {
                    cArray2[n5][1] = (char)n4;
                }
                ++n11;
            }
        }
        int n13 = n3 = n9 + 1;
        int n14 = 0;
        n11 = 0;
        while (n11 < n10) {
            if (cArray[n11] != '\u0000') {
                int n15 = cArray2[n11][0];
                cArray[n11] = (char)(n13 - (n14 < n15 ? n14 : n15));
                n13 = cArray[n11] + n3;
                n14 = n3 - cArray2[n11][1] - 1;
            }
            ++n11;
        }
        byte by = this.m_oraCharReplacement;
        byte[] byArray = new byte[n13];
        n11 = 0;
        while (n11 < n13) {
            byArray[n11] = by;
            ++n11;
        }
        n12 = this.m_ucsChar.length;
        n11 = 0;
        while (n11 < n12) {
            c2 = this.m_ucsChar[n11];
            if (c2 != c3 && byArray[n2 = cArray[n5 = c2 >> n7 & n8] + (n4 = c2 & n9)] == by) {
                byArray[n2] = (byte)n11;
            }
            ++n11;
        }
        if (this.extraUnicodeToOracleMapping != null) {
            n12 = this.extraUnicodeToOracleMapping.length;
            n11 = 0;
            while (n11 < n12) {
                c2 = this.extraUnicodeToOracleMapping[n11][0];
                n5 = c2 >> n7 & n8;
                n4 = c2 & n9;
                n2 = cArray[n5] + n4;
                if (byArray[n2] == by) {
                    byArray[n2] = (byte)this.extraUnicodeToOracleMapping[n11][1];
                }
                ++n11;
            }
        }
        this.m_oraCharLevel1 = cArray;
        this.m_oraCharLevel2 = byArray;
    }

    public void extractCodepoints(Vector vector) {
        int n2 = 0;
        int n3 = 255;
        int n4 = n2;
        while (n4 <= n3) {
            try {
                int[] nArray = new int[]{n4, this.toUnicode((byte)n4)};
                vector.addElement(nArray);
            }
            catch (SQLException sQLException) {}
            ++n4;
        }
    }

    public void extractExtraMappings(Vector vector) {
        if (this.extraUnicodeToOracleMapping == null) {
            return;
        }
        int n2 = 0;
        while (n2 < this.extraUnicodeToOracleMapping.length) {
            int[] nArray = new int[]{this.extraUnicodeToOracleMapping[n2][0], this.extraUnicodeToOracleMapping[n2][1]};
            vector.addElement(nArray);
            ++n2;
        }
    }

    public char getOraChar1ByteRep() {
        return (char)this.m_oraCharReplacement;
    }

    public char getOraChar2ByteRep() {
        return '\u0000';
    }

    public char getUCS2CharRep() {
        return this.m_ucsReplacement;
    }

    public boolean hasExtraMappings() {
        return this.extraUnicodeToOracleMapping != null;
    }

    byte toOracleCharacter(char c2) throws SQLException {
        int n2 = c2 >> this.m_l1KeyShift & this.m_l1KeyMask;
        int n3 = c2 & this.m_l2KeyMask;
        byte by = this.m_oraCharLevel2[this.m_oraCharLevel1[n2] + n3];
        if (by == this.m_oraCharReplacement) {
            throw new SQLException("Cannot map Unicode to Oracle character.");
        }
        return by;
    }

    byte toOracleCharacterWithReplacement(char c2) {
        int n2 = c2 >> this.m_l1KeyShift & this.m_l1KeyMask;
        int n3 = c2 & this.m_l2KeyMask;
        return this.m_oraCharLevel2[this.m_oraCharLevel1[n2] + n3];
    }

    public byte[] toOracleString(String string) throws SQLException {
        int n2 = string.length();
        if (n2 == 0) {
            return new byte[0];
        }
        char[] cArray = new char[n2];
        string.getChars(0, n2, cArray, 0);
        byte[] byArray = new byte[n2];
        int n3 = 0;
        while (n3 < n2) {
            byArray[n3] = this.toOracleCharacter(cArray[n3]);
            ++n3;
        }
        return byArray;
    }

    public byte[] toOracleStringWithReplacement(String string) {
        int n2 = string.length();
        if (n2 == 0) {
            return new byte[0];
        }
        char[] cArray = new char[n2];
        string.getChars(0, n2, cArray, 0);
        byte[] byArray = new byte[n2];
        int n3 = 0;
        while (n3 < n2) {
            byArray[n3] = this.toOracleCharacterWithReplacement(cArray[n3]);
            ++n3;
        }
        return byArray;
    }

    char toUnicode(byte by) throws SQLException {
        char c2 = this.m_ucsChar[by & 0xFF];
        if (c2 == this.m_ucsReplacement) {
            throw new SQLException("Cannot map Oracle character to Unicode.");
        }
        return c2;
    }

    public String toUnicodeString(byte[] byArray, int n2, int n3) throws SQLException {
        int n4 = n2 + n3;
        char[] cArray = new char[n3];
        int n5 = n2;
        int n6 = 0;
        while (n5 < n4) {
            cArray[n6] = this.m_ucsChar[byArray[n5] & 0xFF];
            if (cArray[n6] == this.m_ucsReplacement) {
                throw new SQLException("Cannot map Oracle character to Unicode.");
            }
            ++n5;
            ++n6;
        }
        return new String(cArray);
    }

    public String toUnicodeStringWithReplacement(byte[] byArray, int n2, int n3) {
        int n4 = n2 + n3;
        char[] cArray = new char[n3];
        int n5 = n2;
        int n6 = 0;
        while (n5 < n4) {
            cArray[n6] = this.m_ucsChar[byArray[n5] & 0xFF];
            ++n5;
            ++n6;
        }
        return new String(cArray);
    }

    char toUnicodeWithReplacement(byte by) {
        return this.m_ucsChar[by & 0xFF];
    }
}

