/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql.converter;

import java.sql.SQLException;
import java.util.Vector;
import oracle.sql.converter.CharacterConverter;

public class CharacterConverter12Byte
extends CharacterConverter {
    static final int ORACHARMASK = 255;
    static final int UCSCHARWIDTH = 16;
    static final int ORACHARWIDTH = 16;
    static final int BYTEWIDTH = 8;
    static final int HIBYTEMASK = 65280;
    static final int LOWBYTEMASK = 255;
    static final int BELOW_CJK = 12287;
    static final int INVALID_ORA_CHAR = 65535;
    int m_ucsL1KeyMask = 0;
    int m_ucsL2KeyMask = 0;
    int m_oraL1KeyMask = 0;
    int m_oraL2KeyMask = 0;
    public int m_ucsL1KeyWidth = 0;
    public int m_ucsL1KeyShift = 0;
    public int m_oraL1KeyWidth = 0;
    public int m_oraL1KeyShift = 0;
    public char[] m_ucsCharLevel1 = null;
    public char[] m_ucsCharLevel2 = null;
    public char m_ucsCharReplacement = '\u0000';
    public char[] m_oraCharLevel1 = null;
    public char[] m_oraCharLevel2 = null;
    public char m_1ByteOraCharReplacement = '\u0000';
    public char m_2ByteOraCharReplacement = '\u0000';
    public char[][] extraUnicodeToOracleMapping = null;
    static final short MAX_7BIT = 127;

    public CharacterConverter12Byte() {
        this.m_groupId = 1;
    }

    public void buildUnicodeToOracleMapping() {
        int n2;
        int n3;
        int n4;
        int n5;
        char c2;
        this.m_ucsL1KeyShift = 16 - this.m_ucsL1KeyWidth;
        this.m_ucsL1KeyMask = (1 << this.m_ucsL1KeyWidth) - 1;
        this.m_ucsL2KeyMask = (1 << this.m_ucsL1KeyShift) - 1;
        int n6 = this.m_oraL1KeyWidth;
        int n7 = 16 - n6;
        int n8 = (1 << n6) - 1;
        int n9 = (1 << n7) - 1;
        this.m_oraL1KeyShift = n7;
        this.m_oraL1KeyMask = n8;
        this.m_oraL2KeyMask = n9;
        int n10 = 1 << n6;
        char[] cArray = new char[n10];
        char[][] cArray2 = new char[n10][2];
        int n11 = 0;
        while (n11 < n10) {
            cArray[n11] = '\u0000';
            cArray2[n11][0] = (char)n9;
            cArray2[n11][1] = '\u0000';
            ++n11;
        }
        int n12 = 65536;
        char c3 = this.m_ucsCharReplacement;
        n11 = 0;
        while (n11 < n12) {
            c2 = this.toUnicodeWithReplacement(n11);
            if (c2 != c3) {
                n5 = c2 >> n7 & n8;
                cArray[n5] = '\u0001';
                n4 = c2 & n9;
                if (n4 < cArray2[n5][0]) {
                    cArray2[n5][0] = (char)n4;
                }
                if (n4 > cArray2[n5][1]) {
                    cArray2[n5][1] = (char)n4;
                }
            }
            ++n11;
        }
        if (this.extraUnicodeToOracleMapping != null) {
            n12 = this.extraUnicodeToOracleMapping.length;
            n11 = 0;
            while (n11 < n12) {
                c2 = this.extraUnicodeToOracleMapping[n11][0];
                n5 = c2 >> n7 & n8;
                cArray[n5] = '\u0001';
                n4 = c2 & n9;
                if (n4 < cArray2[n5][0]) {
                    cArray2[n5][0] = (char)n4;
                }
                if (n4 > cArray2[n5][1]) {
                    cArray2[n5][1] = (char)n4;
                }
                ++n11;
            }
        }
        int n13 = n3 = n9 + 1;
        int n14 = 0;
        n11 = 0;
        while (n11 < n10) {
            if (cArray[n11] != '\u0000') {
                int n15 = cArray2[n11][0];
                cArray[n11] = (char)(n13 - (n14 < n15 ? n14 : n15));
                n13 = cArray[n11] + n3;
                n14 = n3 - cArray2[n11][1] - 1;
            }
            ++n11;
        }
        char[] cArray3 = new char[n13];
        n11 = 0;
        while (n11 < n13) {
            cArray3[n11] = 65535;
            ++n11;
        }
        n12 = 65536;
        n11 = 0;
        while (n11 < n12) {
            c2 = this.toUnicodeWithReplacement(n11);
            if (c2 != c3 && cArray3[n2 = cArray[n5 = c2 >> n7 & n8] + (n4 = c2 & n9)] == '\uffff') {
                cArray3[n2] = (char)n11;
            }
            ++n11;
        }
        if (this.extraUnicodeToOracleMapping != null) {
            n12 = this.extraUnicodeToOracleMapping.length;
            n11 = 0;
            while (n11 < n12) {
                c2 = this.extraUnicodeToOracleMapping[n11][0];
                n5 = c2 >> n7 & n8;
                n4 = c2 & n9;
                n2 = cArray[n5] + n4;
                if (cArray3[n2] == '\uffff') {
                    cArray3[n2] = this.extraUnicodeToOracleMapping[n11][1];
                }
                ++n11;
            }
        }
        this.m_oraCharLevel1 = cArray;
        this.m_oraCharLevel2 = cArray3;
    }

    public void extractCodepoints(Vector vector) {
        int n2 = 0;
        int n3 = 65535;
        int n4 = n2;
        while (n4 <= n3) {
            try {
                int[] nArray = new int[]{n4, this.toUnicode(n4)};
                vector.addElement(nArray);
            }
            catch (SQLException sQLException) {}
            ++n4;
        }
    }

    public void extractExtraMappings(Vector vector) {
        if (this.extraUnicodeToOracleMapping == null) {
            return;
        }
        int n2 = 0;
        while (n2 < this.extraUnicodeToOracleMapping.length) {
            int[] nArray = new int[]{this.extraUnicodeToOracleMapping[n2][0], this.extraUnicodeToOracleMapping[n2][1]};
            vector.addElement(nArray);
            ++n2;
        }
    }

    public char getOraChar1ByteRep() {
        return this.m_1ByteOraCharReplacement;
    }

    public char getOraChar2ByteRep() {
        return this.m_2ByteOraCharReplacement;
    }

    public char getUCS2CharRep() {
        return this.m_ucsCharReplacement;
    }

    public boolean hasExtraMappings() {
        return this.extraUnicodeToOracleMapping != null;
    }

    char toOracleCharacter(char c2) throws SQLException {
        int n2 = c2 >> this.m_oraL1KeyShift & this.m_oraL1KeyMask;
        int n3 = c2 & this.m_oraL2KeyMask;
        char c3 = this.m_oraCharLevel2[this.m_oraCharLevel1[n2] + n3];
        if (c3 == '\uffff') {
            throw new SQLException("Cannot map Unicode to Oracle character.");
        }
        return c3;
    }

    char toOracleCharacterWithReplacement(char c2) {
        int n2 = c2 >> this.m_oraL1KeyShift & this.m_oraL1KeyMask;
        int n3 = c2 & this.m_oraL2KeyMask;
        char c3 = this.m_oraCharLevel2[this.m_oraCharLevel1[n2] + n3];
        if (c3 == '\uffff') {
            if (c2 > '\u2fff') {
                return this.m_2ByteOraCharReplacement;
            }
            return this.m_1ByteOraCharReplacement;
        }
        return c3;
    }

    public byte[] toOracleString(String string) throws SQLException {
        int n2 = string.length();
        if (n2 == 0) {
            return new byte[0];
        }
        char[] cArray = new char[n2];
        string.getChars(0, n2, cArray, 0);
        byte[] byArray = new byte[n2 * 2];
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            char c2 = this.toOracleCharacter(cArray[n4]);
            int n5 = c2 & 0xFF00;
            if (n5 != 0) {
                byArray[n3++] = (byte)(n5 >> 8);
            }
            byArray[n3++] = (byte)c2;
            ++n4;
        }
        if (n3 < byArray.length) {
            byte[] byArray2 = new byte[n3];
            System.arraycopy(byArray, 0, byArray2, 0, n3);
            return byArray2;
        }
        return byArray;
    }

    public byte[] toOracleStringWithReplacement(String string) {
        int n2 = string.length();
        if (n2 == 0) {
            return new byte[0];
        }
        char[] cArray = new char[n2];
        string.getChars(0, n2, cArray, 0);
        byte[] byArray = new byte[n2 * 2];
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            char c2 = this.toOracleCharacterWithReplacement(cArray[n4]);
            int n5 = c2 & 0xFF00;
            if (n5 != 0) {
                byArray[n3++] = (byte)(n5 >> 8);
            }
            byArray[n3++] = (byte)c2;
            ++n4;
        }
        if (n3 < byArray.length) {
            byte[] byArray2 = new byte[n3];
            System.arraycopy(byArray, 0, byArray2, 0, n3);
            return byArray2;
        }
        return byArray;
    }

    char toUnicode(int n2) throws SQLException {
        int n3 = n2 >> this.m_ucsL1KeyShift & this.m_ucsL1KeyMask;
        int n4 = n2 & this.m_ucsL2KeyMask;
        char c2 = this.m_ucsCharLevel2[this.m_ucsCharLevel1[n3] + n4];
        if (c2 == this.m_ucsCharReplacement) {
            throw new SQLException("Cannot map Oracle character to Unicode.");
        }
        return c2;
    }

    public String toUnicodeString(byte[] byArray, int n2, int n3) throws SQLException {
        int n4 = n2 + n3;
        char[] cArray = new char[n3];
        int n5 = n2;
        int n6 = 0;
        while (n5 < n4) {
            int n7 = byArray[n5] & 0xFF;
            if (n7 > 127) {
                if (n5 < n4 - 1) {
                    n7 = byArray[n5] << 8 & 0xFF00 | byArray[n5 + 1] & 0xFF;
                    ++n5;
                } else {
                    throw new SQLException("Cannot map Oracle character to Unicode.");
                }
            }
            cArray[n6++] = this.toUnicode(n7);
            ++n5;
        }
        return new String(cArray, 0, n6);
    }

    public String toUnicodeStringWithReplacement(byte[] byArray, int n2, int n3) {
        int n4 = n2 + n3;
        char[] cArray = new char[n3];
        int n5 = n2;
        int n6 = 0;
        while (n5 < n4) {
            int n7 = byArray[n5] & 0xFF;
            if (n7 > 127) {
                if (n4 - n5 < 2) break;
                n7 = byArray[n5] << 8 & 0xFF00 | byArray[n5 + 1] & 0xFF;
                ++n5;
            }
            cArray[n6++] = this.toUnicodeWithReplacement(n7);
            ++n5;
        }
        return new String(cArray, 0, n6);
    }

    char toUnicodeWithReplacement(int n2) {
        int n3 = n2 >> this.m_ucsL1KeyShift & this.m_ucsL1KeyMask;
        int n4 = n2 & this.m_ucsL2KeyMask;
        return this.m_ucsCharLevel2[this.m_ucsCharLevel1[n3] + n4];
    }
}

