/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.StringWriter;
import java.sql.Connection;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLOutput;
import java.sql.Struct;
import java.util.Hashtable;
import java.util.Map;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.internal.ObjectData;
import oracle.sql.CustomDatum;
import oracle.sql.CustomDatumFactory;
import oracle.sql.Datum;
import oracle.sql.ORAData;
import oracle.sql.ORADataFactory;
import oracle.sql.OracleSQLOutput;
import oracle.sql.StructDescriptor;

public class STRUCT
extends Datum
implements Struct {
    StructDescriptor m_descriptor;
    oracle.jdbc.OracleConnection m_conn;
    Datum[] m_datumArray;
    Object[] m_objArray;
    boolean m_enableLocalCache = false;
    long m_imgOffset;
    long m_imgLength;
    static /* synthetic */ Class class$oracle$sql$STRUCT;
    static /* synthetic */ Class class$java$sql$Struct;

    public STRUCT(StructDescriptor structDescriptor, Connection connection, Object[] objectArray) throws SQLException {
        if (structDescriptor != null) {
            this.m_descriptor = structDescriptor;
            if (!this.m_descriptor.isInstantiable()) {
                throw new SQLException("Cannot construct STRUCT instance for a non-instantiable object type");
            }
        } else {
            DBError.check_error(61, "STRUCT");
        }
        if (connection != null) {
            this._setConnection(connection);
        } else {
            DBError.check_error(8, "Connection is null");
        }
        this.m_datumArray = objectArray != null ? this.m_descriptor.toArray(objectArray) : new Datum[0];
    }

    public STRUCT(StructDescriptor structDescriptor, byte[] byArray, Connection connection) throws SQLException {
        super(byArray);
        if (connection != null) {
            this._setConnection(connection);
        } else {
            DBError.check_error(8, "Connection is null");
        }
        this.m_descriptor = structDescriptor;
        this.m_datumArray = null;
    }

    private void _setConnection(Connection connection) {
        this.m_conn = connection != null && ((oracle.jdbc.OracleConnection)connection).isLogicalConnection() ? (oracle.jdbc.OracleConnection)((oracle.jdbc.OracleConnection)connection)._getPC() : (oracle.jdbc.OracleConnection)connection;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public String debugString() {
        StringWriter stringWriter = new StringWriter();
        try {
            StructDescriptor structDescriptor = this.getDescriptor();
            stringWriter.write("name = " + structDescriptor.getName());
            int n2 = structDescriptor.getLength();
            stringWriter.write(" length = " + n2);
            Object[] objectArray = this.getAttributes();
            int n3 = 0;
            while (n3 < n2) {
                stringWriter.write(" attribute[" + n3 + "] = " + objectArray[n3]);
                ++n3;
            }
        }
        catch (SQLException sQLException) {
            return "StructDescriptor missing or bad";
        }
        return stringWriter.toString();
    }

    public synchronized Object[] getAttributes() throws SQLException {
        return this.getAttributes(this.getMap());
    }

    public synchronized Object[] getAttributes(Map map) throws SQLException {
        return this.m_descriptor.toArray(this, map, this.m_enableLocalCache);
    }

    public synchronized boolean getAutoBuffering() throws SQLException {
        return this.m_enableLocalCache;
    }

    public OracleConnection getConnection() throws SQLException {
        try {
            return (OracleConnection)this.getJavaSqlConnection();
        }
        catch (ClassCastException classCastException) {
            DBError.throwSqlException(103);
            return null;
        }
    }

    public synchronized StructDescriptor getDescriptor() throws SQLException {
        return this.m_descriptor;
    }

    public CustomDatumFactory getFactory(Hashtable hashtable, String string) throws SQLException {
        String string2 = this.getSQLTypeName();
        Object v2 = hashtable.get(string2);
        if (v2 == null) {
            throw new SQLException("Unable to convert a \"" + string2 + "\" to a \"" + string + "\" or a subclass of \"" + string + "\"");
        }
        return (CustomDatumFactory)v2;
    }

    public long getImageLength() {
        return this.m_imgLength;
    }

    public long getImageOffset() {
        return this.m_imgOffset;
    }

    public Connection getJavaSqlConnection() throws SQLException {
        return this.m_conn;
    }

    public Map getMap() {
        try {
            return this.getConnection().getTypeMap();
        }
        catch (SQLException sQLException) {
            return null;
        }
    }

    public ORADataFactory getORADataFactory(Hashtable hashtable, String string) throws SQLException {
        String string2 = this.getSQLTypeName();
        Object v2 = hashtable.get(string2);
        if (v2 == null) {
            throw new SQLException("Unable to convert a \"" + string2 + "\" to a \"" + string + "\" or a subclass of \"" + string + "\"");
        }
        return (ORADataFactory)v2;
    }

    public synchronized Datum[] getOracleAttributes() throws SQLException {
        return this.m_descriptor.toOracleArray(this, this.m_enableLocalCache);
    }

    public synchronized String getSQLTypeName() throws SQLException {
        return this.m_descriptor.getName();
    }

    public boolean isConvertibleTo(Class clazz) {
        return false;
    }

    public boolean isInHierarchyOf(String string) throws SQLException {
        return this.getDescriptor().isInHierarchyOf(string);
    }

    public Object makeJdbcArray(int n2) {
        return new Object[n2];
    }

    public synchronized void setAutoBuffering(boolean bl) throws SQLException {
        this.m_enableLocalCache = bl;
    }

    public synchronized void setDatumArray(Datum[] datumArray) {
        this.m_datumArray = datumArray == null ? new Datum[]{} : datumArray;
    }

    public synchronized void setDescriptor(StructDescriptor structDescriptor) {
        this.m_descriptor = structDescriptor;
    }

    public void setImage(byte[] byArray, long l2, long l3) throws SQLException {
        this.setShareBytes(byArray);
        this.m_imgOffset = l2;
        this.m_imgLength = l3;
    }

    public void setImageLength(long l2) throws SQLException {
        this.m_imgLength = l2;
    }

    public synchronized void setObjArray(Object[] objectArray) throws SQLException {
        this.m_objArray = objectArray == null ? new Object[]{} : objectArray;
    }

    public synchronized byte[] toBytes() throws SQLException {
        return this.m_descriptor.toBytes(this, this.m_enableLocalCache);
    }

    public Object toClass(Class clazz) throws SQLException {
        return this.toClass(clazz, this.getMap());
    }

    public Object toClass(Class clazz, Map map) throws SQLException {
        try {
            if (clazz == null || clazz == (class$oracle$sql$STRUCT != null ? class$oracle$sql$STRUCT : (class$oracle$sql$STRUCT = STRUCT.class$("oracle.sql.STRUCT"))) || clazz == (class$java$sql$Struct != null ? class$java$sql$Struct : (class$java$sql$Struct = STRUCT.class$("java.sql.Struct")))) {
                return this;
            }
            ObjectData objectData = null;
            Object t2 = clazz.newInstance();
            if (t2 instanceof SQLData) {
                ((SQLData)t2).readSQL(this.m_descriptor.toJdbc2SQLInput(this, map), this.m_descriptor.getName());
                objectData = t2;
            } else if (t2 instanceof ORADataFactory) {
                ORADataFactory oRADataFactory = (ORADataFactory)t2;
                objectData = oRADataFactory.create(this, 2002);
            } else if (t2 instanceof CustomDatumFactory) {
                CustomDatumFactory customDatumFactory = (CustomDatumFactory)t2;
                objectData = customDatumFactory.create(this, 2002);
            } else {
                DBError.throwSqlException(49, this.m_descriptor.getName());
            }
            return objectData;
        }
        catch (InstantiationException instantiationException) {
            DBError.throwSqlException(49, "InstantiationException: " + instantiationException.getMessage());
        }
        catch (IllegalAccessException illegalAccessException) {
            DBError.throwSqlException(49, "IllegalAccessException: " + illegalAccessException.getMessage());
        }
        return null;
    }

    public Object toJdbc() throws SQLException {
        Map map = this.getMap();
        return this.toJdbc(map);
    }

    public Object toJdbc(Map map) throws SQLException {
        Class clazz;
        Object object = this;
        if (map != null && (clazz = this.m_descriptor.getClass(map)) != null) {
            object = this.toClass(clazz, map);
        }
        return object;
    }

    public static STRUCT toSTRUCT(Object object, oracle.jdbc.OracleConnection oracleConnection) throws SQLException {
        if (object == null) {
            return null;
        }
        STRUCT sTRUCT = null;
        if (object instanceof STRUCT) {
            sTRUCT = (STRUCT)object;
        } else if (object instanceof ORAData) {
            sTRUCT = (STRUCT)((ORAData)object).toDatum(oracleConnection);
        } else if (object instanceof CustomDatum) {
            sTRUCT = (STRUCT)((CustomDatum)object).toDatum((OracleConnection)oracleConnection);
        } else if (object instanceof SQLData) {
            SQLData sQLData = (SQLData)object;
            StructDescriptor structDescriptor = StructDescriptor.createDescriptor(sQLData.getSQLTypeName(), oracleConnection);
            SQLOutput sQLOutput = structDescriptor.toJdbc2SQLOutput();
            sQLData.writeSQL(sQLOutput);
            sTRUCT = ((OracleSQLOutput)sQLOutput).getSTRUCT();
        } else {
            DBError.check_error(59, object);
        }
        return sTRUCT;
    }
}

