/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.Ref;
import java.sql.SQLException;
import java.util.Map;
import oracle.jdbc.OraclePreparedStatement;
import oracle.jdbc.OracleResultSet;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleConnection;
import oracle.sql.Datum;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;

public class REF
extends Datum
implements Ref,
Serializable,
Cloneable {
    static final boolean DEBUG = false;
    static final long serialVersionUID = 1328446996944583167L;
    String m_typename;
    transient StructDescriptor m_descriptor;
    transient oracle.jdbc.OracleConnection m_conn;

    public REF(String string, Connection connection, byte[] byArray) throws SQLException {
        super(byArray);
        if (connection == null || string == null) {
            DBError.throwSqlException(68);
        }
        this.m_typename = string;
        this.m_descriptor = null;
        this._setConnection(connection);
    }

    public REF(StructDescriptor structDescriptor, Connection connection, byte[] byArray) throws SQLException {
        super(byArray);
        if (connection == null || structDescriptor == null) {
            DBError.check_error(68);
        }
        this.m_descriptor = structDescriptor;
        this._setConnection(connection);
    }

    private void _setConnection(Connection connection) {
        this.m_conn = connection != null && ((oracle.jdbc.OracleConnection)connection).isLogicalConnection() ? (oracle.jdbc.OracleConnection)((oracle.jdbc.OracleConnection)connection)._getPC() : (oracle.jdbc.OracleConnection)connection;
    }

    public Object clone() throws CloneNotSupportedException {
        try {
            return new REF(this.getBaseTypeName(), (Connection)this.getConnection(), this.getBytes());
        }
        catch (SQLException sQLException) {
            throw new CloneNotSupportedException(sQLException.getMessage());
        }
    }

    public boolean equals(Object object) {
        try {
            return object instanceof REF && super.equals(object) && this.getBaseTypeName().equals(((REF)object).getSQLTypeName());
        }
        catch (Exception exception) {
            return false;
        }
    }

    public String getBaseTypeName() throws SQLException {
        if (this.m_typename == null) {
            if (this.m_descriptor != null) {
                this.m_typename = this.m_descriptor.getName();
            } else {
                DBError.throwSqlException(52);
            }
        }
        return this.m_typename;
    }

    public OracleConnection getConnection() throws SQLException {
        try {
            return (OracleConnection)this.getJavaSqlConnection();
        }
        catch (ClassCastException classCastException) {
            DBError.throwSqlException(103);
            return null;
        }
    }

    public StructDescriptor getDescriptor() throws SQLException {
        if (this.m_descriptor == null) {
            this.m_descriptor = StructDescriptor.createDescriptor(this.m_typename, this.getConnection());
        }
        return this.m_descriptor;
    }

    public Connection getJavaSqlConnection() throws SQLException {
        return this.m_conn;
    }

    public String getSQLTypeName() throws SQLException {
        return this.getBaseTypeName();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized STRUCT getSTRUCT() throws SQLException {
        OracleResultSet oracleResultSet;
        OraclePreparedStatement oraclePreparedStatement;
        block4: {
            STRUCT sTRUCT;
            block3: {
                oraclePreparedStatement = (OraclePreparedStatement)this.getConnection().prepareStatement("select deref(?) from dual");
                oraclePreparedStatement.setRowPrefetch(1);
                oraclePreparedStatement.setREF(1, this);
                oracleResultSet = (OracleResultSet)oraclePreparedStatement.executeQuery();
                try {
                    if (oracleResultSet.next()) {
                        sTRUCT = oracleResultSet.getSTRUCT(1);
                        Object var5_4 = null;
                        break block3;
                    }
                    DBError.throwSqlException(52);
                    break block4;
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    oracleResultSet.close();
                    oracleResultSet = null;
                    oraclePreparedStatement.close();
                    oraclePreparedStatement = null;
                    throw throwable;
                }
            }
            oracleResultSet.close();
            oracleResultSet = null;
            oraclePreparedStatement.close();
            return sTRUCT;
        }
        Object var5_5 = null;
        oracleResultSet.close();
        oracleResultSet = null;
        oraclePreparedStatement.close();
        return null;
    }

    public Object getValue() throws SQLException {
        STRUCT sTRUCT = this.getSTRUCT();
        return sTRUCT != null ? sTRUCT.toJdbc() : null;
    }

    public Object getValue(Map map) throws SQLException {
        STRUCT sTRUCT = this.getSTRUCT();
        return sTRUCT != null ? sTRUCT.toJdbc(map) : null;
    }

    public int hashCode() {
        int n2;
        block4: {
            byte[] byArray;
            block5: {
                block3: {
                    byArray = this.shareBytes();
                    n2 = 0;
                    if ((byArray[2] & 5) != 5) break block3;
                    int n3 = 0;
                    while (n3 < 4) {
                        n2 *= 256;
                        n2 += byArray[8 + n3] & 0xFF;
                        ++n3;
                    }
                    break block4;
                }
                if ((byArray[2] & 3) != 3) break block5;
                int n4 = 0;
                while (n4 < 4 && n4 < byArray.length) {
                    n2 *= 256;
                    n2 += byArray[6 + n4] & 0xFF;
                    ++n4;
                }
                break block4;
            }
            if ((byArray[2] & 2) != 2) break block4;
            int n5 = 0;
            while (n5 < 4) {
                n2 *= 256;
                n2 += byArray[8 + n5] & 0xFF;
                ++n5;
            }
        }
        return n2;
    }

    public boolean isConvertibleTo(Class clazz) {
        return false;
    }

    public Object makeJdbcArray(int n2) {
        return new REF[n2];
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.setBytes((byte[])objectInputStream.readObject());
        this.m_typename = objectInputStream.readUTF();
    }

    public void setConnection(Connection connection) throws SQLException {
        this._setConnection(connection);
    }

    public synchronized void setValue(Object object) throws SQLException {
        CallableStatement callableStatement;
        block6: {
            STRUCT sTRUCT = STRUCT.toSTRUCT(object, this.getConnection());
            if (sTRUCT.getConnection() != this.getConnection()) {
                DBError.throwSqlException(77, "Incompatible connection object");
            }
            if (!this.getBaseTypeName().equals(sTRUCT.getSQLTypeName())) {
                DBError.throwSqlException(77, "Incompatible type");
            }
            byte[] byArray = sTRUCT.toBytes();
            byte[] byArray2 = sTRUCT.getDescriptor().getOracleTypeADT().getTOID();
            callableStatement = null;
            try {
                callableStatement = this.getConnection().prepareCall("begin ? := dbms_pickler.update_through_ref (?, ?, ?, ?); end;");
                callableStatement.registerOutParameter(1, 2);
                callableStatement.setBytes(2, this.shareBytes());
                callableStatement.setInt(3, 0);
                callableStatement.setBytes(4, byArray2);
                callableStatement.setBytes(5, byArray);
                callableStatement.execute();
                int n2 = 0;
                n2 = callableStatement.getInt(1);
                if (n2 == 0) break block6;
                DBError.throwSqlException(77, "ORA-" + n2);
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                if (callableStatement != null) {
                    callableStatement.close();
                }
                callableStatement = null;
                throw throwable;
            }
        }
        Object var7_7 = null;
        if (callableStatement != null) {
            callableStatement.close();
        }
        callableStatement = null;
    }

    public Object toJdbc() throws SQLException {
        return this;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.shareBytes());
        try {
            objectOutputStream.writeUTF(this.getBaseTypeName());
        }
        catch (SQLException sQLException) {
            throw new IOException("SQLException ORA-" + sQLException.getErrorCode() + " " + sQLException.getMessage());
        }
    }
}

