/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.InputStream;
import java.io.Reader;
import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBConversion;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.util.RepConversion;
import oracle.sql.Datum;

public class RAW
extends Datum {
    public RAW() {
    }

    public RAW(Object object) throws SQLException {
        this();
        if (object instanceof byte[]) {
            this.setShareBytes((byte[])object);
        } else if (object instanceof String) {
            String string = (String)object;
            byte[] byArray = new byte[string.length()];
            string.getBytes(0, string.length() - 1, byArray, 0);
            this.setShareBytes(byArray);
        } else {
            DBError.check_error(59, object);
        }
    }

    public RAW(byte[] byArray) {
        super(byArray);
    }

    public InputStream asciiStreamValue() throws SQLException {
        int n2 = (int)this.getLength();
        char[] cArray = new char[n2 * 2];
        byte[] byArray = this.shareBytes();
        DBConversion.RAWBytesToHexChars(byArray, n2, cArray);
        byte[] byArray2 = new byte[n2 * 2];
        DBConversion.javaCharsToAsciiBytes(cArray, n2 * 2, byArray2);
        return new ByteArrayInputStream(byArray2);
    }

    public InputStream binaryStreamValue() throws SQLException {
        return this.getStream();
    }

    public Reader characterStreamValue() throws SQLException {
        int n2 = (int)this.getLength();
        char[] cArray = new char[n2 * 2];
        byte[] byArray = this.shareBytes();
        DBConversion.RAWBytesToHexChars(byArray, n2, cArray);
        return new CharArrayReader(cArray);
    }

    public boolean isConvertibleTo(Class clazz) {
        String string = clazz.getName();
        return string.compareTo("java.lang.String") == 0 || string.compareTo("java.io.InputStream") == 0 || string.compareTo("java.io.Reader") == 0;
    }

    public Object makeJdbcArray(int n2) {
        return new byte[n2][];
    }

    public String stringValue() {
        return RepConversion.bArray2String(this.getBytes());
    }

    public Object toJdbc() throws SQLException {
        return this.getBytes();
    }
}

