/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.jdbc.oracore.OracleTypeOPAQUE;
import oracle.sql.OPAQUE;
import oracle.sql.SQLName;
import oracle.sql.TypeDescriptor;

public class OpaqueDescriptor
extends TypeDescriptor
implements Serializable {
    static final boolean DEBUG = false;
    static final long serialVersionUID = 1013921343538311063L;

    public OpaqueDescriptor(String string, Connection connection) throws SQLException {
        super(string, connection);
        this.initPickler();
    }

    public OpaqueDescriptor(OracleTypeADT oracleTypeADT, Connection connection) throws SQLException {
        super(oracleTypeADT, connection);
    }

    public OpaqueDescriptor(SQLName sQLName, Connection connection) throws SQLException {
        super(sQLName, connection);
        this.initPickler();
    }

    public OpaqueDescriptor(SQLName sQLName, OracleTypeOPAQUE oracleTypeOPAQUE, Connection connection) throws SQLException {
        super(sQLName, oracleTypeOPAQUE, connection);
    }

    public static OpaqueDescriptor createDescriptor(String string, Connection connection) throws SQLException {
        SQLName sQLName;
        String string2;
        OpaqueDescriptor opaqueDescriptor;
        if (string == null || string.length() == 0 || connection == null) {
            DBError.check_error(60, "Invalid arguments");
        }
        if ((opaqueDescriptor = (OpaqueDescriptor)((oracle.jdbc.OracleConnection)connection).getDescriptor(string2 = (sQLName = new SQLName(string, (oracle.jdbc.OracleConnection)connection)).getName())) == null) {
            opaqueDescriptor = new OpaqueDescriptor(sQLName, connection);
            ((oracle.jdbc.OracleConnection)connection).putDescriptor(string2, opaqueDescriptor);
        }
        return opaqueDescriptor;
    }

    public String descType() throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        return this.descType(stringBuffer, 0);
    }

    String descType(StringBuffer stringBuffer, int n2) throws SQLException {
        String string = "";
        int n3 = 0;
        while (n3 < n2) {
            string = String.valueOf(string) + "  ";
            ++n3;
        }
        String string2 = String.valueOf(string) + "  ";
        stringBuffer.append(string);
        stringBuffer.append(this.getTypeName());
        stringBuffer.append(" maxLen=" + this.getMaxLength() + " isTrusted=" + this.isTrustedLibrary() + " hasUnboundedSize=" + this.hasUnboundedSize() + " hasFixedSize=" + this.hasFixedSize());
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    public long getMaxLength() throws SQLException {
        return this.hasUnboundedSize() ? 0L : ((OracleTypeOPAQUE)this.m_pickler).getMaxLength();
    }

    public int getTypeCode() {
        return 2007;
    }

    public boolean hasFixedSize() throws SQLException {
        return ((OracleTypeOPAQUE)this.m_pickler).isFixedSized();
    }

    public boolean hasUnboundedSize() throws SQLException {
        return ((OracleTypeOPAQUE)this.m_pickler).isUnboundedSized();
    }

    private void initPickler() throws SQLException {
        try {
            this.m_pickler = new OracleTypeADT(this.getName(), this.m_conn);
            ((OracleTypeADT)this.m_pickler).init((OracleConnection)this.m_conn);
            this.m_pickler = (OracleTypeOPAQUE)((OracleTypeADT)this.m_pickler).cleanup();
            this.m_pickler.setDescriptor(this);
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            DBError.throwSqlException(60, "Unable to resolve type \"" + this.getName() + "\"");
        }
    }

    public boolean isModeledInC() throws SQLException {
        return ((OracleTypeOPAQUE)this.m_pickler).isModeledInC();
    }

    public boolean isTrustedLibrary() throws SQLException {
        return ((OracleTypeOPAQUE)this.m_pickler).isTrustedLibrary();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        if (TypeDescriptor.DEBUG_SERIALIZATION) {
            System.out.println("OpaqueDescriptor::readObject");
        }
    }

    byte[] toBytes(OPAQUE oPAQUE, boolean bl) throws SQLException {
        if (oPAQUE.shareBytes() != null) {
            return oPAQUE.shareBytes();
        }
        try {
            byte[] byArray = this.m_pickler.linearize(oPAQUE);
            Object var5_4 = null;
            if (!bl) {
                oPAQUE.setShareBytes(null);
            }
            return byArray;
        }
        catch (Throwable throwable) {
            block4: {
                Object var5_5 = null;
                if (bl) break block4;
                oPAQUE.setShareBytes(null);
            }
            throw throwable;
        }
    }

    byte[] toValue(OPAQUE oPAQUE, boolean bl) throws SQLException {
        if (oPAQUE.m_value != null) {
            return oPAQUE.m_value;
        }
        try {
            this.m_pickler.unlinearize(oPAQUE.shareBytes(), 0L, oPAQUE, 1, null);
            byte[] byArray = oPAQUE.m_value;
            Object var5_4 = null;
            if (!bl) {
                oPAQUE.m_value = null;
            }
            return byArray;
        }
        catch (Throwable throwable) {
            block4: {
                Object var5_5 = null;
                if (bl) break block4;
                oPAQUE.m_value = null;
            }
            throw throwable;
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (TypeDescriptor.DEBUG_SERIALIZATION) {
            System.out.println("OpaqueDescriptor::writeObject");
        }
    }
}

