/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.Connection;
import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleConnection;
import oracle.sql.Datum;
import oracle.sql.OpaqueDescriptor;

public class OPAQUE
extends Datum {
    OpaqueDescriptor m_descriptor;
    oracle.jdbc.OracleConnection m_conn;
    byte[] m_value;
    long m_imgOffset;
    long m_imgLength;

    public OPAQUE(OpaqueDescriptor opaqueDescriptor, Connection connection, Object object) throws SQLException {
        if (opaqueDescriptor != null) {
            this.m_descriptor = opaqueDescriptor;
        } else {
            DBError.check_error(61, "OPAQUE");
        }
        if (connection != null) {
            this.m_conn = (oracle.jdbc.OracleConnection)connection;
        } else {
            DBError.check_error(8, "Connection is null");
        }
        if (object instanceof byte[]) {
            this.m_value = (byte[])object;
        } else {
            DBError.throwSqlException(59, "OPAQUE()");
        }
    }

    public OPAQUE(OpaqueDescriptor opaqueDescriptor, byte[] byArray, Connection connection) throws SQLException {
        super(byArray);
        if (connection != null) {
            this.m_conn = (oracle.jdbc.OracleConnection)connection;
        } else {
            DBError.check_error(8, "Connection is null");
        }
        this.m_descriptor = opaqueDescriptor;
        this.m_value = null;
    }

    public byte[] getBytesValue() throws SQLException {
        return this.m_descriptor.toValue(this, false);
    }

    public OracleConnection getConnection() throws SQLException {
        try {
            return (OracleConnection)this.getJavaSqlConnection();
        }
        catch (ClassCastException classCastException) {
            DBError.throwSqlException(103);
            return null;
        }
    }

    public OpaqueDescriptor getDescriptor() throws SQLException {
        return this.m_descriptor;
    }

    public long getImageLength() {
        return this.m_imgLength;
    }

    public long getImageOffset() {
        return this.m_imgOffset;
    }

    public Connection getJavaSqlConnection() throws SQLException {
        return this.m_conn;
    }

    public String getSQLTypeName() throws SQLException {
        return this.m_descriptor.getName();
    }

    public Object getValue() throws SQLException {
        return this.m_descriptor.toValue(this, false);
    }

    public boolean isConvertibleTo(Class clazz) {
        return false;
    }

    public Object makeJdbcArray(int n2) {
        return new Object[n2];
    }

    public void setDescriptor(OpaqueDescriptor opaqueDescriptor) {
        this.m_descriptor = opaqueDescriptor;
    }

    public void setImage(byte[] byArray, long l2, long l3) throws SQLException {
        this.setShareBytes(byArray);
        this.m_imgOffset = l2;
        this.m_imgLength = l3;
    }

    public void setImageLength(long l2) throws SQLException {
        this.m_imgLength = l2;
    }

    public void setValue(byte[] byArray) throws SQLException {
        this.m_value = byArray;
    }

    public byte[] toBytes() throws SQLException {
        return this.m_descriptor.toBytes(this, false);
    }

    public Object toJdbc() throws SQLException {
        return this;
    }
}

