/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.sql.Connection;
import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBAccess;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleBlobInputStream;
import oracle.jdbc.driver.OracleBlobOutputStream;
import oracle.jdbc.driver.OracleClobInputStream;
import oracle.jdbc.driver.OracleClobOutputStream;
import oracle.jdbc.driver.OracleClobReader;
import oracle.jdbc.driver.OracleClobWriter;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OracleConversionInputStream;
import oracle.jdbc.driver.OracleConversionReader;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.BfileDBAccess;
import oracle.sql.BlobDBAccess;
import oracle.sql.CLOB;
import oracle.sql.ClobDBAccess;

public class LobDBAccessImpl
implements BlobDBAccess,
ClobDBAccess,
BfileDBAccess {
    OracleConnection m_conn;
    DBAccess m_dbaccess;

    public LobDBAccessImpl(OracleConnection oracleConnection) throws SQLException {
        if (oracleConnection == null) {
            DBError.throwSqlException(68, "connection is null");
        }
        this.m_conn = oracleConnection;
        this.m_dbaccess = oracleConnection.db_access;
    }

    public synchronized void close(BFILE bFILE) throws SQLException {
        this.m_dbaccess.closeLob(bFILE.getConnection(), bFILE, -13);
    }

    public synchronized void close(BLOB bLOB) throws SQLException {
        this.m_dbaccess.closeLob(bLOB.getConnection(), bLOB, 2004);
    }

    public synchronized void close(CLOB cLOB) throws SQLException {
        this.m_dbaccess.closeLob(cLOB.getConnection(), cLOB, 2005);
    }

    public synchronized void closeFile(BFILE bFILE) throws SQLException {
        this.m_dbaccess.fileClose(bFILE);
    }

    public synchronized BLOB createTemporaryBlob(Connection connection, boolean bl, int n2) throws SQLException {
        return (BLOB)this.m_dbaccess.createTemporaryLob(connection, bl, n2, 2004);
    }

    public synchronized CLOB createTemporaryClob(Connection connection, boolean bl, int n2) throws SQLException {
        return (CLOB)this.m_dbaccess.createTemporaryLob(connection, bl, n2, 2005);
    }

    public synchronized boolean fileExists(BFILE bFILE) throws SQLException {
        return this.m_dbaccess.fileExists(bFILE);
    }

    public synchronized void freeTemporary(BLOB bLOB) throws SQLException {
        this.m_dbaccess.freeTemporaryLob(bLOB.getConnection(), bLOB, 2004);
    }

    public synchronized void freeTemporary(CLOB cLOB) throws SQLException {
        this.m_dbaccess.freeTemporaryLob(cLOB.getConnection(), cLOB, 2005);
    }

    public synchronized int getBytes(BFILE bFILE, long l2, int n2, byte[] byArray) throws SQLException {
        if (l2 < 1L || n2 < 0 || byArray == null) {
            DBError.check_error(68, "getBytes()");
        }
        if (n2 == 0) {
            return 0;
        }
        return (int)this.m_dbaccess.lobRead(bFILE, l2, (long)n2, byArray);
    }

    public synchronized int getBytes(BLOB bLOB, long l2, int n2, byte[] byArray) throws SQLException {
        if (n2 < 0 || l2 < 1L || byArray == null) {
            DBError.throwSqlException(68, "getBytes()");
        }
        if (n2 == 0) {
            return 0;
        }
        return (int)this.m_dbaccess.lobRead(bLOB, l2, (long)n2, byArray);
    }

    public synchronized int getChars(CLOB cLOB, long l2, int n2, char[] cArray) throws SQLException {
        if (n2 < 0 || l2 < 1L || cArray == null) {
            DBError.check_error(68, "getChars()");
        }
        if (n2 == 0) {
            return 0;
        }
        return (int)this.m_dbaccess.lobRead(cLOB, l2, (long)n2, cArray);
    }

    public synchronized int getChunkSize(BLOB bLOB) throws SQLException {
        return (int)this.m_dbaccess.getLobChunkSize(bLOB);
    }

    public synchronized int getChunkSize(CLOB cLOB) throws SQLException {
        return (int)this.m_dbaccess.getLobChunkSize(cLOB);
    }

    public synchronized String getDirAlias(BFILE bFILE) throws SQLException {
        return this.m_dbaccess.fileGetDirAlias(bFILE);
    }

    public synchronized String getName(BFILE bFILE) throws SQLException {
        return this.m_dbaccess.fileGetName(bFILE);
    }

    public synchronized boolean isFileOpen(BFILE bFILE) throws SQLException {
        return this.m_dbaccess.fileIsOpen(bFILE);
    }

    public synchronized boolean isOpen(BFILE bFILE) throws SQLException {
        return this.m_dbaccess.isLobOpen(bFILE.getConnection(), bFILE, -13);
    }

    public synchronized boolean isOpen(BLOB bLOB) throws SQLException {
        return this.m_dbaccess.isLobOpen(bLOB.getConnection(), bLOB, 2004);
    }

    public synchronized boolean isOpen(CLOB cLOB) throws SQLException {
        return this.m_dbaccess.isLobOpen(cLOB.getConnection(), cLOB, 2005);
    }

    public synchronized boolean isTemporary(BLOB bLOB) throws SQLException {
        return this.m_dbaccess.isTemporaryLob(bLOB.getConnection(), bLOB, 2004);
    }

    public synchronized boolean isTemporary(CLOB cLOB) throws SQLException {
        return this.m_dbaccess.isTemporaryLob(cLOB.getConnection(), cLOB, 2005);
    }

    public synchronized long length(BFILE bFILE) throws SQLException {
        return this.m_dbaccess.lobLength(bFILE);
    }

    public synchronized long length(BLOB bLOB) throws SQLException {
        return this.m_dbaccess.lobLength(bLOB);
    }

    public synchronized long length(CLOB cLOB) throws SQLException {
        return this.m_dbaccess.lobLength(cLOB);
    }

    public InputStream newConversionInputStream(BFILE bFILE, int n2) throws SQLException {
        return new OracleConversionInputStream(bFILE.getConnection().conversion, bFILE.getBinaryStream(), n2);
    }

    public InputStream newConversionInputStream(BLOB bLOB, int n2) throws SQLException {
        return new OracleConversionInputStream(bLOB.getConnection().conversion, bLOB.getBinaryStream(), n2);
    }

    public Reader newConversionReader(BFILE bFILE, int n2) throws SQLException {
        return new OracleConversionReader(bFILE.getConnection().conversion, bFILE.getBinaryStream(), n2);
    }

    public Reader newConversionReader(BLOB bLOB, int n2) throws SQLException {
        return new OracleConversionReader(bLOB.getConnection().conversion, bLOB.getBinaryStream(), n2);
    }

    public InputStream newInputStream(BFILE bFILE, int n2, long l2) throws SQLException {
        if (l2 == 0L) {
            return new OracleBlobInputStream(bFILE, n2);
        }
        return new OracleBlobInputStream(bFILE, n2, l2);
    }

    public InputStream newInputStream(BLOB bLOB, int n2, long l2) throws SQLException {
        if (l2 == 0L) {
            return new OracleBlobInputStream(bLOB, n2);
        }
        return new OracleBlobInputStream(bLOB, n2, l2);
    }

    public InputStream newInputStream(CLOB cLOB, int n2, long l2) throws SQLException {
        if (l2 == 0L) {
            return new OracleClobInputStream(cLOB, n2);
        }
        return new OracleClobInputStream(cLOB, n2, l2);
    }

    public OutputStream newOutputStream(BLOB bLOB, int n2, long l2) throws SQLException {
        if (l2 == 0L) {
            return new OracleBlobOutputStream(bLOB, n2);
        }
        return new OracleBlobOutputStream(bLOB, n2, l2);
    }

    public OutputStream newOutputStream(CLOB cLOB, int n2, long l2) throws SQLException {
        if (l2 == 0L) {
            return new OracleClobOutputStream(cLOB, n2);
        }
        return new OracleClobOutputStream(cLOB, n2, l2);
    }

    public Reader newReader(CLOB cLOB, int n2, long l2) throws SQLException {
        if (l2 == 0L) {
            return new OracleClobReader(cLOB, n2);
        }
        return new OracleClobReader(cLOB, n2, l2);
    }

    public Writer newWriter(CLOB cLOB, int n2, long l2) throws SQLException {
        if (l2 == 0L) {
            return new OracleClobWriter(cLOB, n2);
        }
        return new OracleClobWriter(cLOB, n2, l2);
    }

    public synchronized void open(BFILE bFILE, int n2) throws SQLException {
        this.m_dbaccess.openLob(bFILE.getConnection(), bFILE, n2, -13);
    }

    public synchronized void open(BLOB bLOB, int n2) throws SQLException {
        this.m_dbaccess.openLob(bLOB.getConnection(), bLOB, n2, 2004);
    }

    public synchronized void open(CLOB cLOB, int n2) throws SQLException {
        this.m_dbaccess.openLob(cLOB.getConnection(), cLOB, n2, 2005);
    }

    public synchronized void openFile(BFILE bFILE) throws SQLException {
        this.m_dbaccess.fileOpen(bFILE);
    }

    public synchronized long position(BFILE bFILE, BFILE bFILE2, long l2) throws SQLException {
        if (l2 < 1L) {
            DBError.check_error(68, "position()");
        }
        if (bFILE2 == null) {
            return -1L;
        }
        long l3 = this.m_dbaccess.isSubLob(bFILE, bFILE2, l2);
        return l3 == 0L ? -1L : l3;
    }

    public synchronized long position(BFILE bFILE, byte[] byArray, long l2) throws SQLException {
        if (l2 < 1L) {
            DBError.check_error(68, "position()");
        }
        if (byArray == null || byArray.length == 0) {
            return -1L;
        }
        long l3 = this.m_dbaccess.hasPattern(bFILE, byArray, l2);
        return l3 == 0L ? -1L : l3;
    }

    public synchronized long position(BLOB bLOB, BLOB bLOB2, long l2) throws SQLException {
        if (l2 < 1L) {
            DBError.throwSqlException(68, "position()");
        }
        if (bLOB2 == null) {
            return -1L;
        }
        long l3 = this.m_dbaccess.isSubLob(bLOB, bLOB2, l2);
        return l3 == 0L ? -1L : l3;
    }

    public synchronized long position(BLOB bLOB, byte[] byArray, long l2) throws SQLException {
        if (l2 < 1L) {
            DBError.throwSqlException(68, "position()");
        }
        if (byArray == null || byArray.length == 0) {
            return -1L;
        }
        long l3 = this.m_dbaccess.hasPattern(bLOB, byArray, l2);
        return l3 == 0L ? -1L : l3;
    }

    public synchronized long position(CLOB cLOB, String string, long l2) throws SQLException {
        if (l2 < 1L) {
            DBError.check_error(68, "position()");
        }
        if (string == null || string.length() == 0) {
            return -1L;
        }
        long l3 = this.m_dbaccess.hasPattern(cLOB, string.toCharArray(), l2);
        return l3 == 0L ? -1L : l3;
    }

    public synchronized long position(CLOB cLOB, CLOB cLOB2, long l2) throws SQLException {
        if (l2 < 1L) {
            DBError.check_error(68, "position");
        }
        if (cLOB2 == null) {
            return -1L;
        }
        long l3 = this.m_dbaccess.isSubLob(cLOB, cLOB2, l2);
        return l3 == 0L ? -1L : l3;
    }

    public synchronized int putBytes(BLOB bLOB, long l2, byte[] byArray) throws SQLException {
        if (l2 < 1L) {
            DBError.throwSqlException(68, "putBytes()");
        }
        if (byArray == null || byArray.length == 0) {
            return 0;
        }
        return (int)this.m_dbaccess.lobWrite(bLOB, l2, byArray);
    }

    public synchronized int putChars(CLOB cLOB, long l2, char[] cArray) throws SQLException {
        if (l2 < 1L) {
            DBError.check_error(68, "putChars()");
        }
        if (cArray == null || cArray.length < 0) {
            return 0;
        }
        return (int)this.m_dbaccess.lobWrite(cLOB, l2, cArray);
    }

    public synchronized void trim(BLOB bLOB, long l2) throws SQLException {
        this.m_dbaccess.trimLob(bLOB.getConnection(), bLOB, 2004, l2);
    }

    public synchronized void trim(CLOB cLOB, long l2) throws SQLException {
        this.m_dbaccess.trimLob(cLOB.getConnection(), cLOB, 2005, l2);
    }
}

