/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ns;

import java.io.IOException;
import oracle.net.nl.RepConversion;
import oracle.net.ns.NetException;
import oracle.net.ns.SQLnetDef;
import oracle.net.ns.SessionAtts;

public class Packet
implements SQLnetDef {
    private int buffer2send;
    protected int length;
    public int type;
    protected int flags;
    protected int dataLen;
    protected int dataOff;
    protected String data;
    protected byte[] buffer;
    public SessionAtts sAtts;

    public Packet(Packet packet) {
        this(packet.sAtts);
        this.length = packet.length;
        this.type = packet.type;
        this.flags = packet.flags;
        this.dataLen = packet.dataLen;
        this.dataOff = packet.dataOff;
        this.buffer = packet.buffer;
    }

    public Packet(SessionAtts sessionAtts) {
        this.sAtts = sessionAtts;
    }

    protected void createBuffer(int n2, int n3, int n4) {
        this.buffer = new byte[n2];
        this.buffer[0] = (byte)(n2 / 256);
        this.buffer[1] = (byte)(n2 % 256);
        this.buffer[5] = (byte)n4;
        this.buffer[4] = (byte)n3;
    }

    protected void dump(byte[] byArray, int n2, int n3) {
        int n4 = 0;
        System.out.println("Packet dump");
        System.out.println("buffer.length=" + byArray.length);
        System.out.println("offset       =" + n2);
        System.out.println("len          =" + n3);
        int n5 = n2;
        while (n5 < n3) {
            System.out.print("|");
            int n6 = 0;
            while (n6 < 8 && n4 < n3 - 1) {
                n4 = n5 + n6;
                RepConversion.printInHex(byArray[n4]);
                System.out.print(" ");
                ++n6;
            }
            System.out.println("|");
            n5 += 8;
        }
        System.out.println("finish dump");
    }

    protected void extractData() throws IOException, NetException {
        if (this.dataLen < 0 || this.dataOff < 8) {
            throw new NetException(1);
        }
        if (this.dataLen <= 0) {
            this.data = new String();
        } else if (this.length > this.dataOff) {
            this.data = new String(this.buffer, 0, this.dataOff, this.dataLen);
        } else {
            byte[] byArray = new byte[this.dataLen];
            if (this.sAtts.nsInputStream.read(byArray) < 0) {
                throw new NetException(0);
            }
            this.data = new String(byArray, 0);
        }
    }

    protected String getData() {
        return this.data;
    }

    protected void receive() throws IOException, NetException {
        int n2 = 0;
        int n3 = this.sAtts.getSDU();
        byte[] byArray = new byte[8];
        while (n2 < byArray.length) {
            if ((n2 += this.sAtts.ntInputStream.read(byArray, n2, byArray.length - n2)) > 0) continue;
            throw new NetException(0);
        }
        this.length = byArray[0] & 0xFF;
        this.length <<= 8;
        this.length |= byArray[1] & 0xFF;
        this.type = byArray[4];
        this.flags = byArray[5];
        if (this.type > 19) {
            throw new NetException(204);
        }
        if (this.length > 4086 || this.length > n3) {
            throw new NetException(203);
        }
        if (this.length < 8) {
            throw new NetException(207);
        }
        this.createBuffer(this.length, this.type, this.flags);
        while (n2 < this.buffer.length) {
            if ((n2 += this.sAtts.ntInputStream.read(this.buffer, n2, this.buffer.length - n2)) > 0) continue;
            throw new NetException(0);
        }
    }

    protected void send() throws IOException {
        this.sAtts.ntOutputStream.write(this.buffer, 0, this.buffer.length);
    }
}

