/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nl;

import java.io.PrintStream;
import java.util.Vector;

public final class NVPair {
    public static int RHS_NONE = 0;
    public static int RHS_ATOM = 1;
    public static int RHS_LIST = 2;
    public static int LIST_REGULAR = 3;
    public static int LIST_COMMASEP = 4;
    private String _name;
    private int _rhsType;
    private String _atom;
    private Vector _list;
    private int _listType;
    private NVPair _parent;
    private String _linesep = System.getProperty("line.separator");

    public NVPair(String string) {
        this._name = string;
        this._atom = null;
        this._list = null;
        this._listType = LIST_REGULAR;
        this._parent = null;
        this._rhsType = RHS_NONE;
    }

    public NVPair(String string, String string2) {
        this(string);
        this.setAtom(string2);
    }

    public NVPair(String string, NVPair nVPair) {
        this(string);
        this.addListElement(nVPair);
    }

    private void _setParent(NVPair nVPair) {
        this._parent = nVPair;
    }

    public void addListElement(NVPair nVPair) {
        if (this._list == null) {
            this._rhsType = RHS_LIST;
            this._list = new Vector(3, 5);
            this._atom = null;
        }
        this._list.addElement(nVPair);
        nVPair._setParent(this);
    }

    public String getAtom() {
        return this._atom;
    }

    public NVPair getListElement(int n2) {
        if (this._list == null) {
            return null;
        }
        return (NVPair)this._list.elementAt(n2);
    }

    public int getListSize() {
        if (this._list == null) {
            return 0;
        }
        return this._list.size();
    }

    public int getListType() {
        return this._listType;
    }

    public String getName() {
        return this._name;
    }

    public NVPair getParent() {
        return this._parent;
    }

    public int getRHSType() {
        return this._rhsType;
    }

    public String modifyCommentString(String string) {
        String string2 = "";
        int n2 = 0;
        while (n2 < string.length()) {
            char c2 = string.charAt(n2);
            switch (c2) {
                case '\\': {
                    if (string.charAt(n2 + 1) != '(' && string.charAt(n2 + 1) != '=' && string.charAt(n2 + 1) != ')' && string.charAt(n2 + 1) != ',' && string.charAt(n2 + 1) != '\\') break;
                }
            }
            int n3 = ++n2;
            ++n2;
            string2 = String.valueOf(string2) + string.charAt(n3);
        }
        return string2;
    }

    public void println() {
        System.out.println(this.toString());
    }

    public void println(PrintStream printStream) {
        if (this._rhsType == RHS_ATOM) {
            printStream.println("          (" + this._name + " = " + this._atom + ")");
        } else if (this._rhsType == RHS_LIST) {
            int n2 = 0;
            while (n2 < this.getListSize()) {
                this.getListElement(n2).println(printStream);
                ++n2;
            }
        }
    }

    public void removeListElement(int n2) {
        if (this._list != null) {
            this._list.removeElementAt(n2);
            if (this.getListSize() == 0) {
                this._list = null;
                this._rhsType = RHS_NONE;
            }
        }
    }

    public void setAtom(String string) {
        this._rhsType = RHS_ATOM;
        this._atom = string;
        this._list = null;
    }

    public void setListType(int n2) {
        this._listType = n2;
    }

    public void setName(String string) {
        this._name = string;
    }

    private String space(int n2) {
        String string = new String("");
        int n3 = 0;
        while (n3 < n2) {
            string = String.valueOf(string) + " ";
            ++n3;
        }
        return string;
    }

    public String toString() {
        String string = "(" + this._name + "=";
        if (this._rhsType == RHS_ATOM) {
            string = String.valueOf(string) + this._atom;
        } else if (this._rhsType == RHS_LIST) {
            if (this._listType == LIST_REGULAR) {
                int n2 = 0;
                while (n2 < this.getListSize()) {
                    string = String.valueOf(string) + this.getListElement(n2).toString();
                    ++n2;
                }
            } else if (this._listType == LIST_COMMASEP) {
                string = String.valueOf(string) + " (";
                int n3 = 0;
                while (n3 < this.getListSize()) {
                    NVPair nVPair = this.getListElement(n3);
                    string = String.valueOf(string) + nVPair.getName();
                    if (n3 != this.getListSize() - 1) {
                        string = String.valueOf(string) + ", ";
                    }
                    ++n3;
                }
                string = String.valueOf(string) + ")";
            }
        }
        string = String.valueOf(string) + ")";
        return string;
    }

    public String toString(int n2, boolean bl) {
        String string = "";
        String string2 = new String(this._name);
        if (this._rhsType == RHS_LIST) {
            if (this._listType == LIST_REGULAR) {
                string = string2.equalsIgnoreCase("ADDRESS") || string2.equalsIgnoreCase("RULE") ? String.valueOf(string) + this.space(n2 * 2) + "(" + this._name + " = " : String.valueOf(string) + this.space(n2 * 2) + "(" + this._name + " =" + this._linesep;
                int n3 = 0;
                while (n3 < this.getListSize()) {
                    string = string2.equalsIgnoreCase("ADDRESS") || string2.equalsIgnoreCase("RULE") ? String.valueOf(string) + this.getListElement(n3).toString(n2 + 1, false) : String.valueOf(string) + this.getListElement(n3).toString(n2 + 1, true);
                    ++n3;
                }
                string = string2.equalsIgnoreCase("ADDRESS") || string2.equalsIgnoreCase("RULE") ? String.valueOf(string) + ")" + this._linesep : (n2 == 0 ? String.valueOf(string) + ")" : (n2 == 1 ? String.valueOf(string) + this.space(n2 * 2) + ")" : String.valueOf(string) + this.space(n2 * 2) + ")" + this._linesep));
            } else if (this._listType == LIST_COMMASEP) {
                string = String.valueOf(string) + "(" + this._name + "=" + " (";
                int n4 = 0;
                while (n4 < this.getListSize()) {
                    NVPair nVPair = this.getListElement(n4);
                    string = String.valueOf(string) + nVPair.getName();
                    if (n4 != this.getListSize() - 1) {
                        string = String.valueOf(string) + ", ";
                    }
                    ++n4;
                }
                string = String.valueOf(string) + ")" + ")";
            }
        } else if (this._rhsType == RHS_ATOM) {
            if (n2 == 0) {
                if (string2.indexOf("COMMENT") != -1) {
                    this._atom = this.modifyCommentString(this._atom);
                    string = String.valueOf(string) + "(" + this._atom + ")";
                } else {
                    string = String.valueOf(string) + "(" + this._name + " = " + this._atom + ")";
                }
            } else if (string2.indexOf("COMMENT") != -1) {
                this._atom = this.modifyCommentString(this._atom);
                string = String.valueOf(string) + this._atom + this._linesep;
            } else if (!bl) {
                string = String.valueOf(string) + "(" + this._name + " = " + this._atom + ")";
            } else {
                string = String.valueOf(string) + this.space(n2 * 2) + "(" + this._name + " = " + this._atom + ")";
                string = String.valueOf(string) + this._linesep;
            }
        }
        return string;
    }

    public String trimValueToString() {
        String string = this.valueToString().trim();
        return string.substring(1, string.length() - 1);
    }

    public String valueToString() {
        String string;
        block4: {
            block5: {
                block3: {
                    string = "";
                    if (this._rhsType != RHS_ATOM) break block3;
                    string = String.valueOf(string) + this._atom;
                    break block4;
                }
                if (this._rhsType != RHS_LIST) break block4;
                if (this._listType != LIST_REGULAR) break block5;
                int n2 = 0;
                while (n2 < this.getListSize()) {
                    string = String.valueOf(string) + this.getListElement(n2).toString();
                    ++n2;
                }
                break block4;
            }
            if (this._listType != LIST_COMMASEP) break block4;
            int n3 = 0;
            while (n3 < this.getListSize()) {
                NVPair nVPair = this.getListElement(n3);
                string = String.valueOf(string) + nVPair.getName();
                if (n3 != this.getListSize() - 1) {
                    string = String.valueOf(string) + ", ";
                }
                ++n3;
            }
        }
        return string;
    }
}

