/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.xa.client;

import java.io.IOException;
import java.sql.Connection;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import oracle.jdbc.oracore.Util;
import oracle.jdbc.xa.client.OracleXAResource;

public class OracleXAHeteroResource
extends OracleXAResource {
    private int m_rmid = -1;

    public OracleXAHeteroResource(Connection connection) throws XAException {
        this.m_conn = connection;
        if (this.m_conn == null) {
            throw new XAException(-7);
        }
    }

    private void checkStatus(int n2) throws XAException {
        if (n2 != 0) {
            throw new XAException(n2);
        }
    }

    public void commit(Xid xid, boolean bl) throws XAException {
        this.trace("OracleXAHeteroResource.commit(xid, bool):start");
        if (xid == null) {
            this.trace("OracleXAHeteroResource.commit(): XAER_INVAL : xid is null");
            throw new XAException(-5);
        }
        int n2 = bl ? 0x40000000 : 0;
        int n3 = xid.getFormatId();
        byte[] byArray = xid.getGlobalTransactionId();
        byte[] byArray2 = xid.getBranchQualifier();
        int n4 = this.do_xa_commit(n3, byArray, byArray2, this.m_rmid, n2, 0);
        this.setSQLXAErrorFlag(true);
        this.trace("Return status of xa_commit is " + n4);
        this.checkStatus(n4);
        this.trace("OracleXAHeteroResource.commit(xid, bool):end");
    }

    private native int do_xa_commit(int var1, byte[] var2, byte[] var3, int var4, int var5, int var6);

    private native int do_xa_end(int var1, byte[] var2, byte[] var3, int var4, int var5, int var6);

    private native int do_xa_forget(int var1, byte[] var2, byte[] var3, int var4, int var5, int var6);

    private native int do_xa_prepare(int var1, byte[] var2, byte[] var3, int var4, int var5, int var6);

    private native int do_xa_rollback(int var1, byte[] var2, byte[] var3, int var4, int var5, int var6);

    private native int do_xa_start(int var1, byte[] var2, byte[] var3, int var4, int var5, int var6);

    public void end(Xid xid, int n2) throws XAException {
        this.trace("OracleXAHeteroResource.end(xid, int):start");
        if (xid == null) {
            this.trace("OracleXAHeteroResource.end(xid, int): XAER_INVAL : xid is null");
            throw new XAException(-5);
        }
        if (n2 != 0x2000000 && n2 != 0x4000000 && n2 != 0x20000000 && (n2 & 2) != 2) {
            this.trace("OracleXAHeteroResource.end(xid, int): XAER_INVAL; invalid flag");
            throw new XAException(-5);
        }
        int n3 = xid.getFormatId();
        byte[] byArray = xid.getGlobalTransactionId();
        byte[] byArray2 = xid.getBranchQualifier();
        int n4 = this.do_xa_end(n3, byArray, byArray2, this.m_rmid, n2, 0);
        this.trace("Return status of xa_end is " + n4);
        this.setSQLXAErrorFlag(true);
        this.checkStatus(n4);
        this.trace("OracleXAHeteroResource.end(xid, int):end");
    }

    public void forget(Xid xid) throws XAException {
        this.trace("OracleXAHeteroResource.forget():start");
        if (xid == null) {
            this.trace("OracleXAHeteroResource.forget(): XAER_INVAL : xid is null");
            throw new XAException(-5);
        }
        int n2 = xid.getFormatId();
        byte[] byArray = xid.getGlobalTransactionId();
        byte[] byArray2 = xid.getBranchQualifier();
        int n3 = this.do_xa_forget(n2, byArray, byArray2, this.m_rmid, 0, 0);
        this.trace("Return status of xa_forget is " + n3);
        this.setSQLXAErrorFlag(true);
        this.checkStatus(n3);
        this.trace("OracleXAHeteroResource.forget():end");
    }

    synchronized int getRmid() {
        return this.m_rmid;
    }

    private static byte[] getSerializedBytes(Xid xid) {
        try {
            return Util.serializeObject(xid);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    public int prepare(Xid xid) throws XAException {
        this.trace("OracleXAHeteroResource.prepare():start");
        if (xid == null) {
            this.trace("OracleXAHeteroResource.prepare(): XAER_INVAL : xid is null");
            throw new XAException(-5);
        }
        int n2 = xid.getFormatId();
        byte[] byArray = xid.getGlobalTransactionId();
        byte[] byArray2 = xid.getBranchQualifier();
        int n3 = this.do_xa_prepare(n2, byArray, byArray2, this.m_rmid, 0, 0);
        this.trace("Return status of xa_prepare is " + n3);
        this.setSQLXAErrorFlag(true);
        if (n3 != 0 && n3 != 3) {
            this.checkStatus(n3);
        }
        this.trace("OracleXAHeteroResource.prepare(): return value is " + n3);
        this.trace("OracleXAHeteroResource.prepare():end");
        return n3;
    }

    public void rollback(Xid xid) throws XAException {
        this.trace("OracleXAHeteroResource.rollback():start");
        if (xid == null) {
            this.trace("OracleXAHeteroResource.rollback(): XAER_INVAL : xid is null");
            throw new XAException(-5);
        }
        int n2 = xid.getFormatId();
        byte[] byArray = xid.getGlobalTransactionId();
        byte[] byArray2 = xid.getBranchQualifier();
        int n3 = this.do_xa_rollback(n2, byArray, byArray2, this.m_rmid, 0, 0);
        this.trace("Return status of xa_rollback is " + n3);
        this.setSQLXAErrorFlag(true);
        this.checkStatus(n3);
        this.trace("OracleXAHeteroResource.rollback():end");
    }

    synchronized void setRmid(int n2) {
        this.m_rmid = n2;
    }

    public void start(Xid xid, int n2) throws XAException {
        this.trace("OracleXAHeteroResource.start():start");
        if (xid == null) {
            this.trace("OracleXAHeteroResource.start(): XAER_INVAL : xid is null");
            throw new XAException(-5);
        }
        if (n2 != 0 && n2 != 0x8000000 && n2 != 0x200000 && (n2 & 2) != 2) {
            this.trace("OracleXAHeteroResource.start(): XAER_INVAL; invalid flag");
            throw new XAException(-5);
        }
        int n3 = xid.getFormatId();
        byte[] byArray = xid.getGlobalTransactionId();
        byte[] byArray2 = xid.getBranchQualifier();
        int n4 = this.do_xa_start(n3, byArray, byArray2, this.m_rmid, n2, 0);
        this.trace("Return status of xa_start is " + n4);
        this.setSQLXAErrorFlag(false);
        this.checkStatus(n4);
        this.trace("OracleXAHeteroResource.start():end");
    }
}

