/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.ttc7;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.dbaccess.DBItem;
import oracle.jdbc.dbaccess.DBType;
import oracle.jdbc.ttc7.MAREngine;

public class TTCItem
extends DBItem {
    public final boolean DEBUG_TTCItem = false;
    public MAREngine meg;
    private int type;

    protected TTCItem(MAREngine mAREngine, DBType dBType) {
        super(dBType.max_length);
        this.type = dBType.type;
        this.meg = mAREngine;
    }

    public byte[] StringToBytes(String string, int n2) throws SQLException {
        if (n2 == 2) {
            return this.meg.conv.StringToNCharBytes(string);
        }
        return this.meg.conv.StringToCharBytes(string);
    }

    public char[] getChars(short s2) throws SQLException {
        this.char_value = new char[this.data_size];
        this.char_size = s2 == 2 ? this.meg.conv.NCHARBytesToJavaChars(this.byte_value, this.data_size, this.char_value) : this.meg.conv.CHARBytesToJavaChars(this.byte_value, this.data_size, this.char_value);
        return this.char_value;
    }

    protected int getDataSize() {
        return this.data_size;
    }

    protected boolean isNull() {
        return this.is_null;
    }

    protected void marshal() throws IOException, SQLException {
        if (!(this.type != 113 && this.type != 112 && this.type != 114 || this.meg.proSvrVer < 6 || this.is_null)) {
            this.meg.marshalUB2(this.data_size);
        }
        this.meg.marshalCLR(this.byte_value, this.data_size);
    }

    protected void marshalPLSQL() throws IOException {
        this.meg.marshalCLR(new byte[0], 0);
    }

    public void print() {
        System.out.println("           ---- Enter: TTCItem.print --- ");
        System.out.println("             +++ TTCItem.DBItem  Information +++");
        System.out.print("             DBItem.byte_value is: ");
        System.out.print(this.byte_value == null ? " NULL " : "Not NULL");
        System.out.println();
        if (this.byte_value != null) {
            System.out.println("             DBItem.byte_value.length = " + this.byte_value.length);
        }
        System.out.print("             DBItem.stream_value is: ");
        System.out.print(this.stream_value == null ? " NULL " : "Not NULL");
        System.out.println();
        System.out.println("             DBItem.data_size = " + this.data_size);
        System.out.println("             DBItem.original_size = " + this.original_size);
        System.out.println("             DBItem.max_out_size = " + this.max_out_size);
        System.out.println("             +++ End of TTCItem.DBItem  Info.+++");
        System.out.println("           ---- Exit: TTCItem.print --- ");
    }

    public void setArrayData(boolean bl, String string, int n2) throws SQLException {
        this.is_null = bl;
        if (string != null) {
            this.byte_value = this.StringToBytes(string, n2);
            this.data_size = this.byte_value.length;
            if ((this.type == 96 || this.type == 1) && this.data_size > this.max_out_size) {
                DBError.throwSqlException(70, new Integer(this.data_size));
            }
        } else {
            this.byte_value = new byte[0];
            this.data_size = 0;
        }
    }

    public void setArrayData(boolean bl, byte[] byArray) throws SQLException {
        this.is_null = bl;
        if (byArray != null) {
            if (byArray.length > DBType.max_bind_array_length && ((this.type == 96 || this.type == 1) && byArray.length > this.max_out_size || this.type == 23 && byArray.length > this.max_out_size)) {
                DBError.throwSqlException(70, new Integer(byArray.length));
            }
            this.data_size = byArray.length;
            this.byte_value = byArray;
        } else {
            this.byte_value = new byte[0];
            this.data_size = 0;
        }
    }

    protected void setOriginalSize(int n2) {
        this.original_size = n2;
    }

    protected void unmarshal() throws IOException, SQLException {
        boolean bl = false;
        boolean bl2 = false;
        int n2 = 0;
        if (this.byte_value == null) {
            DBError.check_error(401);
        }
        if ((this.type == 113 || this.type == 112 || this.type == 114) && this.meg.proSvrVer >= 6 && (n2 = this.meg.unmarshalUB2()) == 0) {
            this.is_null = true;
            return;
        }
        this.original_size = 0;
        this.data_size = 0;
        this.is_null = false;
        if (this.max_out_size == 0) {
            this.is_null = true;
            return;
        }
        int[] nArray = new int[1];
        Object var5_5 = null;
        this.meg.unmarshalCLR(this, nArray);
        this.data_size = nArray[0];
        this.is_null = nArray[0] <= 0;
    }

    public void unmarshalIndicator() throws IOException, SQLException {
        this.original_size = this.meg.processIndicator(this.is_null, this.data_size);
    }
}

