/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.ttc7;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.ttc7.TTCColumn;

public abstract class TTCDataSet {
    protected final boolean DEBUG = false;
    protected TTCColumn[] columns;
    protected int depth;
    protected int marshaledRows;
    protected int unmarshaledRows;
    protected int unmarshaledCols;

    protected TTCDataSet(TTCColumn[] tTCColumnArray, int n2) {
        this.columns = tTCColumnArray != null ? tTCColumnArray : new TTCColumn[]{};
        this.depth = n2;
    }

    public void incrementUnmarshaledcols() {
        ++this.unmarshaledCols;
    }

    public void incrementeUnmarshaledRows() {
        ++this.unmarshaledRows;
    }

    public boolean isLastCol() {
        return this.unmarshaledCols == this.columns.length - 1;
    }

    protected abstract void marshalRow() throws SQLException, IOException;

    protected void marshalTypes() throws IOException, SQLException {
        int n2 = 0;
        while (n2 < this.columns.length) {
            this.columns[n2].marshalType();
            ++n2;
        }
    }

    protected abstract boolean next() throws SQLException, IOException;

    protected int numberOfColumns() {
        return this.columns.length;
    }

    protected void print() {
        System.out.println("   ---- Enter: TTCDataSet.print --- ");
        System.out.println("     +++ Beginning of Columns Info +++++++ ");
        System.out.println("         columns.length = " + this.columns.length);
        int n2 = 0;
        while (n2 < this.columns.length) {
            System.out.println("Column # " + n2);
            this.columns[n2].print();
            ++n2;
        }
        System.out.println("     +++ End of Columns Info +++++++ ");
        System.out.println("     TTCDataSet.depth          =" + this.depth);
        System.out.println("     TTCDataSet.marshaledRows  =" + this.marshaledRows);
        System.out.println("     TTCDataSet.unmarshaledRows=" + this.unmarshaledRows);
        System.out.println("   ---- Exit: TTCDataSet.print --- ");
    }

    protected void processIndicator() throws IOException, SQLException {
    }

    protected abstract boolean unmarshalRow() throws SQLException, IOException;

    protected boolean unmarshalRow(int n2, int n3) throws SQLException, IOException {
        return false;
    }
}

