/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.ttc7;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.ttc7.PlsqlTTCColumn;
import oracle.jdbc.ttc7.TTCDataSet;

public class PlsqlTTCDataSet
extends TTCDataSet {
    private PlsqlTTCColumn[] columns;
    private byte[] userIOVector;
    private byte[] realIOVector;

    protected PlsqlTTCDataSet(PlsqlTTCColumn[] plsqlTTCColumnArray, byte[] byArray) {
        super(plsqlTTCColumnArray, plsqlTTCColumnArray.length == 0 ? 0 : 1);
        this.columns = plsqlTTCColumnArray != null ? plsqlTTCColumnArray : new PlsqlTTCColumn[]{};
        this.userIOVector = byArray;
    }

    protected void marshalRow() throws SQLException, IOException {
        if (this.realIOVector == null) {
            DBError.check_error(423);
        }
        int n2 = 0;
        while (n2 < this.realIOVector.length) {
            if ((this.realIOVector[n2] & 0x20) != 0) {
                this.columns[n2].marshal();
            }
            ++n2;
        }
        this.marshaledRows = 1;
    }

    protected boolean next() {
        return this.realIOVector != null;
    }

    protected void print() {
        int n2;
        System.out.println(" \n   ---- Enter: PlsqlTTCDataSet.print --- ");
        super.print();
        System.out.println("\n      +++ userIOVector info +++++++ ");
        if (this.userIOVector == null) {
            System.out.println(" User IOVector is NULL ");
        } else {
            System.out.println("      userIOVector.length = " + this.userIOVector.length);
            n2 = 0;
            while (n2 < this.userIOVector.length) {
                System.out.println("      userIOVector[" + n2 + "] = " + this.userIOVector[n2]);
                ++n2;
            }
        }
        System.out.println("      +++ End of userIOVector Info +++++++");
        System.out.println("\n      +++ realIOVector info +++++++");
        if (this.realIOVector == null) {
            System.out.println(" Real IOVector is NULL ");
        } else {
            System.out.println("      realIOVector.length = " + this.realIOVector.length);
            n2 = 0;
            while (n2 < this.realIOVector.length) {
                System.out.println("       realIOVector[" + n2 + "] = " + this.realIOVector[n2]);
                ++n2;
            }
        }
        System.out.println("      +++ End of realIOVector Info +++++++ ");
        System.out.println("    ---- Exit: PlsqlTTCDataSet.print --- \n");
    }

    protected void setIOVector(byte[] byArray) {
        this.realIOVector = byArray;
    }

    protected boolean unmarshalRow() throws SQLException, IOException {
        if (this.realIOVector == null) {
            DBError.check_error(423);
        }
        int n2 = 0;
        while (n2 < this.realIOVector.length) {
            if ((this.realIOVector[n2] & 0x10) != 0) {
                this.columns[n2].unmarshal();
            }
            ++n2;
        }
        this.unmarshaledRows = 1;
        return false;
    }
}

