/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.ttc7;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBColumn;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.ttc7.MAREngine;
import oracle.jdbc.ttc7.TTCStatement;
import oracle.jdbc.ttc7.TTIfun;
import oracle.jdbc.ttc7.TTIoer;
import oracle.jdbc.ttc7.TTIuds;

public class Odscrarr
extends TTIfun {
    protected int cursor_id = 0;
    private int startpos = 1;
    public static final int HSTITEMS = 32;
    public static final int M_IDEN = 30;
    public static final int NBL = 960;
    public int totalColumns = 0;
    public int numuds = 0;
    private TTIuds[] uds;
    protected String[] colnames;
    private int totalretlen;
    public int colOffset;
    private boolean numitemsO2U = true;
    protected boolean udsarrayO2U = true;
    protected boolean numudsO2U = true;
    private boolean colnameO2U = true;
    private boolean lencolsO2U = true;

    public Odscrarr(MAREngine mAREngine) throws IOException, SQLException {
        super((byte)3, 0, (byte)43);
        this.setMarshalingEngine(mAREngine);
        this.oer = new TTIoer(mAREngine);
    }

    private void decodeAllColumnNames(byte[] byArray) throws SQLException {
        int n2 = 0;
        short s2 = 0;
        this.colnames = new String[this.numuds];
        int n3 = 0;
        while (n3 < this.numuds) {
            s2 = this.uds[n3].udscnl;
            n2 = this.decodeColName(byArray, n2, this.colnames, n3, s2);
            ++n3;
        }
    }

    private int decodeColName(byte[] byArray, int n2, String[] stringArray, int n3, short s2) throws SQLException {
        int n4 = 0;
        char c2 = '\u0000';
        char[] cArray = new char[s2];
        while ((c2 = this.meg.conv.CHARBytesToJavaChar(byArray, n2)) != '\"') {
            if (c2 == '\'') {
                ++n2;
            }
            n2 = this.meg.conv.CHARBytesToJavaChar(byArray, n2, cArray, n4++);
        }
        stringArray[n3] = new String(cArray, 0, n4);
        return ++n2;
    }

    public void fillupDBcols(DBColumn[] dBColumnArray) throws SQLException {
        int n2 = 0;
        while (n2 < this.numuds) {
            dBColumnArray[this.colOffset + n2] = new DBColumn(this.colnames[n2], this.uds[n2].udsnull, this.uds[n2].udsoac.oacdty, this.uds[n2].udsoac.oacflg, this.uds[n2].udsoac.oacpre, this.uds[n2].udsoac.oacscl, this.uds[n2].udsoac.oacmxl, this.uds[n2].udsoac.oacmal, this.uds[n2].udsoac.oacfl2);
            ++n2;
        }
    }

    public void init(TTCStatement tTCStatement, int n2) throws IOException, SQLException {
        this.startpos = 1;
        this.totalColumns = 0;
        this.numuds = 0;
        this.uds = null;
        this.colnames = null;
        this.totalretlen = 0;
        this.numitemsO2U = true;
        this.udsarrayO2U = true;
        this.numudsO2U = true;
        this.colnameO2U = true;
        this.lencolsO2U = true;
        this.oer.init();
        this.cursor_id = tTCStatement.getCursor();
        this.colOffset = n2;
    }

    public void marshal() throws IOException {
        this.marshalFunHeader();
        this.meg.marshalSWORD(this.cursor_id);
        this.meg.marshalSWORD(this.colOffset + this.startpos);
        this.meg.marshalO2U(this.numitemsO2U);
        this.meg.marshalO2U(this.udsarrayO2U);
        this.meg.marshalSWORD(32);
        this.meg.marshalO2U(this.numudsO2U);
        this.meg.marshalO2U(this.colnameO2U);
        this.meg.marshalSWORD(960);
        this.meg.marshalO2U(this.lencolsO2U);
    }

    public DBColumn[] receive(DBColumn[] dBColumnArray) throws SQLException, IOException {
        boolean bl = false;
        while (!bl) {
            byte by = this.meg.unmarshalSB1();
            switch (by) {
                case 8: {
                    byte[] byArray;
                    this.totalColumns = this.meg.unmarshalUB2();
                    this.numuds = this.meg.unmarshalUB2();
                    this.uds = new TTIuds[this.totalColumns];
                    if (dBColumnArray == null) {
                        dBColumnArray = new DBColumn[this.totalColumns];
                    }
                    int n2 = 0;
                    while (n2 < this.numuds) {
                        this.uds[n2] = new TTIuds(this.meg);
                        this.uds[n2].unmarshal();
                        ++n2;
                    }
                    this.totalretlen = this.meg.unmarshalUB2();
                    if (this.totalretlen > 960) {
                        DBError.check_error(414);
                    }
                    if (this.totalretlen == 0 && (this.numuds > 0 || this.totalColumns > 0)) {
                        DBError.check_error(419);
                    }
                    if ((byArray = this.meg.unmarshalCHR(this.totalretlen)) == null || byArray.length == 0 || this.totalretlen == 0) {
                        DBError.check_error(438);
                    }
                    this.decodeAllColumnNames(byArray);
                    this.fillupDBcols(dBColumnArray);
                    break;
                }
                case 4: {
                    this.oer.init();
                    this.oer.unmarshal();
                    this.oer.processError();
                    bl = true;
                }
                case 9: {
                    bl = true;
                    break;
                }
            }
        }
        return dBColumnArray;
    }
}

