/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.ttc7;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.ttc7.LongTTCItem;
import oracle.jdbc.ttc7.TTCColumn;
import oracle.jdbc.ttc7.TTCItem;
import oracle.jdbc.ttc7.TTIoac;

public class NonPlsqlTTCColumn
extends TTCColumn {
    private int row;
    private TTCItem[] items;
    private boolean marshaling;

    protected NonPlsqlTTCColumn(TTIoac tTIoac, int n2, boolean bl, TTCItem[] tTCItemArray) {
        super(tTIoac, n2);
        this.items = tTCItemArray;
        this.marshaling = bl;
    }

    public void clearNull() throws SQLException {
        if (this.type.isStream()) {
            this.items[this.row].is_null = false;
        }
    }

    protected void marshal() throws IOException, SQLException {
        this.items[this.row].marshal();
        ++this.row;
    }

    protected boolean moreRows() {
        return this.row < this.rowsDepth;
    }

    protected void print() {
        System.out.println();
        System.out.println("         ---- Enter: NonPlsqlTTCColumn.print ---");
        super.print();
        if (this.row > 0) {
            this.items[this.row - 1].print();
        } else {
            System.out.println("           >>>> No Rows in this column <<<<");
        }
        System.out.println("           NonPlsqlTTCColumn.row        = " + this.row);
        System.out.println("           NonPlsqlTTCColumn.marshaling = " + this.marshaling);
        System.out.println("         ---- Exit: NonPlsqlTTCColumn.print --\n");
    }

    protected void pushStream() throws IOException {
        ((LongTTCItem)this.items[this.row]).putStream();
        ++this.row;
    }

    protected void setItemOriginalSize(int n2) throws SQLException, IOException {
        int n3 = this.items[n2].meg.processIndicator(this.items[n2].isNull(), this.items[n2].getDataSize());
        this.items[n2].setOriginalSize(n3);
    }

    protected boolean sizeExceeded() throws SQLException, IOException {
        int n2 = 4000;
        short s2 = this.items[this.row].meg.types.getVersion();
        n2 = s2 < 8030 ? 2000 : 4000;
        boolean bl = false;
        if (this.type.type != 999 && this.type.type != 96 && this.type.type != 1 && this.type.type != 8 && this.type.type != 24) {
            return false;
        }
        if (this.type.max_length > n2) {
            bl = true;
        }
        return bl;
    }

    protected boolean unmarshal() throws SQLException, IOException {
        if (this.marshaling) {
            DBError.check_error(424);
        }
        if (this.type.isStream()) {
            return true;
        }
        this.items[this.row].unmarshal();
        this.items[this.row++].unmarshalIndicator();
        return false;
    }
}

