/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.ttc7;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.Vector;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.ttc7.TTCConversion;
import oracle.jdbc.ttc7.TTCItem;
import oracle.jdbc.ttc7.TTCTypeRep;
import oracle.net.ns.BreakNetException;
import oracle.net.ns.Communication;
import oracle.net.ns.NetException;

public class MAREngine {
    private static final boolean DEBUG = false;
    private static final boolean DEBUG1 = false;
    private static final boolean DEBUG2 = false;
    public static final int TTCC_MXL = 252;
    public static final int TTCC_ESC = 253;
    public static final int TTCC_LNG = 254;
    public static final int TTCC_ERR = 255;
    public static final int TTCC_MXIN = 64;
    public static final byte TTCLXMULTI = 1;
    public static final byte TTCLXMCONV = 2;
    public TTCTypeRep types;
    public Communication net;
    public TTCConversion conv;
    public byte proSvrVer;
    protected InputStream inBuffer;
    protected OutputStream outBuffer;
    byte[] resBuffer = null;
    byte[] newBuffer = null;
    byte[] finalBuffer = null;
    byte[] blackHoleBuf = new byte[255];
    byte[] tmpBuf = null;
    int[] retLen = new int[1];

    public MAREngine(Communication communication) throws SQLException, IOException {
        if (communication == null) {
            DBError.check_error(433);
        }
        this.net = communication;
        try {
            this.inBuffer = communication.getInputStream();
            this.outBuffer = communication.getOutputStream();
        }
        catch (NetException netException) {
            throw new IOException(netException.getMessage());
        }
        this.types = new TTCTypeRep();
        this.types.setRep((byte)1, (byte)2);
    }

    protected void addPtr(byte by) throws IOException {
        if ((this.types.rep[3] & 1) > 0) {
            this.outBuffer.write(by);
        } else {
            byte[] byArray = new byte[4];
            byte by2 = this.value2Buffer(by, byArray, (byte)3);
            this.outBuffer.write(byArray, 0, by2);
        }
    }

    private long buffer2Value(byte[] byArray, byte by) throws SQLException, IOException {
        int n2 = 0;
        long l2 = 0L;
        boolean bl = false;
        if ((this.types.rep[by] & 1) > 0) {
            try {
                while (true) {
                    try {
                        n2 = this.inBuffer.read();
                    }
                    catch (BreakNetException breakNetException) {
                        this.net.sendReset();
                        continue;
                    }
                    break;
                }
            }
            catch (NetException netException) {
                throw new IOException(netException.getMessage());
            }
            if ((n2 & 0x80) > 0) {
                n2 &= 0x7F;
                bl = true;
            }
            if (n2 < 0) {
                DBError.check_error(410);
            }
            if (n2 == 0) {
                return 0L;
            }
            if (by == 1 && n2 > 2 || by == 2 && n2 > 4) {
                DBError.check_error(412);
            }
        } else if (by == 1) {
            n2 = 2;
        } else if (by == 2) {
            n2 = 4;
        }
        byArray = new byte[n2];
        try {
            while (true) {
                try {
                    if (this.inBuffer.read(byArray) < 0) {
                        DBError.check_error(410);
                    }
                }
                catch (BreakNetException breakNetException) {
                    this.net.sendReset();
                    continue;
                }
                break;
            }
        }
        catch (NetException netException) {
            throw new IOException(netException.getMessage());
        }
        int n3 = 0;
        while (n3 < byArray.length) {
            short s2 = (this.types.rep[by] & 2) > 0 ? (short)(byArray[byArray.length - 1 - n3] & 0xFF) : (short)(byArray[n3] & 0xFF);
            l2 |= (long)(s2 << 8 * (byArray.length - 1 - n3));
            ++n3;
        }
        l2 &= 0xFFFFFFFFFFFFFFFFL;
        if (bl) {
            l2 *= -1L;
        }
        return l2;
    }

    private long buffer2Value(byte[] byArray, byte by, ByteArrayInputStream byteArrayInputStream) throws SQLException, IOException {
        int n2 = 0;
        long l2 = 0L;
        boolean bl = false;
        if ((this.types.rep[by] & 1) > 0) {
            n2 = byteArrayInputStream.read();
            if ((n2 & 0x80) > 0) {
                n2 &= 0x7F;
                bl = true;
            }
            if (n2 < 0) {
                DBError.check_error(410);
            }
            if (n2 == 0) {
                return 0L;
            }
            if (by == 1 && n2 > 2 || by == 2 && n2 > 4) {
                DBError.check_error(412);
            }
        } else if (by == 1) {
            n2 = 2;
        } else if (by == 2) {
            n2 = 4;
        }
        if (byteArrayInputStream.read(byArray = new byte[n2]) < 0) {
            DBError.check_error(410);
        }
        int n3 = 0;
        while (n3 < byArray.length) {
            short s2 = (this.types.rep[by] & 2) > 0 ? (short)(byArray[byArray.length - 1 - n3] & 0xFF) : (short)(byArray[n3] & 0xFF);
            l2 |= (long)(s2 << 8 * (byArray.length - 1 - n3));
            ++n3;
        }
        l2 &= 0xFFFFFFFFFFFFFFFFL;
        if (bl) {
            l2 *= -1L;
        }
        return l2;
    }

    public boolean escapeSequenceNull(int n2) throws SQLException {
        boolean bl = false;
        switch (n2) {
            case 0: {
                bl = true;
                break;
            }
            case 253: {
                DBError.check_error(401);
            }
            case 255: {
                bl = true;
                break;
            }
        }
        return bl;
    }

    public byte[] getNBytes(int n2) throws SQLException, IOException {
        byte[] byArray = new byte[n2];
        try {
            while (true) {
                try {
                    if (this.inBuffer.read(byArray) < 0) {
                        DBError.check_error(410);
                    }
                }
                catch (BreakNetException breakNetException) {
                    this.net.sendReset();
                    continue;
                }
                break;
            }
        }
        catch (NetException netException) {
            throw new IOException(netException.getMessage());
        }
        return byArray;
    }

    public int getNBytes(byte[] byArray, int n2, int n3) throws SQLException, IOException {
        int n4 = 0;
        try {
            while (true) {
                try {
                    n4 = this.inBuffer.read(byArray, n2, n3);
                    if (n4 < 0) {
                        DBError.check_error(410);
                    }
                }
                catch (BreakNetException breakNetException) {
                    this.net.sendReset();
                    continue;
                }
                break;
            }
        }
        catch (NetException netException) {
            throw new IOException(netException.getMessage());
        }
        return n4;
    }

    public void initBuffers() {
    }

    protected void marshalB1Array(byte[] byArray) throws IOException {
        if (byArray.length > 0) {
            this.outBuffer.write(byArray);
        }
    }

    protected void marshalB1Array(byte[] byArray, int n2, int n3) throws IOException {
        if (byArray.length > 0) {
            this.outBuffer.write(byArray, n2, n3);
        }
    }

    protected void marshalCHR(byte[] byArray) throws IOException {
        if (byArray.length > 0) {
            if (this.types.isConvNeeded()) {
                this.marshalCLR(byArray, byArray.length);
            } else {
                this.outBuffer.write(byArray);
            }
        }
    }

    protected void marshalCLR(byte[] byArray, int n2) throws IOException {
        if (n2 > 64) {
            int n3;
            int n4 = 0;
            this.outBuffer.write(-2);
            do {
                int n5;
                n3 = (n5 = n2 - n4) > 64 ? 64 : n5;
                this.outBuffer.write((byte)(n3 & 0xFF));
                this.outBuffer.write(byArray, n4, n3);
            } while ((n4 += n3) < n2);
            this.outBuffer.write(0);
        } else {
            this.outBuffer.write((byte)(n2 & 0xFF));
            if (byArray.length != 0) {
                this.outBuffer.write(byArray);
            }
        }
    }

    public void marshalDALC(byte[] byArray) throws SQLException, IOException {
        if (byArray == null || byArray.length < 1) {
            this.outBuffer.write(0);
        } else {
            this.marshalSB4(0xFFFFFFFF & byArray.length);
            this.marshalCLR(byArray, byArray.length);
        }
    }

    public void marshalNULLPTR() throws IOException {
        this.addPtr((byte)0);
    }

    public void marshalO2U(boolean bl) throws IOException {
        if (bl) {
            this.addPtr((byte)1);
        } else {
            this.addPtr((byte)0);
        }
    }

    public void marshalPTR() throws IOException {
        this.addPtr((byte)1);
    }

    protected void marshalSB1(byte by) throws IOException {
        this.outBuffer.write(by);
    }

    protected void marshalSB2(short s2) throws IOException {
        byte[] byArray = new byte[2];
        byte by = this.value2Buffer(s2, byArray, (byte)1);
        this.outBuffer.write(byArray, 0, by);
    }

    protected void marshalSB4(int n2) throws IOException {
        byte[] byArray = new byte[4];
        byte by = this.value2Buffer(n2, byArray, (byte)2);
        this.outBuffer.write(byArray, 0, by);
    }

    protected void marshalSWORD(int n2) throws IOException {
        this.marshalSB4(n2);
    }

    protected void marshalUB1(short s2) throws IOException {
        this.outBuffer.write((byte)(s2 & 0xFF));
    }

    protected void marshalUB2(int n2) throws IOException {
        this.marshalSB2((short)(n2 & 0xFFFF));
    }

    protected void marshalUB4(long l2) throws IOException {
        this.marshalSB4((int)(l2 & 0xFFFFFFFFFFFFFFFFL));
    }

    protected void marshalUB4Array(long[] lArray) throws IOException {
        int n2 = 0;
        while (n2 < lArray.length) {
            this.marshalSB4((int)(lArray[n2] & 0xFFFFFFFFFFFFFFFFL));
            ++n2;
        }
    }

    protected void marshalUWORD(long l2) throws IOException {
        this.marshalSB4((int)(l2 & 0xFFFFFFFFFFFFFFFFL));
    }

    public int processIndicator(boolean bl, int n2) throws SQLException, IOException {
        short s2 = this.unmarshalSB2();
        int n3 = 0;
        if (!bl) {
            n3 = s2 == 0 ? n2 : (s2 == -2 || s2 > 0 ? (int)s2 : 65536 + s2);
        }
        return n3;
    }

    protected void reverseArray(byte[] byArray, byte by) {
        int n2 = 0;
        while (n2 < by / 2) {
            byte by2 = byArray[n2];
            byArray[n2] = byArray[by - 1 - n2];
            byArray[by - 1 - n2] = by2;
            ++n2;
        }
    }

    private int unmarshalBuffer(byte[] byArray, int n2, int n3) throws SQLException, IOException {
        if (byArray.length < n2 + n3) {
            this.unmarshalNBytes(byArray, n2, byArray.length - n2);
            this.unmarshalNBytes(this.blackHoleBuf, 0, n2 + n3 - byArray.length);
            n2 = -1;
        } else {
            this.unmarshalNBytes(byArray, n2, n3);
            n2 += n3;
        }
        return n2;
    }

    public byte[] unmarshalCHR(int n2) throws SQLException, IOException {
        if (this.types.isConvNeeded()) {
            int[] nArray = new int[1];
            this.resBuffer = this.unmarshalCLR(n2, nArray);
            this.tmpBuf = new byte[nArray[0]];
            System.arraycopy(this.resBuffer, 0, this.tmpBuf, 0, nArray[0]);
            this.resBuffer = this.tmpBuf;
        } else {
            this.resBuffer = this.getNBytes(n2);
        }
        return this.resBuffer;
    }

    /*
     * Unable to fully structure code
     */
    public byte[] unmarshalCLR(int var1_1, int[] var2_2) throws SQLException, IOException {
        block6: {
            block7: {
                block5: {
                    var3_3 = 0;
                    var4_4 = 0;
                    var5_5 = this.unmarshalUB1();
                    if (var5_5 < 0) {
                        DBError.check_error(401);
                    }
                    if (var5_5 == 0) {
                        var2_2[0] = 0;
                        return new byte[0];
                    }
                    this.tmpBuf = new byte[var1_1 * this.conv.getNLSRATIO()];
                    if (!this.escapeSequenceNull(var5_5)) break block5;
                    var2_2[0] = 0;
                    break block6;
                }
                if (var5_5 == 254) ** GOTO lbl23
                var4_4 = this.unmarshalBuffer(this.tmpBuf, var4_4, var5_5);
                break block7;
lbl-1000:
                // 1 sources

                {
                    if (var3_3 == 254 && this.types.isServerConversion()) continue;
                    if (var4_4 == -1) {
                        this.unmarshalBuffer(this.blackHoleBuf, 0, var3_3);
                        continue;
                    }
                    var4_4 = this.unmarshalBuffer(this.tmpBuf, var4_4, var3_3);
lbl23:
                    // 4 sources

                    ** while ((var3_3 = this.unmarshalUB1()) > 0)
                }
            }
            if (var2_2 != null) {
                var2_2[0] = var4_4 != -1 ? var4_4 : this.tmpBuf.length;
            }
        }
        return this.tmpBuf;
    }

    public void unmarshalCLR(TTCItem tTCItem, int[] nArray) throws SQLException, IOException {
        short s2 = 0;
        int n2 = 0;
        boolean bl = false;
        int n3 = -1;
        s2 = this.unmarshalUB1();
        if (s2 < 0) {
            DBError.check_error(401);
        }
        if (s2 == 0) {
            return;
        }
        if (this.escapeSequenceNull(s2)) {
            nArray[0] = 0;
            return;
        }
        if (s2 != 254) {
            n2 = this.unmarshalBuffer(tTCItem.byte_value, n2, s2);
        } else {
            n3 = -1;
            block5: while (n3 == -1 || (s2 = this.unmarshalUB1()) > 0) {
                if (s2 == 254) {
                    switch (n3) {
                        case -1: {
                            n3 = 1;
                            continue block5;
                        }
                        case 1: {
                            n3 = 0;
                            break;
                        }
                        case 0: {
                            if (bl) {
                                n3 = 0;
                                break;
                            }
                            n3 = 0;
                            continue block5;
                        }
                    }
                }
                if (n2 == -1) {
                    this.unmarshalBuffer(this.blackHoleBuf, 0, s2);
                } else {
                    n2 = this.unmarshalBuffer(tTCItem.byte_value, n2, s2);
                }
                n3 = 0;
                if (s2 <= 252) continue;
                bl = true;
            }
        }
        if (nArray != null) {
            nArray[0] = n2 != -1 ? n2 : tTCItem.byte_value.length;
        }
    }

    public byte[] unmarshalCLRforREFS() throws SQLException, IOException {
        short s2 = 0;
        short s3 = 0;
        this.finalBuffer = null;
        Vector<byte[]> vector = new Vector<byte[]>(10, 10);
        short s4 = this.unmarshalUB1();
        if (s4 < 0) {
            DBError.check_error(401);
        }
        if (s4 == 0) {
            return null;
        }
        if (!this.escapeSequenceNull(s4)) {
            if (s4 == 254) {
                while ((s2 = this.unmarshalUB1()) > 0) {
                    if (s2 == 254 && this.types.isServerConversion()) continue;
                    s3 = (short)(s3 + s2);
                    this.tmpBuf = new byte[s2];
                    this.unmarshalBuffer(this.tmpBuf, 0, s2);
                    vector.addElement(this.tmpBuf);
                }
            } else {
                s3 = s4;
                this.tmpBuf = new byte[s4];
                this.unmarshalBuffer(this.tmpBuf, 0, s4);
                vector.addElement(this.tmpBuf);
            }
            this.finalBuffer = new byte[s3];
            int n2 = 0;
            while (vector.size() > 0) {
                int n3 = ((byte[])vector.elementAt(0)).length;
                System.arraycopy(vector.elementAt(0), 0, this.finalBuffer, n2, n3);
                n2 += n3;
                vector.removeElementAt(0);
            }
        } else {
            this.finalBuffer = null;
        }
        return this.finalBuffer;
    }

    public byte[] unmarshalDALC() throws SQLException, IOException {
        long l2 = this.unmarshalUB4();
        byte[] byArray = new byte[(int)(0xFFFFFFFFFFFFFFFFL & l2)];
        if (byArray.length > 0) {
            if ((byArray = this.unmarshalCLR(byArray.length, this.retLen)) == null) {
                DBError.check_error(401);
            }
        } else {
            byArray = new byte[]{};
        }
        return byArray;
    }

    public byte[] unmarshalDALC(int[] nArray) throws SQLException, IOException {
        long l2 = this.unmarshalUB4();
        byte[] byArray = new byte[(int)(0xFFFFFFFFFFFFFFFFL & l2)];
        if (byArray.length > 0) {
            if ((byArray = this.unmarshalCLR(byArray.length, nArray)) == null) {
                DBError.check_error(401);
            }
        } else {
            byArray = new byte[]{};
        }
        return byArray;
    }

    public byte[] unmarshalNBytes(int n2) throws SQLException, IOException {
        byte[] byArray = new byte[n2];
        try {
            while (true) {
                try {
                    if (this.inBuffer.read(byArray) < 0) {
                        DBError.check_error(410);
                    }
                }
                catch (BreakNetException breakNetException) {
                    this.net.sendReset();
                    continue;
                }
                break;
            }
        }
        catch (NetException netException) {
            throw new IOException(netException.getMessage());
        }
        return byArray;
    }

    public int unmarshalNBytes(byte[] byArray, int n2, int n3) throws SQLException, IOException {
        int n4 = 0;
        while (n4 < n3) {
            n4 += this.getNBytes(byArray, n2 + n4, n3 - n4);
        }
        return n4;
    }

    public int unmarshalRefCursor(byte[] byArray) throws SQLException, IOException {
        return this.unmarshalSB4(byArray);
    }

    public byte unmarshalSB1() throws SQLException, IOException {
        return (byte)this.unmarshalUB1();
    }

    public short unmarshalSB2() throws SQLException, IOException {
        return (short)this.unmarshalUB2();
    }

    public int unmarshalSB4() throws SQLException, IOException {
        return (int)this.unmarshalUB4();
    }

    public int unmarshalSB4(byte[] byArray) throws SQLException, IOException {
        byte[] byArray2 = new byte[4];
        long l2 = this.buffer2Value(byArray2, (byte)2, new ByteArrayInputStream(byArray));
        return (int)l2;
    }

    public int unmarshalSWORD() throws SQLException, IOException {
        return (int)this.unmarshalUB4();
    }

    public byte[] unmarshalTEXT(int n2) throws SQLException, IOException {
        int n3 = 0;
        byte[] byArray = new byte[n2];
        while (n3 < n2) {
            try {
                while (true) {
                    try {
                        if (this.inBuffer.read(byArray, n3, 1) < 0) {
                            DBError.check_error(410);
                        }
                    }
                    catch (BreakNetException breakNetException) {
                        this.net.sendReset();
                        continue;
                    }
                    break;
                }
            }
            catch (NetException netException) {
                throw new IOException(netException.getMessage());
            }
            if (byArray[n3++] == 0) break;
        }
        byte[] byArray2 = new byte[--n3];
        System.arraycopy(byArray, 0, byArray2, 0, n3);
        return byArray2;
    }

    public short unmarshalUB1() throws SQLException, IOException {
        short s2 = 0;
        try {
            while (true) {
                try {
                    s2 = (short)this.inBuffer.read();
                }
                catch (BreakNetException breakNetException) {
                    this.net.sendReset();
                    continue;
                }
                break;
            }
        }
        catch (NetException netException) {
            throw new IOException(netException.getMessage());
        }
        if (s2 < 0) {
            DBError.check_error(410);
        }
        return s2;
    }

    public int unmarshalUB2() throws SQLException, IOException {
        byte[] byArray = new byte[2];
        int n2 = (int)this.buffer2Value(byArray, (byte)1);
        return n2 & 0xFFFF;
    }

    public long unmarshalUB4() throws SQLException, IOException {
        byte[] byArray = new byte[4];
        long l2 = this.buffer2Value(byArray, (byte)2);
        return l2;
    }

    public long unmarshalUWORD() throws SQLException, IOException {
        return this.unmarshalUB4();
    }

    protected byte value2Buffer(int n2, byte[] byArray, byte by) throws IOException {
        boolean bl = true;
        byte by2 = 0;
        int n3 = byArray.length - 1;
        while (n3 >= 0) {
            byArray[by2] = (byte)(n2 >>> 8 * n3 & 0xFF);
            if ((this.types.rep[by] & 1) > 0) {
                if (!bl || byArray[by2] != 0) {
                    bl = false;
                    by2 = (byte)(by2 + 1);
                }
            } else {
                by2 = (byte)(by2 + 1);
            }
            --n3;
        }
        if ((this.types.rep[by] & 1) > 0) {
            this.outBuffer.write(by2);
        }
        if ((this.types.rep[by] & 2) > 0) {
            this.reverseArray(byArray, by2);
        }
        return by2;
    }
}

