/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.pool;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.pool.OracleConnectionCache;
import oracle.jdbc.pool.OracleConnectionEventListener;
import oracle.jdbc.pool.OracleConnectionPoolDataSource;
import oracle.jdbc.pool.OracleDataSource;
import oracle.jdbc.pool.OraclePooledConnection;

public class OracleConnectionCacheImpl
extends OracleDataSource
implements OracleConnectionCache,
Serializable,
Referenceable {
    protected ConnectionPoolDataSource m_cpds = null;
    protected static int _DEFAULT_MIN_LIMIT = 0;
    protected static int _DEFAULT_MAX_LIMIT = 10;
    protected int _MIN_LIMIT = _DEFAULT_MIN_LIMIT;
    protected int _MAX_LIMIT = _DEFAULT_MAX_LIMIT;
    protected Stack m_cache = new Stack();
    protected Hashtable m_activeCache = new Hashtable();
    protected int m_cacheSize = 0;
    protected int m_activeSize = 0;
    protected int m_cacheScheme = 1;
    public static final int DYNAMIC_SCHEME = 1;
    public static final int FIXED_WAIT_SCHEME = 2;
    public static final int FIXED_RETURN_NULL_SCHEME = 3;
    protected OracleConnectionEventListener m_ocel = null;
    protected int m_stmtCacheSize = 0;
    protected boolean m_stmtClearMetaData = false;

    public OracleConnectionCacheImpl() throws SQLException {
        this(null);
    }

    public OracleConnectionCacheImpl(ConnectionPoolDataSource connectionPoolDataSource) throws SQLException {
        this.m_cpds = connectionPoolDataSource;
        this.m_ocel = new OracleConnectionEventListener(this);
        this.m_dataSourceName = "OracleConnectionCacheImpl";
    }

    private void checkCredentials(String string, String string2) throws SQLException {
        String string3 = null;
        String string4 = null;
        if (this.m_cpds != null) {
            string3 = ((OracleConnectionPoolDataSource)this.m_cpds).getUser();
            string4 = ((OracleConnectionPoolDataSource)this.m_cpds).getPassword();
        }
        if (string != null && !string.equals(string3) || string2 != null && !string2.equals(string4)) {
            this.trace("Cannot create a connection with user as " + string + " as it is doesnt match the existing user " + this.m_user + " Or the Password");
            DBError.throwSqlException(79);
        }
    }

    public void close() throws SQLException {
        this.trace(" Close - start - Active Cache Size is " + this.m_activeSize + " Cache Size is " + this.m_cacheSize + " Cache Empty : " + this.m_cache.empty());
        Enumeration enumeration = this.m_activeCache.keys();
        while (enumeration.hasMoreElements()) {
            PooledConnection pooledConnection = (PooledConnection)enumeration.nextElement();
            PooledConnection pooledConnection2 = (PooledConnection)this.m_activeCache.get(pooledConnection);
            this.reusePooledConnection(pooledConnection2);
        }
        while (!this.m_cache.empty()) {
            this.closeSingleConnection((PooledConnection)this.m_cache.pop());
        }
        this.m_cache = null;
        this.m_activeCache = null;
        this.m_ocel = null;
        this.m_cpds = null;
    }

    public void closePooledConnection(PooledConnection pooledConnection) throws SQLException {
        this.trace("Calling closePooledConnection");
        this.detachSingleConnection(pooledConnection);
        this.closeSingleConnection(pooledConnection);
    }

    private void closeSingleConnection(PooledConnection pooledConnection) throws SQLException {
        --this.m_cacheSize;
        pooledConnection.close();
        pooledConnection = null;
    }

    private void detachSingleConnection(PooledConnection pooledConnection) {
        --this.m_activeSize;
        pooledConnection.removeConnectionEventListener(this.m_ocel);
        this.m_activeCache.remove(pooledConnection);
    }

    public synchronized int getActiveSize() {
        return this.m_activeSize;
    }

    public synchronized int getCacheScheme() {
        return this.m_cacheScheme;
    }

    public synchronized int getCacheSize() {
        return this.m_cacheSize;
    }

    public synchronized Connection getConnection() throws SQLException {
        return this.getConnection(this.m_user, this.m_password);
    }

    public synchronized Connection getConnection(String string, String string2) throws SQLException {
        PooledConnection pooledConnection = this.getPooledConnection(string, string2);
        if (pooledConnection != null) {
            return pooledConnection.getConnection();
        }
        return null;
    }

    public synchronized int getMaxLimit() {
        return this._MAX_LIMIT;
    }

    public synchronized int getMinLimit() {
        return this._MIN_LIMIT;
    }

    PooledConnection getNewPoolOrXAConnection() throws SQLException {
        if (this.m_cpds == null) {
            if (this.m_user == null || this.m_password == null) {
                DBError.throwSqlException(79);
            }
            this.m_cpds = new OracleConnectionPoolDataSource();
            this.copy((OracleDataSource)((Object)this.m_cpds));
        }
        PooledConnection pooledConnection = this.m_cpds.getPooledConnection();
        ((OraclePooledConnection)pooledConnection).setStmtCacheSize(this.m_stmtCacheSize, this.m_stmtClearMetaData);
        return pooledConnection;
    }

    protected PooledConnection getPooledConnection(String string, String string2) throws SQLException {
        PooledConnection pooledConnection = null;
        this.trace(" getConnection() -start m_cacheSize: " + this.m_cacheSize + " m_activeSize: " + this.m_activeSize + " user: " + string);
        if (!this.m_cache.empty()) {
            this.trace(" Active Count" + this.m_activeSize);
            this.checkCredentials(string, string2);
            pooledConnection = (PooledConnection)this.m_cache.pop();
        } else if (this.m_cacheSize < this._MAX_LIMIT || this.m_cacheScheme == 1) {
            this.trace(" Getting a new one m_cacheSize " + this.m_cacheSize + " m_activeSize " + this.m_activeSize);
            String string3 = null;
            String string4 = null;
            if (this.m_cpds != null) {
                string3 = ((OracleConnectionPoolDataSource)this.m_cpds).getUser();
                string4 = ((OracleConnectionPoolDataSource)this.m_cpds).getPassword();
            }
            if (this.m_cacheSize > 0 && string != null && !string.equals(string3)) {
                DBError.throwSqlException(79);
            } else if (string != null) {
                this.m_user = string;
                if (this.m_cpds != null) {
                    ((OracleConnectionPoolDataSource)this.m_cpds).setUser(string);
                }
            }
            if (this.m_cacheSize > 0 && string2 != null && !string2.equals(string4)) {
                DBError.throwSqlException(79);
            } else if (string2 != null) {
                this.m_password = string2;
                if (this.m_cpds != null) {
                    ((OracleConnectionPoolDataSource)this.m_cpds).setPassword(string2);
                }
            }
            pooledConnection = this.getNewPoolOrXAConnection();
            ++this.m_cacheSize;
        } else {
            if (this.m_cacheScheme == 3) {
                return null;
            }
            this.checkCredentials(string, string2);
            while (this.m_cache.empty()) {
                this.trace("Waiting...");
                Thread.currentThread();
                Thread.yield();
            }
            pooledConnection = (PooledConnection)this.m_cache.pop();
        }
        if (pooledConnection != null) {
            pooledConnection.addConnectionEventListener(this.m_ocel);
            this.m_activeCache.put(pooledConnection, pooledConnection);
            ++this.m_activeSize;
            ((OraclePooledConnection)pooledConnection).setStmtCacheSize(this.m_stmtCacheSize, this.m_stmtClearMetaData);
        }
        return pooledConnection;
    }

    public synchronized Reference getReference() throws NamingException {
        Reference reference = new Reference(this.getClass().getName(), "oracle.jdbc.pool.OracleDataSourceFactory", null);
        super.addRefProperties(reference);
        if (this._MIN_LIMIT != _DEFAULT_MIN_LIMIT) {
            reference.add(new StringRefAddr("minLimit", Integer.toString(this._MIN_LIMIT)));
        }
        if (this._MAX_LIMIT != _DEFAULT_MAX_LIMIT) {
            reference.add(new StringRefAddr("maxLimit", Integer.toString(this._MAX_LIMIT)));
        }
        if (this.m_cacheScheme != 1) {
            reference.add(new StringRefAddr("cacheScheme", Integer.toString(this.m_cacheScheme)));
        }
        return reference;
    }

    public synchronized int getStmtCacheSize() {
        return this.m_stmtCacheSize;
    }

    synchronized boolean isStmtCacheEnabled() {
        return this.m_stmtCacheSize > 0;
    }

    public void reusePooledConnection(PooledConnection pooledConnection) throws SQLException {
        this.trace("Calling reusePooledConnection");
        this.detachSingleConnection(pooledConnection);
        if (this.m_cacheSize > this._MAX_LIMIT && this.m_cacheScheme == 1) {
            this.closeSingleConnection(pooledConnection);
        } else {
            this.m_cache.push(pooledConnection);
        }
    }

    public synchronized void setCacheScheme(int n2) throws SQLException {
        if (n2 == 1 || n2 == 3 || n2 == 2) {
            this.m_cacheScheme = n2;
            return;
        }
        DBError.throwSqlException(68);
    }

    public synchronized void setConnectionPoolDataSource(ConnectionPoolDataSource connectionPoolDataSource) throws SQLException {
        if (this.m_cacheSize > 0) {
            DBError.throwSqlException(78);
        }
        this.m_cpds = connectionPoolDataSource;
    }

    public synchronized void setMaxLimit(int n2) throws SQLException {
        if (n2 < 0 || n2 < this._MIN_LIMIT) {
            DBError.throwSqlException(68);
        }
        this._MAX_LIMIT = n2;
        if (this.m_cacheSize > this._MAX_LIMIT && this.m_cacheScheme != 1) {
            int n3 = this._MAX_LIMIT;
            while (n3 < this.m_cacheSize) {
                if (this.m_cache.empty()) {
                    DBError.throwSqlException(78);
                } else {
                    ((PooledConnection)this.m_cache.pop()).close();
                }
                ++n3;
            }
            this.m_cacheSize = this._MAX_LIMIT;
        }
    }

    public synchronized void setMinLimit(int n2) throws SQLException {
        if (n2 < 0 || n2 > this._MAX_LIMIT) {
            DBError.throwSqlException(68);
        }
        this._MIN_LIMIT = n2;
        if (this.m_cacheSize < this._MIN_LIMIT) {
            int n3 = this.m_cacheSize;
            while (n3 < this._MIN_LIMIT) {
                PooledConnection pooledConnection = this.getNewPoolOrXAConnection();
                this.m_cache.push(pooledConnection);
                ++n3;
            }
            this.m_cacheSize = this._MIN_LIMIT;
        }
    }

    public synchronized void setStmtCacheSize(int n2) throws SQLException {
        this.setStmtCacheSize(n2, false);
    }

    public synchronized void setStmtCacheSize(int n2, boolean bl) throws SQLException {
        if (n2 < 0) {
            DBError.throwSqlException(68);
        }
        this.m_stmtCacheSize = n2;
        this.m_stmtClearMetaData = bl;
    }
}

