/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBError;

public class Util {
    private static int[] LDSRoundtab;

    static {
        int[] nArray = new int[9];
        nArray[1] = 1;
        nArray[3] = 2;
        nArray[7] = 3;
        LDSRoundtab = nArray;
    }

    static byte FDO_get_align(byte[] byArray, int n2) {
        byte by = Util.FDO_get_entry(byArray, n2);
        return (byte)(by & 7);
    }

    private static byte FDO_get_entry(byte[] byArray, int n2) {
        short s2 = Util.getUnsignedByte(byArray[5]);
        byte by = byArray[6 + s2 + n2];
        return by;
    }

    static byte FDO_get_size(byte[] byArray, int n2) {
        byte by = Util.FDO_get_entry(byArray, n2);
        return (byte)(by >> 3 & 0x1F);
    }

    static int LDSRound(int n2, int n3) {
        int n4 = LDSRoundtab[n3];
        return (n2 >> n4) + 1 << n4;
    }

    static void check_next_byte(InputStream inputStream, byte by) throws SQLException {
        try {
            if (inputStream.read() != by) {
                DBError.check_error(47, "parseTDS");
            }
        }
        catch (IOException iOException) {
            DBError.check_error(iOException);
        }
    }

    public static Object deserializeObject(byte[] byArray) throws IOException, ClassNotFoundException {
        if (byArray == null) {
            return null;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        return new ObjectInputStream(byteArrayInputStream).readObject();
    }

    public static short getUnsignedByte(byte by) {
        return (short)(by & 0xFF);
    }

    public static void printByteArray(byte[] byArray) {
        int n2 = 0;
        while (n2 < byArray.length) {
            System.out.print("0x" + Integer.toHexString(byArray[n2]) + " ");
            ++n2;
        }
        System.out.println();
        int n3 = 0;
        while (n3 < byArray.length) {
            System.out.print(String.valueOf(byArray[n3]) + " ");
            ++n3;
        }
        System.out.println();
    }

    public static void printByteArrayDec(byte[] byArray) {
        int n2 = 0;
        while (n2 < byArray.length) {
            System.out.print(String.valueOf(byArray[n2]) + " ");
            ++n2;
        }
        System.out.println();
    }

    public static void printLongArrayDec(long[] lArray) {
        int n2 = 0;
        while (n2 < lArray.length) {
            System.out.print(String.valueOf(lArray[n2]) + " ");
            ++n2;
        }
        System.out.println();
    }

    public static void printUnsignedByteArray(byte[] byArray) {
        int n2 = byArray.length;
        int[] nArray = Util.toJavaUnsignedBytes(byArray);
        int n3 = 0;
        while (n3 < n2) {
            System.out.print("0x" + Integer.toHexString(nArray[n3]) + " ");
            ++n3;
        }
        System.out.println();
        n3 = 0;
        while (n3 < n2) {
            System.out.print(String.valueOf(nArray[n3]) + " ");
            ++n3;
        }
        System.out.println();
    }

    static byte read_byte(InputStream inputStream) throws SQLException {
        try {
            return (byte)inputStream.read();
        }
        catch (IOException iOException) {
            DBError.check_error(iOException);
            return 0;
        }
    }

    static byte[] read_bytes(InputStream inputStream, int n2) throws SQLException {
        byte[] byArray = new byte[n2];
        try {
            int n3 = inputStream.read(byArray);
            if (n3 != n2) {
                byte[] byArray2 = new byte[n3];
                System.arraycopy(byArray, 0, byArray2, 0, n3);
                return byArray2;
            }
        }
        catch (IOException iOException) {
            DBError.check_error(iOException);
        }
        return byArray;
    }

    static long read_long(InputStream inputStream) throws SQLException {
        byte[] byArray = new byte[4];
        try {
            inputStream.read(byArray);
            return (((byArray[0] & 0xFF) * 256 + (byArray[1] & 0xFF)) * 256 + (byArray[2] & 0xFF)) * 256 + (byArray[3] & 0xFF);
        }
        catch (IOException iOException) {
            DBError.check_error(iOException);
            return 0L;
        }
    }

    static short read_short(InputStream inputStream) throws SQLException {
        byte[] byArray = new byte[2];
        try {
            inputStream.read(byArray);
            return (short)((byArray[0] & 0xFF) * 256 + (byArray[1] & 0xFF));
        }
        catch (IOException iOException) {
            DBError.check_error(iOException);
            return 0;
        }
    }

    public static byte[] serializeObject(Object object) throws IOException {
        if (object == null) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(object);
        objectOutputStream.flush();
        return byteArrayOutputStream.toByteArray();
    }

    static void skip_bytes(InputStream inputStream, int n2) throws SQLException {
        try {
            inputStream.skip(n2);
        }
        catch (IOException iOException) {
            DBError.check_error(iOException);
        }
    }

    public static int[] toJavaUnsignedBytes(byte[] byArray) {
        int[] nArray = new int[byArray.length];
        int n2 = 0;
        while (n2 < byArray.length) {
            nArray[n2] = byArray[n2] & 0xFF;
            ++n2;
        }
        return nArray;
    }

    static void write_bytes(OutputStream outputStream, byte[] byArray) throws SQLException {
        try {
            outputStream.write(byArray);
        }
        catch (IOException iOException) {
            DBError.check_error(iOException);
        }
    }
}

