/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.sql.SQLException;
import java.util.Vector;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.TDSPatch;

public class StreamInfo {
    static final int KOPT_NONE_FINAL_TYPE = 1;
    static final int KOPT_JAVA_OBJECT = 2;
    int null_offset = 0;
    int lds_offset = 0;
    long fixed_data_size = 0L;
    Vector m_patches = null;
    byte[] m_tds;
    int m_beginIndex;
    int m_index;

    StreamInfo(byte[] byArray, long l2) {
        this.m_tds = byArray;
        this.m_beginIndex = (int)l2;
        this.m_index = (int)l2;
    }

    long absolute_offset() throws SQLException {
        return this.m_index;
    }

    void addNormalPatch(long l2, byte by, OracleType oracleType) throws SQLException {
        this.addPatch(new TDSPatch(0, oracleType, l2, by));
    }

    void addPatch(TDSPatch tDSPatch) throws SQLException {
        if (this.m_patches == null) {
            this.m_patches = new Vector(5);
        }
        this.m_patches.addElement(tDSPatch);
    }

    void addSimplePatch(long l2, OracleType oracleType) throws SQLException {
        this.addPatch(new TDSPatch(1, oracleType, l2, 0));
    }

    void checkNextByte(byte by) throws SQLException {
        block2: {
            try {
                if (by == this.m_tds[this.m_index]) break block2;
                DBError.throwSqlException(47, "parseTDS");
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                ++this.m_index;
                throw throwable;
            }
        }
        Object var3_2 = null;
        ++this.m_index;
    }

    TDSPatch getNextPatch() throws SQLException {
        TDSPatch tDSPatch = null;
        if (this.m_patches != null && this.m_patches.size() > 0) {
            tDSPatch = (TDSPatch)this.m_patches.firstElement();
            this.m_patches.removeElementAt(0);
        }
        return tDSPatch;
    }

    boolean isFinalType(int n2, byte by) {
        return n2 >= 3 && (by & 1) == 0;
    }

    boolean isJavaObject(int n2, byte by) {
        return n2 >= 3 && (by & 2) != 0;
    }

    long moveToPatchPos(TDSPatch tDSPatch) throws SQLException {
        long l2 = tDSPatch.getPosition();
        if ((long)(this.m_index - this.m_beginIndex) < l2) {
            this.skip_to(l2);
        } else if ((long)(this.m_index - this.m_beginIndex) > l2) {
            DBError.throwSqlException(47, "parseTDS");
        }
        return l2;
    }

    long offset() throws SQLException {
        return this.m_index - this.m_beginIndex;
    }

    byte readByte() throws SQLException {
        try {
            byte by = this.m_tds[this.m_index];
            Object var3_2 = null;
            ++this.m_index;
            return by;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            ++this.m_index;
            throw throwable;
        }
    }

    long readLong() throws SQLException {
        try {
            long l2 = (((this.m_tds[this.m_index] & 0xFF) * 256 + (this.m_tds[this.m_index + 1] & 0xFF)) * 256 + (this.m_tds[this.m_index + 2] & 0xFF)) * 256 + (this.m_tds[this.m_index + 3] & 0xFF);
            Object var4_2 = null;
            this.m_index += 4;
            return l2;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.m_index += 4;
            throw throwable;
        }
    }

    short readShort() throws SQLException {
        try {
            short s2 = (short)((this.m_tds[this.m_index] & 0xFF) * 256 + (this.m_tds[this.m_index + 1] & 0xFF));
            Object var3_2 = null;
            this.m_index += 2;
            return s2;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.m_index += 2;
            throw throwable;
        }
    }

    int readUnsignedByte() throws SQLException {
        try {
            int n2 = this.m_tds[this.m_index] & 0xFF;
            Object var3_2 = null;
            ++this.m_index;
            return n2;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            ++this.m_index;
            throw throwable;
        }
    }

    void skipBytes(int n2) throws SQLException {
        this.m_index += n2;
    }

    void skip_to(long l2) {
        this.m_index = this.m_beginIndex + (int)l2;
    }

    byte[] tds() throws SQLException {
        return this.m_tds;
    }
}

