/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.oracore.PickleOutputStream;

public final class PickleContext {
    static final boolean PICKLE81_DEBUG = false;
    static boolean DEBUG = false;
    private PickleOutputStream stream_pctx;
    byte[] m_image;
    int m_offset;
    private byte[] lenbuf_pctx = new byte[5];
    static short KOPI20_LN_ELNL = (short)255;
    static short KOPI20_LN_5BLN = (short)254;
    static short KOPI20_LN_ATMN = (short)253;
    static short KOPI20_LN_IEMN = (short)252;
    static short KOPI20_LN_MAXV = (short)245;
    static short KOPI20_IF_IS81 = (short)128;
    static short KOPI20_IF_CMSB = (short)64;
    static short KOPI20_IF_CLSB = (short)32;
    static short KOPI20_IF_DEGN = (short)16;
    static short KOPI20_IF_COLL = (short)8;
    static short KOPI20_IF_NOPS = (short)4;
    static short KOPI20_IF_ANY = (short)2;
    static short KOPI20_IF_NONL = 1;
    static short KOPI20_CF_CMSB = (short)64;
    static short KOPI20_CF_CLSB = (short)32;
    static short KOPI20_CF_INDX = (short)16;
    static short KOPI20_CF_NOLN = (short)8;
    static short KOPI20_VERSION = 1;
    static final byte KOPUP_INLINE_COLL = 1;
    static final byte KOPUP_TYPEINFO_NONE = 0;
    static final byte KOPUP_TYPEINFO_TOID = 4;
    static final byte KOPUP_TYPEINFO_TOBJN = 8;
    static final byte KOPUP_TYPEINFO_TDS = 12;
    static final byte KOPUP_VSN_PRESENT = 16;

    public PickleContext() {
    }

    public PickleContext(byte[] byArray) {
        this.m_image = byArray;
        this.m_offset = 0;
    }

    public PickleContext(byte[] byArray, long l2) {
        this.m_image = byArray;
        this.m_offset = (int)l2;
    }

    public int absolute_offset() throws SQLException {
        return this.m_offset;
    }

    public static boolean hasPrefix_pctx(byte by) throws SQLException {
        return (by & 0xFF & KOPI20_IF_NOPS) == 0;
    }

    public byte[] image() throws SQLException {
        return this.m_image;
    }

    public void initStream_pctx() {
        this.stream_pctx = new PickleOutputStream();
    }

    public void initStream_pctx(int n2) {
        this.stream_pctx = new PickleOutputStream(n2);
    }

    public static boolean is81format_pctx(byte by) throws SQLException {
        return (by & 0xFF & KOPI20_IF_IS81) != 0;
    }

    public static boolean isAtomicNull_pctx(byte by) throws SQLException {
        return (by & 0xFF) == KOPI20_LN_ATMN;
    }

    public static boolean isCollectionImage_pctx(byte by) throws SQLException {
        return (by & 0xFF & KOPI20_IF_COLL) != 0;
    }

    public static boolean isDegenerateImage_pctx(byte by) throws SQLException {
        return (by & 0xFF & KOPI20_IF_DEGN) != 0;
    }

    public static boolean isElementNull_pctx(byte by) throws SQLException {
        return (by & 0xFF) == KOPI20_LN_ELNL;
    }

    public static boolean isImmEmbNull_pctx(byte by) throws SQLException {
        return (by & 0xFF) == KOPI20_LN_IEMN;
    }

    public int lenbytes_pctx(int n2) {
        return n2 <= KOPI20_LN_MAXV ? 1 : 5;
    }

    public int offset() throws SQLException {
        if (this.stream_pctx != null) {
            return this.stream_pctx.offset();
        }
        return this.m_offset;
    }

    public void patchImageLen_pctx(int n2, int n3) throws SQLException {
        byte[] byArray = this.to5bLengthBytes_pctx(n3);
        this.stream_pctx.overwrite(n2, byArray, 0, byArray.length);
    }

    public byte[] read1byteDataValue_pctx() throws SQLException {
        if ((this.m_image[this.m_offset] & 0xFF) == KOPI20_LN_ELNL) {
            return null;
        }
        byte[] byArray = new byte[this.m_image[this.m_offset] & 0xFF];
        System.arraycopy(this.m_image, this.m_offset + 1, byArray, 0, byArray.length);
        this.m_offset += byArray.length + 1;
        return byArray;
    }

    public boolean readAndCheckVersion_pctx() throws SQLException {
        try {
            boolean bl = (this.m_image[this.m_offset] & 0xFF) <= KOPI20_VERSION;
            Object var3_2 = null;
            ++this.m_offset;
            return bl;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            ++this.m_offset;
            throw throwable;
        }
    }

    public byte readByte_pctx() throws SQLException {
        try {
            byte by = this.m_image[this.m_offset];
            Object var3_2 = null;
            ++this.m_offset;
            return by;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            ++this.m_offset;
            throw throwable;
        }
    }

    public byte[] readBytes_pctx(int n2) throws SQLException {
        byte[] byArray = new byte[n2];
        System.arraycopy(this.m_image, this.m_offset, byArray, 0, n2);
        this.m_offset += n2;
        return byArray;
    }

    public byte[] readDataValue_pctx() throws SQLException {
        int n2 = this.m_image[this.m_offset] & 0xFF;
        if (n2 == KOPI20_LN_ELNL) {
            ++this.m_offset;
            return null;
        }
        if (n2 > KOPI20_LN_MAXV) {
            n2 = (((this.m_image[this.m_offset + 1] & 0xFF) * 256 + (this.m_image[this.m_offset + 2] & 0xFF)) * 256 + (this.m_image[this.m_offset + 3] & 0xFF)) * 256 + (this.m_image[this.m_offset + 4] & 0xFF);
            this.m_offset += 5;
        } else {
            ++this.m_offset;
        }
        byte[] byArray = new byte[n2];
        System.arraycopy(this.m_image, this.m_offset, byArray, 0, byArray.length);
        this.m_offset += byArray.length;
        return byArray;
    }

    public byte[] readDataValue_pctx(byte by) throws SQLException {
        byte[] byArray = new byte[this.readRestOfLength_pctx(by)];
        System.arraycopy(this.m_image, this.m_offset, byArray, 0, byArray.length);
        this.m_offset += byArray.length;
        return byArray;
    }

    public byte[] readDataValue_pctx(int n2) throws SQLException {
        byte[] byArray = new byte[n2];
        System.arraycopy(this.m_image, this.m_offset, byArray, 0, n2);
        this.m_offset += n2;
        return byArray;
    }

    public int readLength_pctx() throws SQLException {
        int n2 = this.m_image[this.m_offset] & 0xFF;
        if (n2 > KOPI20_LN_MAXV) {
            if (n2 == KOPI20_LN_ELNL) {
                DBError.throwSqlException(1, "Invalid null flag read");
            }
            n2 = (((this.m_image[this.m_offset + 1] & 0xFF) * 256 + (this.m_image[this.m_offset + 2] & 0xFF)) * 256 + (this.m_image[this.m_offset + 3] & 0xFF)) * 256 + (this.m_image[this.m_offset + 4] & 0xFF);
            this.m_offset += 5;
        } else {
            ++this.m_offset;
        }
        return n2;
    }

    public int readLength_pctx(boolean bl) throws SQLException {
        int n2 = this.m_image[this.m_offset] & 0xFF;
        if (n2 > KOPI20_LN_MAXV) {
            n2 = (((this.m_image[this.m_offset + 1] & 0xFF) * 256 + (this.m_image[this.m_offset + 2] & 0xFF)) * 256 + (this.m_image[this.m_offset + 3] & 0xFF)) * 256 + (this.m_image[this.m_offset + 4] & 0xFF);
            if (bl) {
                n2 -= 5;
            }
            this.m_offset += 5;
        } else {
            if (bl) {
                --n2;
            }
            ++this.m_offset;
        }
        return n2;
    }

    public byte[] readPrefixSegment_pctx() throws SQLException {
        byte[] byArray = new byte[this.readLength_pctx()];
        System.arraycopy(this.m_image, this.m_offset, byArray, 0, byArray.length);
        this.m_offset += byArray.length;
        return byArray;
    }

    public int readRestOfLength_pctx(byte by) throws SQLException {
        if ((by & 0xFF) != KOPI20_LN_5BLN) {
            return by & 0xFF;
        }
        try {
            int n2 = (((this.m_image[this.m_offset] & 0xFF) * 256 + (this.m_image[this.m_offset + 1] & 0xFF)) * 256 + (this.m_image[this.m_offset + 2] & 0xFF)) * 256 + (this.m_image[this.m_offset + 3] & 0xFF);
            Object var4_3 = null;
            this.m_offset += 4;
            return n2;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.m_offset += 4;
            throw throwable;
        }
    }

    public void skipDataValue_pctx() throws SQLException {
        if ((this.m_image[this.m_offset] & 0xFF) == KOPI20_LN_ELNL) {
            ++this.m_offset;
        } else {
            this.skip_bytes(this.readLength_pctx());
        }
    }

    public void skipDataValue_pctx(byte by) throws SQLException {
        this.skip_bytes(this.readRestOfLength_pctx(by));
    }

    public void skipLength_pctx() throws SQLException {
        int n2 = this.m_image[this.m_offset] & 0xFF;
        this.m_offset = n2 > KOPI20_LN_MAXV ? (this.m_offset += 5) : ++this.m_offset;
    }

    public void skipRestOfLength_pctx(byte by) throws SQLException {
        if ((by & 0xFF) > KOPI20_LN_MAXV) {
            if ((by & 0xFF) == KOPI20_LN_5BLN) {
                this.m_offset += 4;
            } else {
                DBError.throwSqlException(1, "Invalid first length byte");
            }
        }
    }

    public void skip_bytes(int n2) throws SQLException {
        if (n2 > 0) {
            this.m_offset += n2;
        }
    }

    public void skip_to(long l2) throws SQLException {
        if (l2 > (long)this.m_offset) {
            this.m_offset = (int)l2;
        }
    }

    public byte[] stream2bytes_pctx() throws SQLException {
        return this.stream_pctx.toByteArray();
    }

    public byte[] to5bLengthBytes_pctx(int n2) throws SQLException {
        this.lenbuf_pctx[0] = (byte)KOPI20_LN_5BLN;
        this.lenbuf_pctx[1] = (byte)(n2 >> 24);
        this.lenbuf_pctx[2] = (byte)((n2 &= 0xFFFFFF) >> 16);
        this.lenbuf_pctx[3] = (byte)((n2 &= 0xFFFF) >> 8);
        this.lenbuf_pctx[4] = (byte)(n2 &= 0xFF);
        return this.lenbuf_pctx;
    }

    public int writeAtomicNull_pctx() throws SQLException {
        this.stream_pctx.write(KOPI20_LN_ATMN);
        return 1;
    }

    public int writeCollImageHeader_pctx(int n2) throws SQLException {
        return this.writeCollImageHeader_pctx(KOPI20_LN_MAXV + 1, n2);
    }

    public int writeCollImageHeader_pctx(int n2, int n3) throws SQLException {
        int n4 = 5;
        this.lenbuf_pctx[0] = (byte)(KOPI20_IF_IS81 | KOPI20_IF_COLL);
        this.lenbuf_pctx[1] = (byte)KOPI20_VERSION;
        this.stream_pctx.write(this.lenbuf_pctx, 0, 2);
        n4 += this.writeLength_pctx(n2);
        this.lenbuf_pctx[0] = 1;
        this.lenbuf_pctx[1] = 1;
        this.stream_pctx.write(this.lenbuf_pctx, 0, 2);
        this.lenbuf_pctx[0] = 0;
        this.stream_pctx.write(this.lenbuf_pctx, 0, 1);
        return n4 += this.writeLength_pctx(n3);
    }

    public int writeCollImageHeader_pctx(int n2, byte[] byArray) throws SQLException {
        int n3 = byArray.length;
        int n4 = 3 + n3;
        this.lenbuf_pctx[0] = (byte)(KOPI20_IF_IS81 | KOPI20_IF_DEGN);
        this.lenbuf_pctx[1] = (byte)KOPI20_VERSION;
        this.stream_pctx.write(this.lenbuf_pctx, 0, 2);
        n4 += this.writeLength_pctx(n2);
        this.lenbuf_pctx[0] = 0;
        this.stream_pctx.write(this.lenbuf_pctx, 0, 1);
        this.stream_pctx.write(byArray, 0, n3);
        return n4 += this.writeLength_pctx(n3 + 1);
    }

    public int writeCollImageHeader_pctx(byte[] byArray) throws SQLException {
        return this.writeCollImageHeader_pctx(KOPI20_LN_MAXV + 1, byArray);
    }

    public int writeEltNull_pctx() throws SQLException {
        this.stream_pctx.write(KOPI20_LN_ELNL);
        return 1;
    }

    public int writeIEmbNull_pctx(byte by) throws SQLException {
        this.lenbuf_pctx[0] = (byte)KOPI20_LN_IEMN;
        this.lenbuf_pctx[1] = by;
        this.stream_pctx.write(this.lenbuf_pctx, 0, 2);
        return 2;
    }

    public int writeImageHeader_pctx(int n2, boolean bl) throws SQLException {
        int n3 = 2;
        this.lenbuf_pctx[0] = bl ? (byte)KOPI20_IF_IS81 : (byte)(KOPI20_IF_IS81 | KOPI20_IF_NOPS);
        this.lenbuf_pctx[1] = (byte)KOPI20_VERSION;
        this.stream_pctx.write(this.lenbuf_pctx, 0, 2);
        return n3 += this.writeLength_pctx(n2);
    }

    public int writeImageHeader_pctx(boolean bl) throws SQLException {
        return this.writeImageHeader_pctx(KOPI20_LN_MAXV + 1, bl);
    }

    public int writeLength_pctx(int n2) throws SQLException {
        if (n2 <= KOPI20_LN_MAXV) {
            this.stream_pctx.write((byte)n2);
            return 1;
        }
        this.lenbuf_pctx[0] = (byte)KOPI20_LN_5BLN;
        this.lenbuf_pctx[1] = (byte)(n2 >> 24);
        this.lenbuf_pctx[2] = (byte)((n2 &= 0xFFFFFF) >> 16);
        this.lenbuf_pctx[3] = (byte)((n2 &= 0xFFFF) >> 8);
        this.lenbuf_pctx[4] = (byte)(n2 &= 0xFF);
        try {
            this.stream_pctx.write(this.lenbuf_pctx);
        }
        catch (IOException iOException) {
            if (DEBUG) {
                iOException.printStackTrace();
            }
            DBError.throwSqlException(iOException);
        }
        return 5;
    }

    public int writeLength_pctx(int n2, boolean bl) throws SQLException {
        if (!bl) {
            return this.writeLength_pctx(n2);
        }
        if (n2 <= KOPI20_LN_MAXV - 1) {
            this.stream_pctx.write((byte)n2 + 1);
            return 1;
        }
        this.lenbuf_pctx[0] = (byte)KOPI20_LN_5BLN;
        this.lenbuf_pctx[1] = (byte)((n2 += 5) >> 24);
        this.lenbuf_pctx[2] = (byte)((n2 &= 0xFFFFFF) >> 16);
        this.lenbuf_pctx[3] = (byte)((n2 &= 0xFFFF) >> 8);
        this.lenbuf_pctx[4] = (byte)(n2 &= 0xFF);
        try {
            this.stream_pctx.write(this.lenbuf_pctx);
        }
        catch (IOException iOException) {
            if (DEBUG) {
                iOException.printStackTrace();
            }
            DBError.throwSqlException(iOException);
        }
        return 5;
    }

    public int writeOpaqueImageHeader_pctx(int n2) throws SQLException {
        int n3 = 2;
        this.lenbuf_pctx[0] = (byte)(KOPI20_IF_IS81 | KOPI20_IF_NOPS | KOPI20_IF_NONL);
        this.lenbuf_pctx[1] = (byte)KOPI20_VERSION;
        this.stream_pctx.write(this.lenbuf_pctx, 0, 2);
        return n3 += this.writeLength_pctx(n2 + 2, true);
    }

    public int write_data_pctx(byte by) throws SQLException {
        this.stream_pctx.write(by);
        return 1;
    }

    public int write_data_pctx(byte[] byArray) throws SQLException {
        try {
            this.stream_pctx.write(byArray);
        }
        catch (IOException iOException) {
            if (DEBUG) {
                iOException.printStackTrace();
            }
            DBError.throwSqlException(iOException);
        }
        return byArray.length;
    }
}

