/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Map;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.PickleContext;
import oracle.jdbc.oracore.StreamInfo;
import oracle.jdbc.oracore.UnpickleContext;
import oracle.sql.Datum;
import oracle.sql.RAW;
import oracle.sql.TypeDescriptor;

public class OracleTypeRAW
extends OracleType
implements Serializable {
    static final long serialVersionUID = -6083664758336974576L;
    static boolean DEBUG = false;
    int length;

    public OracleTypeRAW() {
    }

    public OracleTypeRAW(int n2) {
        super(n2);
    }

    public int getLength() {
        return this.length;
    }

    public int getTypeCode() {
        return -2;
    }

    public void parseTDSrec(StreamInfo streamInfo) throws SQLException {
        super.parseTDSrec(streamInfo);
        this.length = streamInfo.readShort();
    }

    protected int pickle81(PickleContext pickleContext, Datum datum) throws SQLException {
        if (datum.getLength() > (long)this.length) {
            DBError.check_error(72, this);
        }
        int n2 = pickleContext.writeLength_pctx((int)datum.getLength());
        return n2 += pickleContext.write_data_pctx(datum.shareBytes());
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        if (TypeDescriptor.DEBUG_SERIALIZATION) {
            System.out.println("OracleTypeRAW::readObject");
        }
        this.length = objectInputStream.readInt();
    }

    public Datum toDatum(Object object, OracleConnection oracleConnection) throws SQLException {
        RAW rAW;
        block3: {
            rAW = null;
            if (object == null) break block3;
            try {
                if (object instanceof RAW) {
                    rAW = (RAW)object;
                    break block3;
                }
                rAW = new RAW(object);
            }
            catch (SQLException sQLException) {
                DBError.throwSqlException(59, object);
            }
        }
        return rAW;
    }

    public Datum[] toDatumArray(Object object, OracleConnection oracleConnection, long l2, int n2) throws SQLException {
        Datum[] datumArray = null;
        if (object != null) {
            if (object instanceof char[][]) {
                char[][] cArray = (char[][])object;
                int n3 = (int)(n2 == -1 ? (long)cArray.length : Math.min((long)cArray.length - l2 + 1L, (long)n2));
                datumArray = new Datum[n3];
                int n4 = 0;
                while (n4 < n3) {
                    datumArray[n4] = this.toDatum(new String(cArray[(int)l2 + n4 - 1]), oracleConnection);
                    ++n4;
                }
            } else {
                if (object instanceof Object[]) {
                    return super.toDatumArray(object, oracleConnection, l2, n2);
                }
                DBError.check_error(59, object);
            }
        }
        return datumArray;
    }

    protected Object toObject(byte[] byArray, int n2, Map map) throws SQLException {
        if (byArray == null || byArray.length == 0) {
            return null;
        }
        switch (n2) {
            case 1: {
                return new RAW(byArray);
            }
            case 2: 
            case 3: {
                return byArray;
            }
        }
        DBError.throwSqlException(59, byArray);
        return null;
    }

    protected Object unpickle80rec(UnpickleContext unpickleContext, int n2, int n3, Map map) throws SQLException {
        switch (n2) {
            case 1: {
                if (unpickleContext.is_null(this.null_offset)) {
                    return null;
                }
                unpickleContext.skip_to(unpickleContext.m_ldsOffsets[this.lds_offset]);
                if (n3 == 9) {
                    unpickleContext.skip_bytes(4);
                    return null;
                }
                unpickleContext.markAndSkip();
                byte[] byArray = unpickleContext.read_lengthBytes();
                unpickleContext.reset();
                return this.toObject(byArray, n3, map);
            }
            case 2: {
                if ((unpickleContext.read_byte() & 1) == 1 || n3 == 9) {
                    unpickleContext.skip_lengthBytes();
                    return null;
                }
                return this.toObject(unpickleContext.read_lengthBytes(), n3, map);
            }
            case 3: {
                if (n3 == 9) {
                    unpickleContext.skip_lengthBytes();
                    return null;
                }
                return this.toObject(unpickleContext.read_lengthBytes(), n3, map);
            }
        }
        DBError.throwSqlException(1, "format=" + n2);
        return null;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (TypeDescriptor.DEBUG_SERIALIZATION) {
            System.out.println("OracleTypeRAW::writeObject");
        }
        objectOutputStream.writeInt(this.length);
    }
}

