/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Map;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.PickleContext;
import oracle.jdbc.oracore.StreamInfo;
import oracle.jdbc.oracore.UnpickleContext;
import oracle.jdbc.oracore.Util;
import oracle.sql.Datum;
import oracle.sql.NUMBER;
import oracle.sql.TypeDescriptor;

public class OracleTypeNUMBER
extends OracleType
implements Serializable {
    static final long serialVersionUID = -7182242886677299812L;
    int m_precision;
    int m_scale;

    protected OracleTypeNUMBER() {
    }

    protected OracleTypeNUMBER(int n2) {
        super(n2);
    }

    static Datum[] cArrayToNUMBERArray(Object object, OracleConnection oracleConnection, long l2, int n2) throws SQLException {
        Datum[] datumArray = null;
        if (object != null) {
            if (object instanceof short[]) {
                short[] sArray = (short[])object;
                int n3 = (int)(n2 == -1 ? (long)sArray.length : Math.min((long)sArray.length - l2 + 1L, (long)n2));
                datumArray = new Datum[n3];
                int n4 = 0;
                while (n4 < n3) {
                    datumArray[n4] = new NUMBER(sArray[(int)l2 + n4 - 1]);
                    ++n4;
                }
            } else if (object instanceof int[]) {
                int[] nArray = (int[])object;
                int n5 = (int)(n2 == -1 ? (long)nArray.length : Math.min((long)nArray.length - l2 + 1L, (long)n2));
                datumArray = new Datum[n5];
                int n6 = 0;
                while (n6 < n5) {
                    datumArray[n6] = new NUMBER(nArray[(int)l2 + n6 - 1]);
                    ++n6;
                }
            } else if (object instanceof long[]) {
                long[] lArray = (long[])object;
                int n7 = (int)(n2 == -1 ? (long)lArray.length : Math.min((long)lArray.length - l2 + 1L, (long)n2));
                datumArray = new Datum[n7];
                int n8 = 0;
                while (n8 < n7) {
                    datumArray[n8] = new NUMBER(lArray[(int)l2 + n8 - 1]);
                    ++n8;
                }
            } else if (object instanceof float[]) {
                float[] fArray = (float[])object;
                int n9 = (int)(n2 == -1 ? (long)fArray.length : Math.min((long)fArray.length - l2 + 1L, (long)n2));
                datumArray = new Datum[n9];
                int n10 = 0;
                while (n10 < n9) {
                    datumArray[n10] = new NUMBER(fArray[(int)l2 + n10 - 1]);
                    ++n10;
                }
            } else if (object instanceof double[]) {
                double[] dArray = (double[])object;
                int n11 = (int)(n2 == -1 ? (long)dArray.length : Math.min((long)dArray.length - l2 + 1L, (long)n2));
                datumArray = new Datum[n11];
                int n12 = 0;
                while (n12 < n11) {
                    datumArray[n12] = new NUMBER(dArray[(int)l2 + n12 - 1]);
                    ++n12;
                }
            } else if (object instanceof boolean[]) {
                boolean[] blArray = (boolean[])object;
                int n13 = (int)(n2 == -1 ? (long)blArray.length : Math.min((long)blArray.length - l2 + 1L, (long)n2));
                datumArray = new Datum[n13];
                int n14 = 0;
                while (n14 < n13) {
                    datumArray[n14] = new NUMBER(new Boolean(blArray[(int)l2 + n14 - 1]));
                    ++n14;
                }
            } else if (object instanceof char[][]) {
                char[][] cArray = (char[][])object;
                int n15 = (int)(n2 == -1 ? (long)cArray.length : Math.min((long)cArray.length - l2 + 1L, (long)n2));
                datumArray = new Datum[n15];
                int n16 = 0;
                while (n16 < n15) {
                    datumArray[n16] = new NUMBER(new String(cArray[(int)l2 + n16 - 1]));
                    ++n16;
                }
            } else {
                DBError.check_error(59, object);
            }
        }
        return datumArray;
    }

    public int getAlignLDS(byte[] byArray) {
        if (this.size_for_lds == 0) {
            this.size_for_lds = Util.FDO_get_size(byArray, 12);
            this.align_for_lds = Util.FDO_get_align(byArray, 12);
        }
        return this.align_for_lds;
    }

    public int getPrecision() {
        return this.m_precision;
    }

    public int getScale() {
        return this.m_scale;
    }

    public int getSizeLDS(byte[] byArray) {
        if (this.size_for_lds == 0) {
            this.size_for_lds = Util.FDO_get_size(byArray, 12);
            this.align_for_lds = Util.FDO_get_align(byArray, 12);
        }
        return this.size_for_lds;
    }

    protected static Object numericUnpickle80rec(int n2, int n3, UnpickleContext unpickleContext, int n4, int n5, Map map) throws SQLException {
        switch (n4) {
            case 1: {
                if (unpickleContext.is_null(n3)) {
                    return null;
                }
                unpickleContext.skip_to(unpickleContext.m_ldsOffsets[n2]);
                break;
            }
            case 2: {
                if ((unpickleContext.read_byte() & 1) != 1) break;
                unpickleContext.skip_bytes(22);
                return null;
            }
            default: {
                DBError.throwSqlException(1, "format=" + n4);
            }
            case 3: 
        }
        if (n5 == 9) {
            unpickleContext.skip_bytes(22);
            return null;
        }
        return OracleTypeNUMBER.toNumericObject(unpickleContext.read_varNumBytes(), n5, map);
    }

    public void parseTDSrec(StreamInfo streamInfo) throws SQLException {
        this.null_offset = streamInfo.null_offset++;
        this.lds_offset = streamInfo.lds_offset++;
        this.m_precision = streamInfo.readUnsignedByte();
        this.m_scale = streamInfo.readUnsignedByte();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        if (TypeDescriptor.DEBUG_SERIALIZATION) {
            System.out.println("OracleTypeNUMBER::readObject");
        }
        this.m_scale = objectInputStream.readInt();
        this.m_precision = objectInputStream.readInt();
    }

    public Datum toDatum(Object object, OracleConnection oracleConnection) throws SQLException {
        return OracleTypeNUMBER.toNUMBER(object, oracleConnection);
    }

    public Datum[] toDatumArray(Object object, OracleConnection oracleConnection, long l2, int n2) throws SQLException {
        return OracleTypeNUMBER.toNUMBERArray(object, oracleConnection, l2, n2);
    }

    public static NUMBER toNUMBER(Object object, OracleConnection oracleConnection) throws SQLException {
        NUMBER nUMBER;
        block3: {
            nUMBER = null;
            if (object == null) break block3;
            try {
                if (object instanceof NUMBER) {
                    nUMBER = (NUMBER)object;
                    break block3;
                }
                nUMBER = new NUMBER(object);
            }
            catch (SQLException sQLException) {
                DBError.check_error(59, object);
            }
        }
        return nUMBER;
    }

    public static Datum[] toNUMBERArray(Object object, OracleConnection oracleConnection, long l2, int n2) throws SQLException {
        Datum[] datumArray = null;
        if (object != null) {
            if (object instanceof Object[] && !(object instanceof char[][])) {
                Object[] objectArray = (Object[])object;
                int n3 = (int)(n2 == -1 ? (long)objectArray.length : Math.min((long)objectArray.length - l2 + 1L, (long)n2));
                datumArray = new Datum[n3];
                int n4 = 0;
                while (n4 < n3) {
                    datumArray[n4] = OracleTypeNUMBER.toNUMBER(objectArray[(int)l2 + n4 - 1], oracleConnection);
                    ++n4;
                }
            } else {
                datumArray = OracleTypeNUMBER.cArrayToNUMBERArray(object, oracleConnection, l2, n2);
            }
        }
        return datumArray;
    }

    static Object toNumericObject(byte[] byArray, int n2, Map map) throws SQLException {
        if (byArray == null || byArray.length == 0) {
            return null;
        }
        switch (n2) {
            case 1: {
                return new NUMBER(byArray);
            }
            case 2: {
                return NUMBER.toBigDecimal(byArray);
            }
            case 3: {
                return byArray;
            }
        }
        DBError.throwSqlException(23);
        return null;
    }

    protected Object toObject(byte[] byArray, int n2, Map map) throws SQLException {
        return OracleTypeNUMBER.toNumericObject(byArray, n2, map);
    }

    protected static Object unpickle80_nativeArray(UnpickleContext unpickleContext, long l2, int n2, int n3, int n4) throws SQLException {
        int n5 = 0;
        switch (n4) {
            case 2: {
                n5 = 23;
                break;
            }
            case 3: {
                n5 = 22;
                break;
            }
            default: {
                DBError.throwSqlException(1, "format=" + n4);
            }
        }
        if (n2 > 0) {
            unpickleContext.skip_bytes(n5 * ((int)l2 - 1));
        }
        int n6 = unpickleContext.absolute_offset();
        byte[] byArray = unpickleContext.image();
        int n7 = 0;
        switch (n3) {
            case 4: {
                int[] nArray = new int[n2];
                int n8 = 0;
                while (n8 < n2) {
                    n7 = n6 + n8 * n5;
                    if (n4 == 3 || (byArray[n7++] & 1) == 0) {
                        byte[] byArray2 = new byte[byArray[n7++]];
                        System.arraycopy(byArray, n7, byArray2, 0, byArray2.length);
                        nArray[n8] = NUMBER.toInt(byArray2);
                    }
                    ++n8;
                }
                unpickleContext.skip_bytes(n5 * n2);
                return nArray;
            }
            case 5: {
                double[] dArray = new double[n2];
                int n9 = 0;
                while (n9 < n2) {
                    n7 = n6 + n9 * n5;
                    if (n4 == 3 || (byArray[n7++] & 1) == 0) {
                        byte[] byArray3 = new byte[byArray[n7++]];
                        System.arraycopy(byArray, n7, byArray3, 0, byArray3.length);
                        dArray[n9] = NUMBER.toDouble(byArray3);
                    }
                    ++n9;
                }
                unpickleContext.skip_bytes(n5 * n2);
                return dArray;
            }
            case 7: {
                long[] lArray = new long[n2];
                int n10 = 0;
                while (n10 < n2) {
                    n7 = n6 + n10 * n5;
                    if (n4 == 3 || (byArray[n7++] & 1) == 0) {
                        byte[] byArray4 = new byte[byArray[n7++]];
                        System.arraycopy(byArray, n7, byArray4, 0, byArray4.length);
                        lArray[n10] = NUMBER.toLong(byArray4);
                    }
                    ++n10;
                }
                unpickleContext.skip_bytes(n5 * n2);
                return lArray;
            }
            case 6: {
                float[] fArray = new float[n2];
                int n11 = 0;
                while (n11 < n2) {
                    n7 = n6 + n11 * n5;
                    if (n4 == 3 || (byArray[n7++] & 1) == 0) {
                        byte[] byArray5 = new byte[byArray[n7++]];
                        System.arraycopy(byArray, n7, byArray5, 0, byArray5.length);
                        fArray[n11] = NUMBER.toFloat(byArray5);
                    }
                    ++n11;
                }
                unpickleContext.skip_bytes(n5 * n2);
                return fArray;
            }
            case 8: {
                short[] sArray = new short[n2];
                int n12 = 0;
                while (n12 < n2) {
                    n7 = n6 + n12 * n5;
                    if (n4 == 3 || (byArray[n7++] & 1) == 0) {
                        byte[] byArray6 = new byte[byArray[n7++]];
                        System.arraycopy(byArray, n7, byArray6, 0, byArray6.length);
                        sArray[n12] = NUMBER.toShort(byArray6);
                    }
                    ++n12;
                }
                unpickleContext.skip_bytes(n5 * n2);
                return sArray;
            }
        }
        DBError.throwSqlException(23);
        return null;
    }

    protected Object unpickle80rec(UnpickleContext unpickleContext, int n2, int n3, Map map) throws SQLException {
        return OracleTypeNUMBER.numericUnpickle80rec(this.lds_offset, this.null_offset, unpickleContext, n2, n3, map);
    }

    protected static Object unpickle81_nativeArray(PickleContext pickleContext, long l2, int n2, int n3) throws SQLException {
        int n4 = 1;
        while ((long)n4 < l2 && n2 > 0) {
            pickleContext.skipDataValue_pctx();
            ++n4;
        }
        byte[] byArray = null;
        switch (n3) {
            case 4: {
                int[] nArray = new int[n2];
                int n5 = 0;
                while (n5 < n2) {
                    byArray = pickleContext.readDataValue_pctx();
                    if (byArray != null) {
                        nArray[n5] = NUMBER.toInt(byArray);
                    }
                    ++n5;
                }
                return nArray;
            }
            case 5: {
                double[] dArray = new double[n2];
                int n6 = 0;
                while (n6 < n2) {
                    byArray = pickleContext.readDataValue_pctx();
                    if (byArray != null) {
                        dArray[n6] = NUMBER.toDouble(byArray);
                    }
                    ++n6;
                }
                return dArray;
            }
            case 7: {
                long[] lArray = new long[n2];
                int n7 = 0;
                while (n7 < n2) {
                    byArray = pickleContext.readDataValue_pctx();
                    if (byArray != null) {
                        lArray[n7] = NUMBER.toLong(byArray);
                    }
                    ++n7;
                }
                return lArray;
            }
            case 6: {
                float[] fArray = new float[n2];
                int n8 = 0;
                while (n8 < n2) {
                    byArray = pickleContext.readDataValue_pctx();
                    if (byArray != null) {
                        fArray[n8] = NUMBER.toFloat(byArray);
                    }
                    ++n8;
                }
                return fArray;
            }
            case 8: {
                short[] sArray = new short[n2];
                int n9 = 0;
                while (n9 < n2) {
                    byArray = pickleContext.readDataValue_pctx();
                    if (byArray != null) {
                        sArray[n9] = NUMBER.toShort(byArray);
                    }
                    ++n9;
                }
                return sArray;
            }
        }
        DBError.throwSqlException(23);
        return null;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (TypeDescriptor.DEBUG_SERIALIZATION) {
            System.out.println("OracleTypeNUMBER::writeObject");
        }
        objectOutputStream.writeInt(this.m_scale);
        objectOutputStream.writeInt(this.m_precision);
    }
}

