/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Map;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.PickleContext;
import oracle.jdbc.oracore.StreamInfo;
import oracle.jdbc.oracore.UnpickleContext;
import oracle.sql.CHAR;
import oracle.sql.CharacterSet;
import oracle.sql.Datum;
import oracle.sql.TypeDescriptor;

public class OracleTypeCHAR
extends OracleType
implements Serializable {
    static final long serialVersionUID = -6899444518695804629L;
    static boolean DEBUG = false;
    int form;
    int charset;
    int length;
    private transient OracleConnection conn;
    private short pickle_cs_id;
    private transient CharacterSet pickle_cs;
    static final int SQLCS_IMPLICIT = 1;
    static final int SQLCS_NCHAR = 2;
    static final int SQLCS_EXPLICIT = 3;
    static final int SQLCS_FLEXIBLE = 4;
    static final int SQLCS_LIT_NULL = 5;

    protected OracleTypeCHAR() {
    }

    public OracleTypeCHAR(OracleConnection oracleConnection) {
        this.form = 0;
        this.charset = 0;
        this.length = 0;
        this.conn = oracleConnection;
        this.pickle_cs_id = 0;
        this.pickle_cs = null;
        try {
            this.pickle_cs_id = this.conn.getStructAttrCsId();
        }
        catch (SQLException sQLException) {
            if (DEBUG) {
                sQLException.printStackTrace();
            }
            this.pickle_cs_id = (short)-1;
        }
        this.pickle_cs = CharacterSet.make(this.pickle_cs_id);
    }

    protected OracleTypeCHAR(OracleConnection oracleConnection, int n2) {
        super(n2);
        this.form = 0;
        this.charset = 0;
        this.length = 0;
        this.conn = oracleConnection;
        this.pickle_cs_id = 0;
        this.pickle_cs = null;
        try {
            this.pickle_cs_id = this.conn.getStructAttrCsId();
        }
        catch (SQLException sQLException) {
            if (DEBUG) {
                sQLException.printStackTrace();
            }
            this.pickle_cs_id = (short)-1;
        }
        this.pickle_cs = CharacterSet.make(this.pickle_cs_id);
    }

    private Datum[] cArrayToDatumArray(Object object, OracleConnection oracleConnection, long l2, int n2) throws SQLException {
        Datum[] datumArray = null;
        if (object != null) {
            if (object instanceof char[][]) {
                char[][] cArray = (char[][])object;
                int n3 = (int)(n2 == -1 ? (long)cArray.length : Math.min((long)cArray.length - l2 + 1L, (long)n2));
                datumArray = new Datum[n3];
                int n4 = 0;
                while (n4 < n3) {
                    datumArray[n4] = new CHAR(new String(cArray[(int)l2 + n4 - 1]), this.pickle_cs);
                    ++n4;
                }
            } else if (object instanceof boolean[]) {
                boolean[] blArray = (boolean[])object;
                int n5 = (int)(n2 == -1 ? (long)blArray.length : Math.min((long)blArray.length - l2 + 1L, (long)n2));
                datumArray = new Datum[n5];
                int n6 = 0;
                while (n6 < n5) {
                    datumArray[n6] = new CHAR(new Boolean(blArray[(int)l2 + n6 - 1]), this.pickle_cs);
                    ++n6;
                }
            } else if (object instanceof short[]) {
                short[] sArray = (short[])object;
                int n7 = (int)(n2 == -1 ? (long)sArray.length : Math.min((long)sArray.length - l2 + 1L, (long)n2));
                datumArray = new Datum[n7];
                int n8 = 0;
                while (n8 < n7) {
                    datumArray[n8] = new CHAR(new Integer(sArray[(int)l2 + n8 - 1]), this.pickle_cs);
                    ++n8;
                }
            } else if (object instanceof int[]) {
                int[] nArray = (int[])object;
                int n9 = (int)(n2 == -1 ? (long)nArray.length : Math.min((long)nArray.length - l2 + 1L, (long)n2));
                datumArray = new Datum[n9];
                int n10 = 0;
                while (n10 < n9) {
                    datumArray[n10] = new CHAR(new Integer(nArray[(int)l2 + n10 - 1]), this.pickle_cs);
                    ++n10;
                }
            } else if (object instanceof long[]) {
                long[] lArray = (long[])object;
                int n11 = (int)(n2 == -1 ? (long)lArray.length : Math.min((long)lArray.length - l2 + 1L, (long)n2));
                datumArray = new Datum[n11];
                int n12 = 0;
                while (n12 < n11) {
                    datumArray[n12] = new CHAR(new Long(lArray[(int)l2 + n12 - 1]), this.pickle_cs);
                    ++n12;
                }
            } else if (object instanceof float[]) {
                float[] fArray = (float[])object;
                int n13 = (int)(n2 == -1 ? (long)fArray.length : Math.min((long)fArray.length - l2 + 1L, (long)n2));
                datumArray = new Datum[n13];
                int n14 = 0;
                while (n14 < n13) {
                    datumArray[n14] = new CHAR(new Float(fArray[(int)l2 + n14 - 1]), this.pickle_cs);
                    ++n14;
                }
            } else if (object instanceof double[]) {
                double[] dArray = (double[])object;
                int n15 = (int)(n2 == -1 ? (long)dArray.length : Math.min((long)dArray.length - l2 + 1L, (long)n2));
                datumArray = new Datum[n15];
                int n16 = 0;
                while (n16 < n15) {
                    datumArray[n16] = new CHAR(new Double(dArray[(int)l2 + n16 - 1]), this.pickle_cs);
                    ++n16;
                }
            } else {
                DBError.check_error(59, object);
            }
        }
        return datumArray;
    }

    private CHAR getDbCHAR(Datum datum) {
        CHAR cHAR = (CHAR)datum;
        CHAR cHAR2 = null;
        if (cHAR.getCharacterSet().getOracleId() == this.pickle_cs_id) {
            cHAR2 = cHAR;
        } else {
            try {
                byte[] byArray = this.pickle_cs.convert(cHAR.getCharacterSet(), cHAR.getBytes(), 0, (int)cHAR.getLength());
                cHAR2 = new CHAR(byArray, this.pickle_cs);
            }
            catch (SQLException sQLException) {
                if (DEBUG) {
                    sQLException.printStackTrace();
                }
                cHAR2 = cHAR;
            }
        }
        return cHAR2;
    }

    public int getLength() {
        return this.length;
    }

    public void parseTDSrec(StreamInfo streamInfo) throws SQLException {
        super.parseTDSrec(streamInfo);
        try {
            this.length = streamInfo.readShort();
            this.form = streamInfo.readByte();
            this.charset = streamInfo.readShort();
        }
        catch (SQLException sQLException) {
            DBError.check_error(47, "parseTDS");
        }
    }

    protected int pickle81(PickleContext pickleContext, Datum datum) throws SQLException {
        if (((CHAR)datum).getString().length() > this.length) {
            DBError.check_error(72, "\"" + ((CHAR)datum).getString() + "\"");
        }
        return super.pickle81(pickleContext, this.getDbCHAR(datum));
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        if (TypeDescriptor.DEBUG_SERIALIZATION) {
            System.out.println("OracleTypeCHAR::readObject");
        }
        this.form = objectInputStream.readInt();
        this.charset = objectInputStream.readInt();
        this.length = objectInputStream.readInt();
        this.pickle_cs_id = objectInputStream.readShort();
        this.pickle_cs = CharacterSet.make(this.pickle_cs_id);
    }

    public void setConnection(OracleConnection oracleConnection) throws SQLException {
        this.conn = oracleConnection;
    }

    public Datum toDatum(Object object, OracleConnection oracleConnection) throws SQLException {
        if (object == null) {
            return null;
        }
        CHAR cHAR = object instanceof CHAR ? (CHAR)object : new CHAR(object, this.pickle_cs);
        return cHAR;
    }

    public Datum[] toDatumArray(Object object, OracleConnection oracleConnection, long l2, int n2) throws SQLException {
        Datum[] datumArray = null;
        if (object != null) {
            if (object instanceof Object[] && !(object instanceof char[][])) {
                return super.toDatumArray(object, oracleConnection, l2, n2);
            }
            datumArray = this.cArrayToDatumArray(object, oracleConnection, l2, n2);
        }
        return datumArray;
    }

    protected Object toObject(byte[] byArray, int n2, Map map) throws SQLException {
        if (byArray == null || byArray.length == 0) {
            return null;
        }
        CHAR cHAR = null;
        switch (this.form) {
            case 1: {
                cHAR = new CHAR(byArray, this.pickle_cs);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                cHAR = new CHAR(byArray, null);
                break;
            }
        }
        if (n2 == 1) {
            return cHAR;
        }
        if (n2 == 2) {
            return cHAR.stringValue();
        }
        if (n2 == 3) {
            return byArray;
        }
        DBError.check_error(59, byArray);
        return null;
    }

    protected Object unpickle80rec(UnpickleContext unpickleContext, int n2, int n3, Map map) throws SQLException {
        switch (n2) {
            case 1: {
                if (unpickleContext.is_null(this.null_offset)) {
                    return null;
                }
                unpickleContext.skip_to(unpickleContext.m_ldsOffsets[this.lds_offset]);
                if (n3 == 9) {
                    unpickleContext.skip_bytes(6);
                    return null;
                }
                long l2 = unpickleContext.read_long();
                if (l2 == 0L) {
                    unpickleContext.skip_bytes(2);
                    unpickleContext.mark();
                } else {
                    unpickleContext.markAndSkip(l2);
                }
                byte[] byArray = unpickleContext.read_lengthBytes();
                unpickleContext.reset();
                return this.toObject(byArray, n3, map);
            }
            case 2: {
                if ((unpickleContext.read_byte() & 1) == 1) {
                    unpickleContext.skip_bytes(4);
                    return null;
                }
            }
            case 3: {
                if (n3 == 9) {
                    unpickleContext.skip_lengthBytes();
                    return null;
                }
                return this.toObject(unpickleContext.read_lengthBytes(), n3, map);
            }
        }
        DBError.throwSqlException(1, "format=" + n2);
        return null;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (TypeDescriptor.DEBUG_SERIALIZATION) {
            System.out.println("OracleTypeCHAR::writeObject");
        }
        objectOutputStream.writeInt(this.form);
        objectOutputStream.writeInt(this.charset);
        objectOutputStream.writeInt(this.length);
        objectOutputStream.writeShort(this.pickle_cs_id);
    }
}

