/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Map;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.oracore.PickleContext;
import oracle.jdbc.oracore.StreamInfo;
import oracle.jdbc.oracore.UnpickleContext;
import oracle.jdbc.oracore.Util;
import oracle.sql.Datum;
import oracle.sql.StructDescriptor;
import oracle.sql.TypeDescriptor;

public abstract class OracleType
implements Serializable {
    static final long serialVersionUID = -6719430495533003861L;
    static final int STYLE_ARRAY_LENGTH = 0;
    static final int STYLE_DATUM = 1;
    static final int STYLE_JAVA = 2;
    static final int STYLE_RAWBYTE = 3;
    static final int STYLE_INT = 4;
    static final int STYLE_DOUBLE = 5;
    static final int STYLE_FLOAT = 6;
    static final int STYLE_LONG = 7;
    static final int STYLE_SHORT = 8;
    static final int STYLE_SKIP = 9;
    static final int FORMAT_ADT_ATTR = 1;
    static final int FORMAT_COLL_ELEM = 2;
    static final int FORMAT_COLL_ELEM_NO_INDICATOR = 3;
    int null_offset = 0;
    int lds_offset = 0;
    int size_for_lds = 0;
    int align_for_lds;
    int m_typeCode;
    int m_dbtypeCode;
    static final int KOPMAP_FLOAT = 2;
    static final int KOPMAP_SB4 = 4;
    static final int KOPMAP_PTR = 5;
    static final int KOPMAP_ORLD = 11;
    static final int KOPMAP_ORLN = 12;

    public OracleType() {
    }

    public OracleType(int n2) {
        this();
        this.m_typeCode = n2;
    }

    public int getAlignLDS(byte[] byArray) {
        if (this.size_for_lds == 0) {
            this.size_for_lds = Util.FDO_get_size(byArray, 5);
            this.align_for_lds = Util.FDO_get_align(byArray, 5);
        }
        return this.align_for_lds;
    }

    public int getDBTypeCode() throws SQLException {
        return this.m_dbtypeCode;
    }

    public int getSizeLDS(byte[] byArray) {
        if (this.size_for_lds == 0) {
            this.size_for_lds = Util.FDO_get_size(byArray, 5);
            this.align_for_lds = Util.FDO_get_align(byArray, 5);
        }
        return this.size_for_lds;
    }

    public int getTypeCode() throws SQLException {
        return this.m_typeCode;
    }

    public TypeDescriptor getTypeDescriptor() {
        return null;
    }

    public boolean isInHierarchyOf(OracleType oracleType) throws SQLException {
        return false;
    }

    public boolean isInHierarchyOf(StructDescriptor structDescriptor) throws SQLException {
        return false;
    }

    public boolean isObjectType() {
        return false;
    }

    public void parseTDSrec(StreamInfo streamInfo) throws SQLException {
        this.null_offset = streamInfo.null_offset++;
        this.lds_offset = streamInfo.lds_offset++;
    }

    protected int pickle81(PickleContext pickleContext, Datum datum) throws SQLException {
        int n2 = pickleContext.writeLength_pctx((int)datum.getLength());
        return n2 += pickleContext.write_data_pctx(datum.shareBytes());
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        if (TypeDescriptor.DEBUG_SERIALIZATION) {
            System.out.println("OracleType::readObject");
        }
        this.null_offset = objectInputStream.readInt();
        this.lds_offset = objectInputStream.readInt();
        this.size_for_lds = objectInputStream.readInt();
        this.align_for_lds = objectInputStream.readInt();
        this.m_typeCode = objectInputStream.readInt();
        this.m_dbtypeCode = objectInputStream.readInt();
    }

    void readSerializedFields(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.null_offset = objectInputStream.readInt();
        this.lds_offset = objectInputStream.readInt();
        this.size_for_lds = objectInputStream.readInt();
        this.align_for_lds = objectInputStream.readInt();
        this.m_typeCode = objectInputStream.readInt();
        this.m_dbtypeCode = objectInputStream.readInt();
    }

    public void setConnection(OracleConnection oracleConnection) throws SQLException {
    }

    public void setDBTypeCode(int n2) {
        this.m_dbtypeCode = n2;
    }

    public void setTypeCode(int n2) {
        this.m_typeCode = n2;
    }

    public abstract Datum toDatum(Object var1, OracleConnection var2) throws SQLException;

    public Datum[] toDatumArray(Object object, OracleConnection oracleConnection, long l2, int n2) throws SQLException {
        Datum[] datumArray = null;
        if (object != null) {
            if (object instanceof Object[]) {
                Object[] objectArray = (Object[])object;
                int n3 = (int)(n2 == -1 ? (long)objectArray.length : Math.min((long)objectArray.length - l2 + 1L, (long)n2));
                datumArray = new Datum[n3];
                int n4 = 0;
                while (n4 < n3) {
                    datumArray[n4] = this.toDatum(objectArray[(int)l2 + n4 - 1], oracleConnection);
                    ++n4;
                }
            } else {
                DBError.check_error(59, object);
            }
        }
        return datumArray;
    }

    protected Object toObject(byte[] byArray, int n2, Map map) throws SQLException {
        return null;
    }

    protected abstract Object unpickle80rec(UnpickleContext var1, int var2, int var3, Map var4) throws SQLException;

    protected Object unpickle81rec(PickleContext pickleContext, byte by, int n2, Map map) throws SQLException {
        if (n2 == 9) {
            pickleContext.skipDataValue_pctx();
            return null;
        }
        byte[] byArray = pickleContext.readDataValue_pctx(by);
        return this.toObject(byArray, n2, map);
    }

    protected Object unpickle81rec(PickleContext pickleContext, int n2, Map map) throws SQLException {
        if (n2 == 9) {
            pickleContext.skipDataValue_pctx();
            return null;
        }
        byte[] byArray = pickleContext.readDataValue_pctx();
        return this.toObject(byArray, n2, map);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (TypeDescriptor.DEBUG_SERIALIZATION) {
            System.out.println("OracleType::writeObject");
        }
        objectOutputStream.writeInt(this.null_offset);
        objectOutputStream.writeInt(this.lds_offset);
        objectOutputStream.writeInt(this.size_for_lds);
        objectOutputStream.writeInt(this.align_for_lds);
        objectOutputStream.writeInt(this.m_typeCode);
        objectOutputStream.writeInt(this.m_dbtypeCode);
    }

    void writeSerializedFields(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(this.null_offset);
        objectOutputStream.writeInt(this.lds_offset);
        objectOutputStream.writeInt(this.size_for_lds);
        objectOutputStream.writeInt(this.align_for_lds);
        objectOutputStream.writeInt(this.m_typeCode);
        objectOutputStream.writeInt(this.m_dbtypeCode);
    }
}

