/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oci8;

import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBData;
import oracle.jdbc.dbaccess.DBDataSet;
import oracle.jdbc.dbaccess.DBDataSetImpl;
import oracle.jdbc.dbaccess.DBType;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.oci8.OCIDBItem;
import oracle.jdbc.oci8.OCIDBType;
import oracle.sql.Datum;
import oracle.sql.NUMBER;
import oracle.sql.SQLUtil;

public class OCIDBDataSet
extends DBDataSetImpl {
    private short _versionNum = 0;

    public OCIDBDataSet(OracleConnection oracleConnection, OracleStatement oracleStatement, int n2, int n3, short s2) {
        super(oracleConnection, oracleStatement, n2, n3);
        this._versionNum = s2;
    }

    public int checkPlsqlIndexTableBindTypes(DBDataSet dBDataSet, int n2, int n3, int n4, int n5) throws SQLException {
        if (this.m_first_row) {
            return 0;
        }
        OCIDBType oCIDBType = (OCIDBType)((DBDataSetImpl)dBDataSet).getDBTypes()[n2];
        if (oCIDBType.element_type_plsqlindextable != n5 || oCIDBType.max_length_plsqlindextable != n3 || oCIDBType.max_length != n4) {
            return -1;
        }
        return 0;
    }

    public Datum[] getPlsqlIndexTableItem(int n2, int n3) throws SQLException {
        DBData[] dBDataArray = this.getDBData();
        DBType[] dBTypeArray = this.getDBTypes();
        int n4 = this.getPlsqlIndexTableType(n2);
        OCIDBItem oCIDBItem = (OCIDBItem)dBDataArray[n2].getItem(n3);
        Datum[] datumArray = new Datum[oCIDBItem.cur_length_plsqlindextable];
        int n5 = 0;
        while (n5 < oCIDBItem.cur_length_plsqlindextable) {
            switch (n4) {
                case 2: 
                case 6: {
                    datumArray[n5] = new NUMBER((byte[])oCIDBItem.indextable_value[n5]);
                    break;
                }
                default: {
                    datumArray[n5] = SQLUtil.makeDatum(this.m_connection, (byte[])oCIDBItem.indextable_value[n5], n4, null, 0);
                    break;
                }
            }
            ++n5;
        }
        return datumArray;
    }

    public int getPlsqlIndexTableType(int n2) throws SQLException {
        return ((OCIDBType)this.getDBTypes()[n2]).element_type_plsqlindextable;
    }

    public boolean setPlsqlIndexTableItem(int n2, int n3, Datum[] datumArray, int n4, int n5, int n6, int n7) throws SQLException {
        OCIDBType oCIDBType = (OCIDBType)this._createOrGetBindDBType(n2, 998);
        if (this.m_first_row) {
            oCIDBType.setPlsqlIndexTableTypeFields(n4, n7, n6, this._versionNum);
            this._setBindDBType(n2, oCIDBType);
        }
        OCIDBItem oCIDBItem = (OCIDBItem)this._createOrGetDBItem(n2, oCIDBType, n3);
        oCIDBItem.setPlsqlIndexTableItemFields(datumArray, n5, oCIDBType);
        this._setBindDBItem(n2, oCIDBItem);
        return true;
    }

    public void setPlsqlIndexTableType(int n2, int n3, int n4, int n5) throws SQLException {
        OCIDBType oCIDBType = (OCIDBType)this._createOrGetBindDBType(n2, 998);
        oCIDBType.setPlsqlIndexTableTypeFields(n3, n4, n5, this._versionNum);
        this._setBindDBType(n2, oCIDBType);
    }
}

