/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import oracle.jdbc.dbaccess.DBConversion;
import oracle.jdbc.dbaccess.DBDataSet;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.BaseResultSet;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.OracleResultSet;
import oracle.jdbc.driver.OracleResultSetImpl;
import oracle.jdbc.driver.OracleResultSetMetaData;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.ScrollRsetStatement;
import oracle.jdbc.driver.ScrollableResultSet;
import oracle.sql.ARRAY;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.CustomDatum;
import oracle.sql.CustomDatumFactory;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.NUMBER;
import oracle.sql.OPAQUE;
import oracle.sql.ORAData;
import oracle.sql.ORADataFactory;
import oracle.sql.RAW;
import oracle.sql.REF;
import oracle.sql.ROWID;
import oracle.sql.SQLUtil;
import oracle.sql.STRUCT;

public class UpdatableResultSet
extends BaseResultSet {
    static boolean DEBUG = false;
    static final int s_concurrencyType = 1008;
    static final int s_beginColumnIndex = 1;
    OracleConnection m_conn;
    OracleResultSet m_rset;
    boolean m_isCachedRset;
    ScrollRsetStatement m_scrollStmt;
    ResultSetMetaData m_metadata;
    private int m_type;
    private int m_columnCount;
    private OraclePreparedStatement m_deleteStmt;
    private OraclePreparedStatement m_insertStmt;
    private String m_updateSql1;
    private String m_updateSql2;
    private OraclePreparedStatement m_updateStmt;
    private int[] m_idxColsChanged;
    private Object[] m_rowBuffer;
    private boolean[] m_nullIndicator;
    private int[][] m_typeInfo;
    private boolean m_isInserting;
    private boolean m_isUpdating;
    private int m_wasNull;
    private static final int VALUE_NULL = 1;
    private static final int VALUE_NOT_NULL = 2;
    private static final int VALUE_UNKNOWN = 3;
    private static final int VALUE_IN_RSET = 4;
    private static final int ASCII_STREAM = 1;
    private static final int BINARY_STREAM = 2;
    private static final int UNICODE_STREAM = 3;
    private static int _MIN_STREAM_SIZE = 4000;

    public UpdatableResultSet(ScrollRsetStatement scrollRsetStatement, OracleResultSetImpl oracleResultSetImpl, int n2, int n3) throws SQLException {
        this.init(scrollRsetStatement, oracleResultSetImpl, n2, n3);
        this.m_isCachedRset = false;
    }

    public UpdatableResultSet(ScrollRsetStatement scrollRsetStatement, ScrollableResultSet scrollableResultSet, int n2, int n3) throws SQLException {
        this.init(scrollRsetStatement, scrollableResultSet, n2, n3);
        scrollableResultSet.resetBeginColumnIndex();
        this.m_isCachedRset = true;
    }

    public synchronized boolean absolute(int n2) throws SQLException {
        this.cancelRowChanges();
        return this.m_rset.absolute(n2);
    }

    public synchronized void afterLast() throws SQLException {
        this.cancelRowChanges();
        this.m_rset.afterLast();
    }

    public synchronized void beforeFirst() throws SQLException {
        this.cancelRowChanges();
        this.m_rset.beforeFirst();
    }

    private void cancelRowChanges() throws SQLException {
        if (this.m_isInserting) {
            this.cancelRowInserts();
        }
        if (this.m_isUpdating) {
            this.cancelRowUpdates();
        }
    }

    private void cancelRowInserts() {
        if (this.m_isInserting) {
            this.m_isInserting = false;
            this.clearRowBuffer();
        }
    }

    public synchronized void cancelRowUpdates() throws SQLException {
        if (this.m_isUpdating) {
            this.m_isUpdating = false;
            this.clearRowBuffer();
        }
    }

    private void clearRowBuffer() {
        int n2;
        if (this.m_rowBuffer != null) {
            n2 = 0;
            while (n2 < this.m_rowBuffer.length) {
                this.m_rowBuffer[n2] = null;
                ++n2;
            }
        }
        if (this.m_nullIndicator != null) {
            n2 = 0;
            while (n2 < this.m_nullIndicator.length) {
                this.m_nullIndicator[n2] = false;
                ++n2;
            }
        }
        if (this.m_typeInfo != null) {
            n2 = 0;
            while (n2 < this.m_typeInfo.length) {
                if (this.m_typeInfo[n2] != null) {
                    int n3 = 0;
                    while (n3 < this.m_typeInfo[n2].length) {
                        this.m_typeInfo[n2][n3] = 0;
                        ++n3;
                    }
                }
                ++n2;
            }
        }
    }

    public void clearWarnings() throws SQLException {
        this.m_warning = null;
        this.m_rset.clearWarnings();
    }

    public synchronized void close() throws SQLException {
        if (this.m_rset != null) {
            this.m_rset.close();
        }
        if (this.m_insertStmt != null) {
            this.m_insertStmt.close();
        }
        if (this.m_updateStmt != null) {
            this.m_updateStmt.close();
        }
        if (this.m_deleteStmt != null) {
            this.m_deleteStmt.close();
        }
        if (this.m_scrollStmt != null) {
            this.m_scrollStmt.notify_close_rset();
        }
        this.cancelRowInserts();
        this.m_conn = null;
        this.m_rset = null;
        this.m_scrollStmt = null;
        this.m_metadata = null;
        this.m_scrollStmt = null;
        this.m_deleteStmt = null;
        this.m_insertStmt = null;
        this.m_updateSql1 = null;
        this.m_updateSql2 = null;
        this.m_updateStmt = null;
        this.m_idxColsChanged = null;
        this.m_rowBuffer = null;
        this.m_nullIndicator = null;
        this.m_typeInfo = null;
    }

    public synchronized void deleteRow() throws SQLException {
        if (this.isOnInsertRow()) {
            DBError.throwSqlException(84);
        }
        this.prepare_deleteRow_statement();
        this.prepare_deleteRow_binds();
        this.execute_deleteRow();
    }

    private void execute_deleteRow() throws SQLException {
        if (this.m_deleteStmt.executeUpdate() == 0) {
            DBError.throwSqlException(85);
        }
        if (this.m_isCachedRset) {
            ((ScrollableResultSet)this.m_rset).removeRowInCache(this.getRow());
        }
    }

    private void execute_insertRow() throws SQLException {
        if (this.m_insertStmt.executeUpdate() != 1) {
            DBError.throwSqlException(85);
        }
    }

    private void execute_updateRow() throws SQLException {
        block7: {
            try {
                if (this.m_updateStmt.executeUpdate() == 0) {
                    DBError.throwSqlException(85);
                }
                if (!this.m_isCachedRset) break block7;
                if (this.m_autoRefetch) {
                    ((ScrollableResultSet)this.m_rset).refreshRowsInCache(this.getRow(), 1, 1000);
                    this.cancelRowUpdates();
                    break block7;
                }
                if (this.m_rowBuffer != null) {
                    int n2 = 1;
                    while (n2 < this.getColumnCount()) {
                        if (this.m_rowBuffer[n2] != null || this.m_rowBuffer[n2] == null && this.m_nullIndicator[n2]) {
                            ((ScrollableResultSet)this.m_rset).setCurrentRowValueAt(this, n2 + 1, this.m_rowBuffer[n2]);
                        }
                        ++n2;
                    }
                }
                this.cancelRowUpdates();
            }
            catch (Throwable throwable) {
                Object var2_3 = null;
                this.m_updateStmt.close();
                this.m_updateStmt = null;
                throw throwable;
            }
        }
        Object var2_2 = null;
        this.m_updateStmt.close();
        this.m_updateStmt = null;
    }

    public synchronized int findColumn(String string) throws SQLException {
        return this.m_rset.findColumn(string) - 1;
    }

    public synchronized boolean first() throws SQLException {
        this.cancelRowChanges();
        return this.m_rset.first();
    }

    public synchronized ARRAY getARRAY(int n2) throws SQLException {
        ARRAY aRRAY = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
            Datum datum = this.getRowBufferDatumAt(n2);
            this.setIsNull(datum == null);
            if (datum != null && !(datum instanceof ARRAY)) {
                DBError.check_error(4, "getARRAY");
            }
            aRRAY = (ARRAY)datum;
        } else {
            this.setIsNull(4);
            aRRAY = this.m_rset.getARRAY(n2 + 1);
        }
        return aRRAY;
    }

    public synchronized Array getArray(int n2) throws SQLException {
        return this.getARRAY(n2);
    }

    public synchronized InputStream getAsciiStream(int n2) throws SQLException {
        InputStream inputStream = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
            Object object = this.getRowBufferAt(n2);
            this.setIsNull(object == null);
            if (object != null) {
                if (object instanceof InputStream) {
                    inputStream = (InputStream)object;
                } else {
                    Datum datum = this.getRowBufferDatumAt(n2);
                    inputStream = datum.asciiStreamValue();
                }
            }
        } else {
            this.setIsNull(4);
            inputStream = this.m_rset.getAsciiStream(n2 + 1);
        }
        return inputStream;
    }

    public synchronized BFILE getBFILE(int n2) throws SQLException {
        BFILE bFILE = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
            Datum datum = this.getRowBufferDatumAt(n2);
            this.setIsNull(datum == null);
            if (datum != null && !(datum instanceof BFILE)) {
                DBError.check_error(4, "getBFILE");
            }
            bFILE = (BFILE)datum;
        } else {
            this.setIsNull(4);
            bFILE = this.m_rset.getBFILE(n2 + 1);
        }
        return bFILE;
    }

    public synchronized BLOB getBLOB(int n2) throws SQLException {
        BLOB bLOB = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
            Datum datum = this.getRowBufferDatumAt(n2);
            this.setIsNull(datum == null);
            if (datum != null && !(datum instanceof BLOB)) {
                DBError.check_error(4, "getBLOB");
            }
            bLOB = (BLOB)datum;
        } else {
            this.setIsNull(4);
            bLOB = this.m_rset.getBLOB(n2 + 1);
        }
        return bLOB;
    }

    public synchronized BFILE getBfile(int n2) throws SQLException {
        return this.getBFILE(n2);
    }

    public synchronized BigDecimal getBigDecimal(int n2) throws SQLException {
        BigDecimal bigDecimal = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
            Datum datum = this.getRowBufferDatumAt(n2);
            this.setIsNull(datum == null);
            if (datum != null) {
                bigDecimal = datum.bigDecimalValue();
            }
        } else {
            this.setIsNull(4);
            bigDecimal = this.m_rset.getBigDecimal(n2 + 1);
        }
        return bigDecimal;
    }

    public synchronized BigDecimal getBigDecimal(int n2, int n3) throws SQLException {
        BigDecimal bigDecimal = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
            Datum datum = this.getRowBufferDatumAt(n2);
            this.setIsNull(datum == null);
            if (datum != null) {
                bigDecimal = datum.bigDecimalValue();
            }
        } else {
            this.setIsNull(4);
            bigDecimal = this.m_rset.getBigDecimal(n2 + 1);
        }
        return bigDecimal;
    }

    public synchronized InputStream getBinaryStream(int n2) throws SQLException {
        InputStream inputStream = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
            Object object = this.getRowBufferAt(n2);
            this.setIsNull(object == null);
            if (object != null) {
                if (object instanceof InputStream) {
                    inputStream = (InputStream)object;
                } else {
                    Datum datum = this.getRowBufferDatumAt(n2);
                    inputStream = datum.binaryStreamValue();
                }
            }
        } else {
            this.setIsNull(4);
            inputStream = this.m_rset.getBinaryStream(n2 + 1);
        }
        return inputStream;
    }

    public synchronized Blob getBlob(int n2) throws SQLException {
        return this.getBLOB(n2);
    }

    public synchronized boolean getBoolean(int n2) throws SQLException {
        boolean bl = false;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
            Datum datum = this.getRowBufferDatumAt(n2);
            this.setIsNull(datum == null);
            if (datum != null) {
                bl = datum.booleanValue();
            }
        } else {
            this.setIsNull(4);
            bl = this.m_rset.getBoolean(n2 + 1);
        }
        return bl;
    }

    public synchronized byte getByte(int n2) throws SQLException {
        byte by = 0;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
            Datum datum = this.getRowBufferDatumAt(n2);
            this.setIsNull(datum == null);
            if (datum != null) {
                by = datum.byteValue();
            }
        } else {
            this.setIsNull(4);
            by = this.m_rset.getByte(n2 + 1);
        }
        return by;
    }

    public synchronized byte[] getBytes(int n2) throws SQLException {
        byte[] byArray = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
            Datum datum = this.getRowBufferDatumAt(n2);
            this.setIsNull(datum == null);
            if (datum != null) {
                byArray = datum.getBytes();
            }
        } else {
            this.setIsNull(4);
            byArray = this.m_rset.getBytes(n2 + 1);
        }
        return byArray;
    }

    public synchronized CHAR getCHAR(int n2) throws SQLException {
        CHAR cHAR = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
            Datum datum = this.getRowBufferDatumAt(n2);
            this.setIsNull(datum == null);
            if (datum != null && !(datum instanceof CHAR)) {
                DBError.check_error(4, "getCHAR");
            }
            cHAR = (CHAR)datum;
        } else {
            this.setIsNull(4);
            cHAR = this.m_rset.getCHAR(n2 + 1);
        }
        return cHAR;
    }

    public synchronized CLOB getCLOB(int n2) throws SQLException {
        CLOB cLOB = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
            Datum datum = this.getRowBufferDatumAt(n2);
            this.setIsNull(datum == null);
            if (datum != null && !(datum instanceof CLOB)) {
                DBError.check_error(4, "getCLOB");
            }
            cLOB = (CLOB)datum;
        } else {
            this.setIsNull(4);
            cLOB = this.m_rset.getCLOB(n2 + 1);
        }
        return cLOB;
    }

    public synchronized Reader getCharacterStream(int n2) throws SQLException {
        Reader reader = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
            Object object = this.getRowBufferAt(n2);
            this.setIsNull(object == null);
            if (object != null) {
                if (object instanceof Reader) {
                    reader = (Reader)object;
                } else {
                    Datum datum = this.getRowBufferDatumAt(n2);
                    reader = datum.characterStreamValue();
                }
            }
        } else {
            this.setIsNull(4);
            reader = this.m_rset.getCharacterStream(n2 + 1);
        }
        return reader;
    }

    public synchronized Clob getClob(int n2) throws SQLException {
        return this.getCLOB(n2);
    }

    private int getColumnCount() throws SQLException {
        if (this.m_columnCount == 0) {
            this.m_columnCount = this.m_rset instanceof OracleResultSetImpl ? (((OracleResultSetImpl)this.m_rset).statement.defines != null ? ((OracleResultSetImpl)this.m_rset).statement.defines.getNoOfArgs() : this.getInternalMetadata().getColumnCount()) : ((ScrollableResultSet)this.m_rset).getColumnCount();
        }
        return this.m_columnCount;
    }

    public int getConcurrency() throws SQLException {
        return 1008;
    }

    public synchronized ResultSet getCursor(int n2) throws SQLException {
        ResultSet resultSet = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
            Datum datum = this.getOracleObject(n2);
            this.setIsNull(datum == null);
            DBError.check_error(4, "getCursor");
        } else {
            this.setIsNull(4);
            resultSet = this.m_rset.getCursor(n2 + 1);
        }
        return resultSet;
    }

    public synchronized CustomDatum getCustomDatum(int n2, CustomDatumFactory customDatumFactory) throws SQLException {
        if (customDatumFactory == null) {
            DBError.throwSqlException(68);
        }
        CustomDatum customDatum = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
            Datum datum = this.getRowBufferDatumAt(n2);
            this.setIsNull(datum == null);
            customDatum = customDatumFactory.create(datum, 0);
        } else {
            this.setIsNull(4);
            customDatum = this.m_rset.getCustomDatum(n2 + 1, customDatumFactory);
        }
        return customDatum;
    }

    public synchronized DATE getDATE(int n2) throws SQLException {
        DATE dATE = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
            Datum datum = this.getRowBufferDatumAt(n2);
            this.setIsNull(datum == null);
            if (datum != null && !(datum instanceof DATE)) {
                DBError.check_error(4, "getDATE");
            }
            dATE = (DATE)datum;
        } else {
            this.setIsNull(4);
            dATE = this.m_rset.getDATE(n2 + 1);
        }
        return dATE;
    }

    public synchronized Date getDate(int n2) throws SQLException {
        Date date = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
            Datum datum = this.getRowBufferDatumAt(n2);
            this.setIsNull(datum == null);
            if (datum != null) {
                date = datum.dateValue();
            }
        } else {
            this.setIsNull(4);
            date = this.m_rset.getDate(n2 + 1);
        }
        return date;
    }

    public synchronized Date getDate(int n2, Calendar calendar) throws SQLException {
        Date date = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
            Datum datum = this.getOracleObject(n2);
            this.setIsNull(datum == null);
            if (datum != null) {
                if (datum instanceof DATE) {
                    date = ((DATE)datum).dateValue(calendar);
                } else {
                    DATE dATE = new DATE(datum.stringValue());
                    if (dATE != null) {
                        date = dATE.dateValue(calendar);
                    }
                }
            }
        } else {
            this.setIsNull(4);
            date = this.m_rset.getDate(n2 + 1, calendar);
        }
        return date;
    }

    public synchronized double getDouble(int n2) throws SQLException {
        double d2 = 0.0;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
            Datum datum = this.getRowBufferDatumAt(n2);
            this.setIsNull(datum == null);
            if (datum != null) {
                d2 = datum.doubleValue();
            }
        } else {
            this.setIsNull(4);
            d2 = this.m_rset.getDouble(n2 + 1);
        }
        return d2;
    }

    public synchronized int getFetchDirection() throws SQLException {
        return this.m_rset.getFetchDirection();
    }

    public synchronized int getFetchSize() throws SQLException {
        return this.m_rset.getFetchSize();
    }

    public int getFirstUserColumnIndex() {
        return 1;
    }

    public synchronized float getFloat(int n2) throws SQLException {
        float f2 = 0.0f;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
            Datum datum = this.getRowBufferDatumAt(n2);
            this.setIsNull(datum == null);
            if (datum != null) {
                f2 = datum.floatValue();
            }
        } else {
            this.setIsNull(4);
            f2 = this.m_rset.getFloat(n2 + 1);
        }
        return f2;
    }

    public synchronized int getInt(int n2) throws SQLException {
        int n3 = 0;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
            Datum datum = this.getRowBufferDatumAt(n2);
            this.setIsNull(datum == null);
            if (datum != null) {
                n3 = datum.intValue();
            }
        } else {
            this.setIsNull(4);
            n3 = this.m_rset.getInt(n2 + 1);
        }
        return n3;
    }

    private ResultSetMetaData getInternalMetadata() throws SQLException {
        if (this.m_metadata == null) {
            this.m_metadata = this.m_rset.getMetaData();
        }
        return this.m_metadata;
    }

    public synchronized long getLong(int n2) throws SQLException {
        long l2 = 0L;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
            Datum datum = this.getRowBufferDatumAt(n2);
            this.setIsNull(datum == null);
            if (datum != null) {
                l2 = datum.longValue();
            }
        } else {
            this.setIsNull(4);
            l2 = this.m_rset.getLong(n2 + 1);
        }
        return l2;
    }

    public synchronized ResultSetMetaData getMetaData() throws SQLException {
        if (((OracleStatement)this.m_scrollStmt).closed) {
            DBError.check_error(9, "getMetaData");
        }
        return new OracleResultSetMetaData(this.m_conn, (OracleStatement)this.m_scrollStmt, 1);
    }

    public synchronized NUMBER getNUMBER(int n2) throws SQLException {
        NUMBER nUMBER = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
            Datum datum = this.getRowBufferDatumAt(n2);
            this.setIsNull(datum == null);
            if (datum != null && !(datum instanceof NUMBER)) {
                DBError.check_error(4, "getNUMBER");
            }
            nUMBER = (NUMBER)datum;
        } else {
            this.setIsNull(4);
            nUMBER = this.m_rset.getNUMBER(n2 + 1);
        }
        return nUMBER;
    }

    public synchronized OPAQUE getOPAQUE(int n2) throws SQLException {
        OPAQUE oPAQUE = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
            Datum datum = this.getRowBufferDatumAt(n2);
            this.setIsNull(datum == null);
            if (datum != null && !(datum instanceof OPAQUE)) {
                DBError.check_error(4, "getOPAQUE");
            }
            oPAQUE = (OPAQUE)datum;
        } else {
            this.setIsNull(4);
            oPAQUE = this.m_rset.getOPAQUE(n2 + 1);
        }
        return oPAQUE;
    }

    public synchronized ORAData getORAData(int n2, ORADataFactory oRADataFactory) throws SQLException {
        if (oRADataFactory == null) {
            DBError.throwSqlException(68);
        }
        ORAData oRAData = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
            Datum datum = this.getRowBufferDatumAt(n2);
            this.setIsNull(datum == null);
            oRAData = oRADataFactory.create(datum, 0);
        } else {
            this.setIsNull(4);
            oRAData = this.m_rset.getORAData(n2 + 1, oRADataFactory);
        }
        return oRAData;
    }

    public synchronized Object getObject(int n2) throws SQLException {
        Object object = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
            Datum datum = this.getOracleObject(n2);
            this.setIsNull(datum == null);
            if (datum != null) {
                object = datum.toJdbc();
            }
        } else {
            this.setIsNull(4);
            object = this.m_rset.getObject(n2 + 1);
        }
        return object;
    }

    public synchronized Object getObject(int n2, Map map) throws SQLException {
        Object object = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
            Datum datum = this.getOracleObject(n2);
            this.setIsNull(datum == null);
            if (datum != null) {
                object = datum instanceof STRUCT ? ((STRUCT)datum).toJdbc(map) : datum.toJdbc();
            }
        } else {
            this.setIsNull(4);
            object = this.m_rset.getObject(n2 + 1, map);
        }
        return object;
    }

    public synchronized Datum getOracleObject(int n2) throws SQLException {
        Datum datum = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
            this.setIsNull(datum == null);
            datum = this.getRowBufferDatumAt(n2);
        } else {
            this.setIsNull(4);
            datum = this.m_rset.getOracleObject(n2 + 1);
        }
        return datum;
    }

    public synchronized RAW getRAW(int n2) throws SQLException {
        RAW rAW = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
            Datum datum = this.getRowBufferDatumAt(n2);
            this.setIsNull(datum == null);
            if (datum != null && !(datum instanceof RAW)) {
                DBError.check_error(4, "getRAW");
            }
            rAW = (RAW)datum;
        } else {
            this.setIsNull(4);
            rAW = this.m_rset.getRAW(n2 + 1);
        }
        return rAW;
    }

    public synchronized REF getREF(int n2) throws SQLException {
        REF rEF = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
            Datum datum = this.getRowBufferDatumAt(n2);
            this.setIsNull(datum == null);
            if (datum != null && !(datum instanceof REF)) {
                DBError.check_error(4, "getREF");
            }
            rEF = (REF)datum;
        } else {
            this.setIsNull(4);
            rEF = this.m_rset.getREF(n2 + 1);
        }
        return rEF;
    }

    public synchronized ROWID getROWID(int n2) throws SQLException {
        ROWID rOWID = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
            Datum datum = this.getRowBufferDatumAt(n2);
            this.setIsNull(datum == null);
            if (datum != null && !(datum instanceof ROWID)) {
                DBError.check_error(4, "getROWID");
            }
            rOWID = (ROWID)datum;
        } else {
            this.setIsNull(4);
            rOWID = this.m_rset.getROWID(n2 + 1);
        }
        return rOWID;
    }

    public synchronized Ref getRef(int n2) throws SQLException {
        return this.getREF(n2);
    }

    public synchronized int getRow() throws SQLException {
        return this.m_rset.getRow();
    }

    private Object getRowBufferAt(int n2) throws SQLException {
        if (n2 < 1 || n2 > this.getColumnCount() - 1) {
            DBError.throwSqlException(68, "getRowBufferDatumAt");
        }
        if (this.m_rowBuffer != null) {
            return this.m_rowBuffer[n2];
        }
        return null;
    }

    private Datum getRowBufferDatumAt(int n2) throws SQLException {
        Object object;
        if (n2 < 1 || n2 > this.getColumnCount() - 1) {
            DBError.throwSqlException(68, "getRowBufferDatumAt");
        }
        Datum datum = null;
        if (this.m_rowBuffer != null && (object = this.m_rowBuffer[n2]) != null) {
            if (object instanceof Datum) {
                datum = (Datum)object;
            } else {
                datum = SQLUtil.makeOracleDatum(this.m_conn, object, this.getInternalMetadata().getColumnType(n2 + 1), null);
                this.m_rowBuffer[n2] = datum;
            }
        }
        return datum;
    }

    public synchronized STRUCT getSTRUCT(int n2) throws SQLException {
        STRUCT sTRUCT = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
            Datum datum = this.getRowBufferDatumAt(n2);
            this.setIsNull(datum == null);
            if (datum != null && !(datum instanceof STRUCT)) {
                DBError.check_error(4, "getSTRUCT");
            }
            sTRUCT = (STRUCT)datum;
        } else {
            this.setIsNull(4);
            sTRUCT = this.m_rset.getSTRUCT(n2 + 1);
        }
        return sTRUCT;
    }

    public synchronized short getShort(int n2) throws SQLException {
        short s2 = 0;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
            long l2 = this.getLong(n2);
            if (l2 > 65537L || l2 < -65538L) {
                DBError.check_error(26, "getShort");
            }
            s2 = (short)l2;
        } else {
            this.setIsNull(4);
            s2 = this.m_rset.getShort(n2 + 1);
        }
        return s2;
    }

    public synchronized Statement getStatement() throws SQLException {
        return (Statement)((Object)this.m_scrollStmt);
    }

    public synchronized String getString(int n2) throws SQLException {
        String string = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
            Datum datum = this.getRowBufferDatumAt(n2);
            this.setIsNull(datum == null);
            if (datum != null) {
                string = datum.stringValue();
            }
        } else {
            this.setIsNull(4);
            string = this.m_rset.getString(n2 + 1);
        }
        return string;
    }

    public synchronized Time getTime(int n2) throws SQLException {
        Time time = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
            Datum datum = this.getRowBufferDatumAt(n2);
            this.setIsNull(datum == null);
            if (datum != null) {
                time = datum.timeValue();
            }
        } else {
            this.setIsNull(4);
            time = this.m_rset.getTime(n2 + 1);
        }
        return time;
    }

    public synchronized Time getTime(int n2, Calendar calendar) throws SQLException {
        Time time = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
            Datum datum = this.getOracleObject(n2);
            this.setIsNull(datum == null);
            if (datum != null) {
                if (datum instanceof DATE) {
                    time = ((DATE)datum).timeValue(calendar);
                } else {
                    DATE dATE = new DATE(datum.stringValue());
                    if (dATE != null) {
                        time = dATE.timeValue(calendar);
                    }
                }
            }
        } else {
            this.setIsNull(4);
            time = this.m_rset.getTime(n2 + 1, calendar);
        }
        return time;
    }

    public synchronized Timestamp getTimestamp(int n2) throws SQLException {
        Timestamp timestamp = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
            Datum datum = this.getRowBufferDatumAt(n2);
            this.setIsNull(datum == null);
            if (datum != null) {
                timestamp = datum.timestampValue();
            }
        } else {
            this.setIsNull(4);
            timestamp = this.m_rset.getTimestamp(n2 + 1);
        }
        return timestamp;
    }

    public synchronized Timestamp getTimestamp(int n2, Calendar calendar) throws SQLException {
        Timestamp timestamp = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
            Datum datum = this.getOracleObject(n2);
            this.setIsNull(datum == null);
            if (datum != null) {
                if (datum instanceof DATE) {
                    timestamp = ((DATE)datum).timestampValue(calendar);
                } else {
                    DATE dATE = new DATE(datum.stringValue());
                    if (dATE != null) {
                        timestamp = dATE.timestampValue(calendar);
                    }
                }
            }
        } else {
            this.setIsNull(4);
            timestamp = this.m_rset.getTimestamp(n2 + 1, calendar);
        }
        return timestamp;
    }

    public int getType() throws SQLException {
        return this.m_type;
    }

    public synchronized InputStream getUnicodeStream(int n2) throws SQLException {
        InputStream inputStream = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
            Object object = this.getRowBufferAt(n2);
            this.setIsNull(object == null);
            if (object != null) {
                if (object instanceof InputStream) {
                    inputStream = (InputStream)object;
                } else {
                    Datum datum = this.getRowBufferDatumAt(n2);
                    DBConversion dBConversion = this.m_conn.conversion;
                    byte[] byArray = datum.shareBytes();
                    if (datum instanceof RAW) {
                        inputStream = dBConversion.ConvertStream(new ByteArrayInputStream(byArray), 3);
                    } else if (datum instanceof CHAR) {
                        inputStream = dBConversion.ConvertStream(new ByteArrayInputStream(byArray), 1);
                    } else {
                        DBError.check_error(4, "getUnicodeStream");
                    }
                }
            }
        } else {
            this.setIsNull(4);
            inputStream = this.m_rset.getUnicodeStream(n2 + 1);
        }
        return inputStream;
    }

    public SQLWarning getWarnings() throws SQLException {
        SQLWarning sQLWarning = this.m_rset.getWarnings();
        if (this.m_warning == null) {
            return sQLWarning;
        }
        SQLWarning sQLWarning2 = this.m_warning;
        while (sQLWarning2.getNextWarning() != null) {
            sQLWarning2 = sQLWarning2.getNextWarning();
        }
        sQLWarning2.setNextWarning(sQLWarning);
        return this.m_warning;
    }

    private int get_num_columns_changed() throws SQLException {
        int n2;
        int n3 = 0;
        if (this.m_idxColsChanged == null) {
            this.m_idxColsChanged = new int[this.getColumnCount()];
        }
        if (this.m_rowBuffer != null) {
            n2 = 1;
            while (n2 < this.getColumnCount()) {
                if (this.m_rowBuffer[n2] != null || this.m_rowBuffer[n2] == null && this.m_nullIndicator[n2]) {
                    this.m_idxColsChanged[n3++] = n2;
                }
                ++n2;
            }
        }
        if (DEBUG) {
            System.out.println("numColsChanged = " + n3);
        }
        if (DEBUG && n3 != 0) {
            n2 = 0;
            while (n2 < n3) {
                System.out.println(" " + this.m_idxColsChanged[n2]);
                ++n2;
            }
        }
        return n3;
    }

    private void init(ScrollRsetStatement scrollRsetStatement, OracleResultSet oracleResultSet, int n2, int n3) throws SQLException {
        if (scrollRsetStatement == null || oracleResultSet == null || n3 != 1008) {
            DBError.throwSqlException(68);
        }
        this.m_conn = (OracleConnection)scrollRsetStatement.getConnection();
        this.m_rset = oracleResultSet;
        this.m_scrollStmt = scrollRsetStatement;
        this.m_type = n2;
        this.m_autoRefetch = scrollRsetStatement.getAutoRefetch();
        this.m_deleteStmt = null;
        this.m_insertStmt = null;
        this.m_updateSql1 = null;
        this.m_updateSql2 = null;
        this.m_updateStmt = null;
        this.m_idxColsChanged = null;
        this.m_rowBuffer = null;
        this.m_nullIndicator = null;
        this.m_typeInfo = null;
        this.m_isInserting = false;
        this.m_isUpdating = false;
        this.m_wasNull = -1;
        this.m_metadata = null;
        this.m_columnCount = 0;
    }

    public synchronized void insertRow() throws SQLException {
        if (!this.isOnInsertRow()) {
            DBError.throwSqlException(83);
        }
        this.prepare_insertRow_statement();
        this.prepare_insertRow_binds();
        this.execute_insertRow();
    }

    public synchronized boolean isAfterLast() throws SQLException {
        return this.m_rset.isAfterLast();
    }

    public synchronized boolean isBeforeFirst() throws SQLException {
        return this.m_rset.isBeforeFirst();
    }

    public synchronized boolean isFirst() throws SQLException {
        return this.m_rset.isFirst();
    }

    public synchronized boolean isLast() throws SQLException {
        return this.m_rset.isLast();
    }

    boolean isOnInsertRow() {
        return this.m_isInserting;
    }

    private boolean isRowBufferUpdatedAt(int n2) {
        if (this.m_rowBuffer == null) {
            return false;
        }
        return this.m_rowBuffer[n2] != null || this.m_nullIndicator[n2];
    }

    boolean isUpdatingRow() {
        return this.m_isUpdating;
    }

    public synchronized boolean last() throws SQLException {
        this.cancelRowChanges();
        return this.m_rset.last();
    }

    public synchronized void moveToCurrentRow() throws SQLException {
        this.cancelRowInserts();
    }

    public synchronized void moveToInsertRow() throws SQLException {
        if (this.isOnInsertRow()) {
            return;
        }
        this.m_isInserting = true;
        if (this.m_rowBuffer == null) {
            this.m_rowBuffer = new Object[this.getColumnCount()];
        }
        if (this.m_nullIndicator == null) {
            this.m_nullIndicator = new boolean[this.getColumnCount()];
        }
        this.clearRowBuffer();
    }

    public synchronized boolean next() throws SQLException {
        this.cancelRowChanges();
        return this.m_rset.next();
    }

    private int prepare_compare_self_binds(OraclePreparedStatement oraclePreparedStatement, int n2) throws SQLException {
        Datum datum = this.m_rset.getOracleObject(1);
        oraclePreparedStatement.setOracleObject(n2, this.m_rset.getOracleObject(1));
        return n2 + 1;
    }

    private void prepare_compare_self_sql(StringBuffer stringBuffer) throws SQLException {
        stringBuffer.append(" ROWID = ? ");
    }

    private void prepare_deleteRow_binds() throws SQLException {
        int n2 = 1;
        n2 = this.prepare_subquery_binds(this.m_deleteStmt, n2);
        this.prepare_compare_self_binds(this.m_deleteStmt, n2);
    }

    private void prepare_deleteRow_statement() throws SQLException {
        if (this.m_deleteStmt == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("delete from (");
            stringBuffer.append(this.m_scrollStmt.getRevisedSql());
            stringBuffer.append(") where ");
            this.prepare_compare_self_sql(stringBuffer);
            if (DEBUG) {
                System.out.println("deleteSql = " + stringBuffer.toString());
            }
            this.m_deleteStmt = (OraclePreparedStatement)this.m_conn.prepareStatement(stringBuffer.toString());
        }
    }

    private void prepare_insertRow_binds() throws SQLException {
        int n2 = 1;
        n2 = this.prepare_subquery_binds(this.m_insertStmt, n2);
        int n3 = 1;
        while (n3 < this.getColumnCount()) {
            Object object = this.getRowBufferAt(n3);
            if (object != null) {
                if (object instanceof Reader) {
                    this.m_insertStmt.setCharacterStream(n2 + n3 - 1, (Reader)object, this.m_typeInfo[n3][0]);
                } else if (object instanceof InputStream) {
                    if (this.m_typeInfo[n3][1] == 2) {
                        this.m_insertStmt.setBinaryStream(n2 + n3 - 1, (InputStream)object, this.m_typeInfo[n3][0]);
                    } else if (this.m_typeInfo[n3][1] == 1) {
                        this.m_insertStmt.setAsciiStream(n2 + n3 - 1, (InputStream)object, this.m_typeInfo[n3][0]);
                    }
                } else {
                    Datum datum = this.getRowBufferDatumAt(n3);
                    this.m_insertStmt.setOracleObject(n2 + n3 - 1, datum);
                }
            } else {
                int n4;
                if (DEBUG) {
                    System.out.println("bind insert stmt to null at " + (n2 + n3 - 1) + " with type" + this.getInternalMetadata().getColumnType(n3 + 1));
                }
                if ((n4 = this.getInternalMetadata().getColumnType(n3 + 1)) == 2006 || n4 == 2002 || n4 == 2008 || n4 == 2007 || n4 == 2003) {
                    this.m_insertStmt.setNull(n2 + n3 - 1, n4, this.getInternalMetadata().getColumnTypeName(n3 + 1));
                } else {
                    this.m_insertStmt.setNull(n2 + n3 - 1, n4);
                }
            }
            ++n3;
        }
    }

    private void prepare_insertRow_statement() throws SQLException {
        if (this.m_insertStmt == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("insert into (");
            stringBuffer.append(this.m_scrollStmt.getOriginalSql());
            stringBuffer.append(") values ( ");
            int n2 = 1;
            while (n2 < this.getColumnCount()) {
                if (n2 != 1) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append("?");
                ++n2;
            }
            stringBuffer.append(")");
            if (DEBUG) {
                System.out.println(stringBuffer.toString());
            }
            this.m_insertStmt = (OraclePreparedStatement)this.m_conn.prepareStatement(stringBuffer.toString());
        }
    }

    private int prepare_subquery_binds(OraclePreparedStatement oraclePreparedStatement, int n2) throws SQLException {
        int n3 = n2 - 1;
        int n4 = 0;
        DBDataSet dBDataSet = this.m_scrollStmt.getBinds();
        if (dBDataSet != null) {
            n4 = dBDataSet.getNoOfArgs();
            int n5 = 0;
            while (n5 < n4) {
                oraclePreparedStatement.setItem(n3++, dBDataSet.getType(n5), dBDataSet.getBytesItem(n5, 0));
                ++n5;
            }
        }
        if (DEBUG) {
            System.out.println("numSubQueryBinds = " + n4);
        }
        return n4 + 1;
    }

    private void prepare_updateRow_binds(int n2) throws SQLException {
        int n3 = 1;
        n3 = this.prepare_subquery_binds(this.m_updateStmt, n3);
        int n4 = 0;
        while (n4 < n2) {
            int n5 = this.m_idxColsChanged[n4];
            Object object = this.getRowBufferAt(n5);
            if (object != null) {
                if (object instanceof Reader) {
                    this.m_updateStmt.setCharacterStream(n3++, (Reader)object, this.m_typeInfo[n5][0]);
                } else if (object instanceof InputStream) {
                    if (this.m_typeInfo[n5][1] == 2) {
                        this.m_updateStmt.setBinaryStream(n3++, (InputStream)object, this.m_typeInfo[n5][0]);
                    } else if (this.m_typeInfo[n5][1] == 1) {
                        this.m_updateStmt.setAsciiStream(n3++, (InputStream)object, this.m_typeInfo[n5][0]);
                    }
                } else {
                    Datum datum = this.getRowBufferDatumAt(n5);
                    this.m_updateStmt.setOracleObject(n3++, datum);
                }
            } else {
                int n6 = this.getInternalMetadata().getColumnType(n5 + 1);
                if (n6 == 2006 || n6 == 2002 || n6 == 2008 || n6 == 2007 || n6 == 2003) {
                    this.m_updateStmt.setNull(n3++, n6, this.getInternalMetadata().getColumnTypeName(n5 + 1));
                } else {
                    this.m_updateStmt.setNull(n3++, n6);
                }
            }
            ++n4;
        }
        this.prepare_compare_self_binds(this.m_updateStmt, n3);
    }

    private void prepare_updateRow_statement(int n2) throws SQLException {
        StringBuffer stringBuffer;
        if (this.m_updateStmt != null) {
            this.m_updateStmt.close();
        }
        StringBuffer stringBuffer2 = new StringBuffer();
        if (this.m_updateSql1 == null) {
            stringBuffer = new StringBuffer();
            stringBuffer.append("update (");
            stringBuffer.append(this.m_scrollStmt.getRevisedSql());
            stringBuffer.append(") set ");
            this.m_updateSql1 = stringBuffer.toString();
        }
        stringBuffer2.append(this.m_updateSql1);
        if (this.m_rowBuffer != null) {
            int n3 = 0;
            while (n3 < n2) {
                if (n3 > 0) {
                    stringBuffer2.append(", ");
                }
                stringBuffer2.append(this.getInternalMetadata().getColumnName(this.m_idxColsChanged[n3] + 1));
                stringBuffer2.append(" = ? ");
                ++n3;
            }
        }
        stringBuffer = new StringBuffer();
        if (this.m_updateSql2 == null) {
            stringBuffer.append(" WHERE ");
            this.prepare_compare_self_sql(stringBuffer);
            this.m_updateSql2 = stringBuffer.toString();
        }
        stringBuffer2.append(this.m_updateSql2);
        if (DEBUG) {
            System.out.println("m_updateSql = " + stringBuffer2.toString());
        }
        this.m_updateStmt = (OraclePreparedStatement)this.m_conn.prepareStatement(stringBuffer2.toString());
    }

    public synchronized boolean previous() throws SQLException {
        this.cancelRowChanges();
        return this.m_rset.previous();
    }

    public synchronized void refreshRow() throws SQLException {
        if (this.isOnInsertRow()) {
            DBError.throwSqlException(84);
        }
        this.m_rset.refreshRow();
    }

    public synchronized boolean relative(int n2) throws SQLException {
        this.cancelRowChanges();
        return this.m_rset.relative(n2);
    }

    public boolean rowDeleted() throws SQLException {
        return false;
    }

    public boolean rowInserted() throws SQLException {
        return false;
    }

    public boolean rowUpdated() throws SQLException {
        return false;
    }

    public synchronized void setFetchDirection(int n2) throws SQLException {
        this.m_rset.setFetchDirection(n2);
    }

    public synchronized void setFetchSize(int n2) throws SQLException {
        this.m_rset.setFetchSize(n2);
    }

    private void setIsNull(int n2) {
        this.m_wasNull = n2;
    }

    private void setIsNull(boolean bl) {
        this.m_wasNull = bl ? 1 : 2;
    }

    private void setRowBufferAt(int n2, Object object, int[] nArray) throws SQLException {
        if (!this.m_isInserting) {
            if (this.isBeforeFirst() || this.isAfterLast() || this.getRow() == 0) {
                DBError.throwSqlException(82);
            } else {
                this.m_isUpdating = true;
            }
        }
        if (n2 < 1 || n2 > this.getColumnCount() - 1) {
            DBError.throwSqlException(68, "setRowBufferAt");
        }
        if (this.m_rowBuffer == null) {
            this.m_rowBuffer = new Object[this.getColumnCount()];
        }
        if (this.m_nullIndicator == null) {
            this.m_nullIndicator = new boolean[this.getColumnCount()];
            int n3 = 0;
            while (n3 < this.getColumnCount()) {
                this.m_nullIndicator[n3] = false;
                ++n3;
            }
        }
        if (nArray != null) {
            if (this.m_typeInfo == null) {
                this.m_typeInfo = new int[this.getColumnCount()][];
            }
            this.m_typeInfo[n2] = nArray;
        }
        this.m_rowBuffer[n2] = object;
        this.m_nullIndicator[n2] = object == null;
    }

    private void setRowBufferAt(int n2, Datum datum) throws SQLException {
        this.setRowBufferAt(n2, datum, null);
    }

    public void updateARRAY(int n2, ARRAY aRRAY) throws SQLException {
        this.updateOracleObject(n2, (Datum)aRRAY);
    }

    public void updateArray(int n2, Array array) throws SQLException {
        this.updateARRAY(n2, (ARRAY)array);
    }

    public void updateAsciiStream(int n2, InputStream inputStream, int n3) throws SQLException {
        if (inputStream != null && n3 > 0) {
            int n4 = 0;
            n4 = this.m_conn.conversion.isUcs2CharSet() ? _MIN_STREAM_SIZE / 2 : _MIN_STREAM_SIZE;
            if (n3 <= n4) {
                byte[] byArray = new byte[n3];
                try {
                    int n5 = inputStream.read(byArray);
                    inputStream.close();
                    String string = new String(byArray, 0, n5);
                    this.updateString(n2, string);
                }
                catch (IOException iOException) {
                    DBError.throwSqlException(iOException);
                }
            } else {
                int[] nArray = new int[]{n3, 1};
                this.setRowBufferAt(n2, inputStream, nArray);
            }
        } else {
            this.setRowBufferAt(n2, null);
        }
    }

    public void updateBFILE(int n2, BFILE bFILE) throws SQLException {
        this.updateOracleObject(n2, (Datum)bFILE);
    }

    public void updateBLOB(int n2, BLOB bLOB) throws SQLException {
        this.updateOracleObject(n2, (Datum)bLOB);
    }

    public void updateBfile(int n2, BFILE bFILE) throws SQLException {
        this.updateOracleObject(n2, (Datum)bFILE);
    }

    public void updateBigDecimal(int n2, BigDecimal bigDecimal) throws SQLException {
        this.updateObject(n2, (Object)bigDecimal);
    }

    public void updateBinaryStream(int n2, InputStream inputStream, int n3) throws SQLException {
        if (inputStream != null && n3 > 0) {
            int n4 = _MIN_STREAM_SIZE;
            if (n3 <= n4) {
                byte[] byArray = new byte[n3];
                try {
                    int n5 = inputStream.read(byArray);
                    inputStream.close();
                    this.updateBytes(n2, byArray);
                }
                catch (IOException iOException) {
                    DBError.throwSqlException(iOException);
                }
            } else {
                int[] nArray = new int[]{n3, 2};
                this.setRowBufferAt(n2, inputStream, nArray);
            }
        } else {
            this.setRowBufferAt(n2, null);
        }
    }

    public void updateBlob(int n2, Blob blob) throws SQLException {
        this.updateBLOB(n2, (BLOB)blob);
    }

    public void updateBoolean(int n2, boolean bl) throws SQLException {
        this.updateObject(n2, (Object)new Boolean(bl));
    }

    public void updateByte(int n2, byte by) throws SQLException {
        this.updateObject(n2, (Object)new Integer(by));
    }

    public void updateBytes(int n2, byte[] byArray) throws SQLException {
        this.updateObject(n2, (Object)byArray);
    }

    public void updateCHAR(int n2, CHAR cHAR) throws SQLException {
        this.updateOracleObject(n2, (Datum)cHAR);
    }

    public void updateCLOB(int n2, CLOB cLOB) throws SQLException {
        this.updateOracleObject(n2, (Datum)cLOB);
    }

    public void updateCharacterStream(int n2, Reader reader, int n3) throws SQLException {
        if (reader != null && n3 > 0) {
            int n4 = 4000 / this.m_conn.db_access.getNlsRatio() / this.m_conn.conversion.getMaxCharbyteSize();
            if (n3 <= n4) {
                char[] cArray = new char[n3];
                try {
                    int n5 = reader.read(cArray);
                    reader.close();
                    this.updateString(n2, new String(cArray));
                }
                catch (IOException iOException) {
                    DBError.throwSqlException(iOException);
                }
            } else {
                int[] nArray = new int[]{n3};
                this.setRowBufferAt(n2, reader, nArray);
            }
        } else {
            this.setRowBufferAt(n2, null);
        }
    }

    public void updateClob(int n2, Clob clob) throws SQLException {
        this.updateCLOB(n2, (CLOB)clob);
    }

    public void updateCustomDatum(int n2, CustomDatum customDatum) throws SQLException {
        Datum datum = customDatum.toDatum(this.m_conn);
        this.updateOracleObject(n2, datum);
    }

    public void updateDATE(int n2, DATE dATE) throws SQLException {
        this.updateOracleObject(n2, (Datum)dATE);
    }

    public void updateDate(int n2, Date date) throws SQLException {
        this.updateObject(n2, (Object)date);
    }

    public void updateDouble(int n2, double d2) throws SQLException {
        this.updateObject(n2, (Object)new Double(d2));
    }

    public void updateFloat(int n2, float f2) throws SQLException {
        this.updateObject(n2, (Object)new Float(f2));
    }

    public void updateInt(int n2, int n3) throws SQLException {
        this.updateObject(n2, (Object)new Integer(n3));
    }

    public void updateLong(int n2, long l2) throws SQLException {
        this.updateObject(n2, (Object)new Long(l2));
    }

    public void updateNUMBER(int n2, NUMBER nUMBER) throws SQLException {
        this.updateOracleObject(n2, (Datum)nUMBER);
    }

    public synchronized void updateNull(int n2) throws SQLException {
        this.setRowBufferAt(n2, null);
    }

    public void updateOPAQUE(int n2, OPAQUE oPAQUE) throws SQLException {
        this.updateOracleObject(n2, (Datum)oPAQUE);
    }

    public void updateORAData(int n2, ORAData oRAData) throws SQLException {
        Datum datum = oRAData.toDatum(this.m_conn);
        this.updateOracleObject(n2, datum);
    }

    public synchronized void updateObject(int n2, Object object) throws SQLException {
        Datum datum = null;
        if (object != null) {
            datum = object instanceof Datum ? (Datum)object : SQLUtil.makeOracleDatum(this.m_conn, object, this.getInternalMetadata().getColumnType(n2 + 1), null);
        }
        this.setRowBufferAt(n2, datum);
    }

    public void updateObject(int n2, Object object, int n3) throws SQLException {
        this.updateObject(n2, object);
    }

    public synchronized void updateOracleObject(int n2, Datum datum) throws SQLException {
        this.setRowBufferAt(n2, datum);
    }

    public void updateRAW(int n2, RAW rAW) throws SQLException {
        this.updateOracleObject(n2, (Datum)rAW);
    }

    public void updateREF(int n2, REF rEF) throws SQLException {
        this.updateOracleObject(n2, (Datum)rEF);
    }

    public void updateROWID(int n2, ROWID rOWID) throws SQLException {
        this.updateOracleObject(n2, (Datum)rOWID);
    }

    public void updateRef(int n2, Ref ref) throws SQLException {
        this.updateREF(n2, (REF)ref);
    }

    public synchronized void updateRow() throws SQLException {
        int n2;
        if (this.isOnInsertRow()) {
            DBError.throwSqlException(84);
        }
        if ((n2 = this.get_num_columns_changed()) > 0) {
            this.prepare_updateRow_statement(n2);
            this.prepare_updateRow_binds(n2);
            this.execute_updateRow();
        }
    }

    public void updateSTRUCT(int n2, STRUCT sTRUCT) throws SQLException {
        this.updateOracleObject(n2, (Datum)sTRUCT);
    }

    public void updateShort(int n2, short s2) throws SQLException {
        this.updateObject(n2, (Object)new Integer(s2));
    }

    public synchronized void updateString(int n2, String string) throws SQLException {
        this.updateObject(n2, (Object)string);
    }

    public void updateTime(int n2, Time time) throws SQLException {
        this.updateObject(n2, (Object)time);
    }

    public void updateTimestamp(int n2, Timestamp timestamp) throws SQLException {
        this.updateObject(n2, (Object)timestamp);
    }

    public synchronized boolean wasNull() throws SQLException {
        switch (this.m_wasNull) {
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
            case 4: {
                return this.m_rset.wasNull();
            }
        }
        DBError.throwSqlException(24);
        return false;
    }
}

