/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleResultSetImpl;
import oracle.jdbc.driver.ScrollRsetStatement;
import oracle.jdbc.driver.ScrollableResultSet;

public class SensitiveScrollableResultSet
extends ScrollableResultSet {
    public static boolean DEBUG = false;
    private int m_beginLastFetchedIdx;
    private int m_endLastFetchedIdx;

    public SensitiveScrollableResultSet(ScrollRsetStatement scrollRsetStatement, OracleResultSetImpl oracleResultSetImpl, int n2, int n3) throws SQLException {
        super(scrollRsetStatement, oracleResultSetImpl, n2, n3);
        int n4 = oracleResultSetImpl.getValidRows();
        if (n4 > 0) {
            this.m_beginLastFetchedIdx = 1;
            this.m_endLastFetchedIdx = n4;
        } else {
            this.m_beginLastFetchedIdx = 0;
            this.m_endLastFetchedIdx = 0;
        }
    }

    public synchronized boolean absolute(int n2) throws SQLException {
        if (super.absolute(n2)) {
            this.handle_refetch();
            return true;
        }
        return false;
    }

    public synchronized boolean first() throws SQLException {
        if (super.first()) {
            this.handle_refetch();
            return true;
        }
        return false;
    }

    private boolean handle_refetch() throws SQLException {
        if (this.m_currentRow >= this.m_beginLastFetchedIdx && this.m_currentRow <= this.m_endLastFetchedIdx || this.m_currentRow >= this.m_endLastFetchedIdx && this.m_currentRow <= this.m_beginLastFetchedIdx) {
            return false;
        }
        this.refreshRow();
        return true;
    }

    public synchronized boolean last() throws SQLException {
        if (super.last()) {
            this.handle_refetch();
            return true;
        }
        return false;
    }

    public synchronized boolean next() throws SQLException {
        if (super.next()) {
            this.handle_refetch();
            return true;
        }
        return false;
    }

    public synchronized boolean previous() throws SQLException {
        if (super.previous()) {
            this.handle_refetch();
            return true;
        }
        return false;
    }

    public synchronized void refreshRow() throws SQLException {
        if (DEBUG) {
            System.out.println("refreshRow ()");
        }
        if (!this.isValidRow(this.m_currentRow)) {
            DBError.throwSqlException(11);
        }
        int n2 = this.getFetchDirection();
        int n3 = 0;
        try {
            n3 = this.refreshRowsInCache(this.m_currentRow, this.getFetchSize(), n2);
        }
        catch (SQLException sQLException) {
            DBError.throwSqlException(sQLException, 90, "Unsupported syntax for refreshRow()");
        }
        if (n3 != 0) {
            this.m_beginLastFetchedIdx = this.m_currentRow;
            this.m_endLastFetchedIdx = this.m_currentRow + n3 - 1;
        }
    }

    public synchronized boolean relative(int n2) throws SQLException {
        if (super.relative(n2)) {
            this.handle_refetch();
            return true;
        }
        return false;
    }

    synchronized int removeRowInCache(int n2) throws SQLException {
        int n3 = super.removeRowInCache(n2);
        if (n3 != 0) {
            if (n2 >= this.m_beginLastFetchedIdx && n2 <= this.m_endLastFetchedIdx && this.m_beginLastFetchedIdx != this.m_endLastFetchedIdx) {
                --this.m_endLastFetchedIdx;
            } else {
                this.m_endLastFetchedIdx = 0;
                this.m_beginLastFetchedIdx = 0;
            }
        }
        return n3;
    }
}

