/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import java.util.Vector;
import oracle.jdbc.dbaccess.DBConversion;
import oracle.jdbc.dbaccess.DBDataSet;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.BaseResultSet;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.OracleResultSet;
import oracle.jdbc.driver.OracleResultSetCache;
import oracle.jdbc.driver.OracleResultSetCacheImpl;
import oracle.jdbc.driver.OracleResultSetImpl;
import oracle.jdbc.driver.OracleResultSetMetaData;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.ScrollRsetStatement;
import oracle.jdbc.driver.UpdatableResultSet;
import oracle.sql.ARRAY;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.CustomDatum;
import oracle.sql.CustomDatumFactory;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.NUMBER;
import oracle.sql.OPAQUE;
import oracle.sql.ORAData;
import oracle.sql.ORADataFactory;
import oracle.sql.RAW;
import oracle.sql.REF;
import oracle.sql.ROWID;
import oracle.sql.SQLUtil;
import oracle.sql.STRUCT;

public class ScrollableResultSet
extends BaseResultSet {
    public static boolean DEBUG = false;
    public OracleConnection m_conn;
    OracleResultSetImpl m_rset;
    ScrollRsetStatement m_scrollStmt;
    ResultSetMetaData m_metadata;
    private int m_type;
    private int m_update;
    private int m_beginColumnIndex;
    private int m_columnCount;
    private int m_wasNull;
    OracleResultSetCache m_cache;
    int m_currentRow;
    private int m_numRowsCached;
    private boolean m_allRowsCached;
    private int m_lastRefetchSz;
    private Vector m_refetchRowids;
    private OraclePreparedStatement m_refetchStmt;
    private int m_usrFetchDirection;

    public ScrollableResultSet(ScrollRsetStatement scrollRsetStatement, OracleResultSetImpl oracleResultSetImpl, int n2, int n3) throws SQLException {
        this.m_conn = (OracleConnection)scrollRsetStatement.getConnection();
        this.m_rset = oracleResultSetImpl;
        this.m_metadata = null;
        this.m_scrollStmt = scrollRsetStatement;
        this.m_type = n2;
        this.m_update = n3;
        this.m_autoRefetch = scrollRsetStatement.getAutoRefetch();
        this.m_beginColumnIndex = ScrollableResultSet.needIdentifier(n2, n3) ? 1 : 0;
        this.m_columnCount = 0;
        this.m_wasNull = -1;
        this.m_cache = scrollRsetStatement.getResultSetCache();
        if (this.m_cache == null) {
            this.m_cache = new OracleResultSetCacheImpl();
        } else {
            try {
                this.m_cache.clear();
            }
            catch (IOException iOException) {
                DBError.throwSqlException(iOException);
            }
        }
        this.m_currentRow = 0;
        this.m_numRowsCached = 0;
        this.m_allRowsCached = false;
        this.m_lastRefetchSz = 0;
        this.m_refetchRowids = null;
        this.m_refetchStmt = null;
        this.m_usrFetchDirection = 1000;
    }

    public synchronized boolean absolute(int n2) throws SQLException {
        if (n2 == 0) {
            DBError.throwSqlException(68, "absolute (0)");
        }
        if (this.isEmptyResultSet()) {
            return false;
        }
        if (n2 > 0) {
            this.m_currentRow = n2;
        } else if (n2 < 0) {
            this.m_currentRow = this.getLastRow() + 1 + n2;
        }
        return this.isValidRow(this.m_currentRow);
    }

    public synchronized void afterLast() throws SQLException {
        if (!this.isEmptyResultSet()) {
            this.m_currentRow = this.getLastRow() + 1;
        }
    }

    public synchronized void beforeFirst() throws SQLException {
        if (!this.isEmptyResultSet()) {
            this.m_currentRow = 0;
        }
    }

    private int cacheAllRows() throws SQLException {
        while (this.m_rset.next()) {
            int n2 = 0;
            while (n2 < this.getColumnCount()) {
                this.putCachedValueAt(this.m_numRowsCached + 1, n2 + 1, this.m_rset.getBytes(n2 + 1));
                ++n2;
            }
            ++this.m_numRowsCached;
        }
        this.m_allRowsCached = true;
        return this.m_numRowsCached;
    }

    private boolean cacheRowAt(int n2) throws SQLException {
        if (DEBUG) {
            System.out.println("cacheRowAt (" + n2 + ") ......");
        }
        while (this.m_numRowsCached < n2 && this.m_rset.next()) {
            int n3 = 0;
            while (n3 < this.getColumnCount()) {
                byte[] byArray = this.m_rset.getBytes(n3 + 1);
                this.putCachedValueAt(this.m_numRowsCached + 1, n3 + 1, byArray);
                ++n3;
            }
            ++this.m_numRowsCached;
        }
        if (this.m_numRowsCached < n2) {
            this.m_allRowsCached = true;
            return false;
        }
        return true;
    }

    public synchronized void close() throws SQLException {
        if (this.m_rset != null) {
            this.m_rset.close();
        }
        if (this.m_refetchStmt != null) {
            this.m_refetchStmt.close();
        }
        if (this.m_scrollStmt != null) {
            this.m_scrollStmt.notify_close_rset();
        }
        if (this.m_refetchRowids != null) {
            this.m_refetchRowids.removeAllElements();
        }
        this.m_rset = null;
        this.m_scrollStmt = null;
        this.m_refetchStmt = null;
        this.m_refetchRowids = null;
        this.m_metadata = null;
        this.m_conn = null;
        try {
            this.m_cache.clear();
            this.m_cache.close();
        }
        catch (IOException iOException) {
            DBError.throwSqlException(iOException);
        }
        this.m_cache = null;
    }

    public synchronized int findColumn(String string) throws SQLException {
        return this.m_rset.findColumn(string) - this.m_beginColumnIndex;
    }

    public synchronized boolean first() throws SQLException {
        if (this.isEmptyResultSet()) {
            return false;
        }
        this.m_currentRow = 1;
        return this.isValidRow(this.m_currentRow);
    }

    public synchronized ARRAY getARRAY(int n2) throws SQLException {
        Datum datum = this.getOracleObject(n2);
        if (datum != null) {
            if (datum instanceof ARRAY) {
                return (ARRAY)datum;
            }
            DBError.check_error(4, "getARRAY");
        }
        return null;
    }

    public synchronized Array getArray(int n2) throws SQLException {
        return this.getARRAY(n2);
    }

    public synchronized InputStream getAsciiStream(int n2) throws SQLException {
        Datum datum = this.getOracleObject(n2);
        if (datum != null) {
            return datum.asciiStreamValue();
        }
        return null;
    }

    public synchronized BFILE getBFILE(int n2) throws SQLException {
        Datum datum = this.getOracleObject(n2);
        if (datum != null) {
            if (datum instanceof BFILE) {
                return (BFILE)datum;
            }
            DBError.check_error(4, "getBFILE");
        }
        return null;
    }

    public synchronized BLOB getBLOB(int n2) throws SQLException {
        Datum datum = this.getOracleObject(n2);
        if (datum != null) {
            if (datum instanceof BLOB) {
                return (BLOB)datum;
            }
            DBError.check_error(4, "getBLOB");
        }
        return null;
    }

    public synchronized BFILE getBfile(int n2) throws SQLException {
        return this.getBFILE(n2);
    }

    public BigDecimal getBigDecimal(int n2) throws SQLException {
        return this.getBigDecimal(n2, 0);
    }

    public synchronized BigDecimal getBigDecimal(int n2, int n3) throws SQLException {
        Datum datum = this.getOracleObject(n2);
        if (datum != null) {
            return datum.bigDecimalValue();
        }
        return null;
    }

    public synchronized InputStream getBinaryStream(int n2) throws SQLException {
        Datum datum = this.getOracleObject(n2);
        if (datum != null) {
            return datum.binaryStreamValue();
        }
        return null;
    }

    public synchronized Blob getBlob(int n2) throws SQLException {
        return this.getBLOB(n2);
    }

    public synchronized boolean getBoolean(int n2) throws SQLException {
        Datum datum = this.getOracleObject(n2);
        if (datum != null) {
            return datum.booleanValue();
        }
        return false;
    }

    public synchronized byte getByte(int n2) throws SQLException {
        Datum datum = this.getOracleObject(n2);
        if (datum != null) {
            return datum.byteValue();
        }
        return 0;
    }

    public synchronized byte[] getBytes(int n2) throws SQLException {
        Datum datum = this.getOracleObject(n2);
        if (datum != null) {
            if (datum instanceof RAW) {
                return ((RAW)datum).shareBytes();
            }
            DBError.check_error(4, "getBytes");
        }
        return null;
    }

    public synchronized CHAR getCHAR(int n2) throws SQLException {
        Datum datum = this.getOracleObject(n2);
        if (datum != null) {
            if (datum instanceof CHAR) {
                return (CHAR)datum;
            }
            DBError.check_error(4, "getCHAR");
        }
        return null;
    }

    public synchronized CLOB getCLOB(int n2) throws SQLException {
        Datum datum = this.getOracleObject(n2);
        if (datum != null) {
            if (datum instanceof CLOB) {
                return (CLOB)datum;
            }
            DBError.check_error(4, "getCLOB");
        }
        return null;
    }

    private Datum getCachedDatumValueAt(int n2, int n3) throws SQLException {
        Datum datum;
        block12: {
            Object object = null;
            try {
                object = this.m_cache.get(n2, n3);
            }
            catch (IOException iOException) {
                DBError.throwSqlException(iOException);
            }
            datum = null;
            if (object == null) break block12;
            if (object instanceof Datum) {
                datum = (Datum)object;
            } else if (((byte[])object).length > 0) {
                int n4 = this.getInternalMetadata().getColumnType(n3);
                int n5 = this.getInternalMetadata().getColumnDisplaySize(n3);
                int n6 = this.m_scrollStmt.getMaxFieldSize();
                if (n6 > 0 && n6 < n5) {
                    n5 = n6;
                }
                String string = null;
                if (n4 == 2006 || n4 == 2002 || n4 == 2008 || n4 == 2007 || n4 == 2003) {
                    string = this.getInternalMetadata().getColumnTypeName(n3);
                }
                int n7 = SQLUtil.get_internal_type(n4);
                short s2 = this.m_rset.statement.getDBTypeForm(n3 - 1);
                datum = s2 == 2 && (n7 == 96 || n7 == 1 || n7 == 8 || n7 == 999 || n7 == 112) ? SQLUtil.makeNDatum(this.m_conn, (byte[])object, n7, string, s2, n5) : SQLUtil.makeDatum(this.m_conn, (byte[])object, n7, string, n5);
                try {
                    this.m_cache.put(n2, n3, datum);
                }
                catch (IOException iOException) {
                    DBError.throwSqlException(iOException);
                }
            } else {
                try {
                    this.m_cache.put(n2, n3, null);
                }
                catch (IOException iOException) {
                    DBError.throwSqlException(iOException);
                }
            }
        }
        return datum;
    }

    private Object getCachedValueAt(int n2, int n3) throws SQLException {
        try {
            return this.m_cache.get(n2, n3);
        }
        catch (IOException iOException) {
            DBError.throwSqlException(iOException);
            return null;
        }
    }

    public synchronized Reader getCharacterStream(int n2) throws SQLException {
        Datum datum = this.getOracleObject(n2);
        if (datum != null) {
            return datum.characterStreamValue();
        }
        return null;
    }

    public synchronized Clob getClob(int n2) throws SQLException {
        return this.getCLOB(n2);
    }

    int getColumnCount() throws SQLException {
        if (this.m_columnCount == 0) {
            int n2 = this.m_rset.statement.defines.getNoOfArgs();
            this.m_columnCount = this.m_rset.statement.defines != null && n2 > 0 ? n2 : this.getInternalMetadata().getColumnCount();
        }
        return this.m_columnCount;
    }

    public int getConcurrency() throws SQLException {
        return this.m_update;
    }

    public synchronized ResultSet getCursor(int n2) throws SQLException {
        DBError.check_error(4, "getCursor");
        return null;
    }

    public synchronized CustomDatum getCustomDatum(int n2, CustomDatumFactory customDatumFactory) throws SQLException {
        Datum datum = this.getOracleObject(n2);
        return customDatumFactory.create(datum, 0);
    }

    public synchronized DATE getDATE(int n2) throws SQLException {
        Datum datum = this.getOracleObject(n2);
        if (datum != null) {
            if (datum instanceof DATE) {
                return (DATE)datum;
            }
            DBError.check_error(4, "getDATE");
        }
        return null;
    }

    public synchronized Date getDate(int n2) throws SQLException {
        Datum datum = this.getOracleObject(n2);
        if (datum != null) {
            return datum.dateValue();
        }
        return null;
    }

    public synchronized Date getDate(int n2, Calendar calendar) throws SQLException {
        DATE dATE = this.getDATE(n2);
        return dATE != null ? dATE.dateValue(calendar) : null;
    }

    public synchronized double getDouble(int n2) throws SQLException {
        Datum datum = this.getOracleObject(n2);
        if (datum != null) {
            return datum.doubleValue();
        }
        return 0.0;
    }

    public synchronized int getFetchDirection() throws SQLException {
        return 1000;
    }

    public synchronized int getFetchSize() throws SQLException {
        return this.m_rset.getFetchSize();
    }

    public int getFirstUserColumnIndex() {
        return this.m_beginColumnIndex;
    }

    public synchronized float getFloat(int n2) throws SQLException {
        Datum datum = this.getOracleObject(n2);
        if (datum != null) {
            return datum.floatValue();
        }
        return 0.0f;
    }

    public synchronized int getInt(int n2) throws SQLException {
        Datum datum = this.getOracleObject(n2);
        if (datum != null) {
            return datum.intValue();
        }
        return 0;
    }

    private ResultSetMetaData getInternalMetadata() throws SQLException {
        if (this.m_metadata == null) {
            this.m_metadata = this.m_rset.getMetaData();
        }
        return this.m_metadata;
    }

    private int getLastRow() throws SQLException {
        if (!this.m_allRowsCached) {
            this.cacheAllRows();
        }
        return this.m_numRowsCached;
    }

    public synchronized long getLong(int n2) throws SQLException {
        Datum datum = this.getOracleObject(n2);
        if (datum != null) {
            return datum.longValue();
        }
        return 0L;
    }

    public synchronized ResultSetMetaData getMetaData() throws SQLException {
        return new OracleResultSetMetaData(this.m_conn, (OracleStatement)this.m_scrollStmt, this.m_beginColumnIndex);
    }

    public synchronized NUMBER getNUMBER(int n2) throws SQLException {
        Datum datum = this.getOracleObject(n2);
        if (datum != null) {
            if (datum instanceof NUMBER) {
                return (NUMBER)datum;
            }
            DBError.check_error(4, "getNUMBER");
        }
        return null;
    }

    public synchronized OPAQUE getOPAQUE(int n2) throws SQLException {
        Datum datum = this.getOracleObject(n2);
        if (datum != null) {
            if (datum instanceof OPAQUE) {
                return (OPAQUE)datum;
            }
            DBError.check_error(4, "getOPAQUE");
        }
        return null;
    }

    public synchronized ORAData getORAData(int n2, ORADataFactory oRADataFactory) throws SQLException {
        Datum datum = this.getOracleObject(n2);
        return oRADataFactory.create(datum, 0);
    }

    public synchronized Object getObject(int n2) throws SQLException {
        return this.getObject(n2, this.m_conn.getTypeMap());
    }

    public synchronized Object getObject(int n2, Map map) throws SQLException {
        Datum datum = this.getOracleObject(n2);
        if (datum != null) {
            if (datum instanceof STRUCT) {
                return ((STRUCT)datum).toJdbc(map);
            }
            return datum.toJdbc();
        }
        return null;
    }

    public synchronized Datum getOracleObject(int n2) throws SQLException {
        Datum datum;
        if (DEBUG) {
            System.out.println("rownum = " + this.m_currentRow + " " + n2);
        }
        this.m_wasNull = -1;
        if (!this.isValidRow(this.m_currentRow)) {
            DBError.throwSqlException(11);
        }
        if (n2 < 1 || n2 > this.getColumnCount()) {
            DBError.throwSqlException(3);
        }
        this.m_wasNull = (datum = this.getCachedDatumValueAt(this.m_currentRow, n2 + this.m_beginColumnIndex)) == null ? 1 : 0;
        return datum;
    }

    public synchronized RAW getRAW(int n2) throws SQLException {
        Datum datum = this.getOracleObject(n2);
        if (datum != null) {
            if (datum instanceof RAW) {
                return (RAW)datum;
            }
            DBError.check_error(4, "getRAW");
        }
        return null;
    }

    public synchronized REF getREF(int n2) throws SQLException {
        Datum datum = this.getOracleObject(n2);
        if (datum != null) {
            if (datum instanceof REF) {
                return (REF)datum;
            }
            DBError.check_error(4, "getREF");
        }
        return null;
    }

    public synchronized ROWID getROWID(int n2) throws SQLException {
        Datum datum = this.getOracleObject(n2);
        if (datum != null) {
            if (datum instanceof ROWID) {
                return (ROWID)datum;
            }
            DBError.check_error(4, "getROWID");
        }
        return null;
    }

    public synchronized Ref getRef(int n2) throws SQLException {
        return this.getREF(n2);
    }

    synchronized ResultSet getResultSet() {
        return this.m_rset;
    }

    public synchronized int getRow() throws SQLException {
        if (this.isValidRow(this.m_currentRow)) {
            return this.m_currentRow;
        }
        return 0;
    }

    public synchronized STRUCT getSTRUCT(int n2) throws SQLException {
        Datum datum = this.getOracleObject(n2);
        if (datum != null) {
            if (datum instanceof STRUCT) {
                return (STRUCT)datum;
            }
            DBError.check_error(4, "getSTRUCT");
        }
        return null;
    }

    public synchronized short getShort(int n2) throws SQLException {
        long l2 = this.getLong(n2);
        if (l2 > 65537L || l2 < -65538L) {
            DBError.check_error(26, "getShort");
        }
        return (short)l2;
    }

    public synchronized Statement getStatement() throws SQLException {
        return (Statement)((Object)this.m_scrollStmt);
    }

    public synchronized String getString(int n2) throws SQLException {
        Datum datum = this.getOracleObject(n2);
        if (datum != null) {
            return datum.stringValue();
        }
        return null;
    }

    public synchronized Time getTime(int n2) throws SQLException {
        Datum datum = this.getOracleObject(n2);
        if (datum != null) {
            return datum.timeValue();
        }
        return null;
    }

    public synchronized Time getTime(int n2, Calendar calendar) throws SQLException {
        DATE dATE = this.getDATE(n2);
        return dATE != null ? dATE.timeValue(calendar) : null;
    }

    public synchronized Timestamp getTimestamp(int n2) throws SQLException {
        Datum datum = this.getOracleObject(n2);
        if (datum != null) {
            return datum.timestampValue();
        }
        return null;
    }

    public synchronized Timestamp getTimestamp(int n2, Calendar calendar) throws SQLException {
        DATE dATE = this.getDATE(n2);
        return dATE != null ? dATE.timestampValue(calendar) : null;
    }

    public int getType() throws SQLException {
        return this.m_type;
    }

    public synchronized InputStream getUnicodeStream(int n2) throws SQLException {
        Datum datum = this.getOracleObject(n2);
        if (datum != null) {
            DBConversion dBConversion = this.m_conn.conversion;
            byte[] byArray = datum.shareBytes();
            if (datum instanceof RAW) {
                return dBConversion.ConvertStream(new ByteArrayInputStream(byArray), 3);
            }
            if (datum instanceof CHAR) {
                return dBConversion.ConvertStream(new ByteArrayInputStream(byArray), 1);
            }
            DBError.check_error(4, "getUnicodeStream");
        }
        return null;
    }

    private int get_refetch_size(int n2, int n3, int n4) throws SQLException {
        int n5 = n4 == 1001 ? -1 : 1;
        int n6 = 0;
        if (this.m_refetchRowids == null) {
            this.m_refetchRowids = new Vector(10);
        } else {
            this.m_refetchRowids.removeAllElements();
        }
        while (n6 < n3 && this.isValidRow(n2 + n6 * n5)) {
            this.m_refetchRowids.addElement(this.getCachedDatumValueAt(n2 + n6 * n5, 1));
            ++n6;
        }
        return n6;
    }

    public synchronized boolean isAfterLast() throws SQLException {
        return !this.isEmptyResultSet() && this.m_currentRow > 0 && !this.isValidRow(this.m_currentRow);
    }

    public synchronized boolean isBeforeFirst() throws SQLException {
        return !this.isEmptyResultSet() && this.m_currentRow < 1;
    }

    private boolean isEmptyResultSet() throws SQLException {
        if (this.m_numRowsCached != 0) {
            return false;
        }
        if (this.m_numRowsCached == 0 && this.m_allRowsCached) {
            return true;
        }
        return this.isValidRow(1) ^ true;
    }

    public synchronized boolean isFirst() throws SQLException {
        return this.m_currentRow == 1;
    }

    public synchronized boolean isLast() throws SQLException {
        return !this.isEmptyResultSet() && this.isValidRow(this.m_currentRow) && !this.isValidRow(this.m_currentRow + 1);
    }

    boolean isValidRow(int n2) throws SQLException {
        if (n2 > 0 && n2 <= this.m_numRowsCached) {
            return true;
        }
        if (n2 <= 0) {
            return false;
        }
        return this.cacheRowAt(n2);
    }

    public synchronized boolean last() throws SQLException {
        if (this.isEmptyResultSet()) {
            return false;
        }
        this.m_currentRow = this.getLastRow();
        return this.isValidRow(this.m_currentRow);
    }

    public static boolean needCache(int n2, int n3) {
        return n2 != 1003 && (n2 != 1004 || n3 != 1007);
    }

    public static boolean needIdentifier(int n2, int n3) {
        return (n2 != 1003 || n3 != 1007) && (n2 != 1004 || n3 != 1007);
    }

    public synchronized boolean next() throws SQLException {
        if (this.isEmptyResultSet()) {
            return false;
        }
        this.m_currentRow = this.m_currentRow < 1 ? 1 : ++this.m_currentRow;
        return this.isValidRow(this.m_currentRow);
    }

    private void prepare_refetch_binds(OraclePreparedStatement oraclePreparedStatement, int n2) throws SQLException {
        int n3;
        int n4 = 0;
        DBDataSet dBDataSet = this.m_scrollStmt.getBinds();
        if (dBDataSet != null) {
            n4 = dBDataSet.getNoOfArgs();
            n3 = 0;
            while (n3 < n4) {
                oraclePreparedStatement.setItem(n3, dBDataSet.getType(n3), dBDataSet.getBytesItem(n3, 0));
                ++n3;
            }
        }
        if (DEBUG) {
            System.out.println("numSubQueryBinds = " + n4);
        }
        n3 = 0;
        while (n3 < n2) {
            oraclePreparedStatement.setROWID(n4 + n3 + 1, (ROWID)this.m_refetchRowids.elementAt(n3));
            ++n3;
        }
    }

    private OraclePreparedStatement prepare_refetch_statement(int n2) throws SQLException {
        if (n2 < 1) {
            DBError.throwSqlException(68);
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this.m_scrollStmt.getRevisedSql().toUpperCase().indexOf("WHERE") == -1) {
            stringBuffer.append(this.m_scrollStmt.getRevisedSql());
            stringBuffer.append(" WHERE ( ROWID = ?");
        } else {
            stringBuffer.append(this.m_scrollStmt.getRevisedSql());
            stringBuffer.append(" AND ( rowid = ?");
        }
        int n3 = 0;
        while (n3 < n2 - 1) {
            stringBuffer.append(" OR rowid = ?");
            ++n3;
        }
        stringBuffer.append(" )");
        if (DEBUG) {
            System.out.println("refetch sql = " + stringBuffer.toString());
        }
        return (OraclePreparedStatement)this.m_conn.prepareStatement(stringBuffer.toString());
    }

    public synchronized boolean previous() throws SQLException {
        if (this.isEmptyResultSet()) {
            return false;
        }
        this.m_currentRow = this.isAfterLast() ? this.getLastRow() : --this.m_currentRow;
        return this.isValidRow(this.m_currentRow);
    }

    private void putCachedValueAt(int n2, int n3, Object object) throws SQLException {
        try {
            this.m_cache.put(n2, n3, object);
        }
        catch (IOException iOException) {
            DBError.throwSqlException(iOException);
        }
    }

    public void refreshRow() throws SQLException {
        if (!ScrollableResultSet.needIdentifier(this.m_type, this.m_update)) {
            DBError.check_error(23, "refreshRow");
        }
        if (this.isValidRow(this.m_currentRow)) {
            int n2 = this.getFetchDirection();
            try {
                this.refreshRowsInCache(this.m_currentRow, this.getFetchSize(), n2);
            }
            catch (SQLException sQLException) {
                DBError.throwSqlException(sQLException, 90, "Unsupported syntax for refreshRow()");
            }
        } else {
            DBError.throwSqlException(82, "refreshRow");
        }
    }

    synchronized int refreshRowsInCache(int n2, int n3, int n4) throws SQLException {
        int n5;
        OracleResultSet oracleResultSet;
        block6: {
            oracleResultSet = null;
            n5 = 0;
            n5 = this.get_refetch_size(n2, n3, n4);
            try {
                if (n5 <= 0) break block6;
                if (n5 != this.m_lastRefetchSz) {
                    if (this.m_refetchStmt != null) {
                        this.m_refetchStmt.close();
                    }
                    this.m_refetchStmt = this.prepare_refetch_statement(n5);
                    this.m_lastRefetchSz = n5;
                }
                this.prepare_refetch_binds(this.m_refetchStmt, n5);
                oracleResultSet = (OracleResultSet)this.m_refetchStmt.executeQuery();
                this.save_refetch_results(oracleResultSet, n2, n5, n4);
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (oracleResultSet != null) {
                    oracleResultSet.close();
                }
                throw throwable;
            }
        }
        Object var7_6 = null;
        if (oracleResultSet != null) {
            oracleResultSet.close();
        }
        return n5;
    }

    public synchronized boolean relative(int n2) throws SQLException {
        if (this.isEmptyResultSet()) {
            return false;
        }
        if (this.isValidRow(this.m_currentRow)) {
            this.m_currentRow += n2;
            return this.isValidRow(this.m_currentRow);
        }
        DBError.throwSqlException(82, "relative");
        return false;
    }

    private void removeCachedRowAt(int n2) throws SQLException {
        try {
            this.m_cache.remove(n2);
        }
        catch (IOException iOException) {
            DBError.throwSqlException(iOException);
        }
    }

    synchronized int removeRowInCache(int n2) throws SQLException {
        if (!this.isEmptyResultSet() && this.isValidRow(n2)) {
            this.removeCachedRowAt(n2);
            --this.m_numRowsCached;
            if (n2 >= this.m_currentRow) {
                --this.m_currentRow;
            }
            return 1;
        }
        return 0;
    }

    synchronized void resetBeginColumnIndex() {
        this.m_beginColumnIndex = 0;
    }

    private void save_refetch_results(OracleResultSet oracleResultSet, int n2, int n3, int n4) throws SQLException {
        int n5 = n4 == 1001 ? -1 : 1;
        while (oracleResultSet.next()) {
            ROWID rOWID = oracleResultSet.getROWID(1);
            boolean bl = false;
            int n6 = n2;
            while (!bl && n6 < n2 + n3 * n5) {
                if (((ROWID)this.getCachedDatumValueAt(n6, 1)).stringValue().equals(rOWID.stringValue())) {
                    bl = true;
                    continue;
                }
                n6 += n5;
            }
            if (!bl) continue;
            int n7 = 0;
            while (n7 < this.getColumnCount()) {
                this.putCachedValueAt(n6, n7 + 1, oracleResultSet.getOracleObject(n7 + 1));
                ++n7;
            }
        }
    }

    public void setCurrentRowValueAt(Object object, int n2, Object object2) throws SQLException {
        if (object instanceof UpdatableResultSet) {
            this.putCachedValueAt(this.m_currentRow, n2, object2);
        } else {
            DBError.throwSqlException(1);
        }
    }

    public synchronized void setFetchDirection(int n2) throws SQLException {
        if (n2 == 1000) {
            this.m_usrFetchDirection = n2;
        } else if (n2 == 1001 || n2 == 1002) {
            this.m_usrFetchDirection = n2;
            this.m_warning = DBError.addSqlWarning(this.m_warning, 87);
        } else {
            DBError.throwSqlException(68, "setFetchDirection");
        }
    }

    public synchronized void setFetchSize(int n2) throws SQLException {
        this.m_rset.setFetchSize(n2);
    }

    public static boolean supportRefreshRow(int n2, int n3) {
        return n2 != 1003 && (n2 != 1004 || n3 != 1007);
    }

    public synchronized boolean wasNull() throws SQLException {
        if (this.m_wasNull == -1) {
            DBError.throwSqlException(24);
        }
        return this.m_wasNull == 1;
    }
}

