/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import java.util.Map;
import oracle.jdbc.OracleDatabaseMetaData;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.internal.OracleResultSet;
import oracle.jdbc.internal.OracleStatement;
import oracle.jdbc.oracore.OracleNamedType;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.sql.StructDescriptor;
import oracle.sql.TypeDescriptor;

public class OracleResultSetMetaData
implements oracle.jdbc.internal.OracleResultSetMetaData {
    oracle.jdbc.internal.OracleConnection connection;
    OracleStatement statement;
    int m_beginColumnIndex;

    public OracleResultSetMetaData(oracle.jdbc.internal.OracleConnection oracleConnection, OracleStatement oracleStatement) throws SQLException {
        this.connection = oracleConnection;
        this.statement = oracleStatement;
        oracleStatement.describe();
        this.m_beginColumnIndex = 0;
    }

    OracleResultSetMetaData(oracle.jdbc.internal.OracleConnection oracleConnection, OracleStatement oracleStatement, int n2) throws SQLException {
        this.connection = oracleConnection;
        this.statement = oracleStatement;
        oracleStatement.describe();
        this.m_beginColumnIndex = n2;
    }

    public OracleResultSetMetaData(OracleResultSet oracleResultSet) throws SQLException {
        this.statement = (OracleStatement)oracleResultSet.getStatement();
        this.connection = (oracle.jdbc.internal.OracleConnection)this.statement.getConnection();
        this.statement.describe();
        this.m_beginColumnIndex = oracleResultSet.getFirstUserColumnIndex();
    }

    public String getCatalogName(int n2) throws SQLException {
        return "";
    }

    public String getColumnClassName(int n2) throws SQLException {
        int n3 = this.getValidColumnIndex(n2);
        int n4 = this.statement.getDBDescription()[n3].type;
        switch (n4) {
            case 1: 
            case 8: 
            case 96: 
            case 999: {
                return "java.lang.String";
            }
            case 2: 
            case 6: {
                return "java.math.BigDecimal";
            }
            case 23: 
            case 24: {
                return "byte[]";
            }
            case 12: {
                return "java.sql.Timestamp";
            }
            case 180: {
                return "oracle.sql.TIMESTAMP";
            }
            case 181: {
                return "oracle.sql.TIMESTAMPTZ";
            }
            case 231: {
                return "oracle.sql.TIMESTAMPLTZ";
            }
            case 104: {
                return "oracle.sql.ROWID";
            }
            case 113: {
                return "oracle.sql.BLOB";
            }
            case 112: {
                return "oracle.sql.CLOB";
            }
            case 114: {
                return "oracle.sql.BFILE";
            }
            case 102: {
                return "oracle.jdbc.driver.OracleResultSet";
            }
            case 109: {
                switch (this.getColumnType(n2)) {
                    case 2003: {
                        return "oracle.sql.ARRAY";
                    }
                    case 2007: {
                        return "oracle.sql.OPAQUE";
                    }
                    case 2008: {
                        Class clazz;
                        OracleNamedType oracleNamedType = (OracleNamedType)this.statement.getDBDescription()[n3].otype;
                        Map map = this.connection.getJavaObjectTypeMap();
                        if (map != null && (clazz = (Class)map.get(oracleNamedType.getFullName())) != null) {
                            return clazz.getName();
                        }
                        return StructDescriptor.getJavaObjectClassName(this.connection, oracleNamedType.getSchemaName(), oracleNamedType.getSimpleName());
                    }
                    case 2002: {
                        Class clazz;
                        Map map = this.connection.getTypeMap();
                        if (map != null && (clazz = (Class)map.get(((OracleNamedType)this.statement.getDBDescription()[n3].otype).getFullName())) != null) {
                            return clazz.getName();
                        }
                        return "oracle.sql.STRUCT";
                    }
                }
                DBError.throwSqlException(1);
            }
            case 111: {
                return "oracle.sql.REF";
            }
        }
        return null;
    }

    public int getColumnCount() throws SQLException {
        return this.statement.getDBDescription().length - this.m_beginColumnIndex;
    }

    public int getColumnDisplaySize(int n2) throws SQLException {
        int n3 = this.getValidColumnIndex(n2);
        return this.statement.getDBDescription()[n3].max_length;
    }

    public String getColumnLabel(int n2) throws SQLException {
        return this.getColumnName(n2);
    }

    public String getColumnName(int n2) throws SQLException {
        int n3 = this.getValidColumnIndex(n2);
        return this.statement.getDBDescription()[n3].name;
    }

    public int getColumnType(int n2) throws SQLException {
        int n3 = this.getValidColumnIndex(n2);
        int n4 = this.statement.getDBDescription()[n3].type;
        switch (n4) {
            case 96: {
                return 1;
            }
            case 1: {
                return 12;
            }
            case 8: {
                return -1;
            }
            case 2: 
            case 6: {
                return 2;
            }
            case 23: {
                return -3;
            }
            case 24: {
                return -4;
            }
            case 104: {
                return -8;
            }
            case 102: {
                return -10;
            }
            case 12: {
                return 93;
            }
            case 180: {
                return -100;
            }
            case 181: {
                return -101;
            }
            case 231: {
                return -102;
            }
            case 113: {
                return 2004;
            }
            case 112: {
                return 2005;
            }
            case 114: {
                return -13;
            }
            case 109: {
                OracleNamedType oracleNamedType = (OracleNamedType)this.statement.getDBDescription()[n3].otype;
                TypeDescriptor typeDescriptor = TypeDescriptor.getTypeDescriptor(oracleNamedType.getFullName(), (OracleConnection)this.connection);
                if (typeDescriptor != null) {
                    return typeDescriptor.getTypeCode();
                }
                DBError.throwSqlException(60);
                return -1;
            }
            case 111: {
                return 2006;
            }
        }
        return 1111;
    }

    public String getColumnTypeName(int n2) throws SQLException {
        int n3 = this.getColumnType(n2);
        switch (n3) {
            case 1: {
                return "CHAR";
            }
            case 12: {
                return "VARCHAR2";
            }
            case -1: {
                return "LONG";
            }
            case -3: {
                return "RAW";
            }
            case -4: {
                return "LONG RAW";
            }
            case 2: {
                return "NUMBER";
            }
            case 93: {
                return "DATE";
            }
            case -100: {
                return "TIMESTAMP";
            }
            case -101: {
                return "TIMESTAMPTZ";
            }
            case -102: {
                return "TIMESTAMPLTZ";
            }
            case -8: {
                return "ROWID";
            }
            case -10: {
                return "REFCURSOR";
            }
            case 2004: {
                return "BLOB";
            }
            case 2005: {
                return "CLOB";
            }
            case -13: {
                return "BFILE";
            }
            case 2002: 
            case 2003: 
            case 2007: 
            case 2008: {
                int n4 = this.getValidColumnIndex(n2);
                OracleTypeADT oracleTypeADT = (OracleTypeADT)this.statement.getDBDescription()[n4].otype;
                return oracleTypeADT.getFullName();
            }
            case 2006: {
                int n5 = this.getValidColumnIndex(n2);
                OracleTypeADT oracleTypeADT = (OracleTypeADT)this.statement.getDBDescription()[n5].otype;
                return oracleTypeADT.getFullName();
            }
        }
        return null;
    }

    public int getPrecision(int n2) throws SQLException {
        int n3 = this.getValidColumnIndex(n2);
        int n4 = this.statement.getDBDescription()[n3].type;
        switch (n4) {
            case 112: 
            case 113: {
                return Integer.parseInt(OracleDatabaseMetaData.getLobPrecision());
            }
            case 8: 
            case 24: {
                return Integer.MAX_VALUE;
            }
            case 1: 
            case 96: {
                return this.statement.getDBDescription()[n3].max_length;
            }
        }
        return this.statement.getDBDescription()[n3].precision;
    }

    public int getScale(int n2) throws SQLException {
        int n3 = this.getValidColumnIndex(n2);
        return this.statement.getDBDescription()[n3].scale;
    }

    public String getSchemaName(int n2) throws SQLException {
        return "";
    }

    public String getTableName(int n2) throws SQLException {
        return "";
    }

    private int getValidColumnIndex(int n2) throws SQLException {
        int n3 = n2 + this.m_beginColumnIndex - 1;
        if (n3 < 0 || n3 >= this.statement.getDBDescription().length) {
            DBError.check_error(3, "getValidColumnIndex");
        }
        return n3;
    }

    public boolean isAutoIncrement(int n2) throws SQLException {
        return false;
    }

    public boolean isCaseSensitive(int n2) throws SQLException {
        int n3 = this.getColumnType(n2);
        return n3 == 1 || n3 == 12 || n3 == -1;
    }

    public boolean isCurrency(int n2) throws SQLException {
        return this.getColumnType(n2) == 2;
    }

    public boolean isDefinitelyWritable(int n2) throws SQLException {
        return false;
    }

    public int isNullable(int n2) throws SQLException {
        int n3 = this.getValidColumnIndex(n2);
        return this.statement.getDBDescription()[n3].nullable ? 1 : 0;
    }

    public boolean isReadOnly(int n2) throws SQLException {
        return false;
    }

    public boolean isSearchable(int n2) throws SQLException {
        int n3 = this.getColumnType(n2);
        return (n3 == -4 || n3 == -1 || n3 == 2004 || n3 == 2005 || n3 == -13 || n3 == 2002 || n3 == 2008 || n3 == 2007 || n3 == 2003 || n3 == 2006 || n3 == -10) ^ true;
    }

    public boolean isSigned(int n2) throws SQLException {
        return true;
    }

    public boolean isWritable(int n2) throws SQLException {
        return true;
    }
}

