/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Date;
import oracle.jdbc.driver.OracleConnection;

public class OracleLog {
    public static final int MASK_ALL_SET = 0xFFFFFFF;
    public static final int MAX_VECTOR_BITS = 32;
    public static final int MAX_MODULES = 32;
    public static final int MODULE_ALL = 0xFFFFFFF;
    public static final int MODULE_DRIVER = 1;
    public static final int MODULE_DBACCESS = 2;
    public static final int MODULE_DBCONV = 4;
    public static final int MODULE_JOLT = 8;
    public static final int MODULE_PICKLE = 16;
    public static final int MODULE_JTTC = 32;
    public static final int MODULE_DATUM = 64;
    public static final int MODULE_KPRB = 128;
    public static final int MODULE_XA = 256;
    public static final int MODULE_TOTAL = 9;
    public static final String[] ModuleName = new String[]{"DRVR ", "DBAC ", "DBCV ", "JOLT ", "PIKL ", "JTTC ", "DATM ", "KPRB ", "XA   "};
    public static final int SUBMOD_ALL = 0xFFFFFFF;
    public static final int SUBMOD_DEFAULT = 1;
    public static final int SUBMOD_DRVR_LOG = 2;
    public static final int SUBMOD_DRVR_ERR = 4;
    public static final int SUBMOD_DRVR_CONN = 8;
    public static final int SUBMOD_DRVR_STMT = 16;
    public static final int SUBMOD_DRVR_RSET = 32;
    public static final int SUBMOD_DRVR_UTIL = 64;
    public static final int SUBMOD_DRVR_SQL = 128;
    public static final int SUBMOD_DBAC_DATA = 2;
    public static final int SUBMOD_PCKL_INIT = 2;
    public static final int SUBMOD_PCKL_TYPE = 4;
    public static final int SUBMOD_PCKL_PCKL = 8;
    public static final int SUBMOD_PCKL_UNPK = 16;
    public static final int SUBMOD_PCKL_CONV = 32;
    public static final int SUBMOD_PCKL_DESC = 64;
    public static final int SUBMOD_JOLT_COMM = 2;
    public static final int SUBMOD_JOLT_BASE = 4;
    public static final int SUBMOD_JOLT_JDBC = 8;
    public static final int SUBMOD_JTTC_BASE = 2;
    public static final int SUBMOD_JTTC_TX = 4;
    public static final int SUBMOD_JTTC_RX = 8;
    public static final int CATEGORY_ALL = 0xFFFFFFF;
    public static final int USER_OPER = 1;
    public static final int PROG_ERROR = 2;
    public static final int ERROR = 4;
    public static final int WARNING = 8;
    public static final int FUNCTION = 16;
    public static final int DEBUG1 = 32;
    public static final int DEBUG2 = 64;
    public static final int CATEGORY_TOTAL = 7;
    public static final String[] CategoryName = new String[]{"OPER ", "PERR ", "ERRO ", "WARN ", "FUNC ", "DBG1 ", "DBG2 "};
    public static final int CATEGORY_LOW_VOL = 15;
    public static final int CATEGORY_MED_VOL = 63;
    public static final int CATEGORY_HIGH_VOL = 0xFFFFFFF;
    public static final int FIELD_NONE = 0;
    public static final int FIELD_ALL = 0xFFFFFFF;
    public static final int FIELD_NUMBER = 1;
    public static final int FIELD_TIME = 2;
    public static final int FIELD_MODULE = 4;
    public static final int FIELD_SUBMOD = 8;
    public static final int FIELD_CATEGORY = 16;
    public static final int FIELD_CONN = 32;
    public static final int FIELD_THREAD = 64;
    public static final int FIELD_DEFAULT = 20;
    public static final boolean TRACE = false;
    private static boolean m_initialized = false;
    private static PrintWriter m_logWriter = null;
    private static PrintStream m_logStream = null;
    private static int m_printMask = 20;
    private static int m_moduleMask = 0xFFFFFFF;
    private static int[] m_submodMasks = null;
    private static int m_categoryMask = 0xFFFFFFF;
    private static int m_maxPrintBytes = 200;
    private static boolean m_warningEnabled = true;
    private static int m_msgNumber = 0;

    static {
        m_submodMasks = new int[32];
        int n2 = 0;
        while (n2 < 32) {
            OracleLog.m_submodMasks[n2] = 0xFFFFFFF;
            ++n2;
        }
    }

    public static String byteToHexString(byte by) {
        StringBuffer stringBuffer = new StringBuffer("");
        int n2 = 0xFF & by;
        if (n2 <= 15) {
            stringBuffer.append("0x0");
        } else {
            stringBuffer.append("0x");
        }
        stringBuffer.append(Integer.toHexString(n2));
        return stringBuffer.toString();
    }

    public static String bytesToFormattedStr(byte[] byArray, int n2, String string) {
        StringBuffer stringBuffer = new StringBuffer("");
        if (string == null) {
            string = new String("");
        }
        stringBuffer.append(string);
        if (byArray == null) {
            stringBuffer.append("byte [] is null");
            return stringBuffer.toString();
        }
        int n3 = 0;
        while (n3 < n2) {
            int n4;
            if (n3 >= m_maxPrintBytes) {
                stringBuffer.append("\n" + string + "... last " + (n2 - m_maxPrintBytes) + " bytes were not printed to limit the output size");
                break;
            }
            if (n3 > 0 && n3 % 20 == 0) {
                stringBuffer.append("\n" + string);
            }
            if (n3 % 20 == 10) {
                stringBuffer.append(" ");
            }
            if ((n4 = 0xFF & byArray[n3]) <= 15) {
                stringBuffer.append("0");
            }
            stringBuffer.append(String.valueOf(Integer.toHexString(n4)) + " ");
            ++n3;
        }
        return stringBuffer.toString();
    }

    public static String bytesToPrintableForm(String string, byte[] byArray) {
        int n2 = byArray == null ? 0 : byArray.length;
        return OracleLog.bytesToPrintableForm(string, byArray, n2);
    }

    public static String bytesToPrintableForm(String string, byte[] byArray, int n2) {
        String string2 = null;
        string2 = byArray == null ? String.valueOf(string) + ": null" : String.valueOf(string) + " (" + byArray.length + " bytes):\n" + OracleLog.bytesToFormattedStr(byArray, n2, "  ");
        return string2;
    }

    public static byte[] charsToUcs2Bytes(char[] cArray) {
        if (cArray == null) {
            return null;
        }
        return OracleLog.charsToUcs2Bytes(cArray, cArray.length);
    }

    public static byte[] charsToUcs2Bytes(char[] cArray, int n2) {
        if (cArray == null) {
            return null;
        }
        if (n2 < 0) {
            return null;
        }
        byte[] byArray = new byte[2 * n2];
        int n3 = 0;
        int n4 = 0;
        while (n3 < n2) {
            byArray[n4++] = (byte)(cArray[n3] >> 8 & 0xFF);
            byArray[n4++] = (byte)(cArray[n3] & 0xFF);
            ++n3;
        }
        return byArray;
    }

    public static void config(int n2, int n3, int n4) {
        m_printMask = n2;
        m_moduleMask = n3;
        m_categoryMask = n4;
        OracleLog.print(1, 2, 1, "Set logging masks (printMask " + OracleLog.getMaskHexStr(m_printMask) + ", moduleMask " + OracleLog.getMaskHexStr(m_moduleMask) + ", categoryMask " + OracleLog.getMaskHexStr(m_categoryMask) + ")");
    }

    public static void enableWarning(boolean bl) {
        m_warningEnabled = bl;
    }

    public static int getBitNumFromVector(int n2) {
        int n3 = 0;
        int n4 = 1;
        int n5 = 0;
        while (n5 < 32) {
            if ((n2 & n4) != 0) {
                n3 = n5;
                break;
            }
            n4 <<= 1;
            ++n5;
        }
        return n3;
    }

    public static String getCategoryName(int n2) {
        String string = null;
        int n3 = 1;
        int n4 = 0;
        while (n4 < 7) {
            if ((n3 & n2) != 0) {
                string = CategoryName[n4];
                break;
            }
            n3 <<= 1;
            ++n4;
        }
        return string;
    }

    private static String getCurrTimeStr() {
        Date date = new Date();
        return String.valueOf(date.toString()) + " ";
    }

    public static PrintStream getLogStream() {
        return m_logStream;
    }

    public static PrintWriter getLogWriter() {
        return m_logWriter;
    }

    private static String getMaskHexStr(int n2) {
        int n3 = 8;
        String string = Integer.toHexString(n2);
        char[] cArray = new char[n3 - string.length()];
        int n4 = 0;
        while (n4 < cArray.length) {
            cArray[n4] = 48;
            ++n4;
        }
        String string2 = new String(cArray);
        return new String("0x" + string2 + string);
    }

    private static String getMessageNumber() {
        int n2;
        int n3;
        StringBuffer stringBuffer = new StringBuffer("");
        PrintWriter printWriter = m_logWriter;
        synchronized (printWriter) {
            m_msgNumber = m_msgNumber == Integer.MAX_VALUE ? 0 : ++m_msgNumber;
            n3 = m_msgNumber;
        }
        String string = Integer.toString(n3);
        int n4 = n2 = string.length();
        while (n4 < 10) {
            stringBuffer.append("0");
            ++n4;
        }
        stringBuffer.append(string);
        stringBuffer.append(" ");
        return stringBuffer.toString();
    }

    public static String getModuleName(int n2) {
        String string = null;
        int n3 = 1;
        int n4 = 0;
        while (n4 < 9) {
            if ((n3 & n2) != 0) {
                string = ModuleName[n4];
                break;
            }
            n3 <<= 1;
            ++n4;
        }
        return string;
    }

    public static String info() {
        String string = null;
        string = OracleLog.isEnabled() ? "Enabled logging (moduleMask " + OracleLog.getMaskHexStr(m_moduleMask) + ", categoryMask " + OracleLog.getMaskHexStr(m_categoryMask) + ")" : "Disabled logging";
        return string;
    }

    private static boolean initialize() {
        boolean bl = false;
        if (m_initialized) {
            return bl;
        }
        m_initialized = true;
        if (ModuleName.length != 9) {
            System.out.println("ERROR: OracleLog.ModuleName[] has " + ModuleName.length + " items (expected " + 9 + ")");
        }
        if (CategoryName.length != 7) {
            System.out.println("ERROR: OracleLog.CategoryName[] has " + ModuleName.length + " items (expected " + 9 + ")");
        }
        try {
            String string = null;
            string = System.getProperty("JdbcTrace");
            if (string != null && string.compareTo("true") == 0) {
                OracleLog.setLogStream(System.out);
            }
            if ((string = System.getProperty("PrintMask")) != null) {
                m_printMask = Integer.parseInt(string);
            }
            if ((string = System.getProperty("ModuleMask")) != null) {
                m_moduleMask = Integer.parseInt(string);
            }
            if ((string = System.getProperty("CategoryMask")) != null) {
                m_categoryMask = Integer.parseInt(string);
            }
            int n2 = 0;
            while (n2 < 32) {
                string = System.getProperty("SubmodMask" + n2);
                if (string != null) {
                    OracleLog.m_submodMasks[n2] = Integer.parseInt(string);
                }
                ++n2;
            }
            string = System.getProperty("MaxPrintBytes");
            if (string != null) {
                m_maxPrintBytes = Integer.parseInt(string);
            }
        }
        catch (SecurityException securityException) {
            bl = true;
        }
        return bl;
    }

    public static boolean isEnabled() {
        return false;
    }

    public static void print(int n2, int n3, int n4, String string) {
        OracleLog.print(null, n2, n3, n4, string);
    }

    public static void print(int n2, int n3, String string) {
        OracleLog.print(null, n2, 1, n3, string);
    }

    public static void print(OracleConnection oracleConnection, int n2, int n3, int n4, String string) {
        if (m_logWriter == null) {
            return;
        }
        boolean bl = false;
        if ((n2 & m_moduleMask) != 0 && (n3 & m_submodMasks[OracleLog.getBitNumFromVector(n2)]) != 0 && (n4 & m_categoryMask) != 0) {
            bl = true;
        }
        if ((n4 & 4) != 0) {
            bl = true;
        }
        if (m_warningEnabled && (n4 & 8) != 0) {
            bl = true;
        }
        if (bl) {
            StringBuffer stringBuffer = new StringBuffer("");
            if ((m_printMask & 1) != 0) {
                stringBuffer.append(OracleLog.getMessageNumber());
            }
            if ((m_printMask & 2) != 0) {
                stringBuffer.append(OracleLog.getCurrTimeStr());
            }
            if ((m_printMask & 4) != 0) {
                stringBuffer.append(OracleLog.getModuleName(n2));
            }
            if ((m_printMask & 8) != 0) {
                stringBuffer.append(String.valueOf(OracleLog.getBitNumFromVector(n3)) + " ");
            }
            if ((m_printMask & 0x10) != 0) {
                stringBuffer.append(OracleLog.getCategoryName(n4));
            }
            if ((m_printMask & 0x40) != 0) {
                stringBuffer.append(String.valueOf(Thread.currentThread().getName()) + " ");
            }
            stringBuffer.append(string);
            m_logWriter.println(stringBuffer.toString());
            m_logWriter.flush();
        }
    }

    public static void print(OracleConnection oracleConnection, int n2, int n3, String string) {
        OracleLog.print(oracleConnection, n2, 1, n3, string);
    }

    public static void setLogStream(PrintStream printStream) {
        if (printStream == null) {
            OracleLog.setLogWriter(null);
        } else {
            OracleLog.setLogWriter(new PrintWriter(printStream));
        }
        m_logStream = printStream;
    }

    public static void setLogVolume(int n2) {
        OracleLog.print(1, 2, 1, "Set logging volume level to " + n2);
        int n3 = 15;
        switch (n2) {
            case 1: {
                n3 = 15;
                break;
            }
            case 2: {
                n3 = 63;
                break;
            }
            case 3: {
                n3 = 0xFFFFFFF;
                break;
            }
            default: {
                OracleLog.print(1, 2, 4, "Logging volume level " + n2 + " is not in the range of 1 to 3");
                return;
            }
        }
        OracleLog.config(m_printMask, m_moduleMask, n3);
    }

    public static void setLogWriter(PrintWriter printWriter) {
        boolean bl = OracleLog.initialize();
        if (printWriter == null) {
            OracleLog.setTrace(false);
            OracleLog.print(1, 2, 1, OracleLog.info());
            m_logWriter = printWriter;
        } else {
            OracleLog.setTrace(true);
            m_logWriter = printWriter;
            OracleLog.print(1, 2, 1, OracleLog.info());
            if (bl) {
                OracleLog.print(1, 2, 32, "Properties were ignored in an applet environment");
            }
        }
    }

    public static void setMaxPrintBytes(int n2) {
        if (n2 > 0) {
            m_maxPrintBytes = n2;
        }
        OracleLog.print(1, 2, 1, "Set the maximum number of bytes to be printed to " + m_maxPrintBytes);
    }

    public static void setSubmodMask(int n2, int n3) {
        int n4 = OracleLog.getBitNumFromVector(n2);
        OracleLog.m_submodMasks[n4] = n3;
        OracleLog.print(1, 2, 1, "Set logging sub-mask for module " + OracleLog.getMaskHexStr(m_moduleMask) + "(number " + n4 + ") to " + OracleLog.getMaskHexStr(n3));
    }

    private static void setTrace(boolean bl) {
        boolean bl2 = bl;
    }

    public static void startLogging() {
        OracleLog.setLogStream(System.out);
    }

    public static void stopLogging() {
        OracleLog.setLogStream(null);
    }

    public static byte[] strToUcs2Bytes(String string) {
        if (string == null) {
            return null;
        }
        return OracleLog.charsToUcs2Bytes(string.toCharArray());
    }

    public static void test() {
        OracleLog.setLogStream(System.out);
        OracleLog.enableWarning(true);
        OracleLog.config(20, 1, 0xFFFFFFF);
        OracleLog.setLogStream(null);
    }

    public static String toPrintableStr(String string, int n2) {
        if (string == null) {
            return "null";
        }
        if (string.length() > n2) {
            return String.valueOf(string.substring(0, n2 - 1)) + "\n ... the actual length was " + string.length();
        }
        return string;
    }
}

