/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import oracle.jdbc.dbaccess.DBAccess;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.oci.OracleOCIConnection;

public class OracleDriver
implements Driver {
    public static final char slash_character = '/';
    public static final char at_sign_character = '@';
    static final String oracle_string = "oracle";
    public static final String user_string = "user";
    public static final String password_string = "password";
    public static final String database_string = "database";
    static final String server_string = "server";
    static final String access_string = "access";
    public static final String protocol_string = "protocol";
    public static final String dll_string = "dll";
    public static final String logon_as_internal_str = "internal_logon";
    static final String prefetch_string = "prefetch";
    static final String row_prefetch_string = "rowPrefetch";
    static final String default_row_prefetch_string = "defaultRowPrefetch";
    static final String batch_string = "batch";
    static final String execute_batch_string = "executeBatch";
    static final String default_execute_batch_string = "defaultExecuteBatch";
    static final String accumulate_batch_result = "AccumulateBatchResult";
    static final String remarks_string = "remarks";
    static final String report_remarks_string = "remarksReporting";
    private static final String synonyms_string = "synonyms";
    private static final String include_synonyms_string = "includeSynonyms";
    private static final String restrict_getTables_string = "restrictGetTables";
    private static final String fixed_string_string = "fixedString";
    private static final int ACCEPTS_URL_GEN_ERROR = 1;
    private static final int ACCEPTS_URL_ORACLE_ERROR = 2;
    private static final int ACCEPTS_URL_SUCCESS = 3;
    private static final String DRIVER_ULTRA = "ultra";
    private static Properties m_driverAccess = new Properties();
    protected static Connection m_defaultConn;
    private static OracleDriver m_defaultDriver;

    static {
        ((Hashtable)m_driverAccess).put("thin", "oracle.jdbc.ttc7.TTC7Protocol");
        ((Hashtable)m_driverAccess).put("oci8", "oracle.jdbc.oci8.OCIDBAccess");
        ((Hashtable)m_driverAccess).put("oci", "oracle.jdbc.oci8.OCIDBAccess");
        ((Hashtable)m_driverAccess).put("kprb", "oracle.jdbc.kprb.KprbDBAccess");
        m_defaultConn = null;
        m_defaultDriver = null;
        try {
            if (m_defaultDriver == null) {
                m_defaultDriver = new OracleDriver();
                DriverManager.registerDriver(m_defaultDriver);
            }
        }
        catch (RuntimeException runtimeException) {
        }
        catch (SQLException sQLException) {}
    }

    public boolean acceptsURL(String string) {
        int n2 = this.oracleAcceptsURL(string);
        return n2 == 3;
    }

    public Connection connect(String string, Properties properties) throws SQLException {
        Object object;
        String string2;
        String string3;
        String string4;
        String string5;
        int n2;
        if (string.regionMatches(0, "jdbc:default:connection", 0, 23)) {
            String string6 = "jdbc:oracle:kprb";
            int n3 = string.length();
            string = n3 > 23 ? string6.concat(string.substring(23, string.length())) : string6.concat(":");
            string6 = null;
        }
        if ((n2 = this.oracleAcceptsURL(string)) == 1) {
            return null;
        }
        if (n2 == 2) {
            DBError.throwSqlException(67);
            return null;
        }
        Hashtable hashtable = this.parseUrl(string);
        if (hashtable == null) {
            return null;
        }
        String string7 = properties.getProperty(user_string);
        String string8 = properties.getProperty(password_string);
        String string9 = properties.getProperty(database_string);
        if (string9 == null) {
            string9 = properties.getProperty(server_string);
        }
        if (string7 == null) {
            string7 = (String)hashtable.get(user_string);
        }
        string7 = this.parseLoginOption(string7, properties);
        if (string8 == null) {
            string8 = (String)hashtable.get(password_string);
        }
        if (string9 == null) {
            string9 = (String)hashtable.get(database_string);
        }
        String string10 = (String)hashtable.get(protocol_string);
        ((Hashtable)properties).put(protocol_string, string10);
        if (string10 == null) {
            DBError.throwSqlException(40, "Protocol is not specified in URL");
            return null;
        }
        String string11 = properties.getProperty(dll_string);
        if (string11 == null) {
            ((Hashtable)properties).put(dll_string, "ocijdbc9");
        }
        if ((string5 = properties.getProperty(prefetch_string)) == null) {
            string5 = properties.getProperty(row_prefetch_string);
        }
        if (string5 == null) {
            string5 = properties.getProperty(default_row_prefetch_string);
        }
        if (string5 != null && Integer.parseInt(string5) <= 0) {
            string5 = null;
        }
        if ((string4 = properties.getProperty(batch_string)) == null) {
            string4 = properties.getProperty(execute_batch_string);
        }
        if (string4 == null) {
            string4 = properties.getProperty(default_execute_batch_string);
        }
        if (string4 != null && Integer.parseInt(string4) <= 0) {
            string4 = null;
        }
        if ((string3 = properties.getProperty(remarks_string)) == null) {
            string3 = properties.getProperty(report_remarks_string);
        }
        if ((string2 = properties.getProperty(synonyms_string)) == null) {
            string2 = properties.getProperty(include_synonyms_string);
        }
        String string12 = properties.getProperty(restrict_getTables_string);
        String string13 = properties.getProperty(fixed_string_string);
        String string14 = properties.getProperty(accumulate_batch_result);
        if (string14 == null) {
            string14 = "true";
        }
        Enumeration<Driver> enumeration = DriverManager.getDrivers();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            if (object instanceof OracleDriver) break;
        }
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            if (!(object instanceof OracleDriver)) continue;
            DriverManager.deregisterDriver((Driver)object);
        }
        object = this.getConnectionInstance(string10, string, string7, string8, string9, properties);
        if (string5 != null) {
            ((OracleConnection)object).setDefaultRowPrefetch(Integer.parseInt(string5));
        }
        if (string4 != null) {
            ((OracleConnection)object).setDefaultExecuteBatch(Integer.parseInt(string4));
        }
        if (string3 != null) {
            ((OracleConnection)object).setRemarksReporting(string3.equalsIgnoreCase("true"));
        }
        if (string2 != null) {
            ((OracleConnection)object).setIncludeSynonyms(string2.equalsIgnoreCase("true"));
        }
        if (string12 != null) {
            ((OracleConnection)object).setRestrictGetTables(string12.equalsIgnoreCase("true"));
        }
        if (string13 != null) {
            ((OracleConnection)object).setDefaultFixedString(string13.equalsIgnoreCase("true"));
        }
        ((OracleConnection)object).setAccumulateBatchResult(string14.equalsIgnoreCase("true"));
        hashtable = null;
        return object;
    }

    public Connection defaultConnection() throws SQLException {
        if (m_defaultConn == null || m_defaultConn.isClosed()) {
            m_defaultConn = DriverManager.getConnection("jdbc:oracle:kprb:");
        }
        return m_defaultConn;
    }

    public static String getCompileTime() {
        String string = "Thu_Aug__2_12:59:58_PDT_2001-stint198-jpgint";
        return string;
    }

    private Connection getConnectionInstance(String string, String string2, String string3, String string4, String string5, Properties properties) throws SQLException {
        Connection connection = null;
        if (string.compareTo(DRIVER_ULTRA) == 0) {
            try {
                Class<?>[] classArray = null;
                Object[] objectArray = new Object[]{string, string2, string3, string4, string5, properties};
                Class<?> clazz = Class.forName("oracle.jdbc.ultra.client.Driver");
                Method[] methodArray = clazz.getMethods();
                int n2 = 0;
                while (n2 < methodArray.length) {
                    if (methodArray[n2].getName().equals("getConnection")) {
                        classArray = methodArray[n2].getParameterTypes();
                        break;
                    }
                    ++n2;
                }
                Method method = clazz.getMethod("getConnection", classArray);
                connection = (Connection)method.invoke(clazz.newInstance(), objectArray);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                DBError.throwSqlException(1);
            }
        } else {
            String string6 = (String)((Hashtable)m_driverAccess).get(string);
            if (string6 == null) {
                DBError.throwSqlException(67, "Invalid protocol " + string);
            }
            DBAccess dBAccess = null;
            try {
                dBAccess = (DBAccess)Class.forName(string6).newInstance();
            }
            catch (Exception exception) {
                return null;
            }
            if (properties.getProperty("is_connection_pooling") == "true") {
                ((Hashtable)properties).put(database_string, string5 == null ? "" : string5);
                connection = new OracleOCIConnection(dBAccess, string2, string3, string4, string5, properties);
            } else {
                connection = new OracleConnection(dBAccess, string2, string3, string4, string5, properties);
            }
        }
        return connection;
    }

    public int getMajorVersion() {
        return 1;
    }

    public int getMinorVersion() {
        return 0;
    }

    public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) throws SQLException {
        return new DriverPropertyInfo[0];
    }

    public boolean jdbcCompliant() {
        return true;
    }

    private int oracleAcceptsURL(String string) {
        int n2 = string.indexOf(58);
        if (n2 == -1) {
            return 1;
        }
        int n3 = string.indexOf(58, n2 + 1);
        if (n3 == -1) {
            return 1;
        }
        if (!string.regionMatches(true, n2 + 1, oracle_string, 0, n3 - (n2 + 1))) {
            return 1;
        }
        int n4 = string.indexOf(58, n3 + 1);
        if (n4 == -1) {
            return 2;
        }
        String string2 = string.substring(n3 + 1, n4);
        if ((string2.equals("oci8") || string2.equals("oci")) && System.getProperty("oracle.jserver.version") != null) {
            return 2;
        }
        if (string2.equals("oci8") || string2.equals("oci") || string2.equals("thin") || string2.equals("kprb") || string2.equals(DRIVER_ULTRA)) {
            return 3;
        }
        return 2;
    }

    private String parseLoginOption(String string, Properties properties) {
        int n2 = 0;
        String string2 = null;
        if (string == null) {
            return null;
        }
        int n3 = string.length();
        if (n3 == 0) {
            return null;
        }
        String string3 = string.toLowerCase();
        n2 = string3.lastIndexOf(" as ");
        if (n2 == -1 || n2 < string3.lastIndexOf("\"")) {
            return string;
        }
        string2 = string.substring(0, n2);
        n2 += 4;
        while (n2 < n3 && string3.charAt(n2) == ' ') {
            ++n2;
        }
        if (n2 == n3) {
            return string;
        }
        String string4 = string3.substring(n2).trim();
        if (string4.length() > 0) {
            ((Hashtable)properties).put(logon_as_internal_str, string4);
        }
        return string2;
    }

    private Hashtable parseUrl(String string) throws SQLException {
        int n2;
        Hashtable<String, String> hashtable = new Hashtable<String, String>(5);
        int n3 = string.indexOf(58, string.indexOf(58) + 1) + 1;
        if (n3 == (n2 = string.length())) {
            return hashtable;
        }
        int n4 = string.indexOf(58, n3);
        if (n4 == -1) {
            return hashtable;
        }
        hashtable.put(protocol_string, string.substring(n3, n4));
        int n5 = n4 + 1;
        int n6 = string.indexOf(47, n5);
        int n7 = string.indexOf(64, n5);
        if (n7 > n5 && n5 > n3 && n6 == -1) {
            return null;
        }
        if (n7 == -1) {
            n7 = n2;
        }
        if (n6 == -1) {
            n6 = n7;
        }
        if (n5 < n6) {
            hashtable.put(user_string, string.substring(n5, n6));
        }
        if (n6 < n7) {
            hashtable.put(password_string, string.substring(n6 + 1, n7));
        }
        if (n7 < n2) {
            hashtable.put(database_string, string.substring(n7 + 1));
        }
        return hashtable;
    }
}

