/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBConversion;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleBufferedStream;

public class OracleConversionInputStream
extends OracleBufferedStream {
    static final int CHUNK_SIZE = 4096;
    DBConversion converter;
    int conversion;
    InputStream istream;
    Reader reader;
    byte[] convbuf;
    char[] java_chars;
    int max_size;
    int total_size;
    int numUnconvertedBytes;
    boolean endOfStream;
    private short csform;

    public OracleConversionInputStream(DBConversion dBConversion, InputStream inputStream, int n2) {
        super(4096);
        this.istream = inputStream;
        this.conversion = n2;
        this.converter = dBConversion;
        this.max_size = 0;
        this.total_size = 0;
        this.numUnconvertedBytes = 0;
        this.endOfStream = false;
        switch (n2) {
            case 0: {
                this.java_chars = new char[4096];
                this.convbuf = new byte[4096];
                break;
            }
            case 1: {
                this.convbuf = new byte[2048];
                this.java_chars = new char[2048];
                break;
            }
            case 2: {
                this.convbuf = new byte[2048];
                this.java_chars = new char[4096];
                break;
            }
            case 3: {
                this.convbuf = new byte[1024];
                this.java_chars = new char[2048];
                break;
            }
            case 4: {
                int n3 = 4096 / this.converter.getMaxCharbyteSize();
                this.convbuf = new byte[n3 * 2];
                this.java_chars = new char[n3];
                break;
            }
            case 5: {
                if (this.converter.isUcs2CharSet()) {
                    this.convbuf = new byte[2048];
                    this.java_chars = new char[2048];
                    break;
                }
                this.convbuf = new byte[4096];
                this.java_chars = new char[4096];
                break;
            }
            case 7: {
                int n4 = 4096 / this.converter.getMaxCharbyteSize();
                this.java_chars = new char[n4];
                break;
            }
            default: {
                this.convbuf = new byte[4096];
                this.java_chars = new char[4096];
            }
        }
    }

    public OracleConversionInputStream(DBConversion dBConversion, InputStream inputStream, int n2, int n3) {
        this(dBConversion, inputStream, n2);
        this.max_size = n3;
        this.total_size = 0;
    }

    public OracleConversionInputStream(DBConversion dBConversion, Reader reader, int n2, int n3) {
        this(dBConversion, null, n2);
        this.reader = reader;
        this.max_size = n3;
        this.total_size = 0;
    }

    public boolean needBytes() throws IOException {
        if (this.closed) {
            return false;
        }
        if (this.pos < this.count) {
            return true;
        }
        if (this.istream != null) {
            return this.needBytesFromStream();
        }
        if (this.reader != null) {
            return this.needBytesFromReader();
        }
        return false;
    }

    public boolean needBytesFromReader() throws IOException {
        try {
            int n2 = 0;
            n2 = this.max_size == 0 ? this.java_chars.length : Math.min(this.max_size - this.total_size, this.java_chars.length);
            if (n2 <= 0) {
                this.reader.close();
                this.close();
                return false;
            }
            int n3 = this.reader.read(this.java_chars, 0, n2);
            if (n3 == -1) {
                this.reader.close();
                this.close();
                return false;
            }
            this.total_size += n3;
            switch (this.conversion) {
                case 7: {
                    if (this.csform == 2) {
                        this.count = this.converter.javaCharsToNCHARBytes(this.java_chars, n3, this.buf);
                        break;
                    }
                    this.count = this.converter.javaCharsToCHARBytes(this.java_chars, n3, this.buf);
                    break;
                }
                default: {
                    System.arraycopy(this.convbuf, 0, this.buf, 0, n3);
                    this.count = n3;
                    break;
                }
            }
        }
        catch (SQLException sQLException) {
            DBError.SQLToIOException(sQLException);
        }
        this.pos = 0;
        return true;
    }

    public boolean needBytesFromStream() throws IOException {
        if (!this.endOfStream) {
            try {
                int n2 = 0;
                n2 = this.max_size == 0 ? this.convbuf.length : Math.min(this.max_size - this.total_size, this.convbuf.length);
                int n3 = 0;
                if (n2 <= 0) {
                    this.endOfStream = true;
                    this.istream.close();
                    if (this.numUnconvertedBytes != 0) {
                        DBError.throwSqlException(55);
                    }
                } else {
                    n3 = this.istream.read(this.convbuf, this.numUnconvertedBytes, n2 - this.numUnconvertedBytes);
                }
                if (n3 == -1) {
                    this.endOfStream = true;
                    this.istream.close();
                    if (this.numUnconvertedBytes != 0) {
                        DBError.throwSqlException(55);
                    }
                } else {
                    this.total_size += (n3 += this.numUnconvertedBytes);
                }
                if (n3 <= 0) {
                    return false;
                }
                switch (this.conversion) {
                    case 0: {
                        int[] nArray = new int[]{n3};
                        int n4 = this.converter.CHARBytesToJavaChars(this.convbuf, nArray, this.java_chars);
                        this.numUnconvertedBytes = nArray[0];
                        int n5 = 0;
                        while (n5 < this.numUnconvertedBytes) {
                            this.convbuf[n5] = this.convbuf[n3 - this.numUnconvertedBytes];
                            ++n5;
                        }
                        this.count = DBConversion.javaCharsToAsciiBytes(this.java_chars, n4, this.buf);
                        break;
                    }
                    case 1: {
                        int[] nArray = new int[]{n3};
                        int n6 = this.converter.CHARBytesToJavaChars(this.convbuf, nArray, this.java_chars);
                        this.numUnconvertedBytes = nArray[0];
                        int n7 = 0;
                        while (n7 < this.numUnconvertedBytes) {
                            this.convbuf[n7] = this.convbuf[n3 - this.numUnconvertedBytes];
                            ++n7;
                        }
                        this.count = DBConversion.javaCharsToUcs2Bytes(this.java_chars, n6, this.buf);
                        break;
                    }
                    case 2: {
                        int n8 = DBConversion.RAWBytesToHexChars(this.convbuf, n3, this.java_chars);
                        this.count = DBConversion.javaCharsToAsciiBytes(this.java_chars, n8, this.buf);
                        break;
                    }
                    case 3: {
                        int n9 = DBConversion.RAWBytesToHexChars(this.convbuf, n3, this.java_chars);
                        this.count = DBConversion.javaCharsToUcs2Bytes(this.java_chars, n9, this.buf);
                        break;
                    }
                    case 4: {
                        int n10 = DBConversion.ucs2BytesToJavaChars(this.convbuf, n3, this.java_chars);
                        this.count = this.converter.javaCharsToCHARBytes(this.java_chars, n10, this.buf);
                        break;
                    }
                    case 5: {
                        DBConversion.asciiBytesToJavaChars(this.convbuf, n3, this.java_chars);
                        this.count = this.converter.javaCharsToCHARBytes(this.java_chars, n3, this.buf);
                        break;
                    }
                    default: {
                        System.arraycopy(this.convbuf, 0, this.buf, 0, n3);
                        this.count = n3;
                        break;
                    }
                }
            }
            catch (SQLException sQLException) {
                DBError.SQLToIOException(sQLException);
            }
            this.pos = 0;
            return true;
        }
        return false;
    }

    public void setFormOfUse(short s2) {
        this.csform = s2;
    }
}

