/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBError;
import oracle.sql.CLOB;

public class OracleClobOutputStream
extends OutputStream {
    long m_lobOffset;
    CLOB m_clob;
    byte[] m_buf;
    int m_count;
    int m_bufSize;
    boolean m_isClosed;

    public OracleClobOutputStream(CLOB cLOB) throws SQLException {
        this(cLOB, cLOB.getConnection().db_access.getDefaultStreamChunkSize(), 1L);
    }

    public OracleClobOutputStream(CLOB cLOB, int n2) throws SQLException {
        this(cLOB, n2, 1L);
    }

    public OracleClobOutputStream(CLOB cLOB, int n2, long l2) throws SQLException {
        if (cLOB == null || n2 <= 0 || l2 < 1L) {
            throw new IllegalArgumentException("Illegal Arguments");
        }
        this.m_clob = cLOB;
        this.m_lobOffset = l2;
        this.m_buf = new byte[n2];
        this.m_count = 0;
        this.m_bufSize = n2;
        this.m_isClosed = false;
    }

    public void close() throws IOException {
        this.flushBuffer();
        this.m_isClosed = true;
    }

    void ensureOpen() throws IOException {
        try {
            if (this.m_isClosed) {
                DBError.check_error(57, null);
            }
        }
        catch (SQLException sQLException) {
            DBError.SQLToIOException(sQLException);
        }
    }

    public void flush() throws IOException {
        this.ensureOpen();
        this.flushBuffer();
    }

    private void flushBuffer() throws IOException {
        try {
            if (this.m_count > 0) {
                char[] cArray = new char[this.m_count];
                int n2 = 0;
                while (n2 < this.m_count) {
                    cArray[n2] = (char)this.m_buf[n2];
                    ++n2;
                }
                this.m_lobOffset += (long)this.m_clob.putChars(this.m_lobOffset, cArray);
                this.m_count = 0;
            }
        }
        catch (SQLException sQLException) {
            DBError.SQLToIOException(sQLException);
        }
    }

    public void write(int n2) throws IOException {
        this.ensureOpen();
        if (this.m_count >= this.m_buf.length) {
            this.flushBuffer();
        }
        this.m_buf[this.m_count++] = (byte)n2;
    }

    public void write(byte[] byArray, int n2, int n3) throws IOException {
        this.ensureOpen();
        int n4 = n2;
        int n5 = n4 + Math.min(n3, byArray.length - n2);
        while (n4 < n5) {
            int n6 = Math.min(this.m_bufSize - this.m_count, n5 - n4);
            System.arraycopy(byArray, n4, this.m_buf, this.m_count, n6);
            n4 += n6;
            this.m_count += n6;
            if (this.m_count < this.m_bufSize) continue;
            this.flushBuffer();
        }
    }
}

