/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleBufferedStream;
import oracle.sql.CLOB;

public class OracleClobInputStream
extends OracleBufferedStream {
    public static final boolean DEBUG = false;
    protected long m_lobOffset;
    protected CLOB m_clob;
    protected long m_markedByte;
    protected boolean m_endOfStream;
    protected char[] m_charBuf;

    public OracleClobInputStream(CLOB cLOB) throws SQLException {
        this(cLOB, cLOB.getConnection().db_access.getDefaultStreamChunkSize(), 1L);
    }

    public OracleClobInputStream(CLOB cLOB, int n2) throws SQLException {
        this(cLOB, n2, 1L);
    }

    public OracleClobInputStream(CLOB cLOB, int n2, long l2) throws SQLException {
        super(n2);
        if (cLOB == null || n2 <= 0 || l2 < 1L) {
            throw new IllegalArgumentException("Illegal Arguments");
        }
        this.m_lobOffset = l2;
        this.m_clob = cLOB;
        this.m_markedByte = -1L;
        this.m_endOfStream = false;
        this.m_charBuf = new char[n2];
    }

    protected void ensureOpen() throws IOException {
        try {
            if (this.closed) {
                DBError.check_error(57, null);
            }
        }
        catch (SQLException sQLException) {
            DBError.SQLToIOException(sQLException);
        }
    }

    public synchronized void mark(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Read-ahead limit < 0");
        }
        this.m_markedByte = this.m_lobOffset - (long)this.count + (long)this.pos;
    }

    public boolean markSupported() {
        return true;
    }

    public boolean needBytes() throws IOException {
        this.ensureOpen();
        if (this.pos >= this.count) {
            if (!this.m_endOfStream) {
                try {
                    this.count = this.m_clob.getChars(this.m_lobOffset, this.chunkSize, this.m_charBuf);
                    int n2 = 0;
                    while (n2 < this.count) {
                        this.buf[n2] = (byte)this.m_charBuf[n2];
                        ++n2;
                    }
                    if (this.count < this.chunkSize) {
                        this.m_endOfStream = true;
                    }
                    if (this.count > 0) {
                        this.pos = 0;
                        this.m_lobOffset += (long)this.count;
                        return true;
                    }
                }
                catch (SQLException sQLException) {
                    DBError.SQLToIOException(sQLException);
                }
            }
            return false;
        }
        return true;
    }

    public synchronized void reset() throws IOException {
        this.ensureOpen();
        if (this.m_markedByte < 0L) {
            throw new IOException("Mark invalid or stream not marked.");
        }
        this.m_lobOffset = this.m_markedByte;
        this.pos = this.count;
        this.m_endOfStream = false;
    }

    public long skip(long l2) throws IOException {
        long l3;
        block5: {
            this.ensureOpen();
            l3 = 0L;
            if ((long)(this.count - this.pos) >= l2) {
                this.pos = (int)((long)this.pos + l2);
                l3 += l2;
            } else {
                l3 += (long)(this.count - this.pos);
                this.pos = this.count;
                try {
                    long l4 = 0L;
                    l4 = this.m_clob.length() - this.m_lobOffset + 1L;
                    if (l4 >= l2 - l3) {
                        this.m_lobOffset += l2 - l3;
                        l3 += l2 - l3;
                        break block5;
                    }
                    this.m_lobOffset += l4;
                    l3 += l4;
                }
                catch (SQLException sQLException) {
                    DBError.SQLToIOException(sQLException);
                }
            }
        }
        return l3;
    }
}

