/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.InputStream;

public class OracleBufferedStream
extends InputStream {
    byte[] buf;
    int pos = 0;
    int count = 0;
    boolean closed = false;
    int chunkSize;

    public OracleBufferedStream(int n2) {
        this.chunkSize = n2;
        this.buf = new byte[n2];
    }

    public int available() throws IOException {
        if (this.closed || this.isNull()) {
            return 0;
        }
        return this.count - this.pos;
    }

    public void close() throws IOException {
        this.closed = true;
    }

    public int flushBytes(int n2) {
        int n3 = n2 > this.count - this.pos ? this.count - this.pos : n2;
        this.pos += n3;
        return n3;
    }

    public boolean isNull() throws IOException {
        return false;
    }

    public synchronized void mark(int n2) {
    }

    public boolean markSupported() {
        return false;
    }

    public boolean needBytes() throws IOException {
        throw new IOException("You should not call this method");
    }

    public synchronized int read() throws IOException {
        if (this.closed || this.isNull()) {
            return -1;
        }
        if (this.needBytes()) {
            return this.buf[this.pos++] & 0xFF;
        }
        return -1;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public synchronized int read(byte[] byArray, int n2, int n3) throws IOException {
        int n4 = n2;
        if (this.closed || this.isNull()) {
            return -1;
        }
        int n5 = n3 > byArray.length ? n4 + byArray.length : n4 + n3;
        if (!this.needBytes()) {
            return -1;
        }
        n4 += this.writeBytes(byArray, n4, n5 - n4);
        while (n4 < n5 && this.needBytes()) {
            n4 += this.writeBytes(byArray, n4, n5 - n4);
        }
        return n4 - n2;
    }

    public synchronized void reset() throws IOException {
        throw new IOException("mark/reset not supported");
    }

    /*
     * Unable to fully structure code
     */
    public long skip(int var1_1) throws IOException {
        var2_2 = 0;
        var3_3 = var1_1;
        if (this.closed || this.isNull()) {
            return -1L;
        }
        if (this.needBytes()) ** GOTO lbl8
        return -1L;
lbl-1000:
        // 1 sources

        {
            var2_2 += this.flushBytes(var3_3 - var2_2);
lbl8:
            // 2 sources

            ** while (var2_2 < var3_3 && this.needBytes())
        }
lbl9:
        // 1 sources

        return var2_2;
    }

    public int writeBytes(byte[] byArray, int n2, int n3) {
        int n4 = n3 > this.count - this.pos ? this.count - this.pos : n3;
        System.arraycopy(this.buf, this.pos, byArray, n2, n4);
        this.pos += n4;
        return n4;
    }
}

